/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceHttps
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceHttps");
    public static final int PSP_HTTPS_ISSUER_ALL = 0;
    public static final int PSP_HTTPS_ISSUER_RSA = 1;
    public static final int PSP_HTTPS_ISSUER_VERISIGN = 2;
    public static final int PSP_HTTPS_ISSUER_SCE = 3;
    public static final int PSP_HTTPS_ISSUER_GEOTRUST = 4;
    public static final int PSP_HTTPS_ISSUER_ENTRUST = 5;
    public static final int PSP_HTTPS_ISSUER_VALICERT = 6;
    public static final int PSP_HTTPS_ISSUER_CYBERTRUST = 7;
    public static final int PSP_HTTPS_ISSUER_THAWTE = 8;
    public static final int PSP_HTTPS_ISSUER_COMODO = 9;
    public static final int PSP_HTTPS_CERT_ALL = -1;
    public static final int PSP_HTTPS_CERT_RSA_1024_V1_C3 = 1;
    public static final int PSP_HTTPS_CERT_RSA_2048_V3 = 2;
    public static final int PSP_HTTPS_CERT_RSA_ALL = 3;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C1 = 1;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C2 = 2;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C3 = 4;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C1_G2 = 8;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C2_G2 = 16;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C3_G2 = 32;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C4_G2 = 64;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C1_G3 = 128;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C2_G3 = 256;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C3_G3 = 512;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C4_G3 = 1024;
    public static final int PSP_HTTPS_CERT_VERISIGN_TSA = 2048;
    public static final int PSP_HTTPS_CERT_VERISIGN_RSA_SS = 4096;
    public static final int PSP_HTTPS_CERT_VERISIGN_PCA_C3_G5 = 8192;
    public static final int PSP_HTTPS_CERT_VERISIGN_ALL = 16383;
    public static final int PSP_HTTPS_CERT_SCEI_ROOT_CA_01 = 1;
    public static final int PSP_HTTPS_CERT_SCEI_ROOT_CA_02 = 2;
    public static final int PSP_HTTPS_CERT_SCEI_ROOT_CA_03 = 4;
    public static final int PSP_HTTPS_CERT_SCEI_ROOT_CA_04 = 8;
    public static final int PSP_HTTPS_CERT_SCEI_ROOT_CA_05 = 16;
    public static final int PSP_HTTPS_CERT_SCEI_ALL = 31;
    public static final int PSP_HTTPS_CERT_GEOTRUST_GLOBAL_CA = 1;
    public static final int PSP_HTTPS_CERT_GEOTRUST_EQUIFAX_SECURE_CA = 2;
    public static final int PSP_HTTPS_CERT_GEOTRUST_EQUIFAX_SECURE_EBUSINESS_CA1 = 4;
    public static final int PSP_HTTPS_CERT_GEOTRUST_EQUIFAX_SECURE_GLOBAL_EBUSINESS_CA1 = 8;
    public static final int PSP_HTTPS_CERT_GEOTRUST_ALL = 15;
    public static final int PSP_HTTPS_CERT_ENTRUST_SECURE_SERVER_CA = 1;
    public static final int PSP_HTTPS_CERT_ENTRUST_ALL = 1;
    public static final int PSP_HTTPS_CERT_VALICERT_C2_CA = 1;
    public static final int PSP_HTTPS_CERT_VALICERT_ALL = 1;
    public static final int PSP_HTTPS_CERT_CYBERTRUST_BALTIMORE_ROOT_CA = 1;
    public static final int PSP_HTTPS_CERT_CYBERTRUST_GTE_GLOBAL_ROOT_CA = 2;
    public static final int PSP_HTTPS_CERT_CYBERTRUST_GTE_ROOT_CA = 4;
    public static final int PSP_HTTPS_CERT_CYBERTRUST_GLOBALSIGN_ROOT_CA_R1 = 8;
    public static final int PSP_HTTPS_CERT_CYBERTRUST_ALL = 15;
    public static final int PSP_HTTPS_CERT_THAWTE_PREMIUMSERVER_CA = 1;
    public static final int PSP_HTTPS_CERT_THAWTE_SERVER_CA = 2;
    public static final int PSP_HTTPS_CERT_THAWTE_ALL = 3;
    public static final int PSP_HTTPS_CERT_COMODO_ATE_CA_ROOT = 1;
    public static final int PSP_HTTPS_CERT_COMODO_AAA_CS = 2;
    public static final int PSP_HTTPS_CERT_COMODO_UTN_UFH = 4;
    public static final int PSP_HTTPS_CERT_COMODO_ALL = 7;
    public static final int PSP_HTTPS_ERROR_DETAIL_INTERNAL = 1;
    public static final int PSP_HTTPS_ERROR_DETAIL_INVALID_CERT = 2;
    public static final int PSP_HTTPS_ERROR_DETAIL_COMMON_NAME_CHECK = 4;
    public static final int PSP_HTTPS_ERROR_DETAIL_NOT_AFTER_CHECK = 8;
    public static final int PSP_HTTPS_ERROR_DETAIL_NOT_BEFORE_CHECK = 16;
    public static final int PSP_HTTPS_ERROR_DETAIL_INVALID_ROOT_CA = 32;
    public static final int PSP_HTTPS_SSL_FLAG_CHECK_SERVER = 1;
    public static final int PSP_HTTPS_SSL_FLAG_CHECK_CLIENT = 2;
    public static final int PSP_HTTPS_SSL_FLAG_CHECK_COMMON_NAME = 4;
    public static final int PSP_HTTPS_SSL_FLAG_CHECK_NOT_AFTER = 8;
    public static final int PSP_HTTPS_SSL_FLAG_CHECK_NOT_BEFORE = 16;
    public static final int PSP_HTTPS_SSL_FLAG_CHECK_VALID_ROOT_CA = 32;
    private boolean isHttpsInit;
    private HashMap<Integer, SslHandler> sslHandlers = new HashMap();

    @Override
    public String getName() {
        return "sceHttps";
    }

    protected void notifyHandler(int oldState, int newState, int event, int error) {
        for (SslHandler handler : this.sslHandlers.values()) {
            handler.triggerHandler(oldState, newState, event, error);
        }
    }

    @HLEFunction(nid=-455994622, version=150)
    public void sceHttpsInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int rootCertNum = cpu.gpr[4];
        int rootCertListAddr = cpu.gpr[5];
        int clientCertAddr = cpu.gpr[6];
        int keyAddr = cpu.gpr[7];
        log.info("sceHttpsInit: rootCertNum=" + rootCertNum + ", rootCertListAddr=" + Integer.toHexString(rootCertListAddr) + ", clientCertAddr=" + Integer.toHexString(clientCertAddr) + ", keyAddr=" + Integer.toHexString(keyAddr));
        cpu.gpr[2] = this.isHttpsInit ? -2143088608 : 0;
    }

    @HLEFunction(nid=1756041094, version=150)
    public void sceHttpsInitWithPath(Processor processor) {
        CpuState cpu = processor.cpu;
        int rootCertFileListAddr = cpu.gpr[4];
        int clientCertFileAddr = cpu.gpr[5];
        int keyFileAddr = cpu.gpr[6];
        log.info("sceHttpsInitWithPath: rootCertFileListAddr=" + Integer.toHexString(rootCertFileListAddr) + ", clientCertFileAddr=" + Integer.toHexString(clientCertFileAddr) + ", keyFileAddr=" + Integer.toHexString(keyFileAddr));
        cpu.gpr[2] = this.isHttpsInit ? -2143088608 : 0;
    }

    @HLEFunction(nid=-103224477, version=150)
    public void sceHttpsEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.info("sceHttpsEnd");
        if (!this.isHttpsInit) {
            cpu.gpr[2] = -2143088639;
        } else {
            this.isHttpsInit = false;
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-2022081571, version=150)
    public void sceHttpsLoadDefaultCert(Processor processor) {
        CpuState cpu = processor.cpu;
        int certIssuer = cpu.gpr[4];
        int certType = cpu.gpr[5];
        log.info("IGNORING: sceHttpsLoadDefaultCert: certIssuer=" + certIssuer + ", certType=" + certType);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1424670507, version=150)
    public void sceHttpsGetSslError(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int sslIdAddr = cpu.gpr[4];
        int errorAddr = cpu.gpr[5];
        int errorDetailAddr = cpu.gpr[6];
        log.warn("PARTIAL: sceHttpsLoadDefaultCert: sslIdAddr=" + Integer.toHexString(sslIdAddr) + ", errorAddr=" + Integer.toHexString(errorAddr) + ", errorDetailAddr=" + Integer.toHexString(errorDetailAddr));
        if (Memory.isAddressGood(errorAddr) && Memory.isAddressGood(errorDetailAddr)) {
            mem.write32(errorAddr, 0);
            mem.write32(errorDetailAddr, 0);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = !this.isHttpsInit ? -2143088639 : -2143088130;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1161618447, version=150)
    public void sceHttpsEnableOption(Processor processor) {
        CpuState cpu = processor.cpu;
        int flag = cpu.gpr[4];
        log.warn("PARTIAL: sceHttpsEnableOption: flag=" + flag);
        cpu.gpr[2] = !this.isHttpsInit ? -2143088639 : 0;
    }

    @HLEFunction(nid=-1275398095, version=150)
    public void sceHttpsDisableOption(Processor processor) {
        CpuState cpu = processor.cpu;
        int flag = cpu.gpr[4];
        log.warn("PARTIAL: sceHttpsDisableOption: flag=" + flag);
        cpu.gpr[2] = !this.isHttpsInit ? -2143088639 : 0;
    }

    @HLEFunction(nid=-786584831, version=150)
    public void sceHttpsGetCaList(Processor processor) {
        CpuState cpu = processor.cpu;
        int rootCAAddr = cpu.gpr[4];
        int rootCANumAddr = cpu.gpr[4];
        log.warn("IGNORING: sceHttpsGetCaList: rootCAAddr=" + Integer.toHexString(rootCAAddr) + ", rootCANumAddr=" + Integer.toHexString(rootCANumAddr));
        cpu.gpr[2] = !this.isHttpsInit ? -2143088639 : 0;
    }

    @HLEFunction(nid=1452938369, version=150)
    public void sceHttpsSetSslCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int sslID = cpu.gpr[4];
        int sslCallback = cpu.gpr[4];
        int sslArg = cpu.gpr[5];
        log.warn("PARTIAL: sceHttpsSetSslCallback: sslID=" + sslID + ", sslCallback=" + Integer.toHexString(sslCallback) + ", sslArg=" + Integer.toHexString(sslArg));
        if (!this.isHttpsInit) {
            cpu.gpr[2] = -2143088639;
        } else {
            SslHandler sslHandler = new SslHandler(sslID, sslCallback, sslArg);
            this.sslHandlers.put(sslID, sslHandler);
            cpu.gpr[2] = 0;
        }
    }

    protected class SslHandler {
        private int id;
        private int addr;
        private int pArg;

        private SslHandler(int id, int addr, int pArg) {
            this.id = id;
            this.addr = addr;
            this.pArg = pArg;
        }

        protected void triggerHandler(int oldState, int newState, int event, int error) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (thread != null) {
                Modules.ThreadManForUserModule.executeCallback(thread, this.addr, null, true, oldState, newState, event, error, this.pArg);
            }
        }

        public String toString() {
            return String.format("SslHandler[id=%d, addr=0x%08X, pArg=0x%08X]", this.id, this.addr, this.pArg);
        }
    }
}

