/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.TimeZone;
import jpcsp.Allegrex.CpuState;
import jpcsp.Debugger.MemoryViewer;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.kernel.types.SceMpegRingbuffer;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.connector.MpegCodec;
import jpcsp.graphics.VideoEngine;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMpeg
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceMpeg");
    public static boolean useMpegCodec = false;
    public static boolean enableMediaEngine = false;
    public static final int PSMF_MAGIC = 1179472720;
    public static final int PSMF_VERSION_0012 = 842084400;
    public static final int PSMF_VERSION_0013 = 0x33313030;
    public static final int PSMF_VERSION_0014 = 875638832;
    public static final int PSMF_VERSION_0015 = 892416048;
    public static final int PSMF_STREAM_VERSION_OFFSET = 4;
    public static final int PSMF_STREAM_OFFSET_OFFSET = 8;
    public static final int PSMF_STREAM_SIZE_OFFSET = 12;
    public static final int PSMF_FIRST_TIMESTAMP_OFFSET = 86;
    public static final int PSMF_LAST_TIMESTAMP_OFFSET = 92;
    protected static final int MPEG_MEMSIZE = 65536;
    public static final int atracDecodeDelay = 3000;
    public static final int avcDecodeDelay = 5400;
    public static final int mpegDecodeErrorDelay = 100;
    public static final int mpegTimestampPerSecond = 90000;
    public static final int videoTimestampStep = 3003;
    public static final int audioTimestampStep = 4180;
    public static final int audioFirstTimestamp = 90000;
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final int MPEG_HEADER_BUFFER_MINIMUM_SIZE = 2048;
    protected int mpegHandle;
    protected SceMpegRingbuffer mpegRingbuffer;
    protected AfterRingbufferPutCallback afterRingbufferPutCallback;
    protected int mpegRingbufferAddr;
    protected int mpegStreamSize;
    protected SceMpegAu mpegAtracAu;
    protected SceMpegAu mpegAvcAu;
    protected long lastAtracSystemTime;
    protected long lastAvcSystemTime;
    protected int avcAuAddr;
    protected int atracAuAddr;
    protected boolean endOfAudioReached;
    protected boolean endOfVideoReached;
    protected long mpegLastTimestamp;
    protected long mpegFirstTimestamp;
    protected Date mpegFirstDate;
    protected Date mpegLastDate;
    protected int videoFrameCount;
    protected int audioFrameCount;
    protected int videoPixelMode;
    protected int avcDetailFrameWidth;
    protected int avcDetailFrameHeight;
    protected int defaultFrameWidth;
    protected boolean isCurrentMpegAnalyzed;
    public int maxAheadTimestamp = 40000;
    protected static final int MPEG_AVC_ES_SIZE = 2048;
    protected static final int MPEG_ATRAC_ES_SIZE = 2112;
    public static final int MPEG_ATRAC_ES_OUTPUT_SIZE = 8192;
    protected static final int MPEG_PCM_ES_SIZE = 320;
    protected static final int MPEG_PCM_ES_OUTPUT_SIZE = 320;
    public static final int MPEG_VERSION_0012 = 0;
    public static final int MPEG_VERSION_0013 = 1;
    public static final int MPEG_VERSION_0014 = 2;
    public static final int MPEG_VERSION_0015 = 3;
    protected int mpegVersion;
    protected int mpegRawVersion;
    protected int mpegMagic;
    protected int mpegOffset;
    protected int mpegStreamAddr;
    public static final int MPEG_AVC_STREAM = 0;
    public static final int MPEG_ATRAC_STREAM = 1;
    public static final int MPEG_PCM_STREAM = 2;
    public static final int MPEG_DATA_STREAM = 3;
    public static final int MPEG_AUDIO_STREAM = 15;
    protected static final int MPEG_AU_MODE_DECODE = 0;
    protected static final int MPEG_AU_MODE_SKIP = 1;
    protected HashMap<Integer, Integer> atracStreamsMap;
    protected HashMap<Integer, Integer> avcStreamsMap;
    protected HashMap<Integer, Integer> pcmStreamsMap;
    protected boolean isAtracRegistered = false;
    protected boolean isAvcRegistered = false;
    protected boolean isPcmRegistered = false;
    protected boolean ignoreAtrac = false;
    protected boolean ignoreAvc = false;
    protected boolean ignorePcm = false;
    protected static final int MPEG_AVC_DECODE_SUCCESS = 1;
    protected static final int MPEG_AVC_DECODE_ERROR_FATAL = -8;
    protected int avcDecodeResult;
    protected int avcFrameStatus;
    protected MpegCodec mpegCodec;
    protected MediaEngine me;
    protected PacketChannel meChannel;
    protected HashMap<Integer, byte[]> encodedVideoFramesYCbCr;
    protected byte[] audioDecodeBuffer;
    protected boolean[] allocatedEsBuffers;
    protected HashMap<Integer, StreamInfo> streamMap;
    protected static final String streamPurpose = "sceMpeg-Stream";

    @Override
    public String getName() {
        return "sceMpeg";
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.useConnector", new EnableConnectorSettingsListener());
        this.setSettingsListener("emu.useMediaEngine", new EnableMediaEngineSettingsListener());
        this.mpegHandle = 0;
        this.isCurrentMpegAnalyzed = false;
        this.mpegRingbuffer = null;
        this.mpegRingbufferAddr = 0;
        this.avcAuAddr = 0;
        this.atracAuAddr = 0;
        this.atracStreamsMap = new HashMap();
        this.avcStreamsMap = new HashMap();
        this.pcmStreamsMap = new HashMap();
        this.mpegAtracAu = new SceMpegAu();
        this.mpegAvcAu = new SceMpegAu();
        this.afterRingbufferPutCallback = new AfterRingbufferPutCallback();
        if (sceMpeg.isEnableConnector()) {
            this.mpegCodec = new MpegCodec();
        }
        if (sceMpeg.checkMediaEngineState()) {
            this.me = new MediaEngine();
            this.meChannel = null;
        }
        this.encodedVideoFramesYCbCr = new HashMap();
        this.audioDecodeBuffer = new byte[8192];
        this.allocatedEsBuffers = new boolean[2];
        this.streamMap = new HashMap();
        super.start();
    }

    public static boolean isEnableConnector() {
        return useMpegCodec;
    }

    private static void setEnableConnector(boolean useConnector) {
        useMpegCodec = useConnector;
        if (useConnector) {
            log.info("Using JPCSP connector");
        }
    }

    public static boolean checkMediaEngineState() {
        return enableMediaEngine;
    }

    private static void setEnableMediaEngine(boolean enableMediaEngine) {
        sceMpeg.enableMediaEngine = enableMediaEngine;
        if (enableMediaEngine) {
            log.info("Media Engine enabled");
        }
    }

    protected Date convertTimestampToDate(long timestamp) {
        long millis = timestamp / 90L;
        return new Date(millis);
    }

    protected StreamInfo getStreamInfo(int uid) {
        return this.streamMap.get(uid);
    }

    protected int getMpegHandle(int mpegAddr) {
        if (Memory.isAddressGood(mpegAddr)) {
            return Processor.memory.read32(mpegAddr);
        }
        return -1;
    }

    protected void writeTimestamp(Memory mem, int address, long ts) {
        mem.write32(address, (int)(ts >> 32 & 1L));
        mem.write32(address + 4, (int)ts);
    }

    protected boolean isCurrentMpegAnalyzed() {
        return this.isCurrentMpegAnalyzed;
    }

    public void setCurrentMpegAnalyzed(boolean status) {
        this.isCurrentMpegAnalyzed = status;
    }

    protected void analyseMpeg(int buffer_addr) {
        Memory mem = Memory.getInstance();
        this.mpegStreamAddr = buffer_addr;
        this.mpegMagic = mem.read32(buffer_addr);
        this.mpegRawVersion = mem.read32(buffer_addr + 4);
        switch (this.mpegRawVersion) {
            case 842084400: {
                this.mpegVersion = 0;
                break;
            }
            case 0x33313030: {
                this.mpegVersion = 1;
                break;
            }
            case 875638832: {
                this.mpegVersion = 2;
                break;
            }
            case 892416048: {
                this.mpegVersion = 3;
                break;
            }
            default: {
                this.mpegVersion = -1;
            }
        }
        this.mpegOffset = Utilities.endianSwap32(mem.read32(buffer_addr + 8));
        this.mpegStreamSize = Utilities.endianSwap32(mem.read32(buffer_addr + 12));
        this.mpegFirstTimestamp = Utilities.endianSwap32(Utilities.readUnaligned32(mem, buffer_addr + 86));
        this.mpegLastTimestamp = Utilities.endianSwap32(Utilities.readUnaligned32(mem, buffer_addr + 92));
        this.mpegFirstDate = this.convertTimestampToDate(this.mpegFirstTimestamp);
        this.mpegLastDate = this.convertTimestampToDate(this.mpegLastTimestamp);
        this.avcDetailFrameWidth = mem.read8(buffer_addr + 142) * 16;
        this.avcDetailFrameHeight = mem.read8(buffer_addr + 143) * 16;
        this.avcDecodeResult = 1;
        this.avcFrameStatus = 0;
        if (this.mpegRingbuffer != null && !this.isCurrentMpegAnalyzed()) {
            this.mpegRingbuffer.reset();
            this.mpegRingbuffer.write(mem, this.mpegRingbufferAddr);
        }
        this.mpegAtracAu.dts = -1L;
        this.mpegAtracAu.pts = 0L;
        this.mpegAvcAu.dts = 0L;
        this.mpegAvcAu.pts = 0L;
        this.videoFrameCount = 0;
        this.audioFrameCount = 0;
        this.endOfAudioReached = false;
        this.endOfVideoReached = false;
        if (this.mpegStreamSize > 0 && !this.isCurrentMpegAnalyzed()) {
            if (sceMpeg.checkMediaEngineState()) {
                this.me.init(buffer_addr, this.mpegStreamSize, this.mpegOffset);
                this.meChannel = new PacketChannel();
                this.meChannel.write(buffer_addr, this.mpegOffset);
            } else if (sceMpeg.isEnableConnector()) {
                this.mpegCodec.init(this.mpegVersion, this.mpegStreamSize, this.mpegLastTimestamp);
                this.mpegCodec.writeVideo(buffer_addr, this.mpegOffset);
            }
        }
        this.setCurrentMpegAnalyzed(true);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Stream offset: %d, Stream size: 0x%X", this.mpegOffset, this.mpegStreamSize));
            log.debug(String.format("First timestamp: %d, Last timestamp: %d", this.mpegFirstTimestamp, this.mpegLastTimestamp));
            if (log.isTraceEnabled()) {
                for (int i = 0; i < 2048; i += 16) {
                    log.trace(MemoryViewer.getMemoryView(buffer_addr + i));
                }
            }
        }
    }

    public static int getMaxAheadTimestamp(int packets) {
        return Math.max(40000, packets * 700);
    }

    private void generateFakeMPEGVideo(int dest_addr, int frameWidth) {
        sceMpeg.generateFakeImage(dest_addr, frameWidth, this.avcDetailFrameWidth, this.avcDetailFrameHeight, this.videoPixelMode);
    }

    public static void generateFakeImage(int dest_addr, int frameWidth, int imageWidth, int imageHeight, int pixelMode) {
        Memory mem = Memory.getInstance();
        Random random = new Random();
        int pixelSize = 3;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(pixelMode);
        for (int y = 0; y < imageHeight - 3 + 1; y += 3) {
            int address = dest_addr + y * frameWidth * bytesPerPixel;
            int width = Math.min(imageWidth, frameWidth);
            for (int x = 0; x < width; x += 3) {
                int j;
                int i;
                int n = random.nextInt(256);
                int color = 0xFF000000 | n << 16 | n << 8 | n;
                int pixelColor = Debug.getPixelColor(color, pixelMode);
                if (bytesPerPixel == 4) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write32(address + (i * frameWidth + j) * 4, pixelColor);
                        }
                    }
                } else if (bytesPerPixel == 2) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write16(address + (i * frameWidth + j) * 2, (short)pixelColor);
                        }
                    }
                }
                address += 3 * bytesPerPixel;
            }
        }
    }

    public static void delayThread(long startMicros, int delayMicros) {
        long now = Emulator.getClock().microTime();
        int threadDelayMicros = delayMicros - (int)(now - startMicros);
        sceMpeg.delayThread(threadDelayMicros);
    }

    public static void delayThread(int delayMicros) {
        if (delayMicros > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(delayMicros, false);
        } else {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    protected void updateAvcDts() {
        this.mpegAvcAu.dts = this.mpegAvcAu.pts - 3003L;
    }

    protected void finishMpeg() {
        if (sceMpeg.checkMediaEngineState()) {
            this.me.finish();
            if (this.meChannel != null) {
                this.meChannel.clear();
            }
        } else if (sceMpeg.isEnableConnector()) {
            this.mpegCodec.finish();
        }
        this.setCurrentMpegAnalyzed(false);
        VideoEngine.getInstance().resetVideoTextures();
    }

    @HLEFunction(nid=570392804, version=150)
    public void sceMpegQueryStreamOffset(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int buffer_addr = cpu.gpr[5];
        int offset_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegQueryStreamOffset(mpeg=0x" + Integer.toHexString(mpeg) + ", buffer=0x" + Integer.toHexString(buffer_addr) + ", offset=0x" + Integer.toHexString(offset_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegQueryStreamOffset bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(buffer_addr) && Memory.isAddressGood(offset_addr)) {
            this.analyseMpeg(buffer_addr);
            if (this.mpegMagic == 1179472720) {
                if (this.mpegVersion < 0) {
                    log.warn("sceMpegQueryStreamOffset bad version " + String.format("0x%08X", this.mpegRawVersion));
                    mem.write32(offset_addr, 0);
                    cpu.gpr[2] = -2141126654;
                } else if ((this.mpegOffset & 0x7FF) != 0 || this.mpegOffset == 0) {
                    log.warn("sceMpegQueryStreamOffset bad offset " + String.format("0x%08X", this.mpegOffset));
                    mem.write32(offset_addr, 0);
                    cpu.gpr[2] = -2141126146;
                } else {
                    mem.write32(offset_addr, this.mpegOffset);
                    cpu.gpr[2] = 0;
                }
            } else {
                log.warn("sceMpegQueryStreamOffset bad magic " + String.format("0x%08X", this.mpegMagic));
                mem.write32(offset_addr, 0);
                cpu.gpr[2] = -2141126146;
            }
        } else {
            log.warn("sceMpegQueryStreamOffset bad address " + String.format("0x%08X 0x%08X", buffer_addr, offset_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1629396497, version=150)
    public void sceMpegQueryStreamSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int buffer_addr = cpu.gpr[4];
        int size_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegQueryStreamSize(buffer=0x" + Integer.toHexString(buffer_addr) + ", size=0x" + Integer.toHexString(size_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(buffer_addr) && Memory.isAddressGood(size_addr)) {
            this.analyseMpeg(buffer_addr);
            if (this.mpegMagic == 1179472720) {
                if ((this.mpegStreamSize & 0x7FF) == 0) {
                    mem.write32(size_addr, this.mpegStreamSize);
                    cpu.gpr[2] = 0;
                } else {
                    mem.write32(size_addr, 0);
                    cpu.gpr[2] = -2141126146;
                }
            } else {
                log.warn("sceMpegQueryStreamSize bad magic " + String.format("0x%08X", this.mpegMagic));
                cpu.gpr[2] = -1;
            }
        } else {
            log.warn("sceMpegQueryStreamSize bad address " + String.format("0x%08X 0x%08X", buffer_addr, size_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1747607963, version=150)
    public void sceMpegInit(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isInfoEnabled()) {
            log.info("sceMpegInit");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (sceMpeg.checkMediaEngineState()) {
            this.meChannel = null;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-2025446186, version=150)
    public void sceMpegFinish(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isInfoEnabled()) {
            log.info("sceMpegFinish");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.finishMpeg();
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1053629905, version=150)
    public void sceMpegQueryMemSize(Processor processor) {
        CpuState cpu = processor.cpu;
        int mode = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegQueryMemSize(mode=" + mode + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 65536;
    }

    @HLEFunction(nid=-658116319, version=150)
    public void sceMpegCreate(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int data = cpu.gpr[5];
        int size = cpu.gpr[6];
        int ringbuffer_addr = cpu.gpr[7];
        int frameWidth = cpu.gpr[8];
        int mode = cpu.gpr[9];
        int ddrtop = cpu.gpr[10];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegCreate(mpeg=0x" + Integer.toHexString(mpeg) + ", data=0x" + Integer.toHexString(data) + ", size=" + size + ", ringbuffer=0x" + Integer.toHexString(ringbuffer_addr) + ", frameWidth=" + frameWidth + ", mode=" + mode + ", ddrtop=0x" + Integer.toHexString(ddrtop) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (size < 65536) {
            log.warn("sceMpegCreate bad size " + size);
            cpu.gpr[2] = -2141126622;
        } else if (Memory.isAddressGood(mpeg) && Memory.isAddressGood(data) && Memory.isAddressGood(ringbuffer_addr)) {
            SceMpegRingbuffer ringbuffer = SceMpegRingbuffer.fromMem(mem, ringbuffer_addr);
            ringbuffer.packetsFree = ringbuffer.packetSize == 0 ? 0 : (ringbuffer.dataUpperBound - ringbuffer.data) / ringbuffer.packetSize;
            ringbuffer.mpeg = mpeg;
            ringbuffer.write(mem, ringbuffer_addr);
            this.mpegHandle = data + 48;
            mem.write32(mpeg, this.mpegHandle);
            Utilities.writeStringZ(mem, this.mpegHandle, "LIBMPEG.001");
            mem.write32(this.mpegHandle + 12, -1);
            mem.write32(this.mpegHandle + 16, ringbuffer_addr);
            mem.write32(this.mpegHandle + 20, ringbuffer.dataUpperBound);
            this.mpegRingbufferAddr = ringbuffer_addr;
            this.mpegRingbuffer = ringbuffer;
            this.videoFrameCount = 0;
            this.audioFrameCount = 0;
            this.videoPixelMode = 3;
            this.defaultFrameWidth = frameWidth;
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegCreate bad address " + String.format("0x%08X 0x%08X 0x%08X", mpeg, data, ringbuffer_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1617577545, version=150)
    public void sceMpegDelete(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegDelete(mpeg=0x" + Integer.toHexString(mpeg) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.finishMpeg();
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegDelete bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else {
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1112936227, version=150)
    public void sceMpegRegistStream(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        int stream_type = cpu.gpr[5];
        int stream_num = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRegistStream(mpeg=0x" + Integer.toHexString(mpeg) + ", stream_type=" + stream_type + ", stream_num=" + stream_num + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegRegistStream bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else {
            StreamInfo info = new StreamInfo(stream_type);
            int uid = info.getUid();
            switch (stream_type) {
                case 0: {
                    this.isAvcRegistered = true;
                    this.avcStreamsMap.put(uid, stream_num);
                    break;
                }
                case 1: 
                case 15: {
                    this.isAtracRegistered = true;
                    this.atracStreamsMap.put(uid, stream_num);
                    break;
                }
                case 2: {
                    this.isPcmRegistered = true;
                    this.pcmStreamsMap.put(uid, stream_num);
                    break;
                }
                default: {
                    log.warn("sceMpegRegistStream unknown stream type=" + stream_type);
                }
            }
            cpu.gpr[2] = uid;
        }
    }

    @HLEFunction(nid=1494895266, version=150)
    public void sceMpegUnRegistStream(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        int streamUid = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegUnRegistStream(mpeg=0x" + Integer.toHexString(mpeg) + ", stream=0x" + Integer.toHexString(streamUid) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegUnRegistStream bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else {
            StreamInfo info = this.getStreamInfo(streamUid);
            if (info != null) {
                switch (info.getType()) {
                    case 0: {
                        this.isAvcRegistered = false;
                        this.avcStreamsMap.remove(streamUid);
                        break;
                    }
                    case 1: 
                    case 15: {
                        this.isAtracRegistered = false;
                        this.atracStreamsMap.remove(streamUid);
                        break;
                    }
                    case 2: {
                        this.isPcmRegistered = false;
                        this.pcmStreamsMap.remove(streamUid);
                        break;
                    }
                    default: {
                        log.warn("sceMpegUnRegistStream unknown stream=0x" + Integer.toHexString(streamUid));
                        break;
                    }
                }
            } else {
                log.warn("sceMpegUnRegistStream unknown stream=0x" + Integer.toHexString(streamUid));
            }
            this.setCurrentMpegAnalyzed(false);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1484730498, version=150)
    public void sceMpegMallocAvcEsBuf(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegMallocAvcEsBuf(mpeg=0x" + Integer.toHexString(mpeg) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegMallocAvcEsBuf(mpeg=0x" + Integer.toHexString(mpeg) + ") bad mpeg handle");
            cpu.gpr[2] = -1;
        } else {
            int esBufferId = 0;
            for (int i = 0; i < this.allocatedEsBuffers.length; ++i) {
                if (this.allocatedEsBuffers[i]) continue;
                esBufferId = i + 1;
                this.allocatedEsBuffers[i] = true;
                break;
            }
            cpu.gpr[2] = esBufferId;
        }
    }

    @HLEFunction(nid=-826773327, version=150)
    public void sceMpegFreeAvcEsBuf(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        int esBuf = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegFreeAvcEsBuf(mpeg=0x" + Integer.toHexString(mpeg) + ", esBuf=0x" + Integer.toHexString(esBuf) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegFreeAvcEsBuf(mpeg=0x" + Integer.toHexString(mpeg) + ", esBuf=0x" + Integer.toHexString(esBuf) + ") bad mpeg handle");
            cpu.gpr[2] = -1;
        } else if (esBuf == 0) {
            log.warn("sceMpegFreeAvcEsBuf(mpeg=0x" + Integer.toHexString(mpeg) + ", esBuf=0x" + Integer.toHexString(esBuf) + ") bad esBuf handle");
            cpu.gpr[2] = -2141126146;
        } else {
            if (esBuf >= 1 && esBuf <= this.allocatedEsBuffers.length) {
                this.allocatedEsBuffers[esBuf - 1] = false;
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-119753095, version=150)
    public void sceMpegQueryAtracEsSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int esSize_addr = cpu.gpr[5];
        int outSize_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegQueryAtracEsSize(mpeg=0x" + Integer.toHexString(mpeg) + ", esSize_addr=0x" + Integer.toHexString(esSize_addr) + ", outSize_addr=0x" + Integer.toHexString(outSize_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegQueryAtracEsSize bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(esSize_addr) && Memory.isAddressGood(outSize_addr)) {
            mem.write32(esSize_addr, 2112);
            mem.write32(outSize_addr, 8192);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegQueryAtracEsSize bad address " + String.format("0x%08X 0x%08X", esSize_addr, outSize_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-1070795083, version=150)
    public void sceMpegQueryPcmEsSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int esSize_addr = cpu.gpr[5];
        int outSize_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegQueryPcmEsSize(mpeg=0x" + Integer.toHexString(mpeg) + ", esSize_addr=0x" + Integer.toHexString(esSize_addr) + ", outSize_addr=0x" + Integer.toHexString(outSize_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            Modules.log.warn("sceMpegQueryPcmEsSize bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(esSize_addr) && Memory.isAddressGood(outSize_addr)) {
            mem.write32(esSize_addr, 320);
            mem.write32(outSize_addr, 320);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegQueryPcmEsSize bad address " + String.format("0x%08X 0x%08X", esSize_addr, outSize_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=377159070, version=150)
    public void sceMpegInitAu(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int buffer_addr = cpu.gpr[5];
        int au_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegInitAu(mpeg=0x" + Integer.toHexString(mpeg) + ", buffer=0x" + Integer.toHexString(buffer_addr) + ", au=0x" + Integer.toHexString(au_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            Modules.log.warn("sceMpegInitAu bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else {
            if (buffer_addr >= 1 && buffer_addr <= this.allocatedEsBuffers.length && this.allocatedEsBuffers[buffer_addr - 1]) {
                this.mpegAvcAu.esBuffer = buffer_addr;
                this.mpegAvcAu.esSize = 2048;
                this.mpegAvcAu.write(mem, au_addr);
            } else {
                this.mpegAtracAu.esBuffer = buffer_addr;
                this.mpegAtracAu.esSize = 2112;
                this.mpegAtracAu.write(mem, au_addr);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=591759022, version=150)
    public void sceMpegChangeGetAvcAuMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        int stream_addr = cpu.gpr[5];
        int mode = cpu.gpr[6];
        log.warn("UNIMPLEMENTED: sceMpegChangeGetAvcAuMode(mpeg=0x" + Integer.toHexString(mpeg) + ",stream_addr=0x" + Integer.toHexString(stream_addr) + ",mode=0x" + mode + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1647331350, version=150)
    public void sceMpegChangeGetAuMode(Processor processor) {
        block14: {
            int streamUid;
            block13: {
                CpuState cpu = processor.cpu;
                int mpeg = cpu.gpr[4];
                streamUid = cpu.gpr[5];
                int mode = cpu.gpr[6];
                if (log.isDebugEnabled()) {
                    log.debug("sceMpegChangeGetAuMode(mpeg=0x" + Integer.toHexString(mpeg) + ",stream_addr=0x" + Integer.toHexString(streamUid) + ",mode=0x" + mode + ")");
                }
                if (IntrManager.getInstance().isInsideInterrupt()) {
                    cpu.gpr[2] = -2147352476;
                    return;
                }
                StreamInfo info = this.getStreamInfo(streamUid);
                if (info == null) break block13;
                switch (info.getType()) {
                    case 0: {
                        if (mode == 0) {
                            this.ignoreAvc = false;
                            break;
                        }
                        if (mode == 1) {
                            this.ignoreAvc = true;
                            break;
                        }
                        break block14;
                    }
                    case 1: 
                    case 15: {
                        if (mode == 0) {
                            this.ignoreAtrac = false;
                            break;
                        }
                        if (mode == 1) {
                            this.ignoreAvc = true;
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        if (mode == 0) {
                            this.ignorePcm = false;
                            break;
                        }
                        if (mode == 1) {
                            this.ignorePcm = true;
                            break;
                        }
                        break block14;
                    }
                    default: {
                        log.warn("sceMpegChangeGetAuMode unknown stream=0x" + Integer.toHexString(streamUid));
                        break;
                    }
                }
                break block14;
            }
            log.warn("sceMpegChangeGetAuMode unknown stream=0x" + Integer.toHexString(streamUid));
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-31168728, version=150)
    public void sceMpegGetAvcAu(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int streamUid = cpu.gpr[5];
        int au_addr = cpu.gpr[6];
        int attr_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegGetAvcAu(mpeg=0x" + Integer.toHexString(mpeg) + ", stream=0x" + Integer.toHexString(streamUid) + ", au=0x" + Integer.toHexString(au_addr) + ", attr_addr=0x" + Integer.toHexString(attr_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegGetAvcAu bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            cpu.gpr[2] = -2141093887;
            sceMpeg.delayThread(100);
        } else if (Memory.isAddressGood(streamUid) && Memory.isAddressGood(au_addr)) {
            log.warn("sceMpegGetAvcAu didn't get a fake stream");
            cpu.gpr[2] = -2141126397;
        } else if (this.streamMap.containsKey(streamUid)) {
            if (this.mpegAvcAu.pts > this.mpegAtracAu.pts + (long)this.maxAheadTimestamp && this.isAtracRegistered) {
                if (log.isDebugEnabled()) {
                    log.debug("sceMpegGetAvcAu video ahead of audio: " + this.mpegAvcAu.pts + " - " + this.mpegAtracAu.pts);
                }
                cpu.gpr[2] = -2141093887;
                sceMpeg.delayThread(100);
            } else {
                cpu.gpr[2] = 0;
                if (!this.ignoreAvc) {
                    if (sceMpeg.checkMediaEngineState()) {
                        Emulator.getClock().pause();
                        if (this.me.getContainer() == null) {
                            this.me.init(this.meChannel, true, true);
                        }
                        if (!this.me.readVideoAu(this.mpegAvcAu)) {
                            if (this.mpegLastTimestamp <= 0L || this.mpegAvcAu.pts >= this.mpegLastTimestamp) {
                                this.endOfVideoReached = true;
                                cpu.gpr[2] = -2141093887;
                            }
                        } else {
                            this.endOfVideoReached = false;
                        }
                        Emulator.getClock().resume();
                    } else if (sceMpeg.isEnableConnector()) {
                        if (!this.mpegCodec.readVideoAu(this.mpegAvcAu, this.videoFrameCount)) {
                            this.mpegAvcAu.pts += 3003L;
                        }
                        this.updateAvcDts();
                    }
                    this.mpegAvcAu.write(mem, au_addr);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sceMpegGetAvcAu returning 0x%08X, AvcAu=%s", cpu.gpr[2], this.mpegAvcAu.toString()));
                    }
                }
                if (Memory.isAddressGood(attr_addr)) {
                    mem.write32(attr_addr, 1);
                }
                if (cpu.gpr[2] != 0) {
                    sceMpeg.delayThread(100);
                }
            }
        } else {
            log.warn("sceMpegGetAvcAu bad address " + String.format("0x%08X 0x%08X", streamUid, au_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-1944190339, version=150)
    public void sceMpegGetPcmAu(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int streamUid = cpu.gpr[5];
        int au_addr = cpu.gpr[6];
        int attr_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegGetPcmAu(mpeg=0x" + Integer.toHexString(mpeg) + ", stream=0x" + Integer.toHexString(streamUid) + ", au=0x" + Integer.toHexString(au_addr) + ", attr_addr=0x" + Integer.toHexString(attr_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegGetPcmAu bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            cpu.gpr[2] = -2141093887;
            sceMpeg.delayThread(100);
        } else if (Memory.isAddressGood(streamUid) && Memory.isAddressGood(au_addr)) {
            log.warn("sceMpegGetPcmAu didn't get a fake stream");
            cpu.gpr[2] = -2141126397;
        } else if (this.streamMap.containsKey(streamUid)) {
            cpu.gpr[2] = 0;
            if (!this.ignorePcm) {
                if (sceMpeg.checkMediaEngineState()) {
                    Emulator.getClock().pause();
                    if (this.me.getContainer() == null) {
                        this.me.init(this.meChannel, true, true);
                    }
                    if (!this.me.readAudioAu(this.mpegAtracAu)) {
                        cpu.gpr[2] = -2141093887;
                    }
                    Emulator.getClock().resume();
                } else if (!sceMpeg.isEnableConnector() || this.mpegCodec.readAudioAu(this.mpegAtracAu, this.audioFrameCount)) {
                    // empty if block
                }
                this.mpegAtracAu.write(mem, au_addr);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceMpegGetPcmAu returning AtracAu=%s", this.mpegAtracAu.toString()));
                }
            }
            if (Memory.isAddressGood(attr_addr)) {
                mem.write32(attr_addr, 128);
                mem.write32(attr_addr, 2);
            }
            if (cpu.gpr[2] != 0) {
                sceMpeg.delayThread(100);
            }
        } else {
            log.warn("sceMpegGetPcmAu bad address " + String.format("0x%08X 0x%08X", streamUid, au_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-506559577, version=150)
    public void sceMpegGetAtracAu(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int streamUid = cpu.gpr[5];
        int au_addr = cpu.gpr[6];
        int attr_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegGetAtracAu(mpeg=0x" + Integer.toHexString(mpeg) + ", stream=0x" + Integer.toHexString(streamUid) + ", au=0x" + Integer.toHexString(au_addr) + ", attr_addr=0x" + Integer.toHexString(attr_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegGetAtracAu bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug("sceMpegGetAtracAu ringbuffer empty");
            cpu.gpr[2] = -2141093887;
            sceMpeg.delayThread(100);
        } else if (Memory.isAddressGood(streamUid) && Memory.isAddressGood(au_addr)) {
            log.warn("sceMpegGetAtracAu didn't get a fake stream");
            cpu.gpr[2] = -2141126397;
        } else if (this.streamMap.containsKey(streamUid)) {
            if (this.endOfAudioReached && this.endOfVideoReached) {
                if (log.isDebugEnabled()) {
                    log.debug("sceMpegGetAtracAu end of audio and video reached");
                }
                if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets) {
                    this.mpegRingbuffer.packetsFree = this.mpegRingbuffer.packets;
                    this.mpegRingbuffer.write(mem, this.mpegRingbufferAddr);
                }
                cpu.gpr[2] = -2141093887;
            } else if (this.mpegAtracAu.pts > this.mpegAvcAu.pts + (long)this.maxAheadTimestamp && this.isAvcRegistered && !this.endOfAudioReached) {
                if (log.isDebugEnabled()) {
                    log.debug("sceMpegGetAtracAu audio ahead of video: " + this.mpegAtracAu.pts + " - " + this.mpegAvcAu.pts);
                }
                cpu.gpr[2] = -2141093887;
                sceMpeg.delayThread(100);
            } else {
                cpu.gpr[2] = 0;
                if (!this.ignoreAtrac) {
                    if (sceMpeg.checkMediaEngineState()) {
                        Emulator.getClock().pause();
                        if (this.me.getContainer() == null) {
                            this.me.init(this.meChannel, true, true);
                        }
                        this.endOfAudioReached = !this.me.readAudioAu(this.mpegAtracAu);
                        Emulator.getClock().resume();
                    } else if (!sceMpeg.isEnableConnector() || this.mpegCodec.readAudioAu(this.mpegAtracAu, this.audioFrameCount)) {
                        // empty if block
                    }
                    this.mpegAtracAu.write(mem, au_addr);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sceMpegGetAtracAu returning 0x%08X, AtracAu=%s", cpu.gpr[2], this.mpegAtracAu.toString()));
                    }
                }
                if (Memory.isAddressGood(attr_addr)) {
                    mem.write32(attr_addr, 0);
                }
                if (cpu.gpr[2] != 0) {
                    sceMpeg.delayThread(100);
                }
            }
        } else {
            log.warn("sceMpegGetAtracAu bad address " + String.format("0x%08X 0x%08X", streamUid, au_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1343161385, version=150)
    public void sceMpegFlushStream(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        int stream_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegFlushStream mpeg=0x" + Integer.toHexString(mpeg) + ", stream_addr=0x" + Integer.toHexString(stream_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.finishMpeg();
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1887139369, version=150)
    public void sceMpegFlushAllStream(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegFlushAllStream mpeg=0x" + Integer.toHexString(mpeg));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.finishMpeg();
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=238825117, version=150)
    public void sceMpegAvcDecode(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int au_addr = cpu.gpr[5];
        int frameWidth = cpu.gpr[6];
        int buffer_addr = cpu.gpr[7];
        int init_addr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcDecode(mpeg=0x" + Integer.toHexString(mpeg) + ", au=0x" + Integer.toHexString(au_addr) + ", frameWidth=" + frameWidth + ", buffer=0x" + Integer.toHexString(buffer_addr) + ", init=0x" + Integer.toHexString(init_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (frameWidth == 0) {
            frameWidth = this.defaultFrameWidth == 0 ? this.avcDetailFrameWidth : this.defaultFrameWidth;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcDecode bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer == null) {
            log.warn("sceMpegAvcDecode ringbuffer not created");
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug("sceMpegAvcDecode ringbuffer empty");
            cpu.gpr[2] = -2141028350;
        } else if (Memory.isAddressGood(au_addr) && Memory.isAddressGood(buffer_addr) && Memory.isAddressGood(init_addr)) {
            int au = mem.read32(au_addr);
            int buffer = mem.read32(buffer_addr);
            int init = mem.read32(init_addr);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceMpegAvcDecode *au=0x%08X, *buffer=0x%08X, init=%d", au, buffer, init));
            }
            int width = Math.min(480, frameWidth);
            int height = 272;
            VideoEngine.getInstance().addVideoTexture(buffer, buffer + 272 * frameWidth * sceDisplay.getPixelFormatBytes(this.videoPixelMode));
            long startTime = Emulator.getClock().microTime();
            int packetsInRingbuffer = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
            int processedPackets = this.mpegRingbuffer.packetsRead - packetsInRingbuffer;
            int processedSize = processedPackets * this.mpegRingbuffer.packetSize;
            int packetsConsumed = 3;
            if (this.mpegStreamSize > 0 && this.mpegLastTimestamp > 0L) {
                int processedSizeBasedOnTimestamp = (int)((float)this.mpegAvcAu.pts / (float)this.mpegLastTimestamp * (float)this.mpegStreamSize);
                if (processedSizeBasedOnTimestamp < processedSize) {
                    packetsConsumed = 0;
                } else {
                    packetsConsumed = (processedSizeBasedOnTimestamp - processedSize) / this.mpegRingbuffer.packetSize;
                    if (packetsConsumed > 10) {
                        packetsConsumed = 10;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceMpegAvcDecode consumed %d %d/%d %d", processedSizeBasedOnTimestamp, processedSize, this.mpegStreamSize, packetsConsumed));
                }
            }
            if (sceMpeg.checkMediaEngineState()) {
                Emulator.getClock().pause();
                if (this.me.stepVideo()) {
                    this.me.writeVideoImage(buffer, frameWidth, this.videoPixelMode);
                    packetsConsumed = this.meChannel.getReadLength() / this.mpegRingbuffer.packetSize;
                    if (this.mpegRingbuffer.packetsFree + packetsConsumed >= this.mpegRingbuffer.packets && this.mpegLastTimestamp > 0L && this.mpegAvcAu.pts < this.mpegLastTimestamp) {
                        packetsConsumed = 0;
                    }
                    this.meChannel.setReadLength(this.meChannel.getReadLength() - packetsConsumed * this.mpegRingbuffer.packetSize);
                } else {
                    packetsConsumed = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
                }
                Emulator.getClock().resume();
                this.avcFrameStatus = 1;
            } else if (sceMpeg.isEnableConnector() && this.mpegCodec.readVideoFrame(buffer, frameWidth, width, 272, this.videoPixelMode, this.videoFrameCount)) {
                packetsConsumed = this.mpegCodec.getPacketsConsumed();
                this.avcFrameStatus = 1;
            } else {
                String displayedString;
                this.mpegAvcAu.pts += 3003L;
                this.updateAvcDts();
                this.generateFakeMPEGVideo(buffer, frameWidth);
                if (sceMpeg.isEnableConnector()) {
                    this.mpegCodec.postFakedVideo(buffer, frameWidth, this.videoPixelMode);
                }
                Date currentDate = this.convertTimestampToDate(this.mpegAvcAu.pts);
                if (log.isDebugEnabled()) {
                    log.debug("currentDate: " + currentDate.toString());
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                Debug.printFramebuffer(buffer, frameWidth, 10, this.avcDetailFrameHeight - 22, -1, -16777216, this.videoPixelMode, 1, " This is a faked MPEG video. ");
                if (this.mpegLastDate != null) {
                    displayedString = String.format(" %s / %s ", dateFormat.format(currentDate), dateFormat.format(this.mpegLastDate));
                    Debug.printFramebuffer(buffer, frameWidth, 10, 10, -1, -16777216, this.videoPixelMode, 2, displayedString);
                }
                displayedString = this.mpegStreamSize > 0 ? String.format(" %d/%d (%.0f%%) ", processedSize, this.mpegStreamSize, Float.valueOf((float)processedSize * 100.0f / (float)this.mpegStreamSize)) : String.format(" %d ", processedSize);
                Debug.printFramebuffer(buffer, frameWidth, 10, 30, -1, -16777216, this.videoPixelMode, 2, displayedString);
                if (log.isDebugEnabled()) {
                    log.debug("sceMpegAvcDecode currentTimestamp=" + this.mpegAvcAu.pts);
                }
                this.avcFrameStatus = 1;
            }
            ++this.videoFrameCount;
            if (log.isDebugEnabled()) {
                log.debug("sceMpegAvcDecode currentTimestamp=" + this.mpegAvcAu.pts);
            }
            if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets && packetsConsumed > 0) {
                this.mpegRingbuffer.packetsFree = Math.min(this.mpegRingbuffer.packets, this.mpegRingbuffer.packetsFree + packetsConsumed);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceMpegAvcDecode consumed %d packets, remaining %d packets", packetsConsumed, this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree));
                }
                this.mpegRingbuffer.write(mem, this.mpegRingbufferAddr);
            }
            this.avcDecodeResult = 1;
            mem.write32(init_addr, this.avcFrameStatus);
            cpu.gpr[2] = 0;
            sceMpeg.delayThread(startTime, 5400);
        } else {
            log.warn(String.format("sceMpegAvcDecode bad address 0x%08X 0x%08X", au_addr, buffer_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=258742487, version=150)
    public void sceMpegAvcDecodeDetail(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int detailAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceMpegAvcDecodeDetail(mpeg=0x%08X, detailAddr=0x%08X)", mpeg, detailAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcDecodeDetail bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(detailAddr)) {
            log.warn(String.format("sceMpegAvcDecodeDetail bad address 0x%08X", detailAddr));
            cpu.gpr[2] = -1;
        } else {
            mem.write32(detailAddr, this.avcDecodeResult);
            mem.write32(detailAddr + 4, this.videoFrameCount);
            mem.write32(detailAddr + 8, this.avcDetailFrameWidth);
            mem.write32(detailAddr + 12, this.avcDetailFrameHeight);
            mem.write32(detailAddr + 16, 0);
            mem.write32(detailAddr + 20, 0);
            mem.write32(detailAddr + 24, 0);
            mem.write32(detailAddr + 28, 0);
            mem.write32(detailAddr + 32, this.avcFrameStatus);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1591971802, version=150)
    public void sceMpegAvcDecodeMode(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int mode_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcDecodeMode(mpeg=0x" + Integer.toHexString(mpeg) + ", mode_addr=0x" + Integer.toHexString(mode_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn(String.format("sceMpegAvcDecodeMode bad mpeg handle 0x%08X", mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(mode_addr)) {
            int mode = mem.read32(mode_addr);
            int pixelMode = mem.read32(mode_addr + 4);
            if (pixelMode >= 0 && pixelMode <= 3) {
                this.videoPixelMode = pixelMode;
            } else {
                log.warn("sceMpegAvcDecodeMode mode=0x" + mode + " pixel mode=" + pixelMode + ": unknown mode");
            }
            cpu.gpr[2] = 0;
        } else {
            log.warn(String.format("sceMpegAvcDecodeMode bad address 0x%08X", mode_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1947192529, version=150)
    public void sceMpegAvcDecodeStop(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int frameWidth = cpu.gpr[5];
        int buffer_addr = cpu.gpr[6];
        int status_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcDecodeStop(mpeg=0x" + Integer.toHexString(mpeg) + ", frameWidth=" + frameWidth + ", buffer_addr=0x" + Integer.toHexString(buffer_addr) + ", status_addr=0x" + Integer.toHexString(status_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcDecodeStop bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(buffer_addr) && Memory.isAddressGood(status_addr)) {
            mem.write32(status_addr, 0);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegAvcDecodeStop bad address " + String.format("0x%08X 0x%08X", buffer_addr, status_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1165085796, version=150)
    public void sceMpegAvcDecodeFlush(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcDecodeFlush mpeg=0x" + Integer.toHexString(mpeg));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.finishMpeg();
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=555353468, version=150)
    public void sceMpegAvcQueryYCbCrSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int mpeg = cpu.gpr[4];
        int mode = cpu.gpr[5];
        int width = cpu.gpr[6];
        int height = cpu.gpr[7];
        int resultAddr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcQueryYCbCrSize(mpeg=0x" + Integer.toHexString(mpeg) + ", mode=" + mode + ", width=" + width + ", height=" + height + ", resultAddr=0x" + Integer.toHexString(resultAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcQueryYCbCrSize bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if ((width & 0xF) != 0 || (height & 0xF) != 0 || width > 480 || height > 272) {
            log.warn("sceMpegAvcQueryYCbCrSize invalid size width=" + width + ", height=" + height);
            cpu.gpr[2] = -2141126146;
        } else if (Memory.isAddressGood(resultAddr)) {
            int size = width / 2 * (height / 2) * 6 + 128;
            mem.write32(resultAddr, size);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegAvcQueryYCbCrSize bad result address 0x" + Integer.toHexString(resultAddr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=1729600283, version=150)
    public void sceMpegAvcInitYCbCr(Processor processor) {
        CpuState cpu = processor.cpu;
        int mpeg = cpu.gpr[4];
        int mode = cpu.gpr[5];
        int width = cpu.gpr[6];
        int height = cpu.gpr[7];
        int ycbcr_addr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcInitYCbCr(mpeg=0x" + Integer.toHexString(mpeg) + ", YCbCr_addr=0x" + Integer.toHexString(ycbcr_addr) + ", mode=" + mode + ", width=" + width + ", height=" + height + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.encodedVideoFramesYCbCr.remove(ycbcr_addr);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-253030107, version=150)
    public void sceMpegAvcDecodeYCbCr(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int mpeg = cpu.gpr[4];
        int au_addr = cpu.gpr[5];
        int buffer_addr = cpu.gpr[6];
        int init_addr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcDecodeYCbCr(mpeg=0x" + Integer.toHexString(mpeg) + ", au=0x" + Integer.toHexString(au_addr) + ", buffer=0x" + Integer.toHexString(buffer_addr) + ", init=0x" + Integer.toHexString(init_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcDecodeYCbCr bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer == null) {
            log.warn("sceMpegAvcDecodeYCbCr ringbuffer not created");
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug("sceMpegAvcDecodeYCbCr ringbuffer empty");
            cpu.gpr[2] = -2141028350;
        } else if (Memory.isAddressGood(au_addr) && Memory.isAddressGood(buffer_addr) && Memory.isAddressGood(init_addr)) {
            long startTime = Emulator.getClock().microTime();
            int packetsInRingbuffer = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
            int processedPackets = this.mpegRingbuffer.packetsRead - packetsInRingbuffer;
            int processedSize = processedPackets * this.mpegRingbuffer.packetSize;
            int packetsConsumed = 3;
            if (this.mpegStreamSize > 0 && this.mpegLastTimestamp > 0L) {
                int processedSizeBasedOnTimestamp = (int)((float)this.mpegAvcAu.pts / (float)this.mpegLastTimestamp * (float)this.mpegStreamSize);
                if (processedSizeBasedOnTimestamp < processedSize) {
                    packetsConsumed = 0;
                } else {
                    packetsConsumed = (processedSizeBasedOnTimestamp - processedSize) / this.mpegRingbuffer.packetSize;
                    if (packetsConsumed > 10) {
                        packetsConsumed = 10;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceMpegAvcDecodeYCbCr consumed %d %d/%d %d", processedSizeBasedOnTimestamp, processedSize, this.mpegStreamSize, packetsConsumed));
                }
            }
            if (sceMpeg.checkMediaEngineState()) {
                if (this.me.stepVideo()) {
                    packetsConsumed = this.meChannel.getReadLength() / this.mpegRingbuffer.packetSize;
                    this.meChannel.setReadLength(this.meChannel.getReadLength() - packetsConsumed * this.mpegRingbuffer.packetSize);
                } else {
                    packetsConsumed = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
                }
                this.avcFrameStatus = 1;
            } else if (sceMpeg.isEnableConnector()) {
                byte[] encodedVideoFrame = this.mpegCodec.readEncodedVideoFrame(this.videoFrameCount);
                if (encodedVideoFrame != null) {
                    int buffer = mem.read32(buffer_addr);
                    this.encodedVideoFramesYCbCr.put(buffer, encodedVideoFrame);
                }
                packetsConsumed = 0;
                this.avcFrameStatus = 1;
            } else {
                this.mpegAvcAu.pts += 3003L;
                this.updateAvcDts();
                packetsConsumed = 0;
                this.avcFrameStatus = 1;
            }
            ++this.videoFrameCount;
            if (log.isDebugEnabled()) {
                log.debug("sceMpegAvcDecodeYCbCr currentTimestamp=" + this.mpegAvcAu.pts);
            }
            if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets && packetsConsumed > 0) {
                this.mpegRingbuffer.packetsFree = Math.min(this.mpegRingbuffer.packets, this.mpegRingbuffer.packetsFree + packetsConsumed);
                this.mpegRingbuffer.write(mem, this.mpegRingbufferAddr);
            }
            this.avcDecodeResult = 1;
            mem.write32(init_addr, this.avcFrameStatus);
            cpu.gpr[2] = 0;
            sceMpeg.delayThread(startTime, 5400);
        } else {
            log.warn("sceMpegAvcDecodeYCbCr bad address " + String.format("0x%08X 0x%08X", au_addr, buffer_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-225244004, version=150)
    public void sceMpegAvcDecodeStopYCbCr(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int buffer_addr = cpu.gpr[5];
        int status_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcDecodeStopYCbCr(mpeg=0x" + Integer.toHexString(mpeg) + ", buffer=0x" + Integer.toHexString(buffer_addr) + ", status=0x" + Integer.toHexString(status_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcDecodeStopYCbCr bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(buffer_addr) && Memory.isAddressGood(status_addr)) {
            mem.write32(status_addr, 0);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegAvcDecodeStopYCbCr bad address " + String.format("0x%08X 0x%08X", buffer_addr, status_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=834470514, version=150)
    public void sceMpegAvcCsc(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int source_addr = cpu.gpr[5];
        int range_addr = cpu.gpr[6];
        int frameWidth = cpu.gpr[7];
        int dest_addr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAvcCsc(mpeg=0x" + Integer.toHexString(mpeg) + ", source=0x" + Integer.toHexString(source_addr) + ", range_addr=0x" + Integer.toHexString(range_addr) + ", frameWidth=" + frameWidth + ", dest=0x" + Integer.toHexString(dest_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (frameWidth == 0) {
            frameWidth = this.defaultFrameWidth == 0 ? this.avcDetailFrameWidth : this.defaultFrameWidth;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAvcCsc bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer == null) {
            log.warn("sceMpegAvcCsc ringbuffer not created");
            cpu.gpr[2] = -1;
        } else if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug("sceMpegAvcCsc ringbuffer empty");
            cpu.gpr[2] = -2141028350;
        } else if (Memory.isAddressGood(dest_addr) && Memory.isAddressGood(source_addr) && Memory.isAddressGood(range_addr)) {
            int rangeWidthStart = mem.read32(range_addr);
            int rangeHeightStart = mem.read32(range_addr + 4);
            int rangeWidthEnd = mem.read32(range_addr + 8);
            int rangeHeightEnd = mem.read32(range_addr + 12);
            if (log.isDebugEnabled()) {
                log.debug("sceMpegAvcCsc range - x:" + rangeWidthStart + " y:" + rangeHeightStart + " xLen:" + rangeWidthEnd + " yLen:" + rangeHeightEnd);
            }
            VideoEngine.getInstance().addVideoTexture(dest_addr, dest_addr + (rangeHeightStart + rangeHeightEnd) * frameWidth * sceDisplay.getPixelFormatBytes(this.videoPixelMode));
            if (sceMpeg.checkMediaEngineState()) {
                if (this.me.getContainer() != null) {
                    this.me.writeVideoImageWithRange(dest_addr, frameWidth, this.videoPixelMode, rangeWidthStart, rangeHeightStart, rangeWidthEnd, rangeHeightEnd);
                }
            } else {
                long startTime = Emulator.getClock().microTime();
                int packetsInRingbuffer = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
                int processedPackets = this.mpegRingbuffer.packetsRead - packetsInRingbuffer;
                int processedSize = processedPackets * this.mpegRingbuffer.packetSize;
                int packetsConsumed = 3;
                if (this.mpegStreamSize > 0 && this.mpegLastTimestamp > 0L) {
                    int processedSizeBasedOnTimestamp = (int)((float)this.mpegAvcAu.pts / (float)this.mpegLastTimestamp * (float)this.mpegStreamSize);
                    if (processedSizeBasedOnTimestamp < processedSize) {
                        packetsConsumed = 0;
                    } else {
                        packetsConsumed = (processedSizeBasedOnTimestamp - processedSize) / this.mpegRingbuffer.packetSize;
                        if (packetsConsumed > 10) {
                            packetsConsumed = 10;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sceMpegAvcCsc consumed %d %d/%d %d", processedSizeBasedOnTimestamp, processedSize, this.mpegStreamSize, packetsConsumed));
                    }
                }
                if (sceMpeg.isEnableConnector() && this.encodedVideoFramesYCbCr.containsKey(source_addr)) {
                    byte[] encodedVideoFrame = this.encodedVideoFramesYCbCr.get(source_addr);
                    this.mpegCodec.decodeVideoFrame(encodedVideoFrame, dest_addr, frameWidth, rangeWidthEnd, rangeHeightEnd, this.videoPixelMode, this.videoFrameCount);
                    packetsConsumed = this.mpegCodec.getPacketsConsumed();
                } else {
                    String displayedString;
                    this.generateFakeMPEGVideo(dest_addr, frameWidth);
                    if (sceMpeg.isEnableConnector()) {
                        this.mpegCodec.postFakedVideo(dest_addr, frameWidth, this.videoPixelMode);
                    }
                    Date currentDate = this.convertTimestampToDate(this.mpegAvcAu.pts);
                    if (log.isDebugEnabled()) {
                        log.debug("currentDate: " + currentDate.toString());
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    Debug.printFramebuffer(dest_addr, frameWidth, 10, 250, -1, -16777216, this.videoPixelMode, 1, " This is a faked MPEG video (in YCbCr mode). ");
                    if (this.mpegLastDate != null) {
                        displayedString = String.format(" %s / %s ", dateFormat.format(currentDate), dateFormat.format(this.mpegLastDate));
                        Debug.printFramebuffer(dest_addr, frameWidth, 10, 10, -1, -16777216, this.videoPixelMode, 2, displayedString);
                    }
                    displayedString = this.mpegStreamSize > 0 ? String.format(" %d/%d (%.0f%%) ", processedSize, this.mpegStreamSize, Float.valueOf((float)processedSize * 100.0f / (float)this.mpegStreamSize)) : String.format(" %d ", processedSize);
                    Debug.printFramebuffer(dest_addr, frameWidth, 10, 30, -1, -16777216, this.videoPixelMode, 2, displayedString);
                    if (log.isDebugEnabled()) {
                        log.debug("sceMpegAvcCsc currentTimestamp=" + this.mpegAvcAu.pts);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("sceMpegAvcCsc currentTimestamp=" + this.mpegAvcAu.pts);
                }
                if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets && packetsConsumed > 0) {
                    this.mpegRingbuffer.packetsFree = Math.min(this.mpegRingbuffer.packets, this.mpegRingbuffer.packetsFree + packetsConsumed);
                    this.mpegRingbuffer.write(mem, this.mpegRingbufferAddr);
                }
                sceMpeg.delayThread(startTime, 5400);
            }
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegAvcCsc bad address " + String.format("0x%08X 0x%08X", source_addr, dest_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-2146679585, version=150)
    public void sceMpegAtracDecode(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int mpeg = cpu.gpr[4];
        int au_addr = cpu.gpr[5];
        int buffer_addr = cpu.gpr[6];
        int init = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegAtracDecode(mpeg=0x" + Integer.toHexString(mpeg) + ", au=0x" + Integer.toHexString(au_addr) + ", buffer=0x" + Integer.toHexString(buffer_addr) + ", init=" + init + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn("sceMpegAtracDecode bad mpeg handle 0x" + Integer.toHexString(mpeg));
            cpu.gpr[2] = -1;
        } else if (Memory.isAddressGood(au_addr) && Memory.isAddressGood(buffer_addr)) {
            long startTime = Emulator.getClock().microTime();
            this.mpegAtracAu.pts += 4180L;
            if (sceMpeg.checkMediaEngineState()) {
                Emulator.getClock().pause();
                int bytes = 0;
                if (this.me.stepAudio(8192)) {
                    bytes = this.me.getCurrentAudioSamples(this.audioDecodeBuffer);
                    mem.copyToMemory(buffer_addr, ByteBuffer.wrap(this.audioDecodeBuffer, 0, bytes), bytes);
                }
                mem.memset(buffer_addr + bytes, (byte)0, 8192 - bytes);
                Emulator.getClock().resume();
            } else if (sceMpeg.isEnableConnector() && this.mpegCodec.readAudioFrame(buffer_addr, this.audioFrameCount)) {
                this.mpegAtracAu.pts = this.mpegCodec.getMpegAtracCurrentTimestamp();
            } else {
                mem.memset(buffer_addr, (byte)0, 8192);
            }
            ++this.audioFrameCount;
            if (log.isDebugEnabled()) {
                log.debug("sceMpegAtracDecode currentTimestamp=" + this.mpegAtracAu.pts);
            }
            cpu.gpr[2] = 0;
            sceMpeg.delayThread(startTime, 3000);
        } else {
            log.warn("sceMpegAtracDecode bad address " + String.format("0x%08X 0x%08X", au_addr, buffer_addr));
            cpu.gpr[2] = -1;
        }
    }

    protected int getPacketsFromSize(int size) {
        int packets = size / 2152;
        return packets;
    }

    private int getSizeFromPackets(int packets) {
        int size = packets * 104 + packets * 2048;
        return size;
    }

    @HLEFunction(nid=-677208250, version=150)
    public void sceMpegRingbufferQueryMemSize(Processor processor) {
        CpuState cpu = processor.cpu;
        int packets = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRingbufferQueryMemSize packets=" + packets);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = this.getSizeFromPackets(packets);
    }

    @HLEFunction(nid=925458136, version=150)
    public void sceMpegRingbufferConstruct(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int ringbuffer_addr = cpu.gpr[4];
        int packets = cpu.gpr[5];
        int data = cpu.gpr[6];
        int size = cpu.gpr[7];
        int callback_addr = cpu.gpr[8];
        int callback_args = cpu.gpr[9];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRingbufferConstruct(ringbuffer=0x" + Integer.toHexString(ringbuffer_addr) + ", packets=" + packets + ", data=0x" + Integer.toHexString(data) + ", size=" + size + ", callback=0x" + Integer.toHexString(callback_addr) + ", args=0x" + Integer.toHexString(callback_args) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (size < this.getSizeFromPackets(packets)) {
            log.warn("sceMpegRingbufferConstruct insufficient space: size=" + size + ", packets=" + packets);
            cpu.gpr[2] = -2141126622;
        } else if (Memory.isAddressGood(ringbuffer_addr)) {
            SceMpegRingbuffer ringbuffer = new SceMpegRingbuffer(packets, data, size, callback_addr, callback_args);
            ringbuffer.write(mem, ringbuffer_addr);
            this.maxAheadTimestamp = sceMpeg.getMaxAheadTimestamp(packets);
            cpu.gpr[2] = 0;
        } else {
            log.warn("sceMpegRingbufferConstruct bad address " + String.format("0x%08X", ringbuffer_addr));
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=322993939, version=150)
    public void sceMpegRingbufferDestruct(Processor processor) {
        CpuState cpu = processor.cpu;
        int ringbuffer_addr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRingbufferDestruct(ringbuffer=0x" + Integer.toHexString(ringbuffer_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    protected void hleMpegRingbufferPostPut() {
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        int packetsAdded = cpu.gpr[2];
        this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        if (packetsAdded > 0) {
            if (sceMpeg.checkMediaEngineState() && this.meChannel != null) {
                this.meChannel.write(this.mpegRingbuffer.data, packetsAdded * this.mpegRingbuffer.packetSize);
            } else if (sceMpeg.isEnableConnector()) {
                this.mpegCodec.writeVideo(this.mpegRingbuffer.data, packetsAdded * this.mpegRingbuffer.packetSize);
            }
            if (packetsAdded > this.mpegRingbuffer.packetsFree) {
                log.warn("sceMpegRingbufferPut clamping packetsAdded old=" + packetsAdded + " new=" + this.mpegRingbuffer.packetsFree);
                packetsAdded = this.mpegRingbuffer.packetsFree;
            }
            this.mpegRingbuffer.packetsRead += packetsAdded;
            this.mpegRingbuffer.packetsWritten += packetsAdded;
            this.mpegRingbuffer.packetsFree -= packetsAdded;
            this.mpegRingbuffer.write(mem, this.mpegRingbufferAddr);
        }
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRingbufferPut packetsAdded=" + packetsAdded + ", packetsRead=" + this.mpegRingbuffer.packetsRead);
        }
        cpu.gpr[2] = packetsAdded;
    }

    @HLEFunction(nid=-1304386146, version=150)
    public void sceMpegRingbufferPut(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        this.mpegRingbufferAddr = cpu.gpr[4];
        int numPackets = cpu.gpr[5];
        int available = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceMpegRingbufferPut ringbuffer=0x%08X, numPackets=%d, available=%d", this.mpegRingbufferAddr, numPackets, available));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (numPackets < 0) {
            cpu.gpr[2] = 0;
        } else {
            int numberPackets = Math.min(available, numPackets);
            int mpegStreamPackets = (this.mpegStreamSize + this.mpegRingbuffer.packetSize - 1) / this.mpegRingbuffer.packetSize;
            int remainingPackets = mpegStreamPackets - this.mpegRingbuffer.packetsRead;
            if (remainingPackets < 0) {
                remainingPackets = 0;
            }
            numberPackets = Math.min(numberPackets, remainingPackets);
            this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
            Modules.ThreadManForUserModule.executeCallback(null, this.mpegRingbuffer.callback_addr, this.afterRingbufferPutCallback, false, this.mpegRingbuffer.data, numberPackets, this.mpegRingbuffer.callback_args);
        }
    }

    @HLEFunction(nid=-1242112889, version=150)
    public void sceMpegRingbufferAvailableSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        this.mpegRingbufferAddr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRingbufferAvailableSize(ringbuffer=0x" + Integer.toHexString(this.mpegRingbufferAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.mpegRingbuffer.read(mem, this.mpegRingbufferAddr);
        cpu.gpr[2] = this.mpegRingbuffer.packetsFree;
        if (log.isDebugEnabled()) {
            log.debug("sceMpegRingbufferAvailableSize returning " + this.mpegRingbuffer.packetsFree);
        }
    }

    @HLEFunction(nid=1010280358, version=150)
    public void sceMpegNextAvcRpAu(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceMpegNextAvcRpAu " + String.format("%08X %08X %08X %08X", cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7]));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=26701908, version=150)
    public void sceMpegGetUserdataAu(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegGetUserdataAu [0x01977054]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1000564276, version=150)
    public void sceMpegQueryUserdataEsSize(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegQueryUserdataEsSize [0xC45C99CC]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=89698421, version=150)
    public void sceMpegAvcCopyYCbCr(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcCopyYCbCr [0x0558B075]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=301554929, version=150)
    public void sceMpegGetAvcNalAu(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegGetAvcNalAu [0x11F95CF1]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1843409713, version=150)
    public void sceMpegGetAvcEsAu(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegGetAvcEsAu [0x921FCCCF]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1865499664, version=150)
    public void sceMpegAvcDecodeGetDecodeSEI(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcDecodeGetDecodeSEI [0x6F314410]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1425107626, version=150)
    public void sceMpegAvcDecodeDetailIndex(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcDecodeDetailIndex [0xAB0E9556]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-818591838, version=150)
    public void sceMpegAvcDecodeDetail2(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcDecodeDetail2 [0xCF3547A2]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-169350607, version=150)
    public void sceMpegAvcConvertToYuv420(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcConvertToYuv420 [0xF5E7EA31]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-775009968, version=150)
    public void sceMpegAvcCscMode(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcCscMode [0xD1CE4950]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-608827816, version=150)
    public void sceMpegFlushAu(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegFlushAu [0xDBB60658]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-380094218, version=150)
    public void sceMpegAvcCscInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpegAvcCscInfo [0xE95838F6]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=298497113, version=150)
    public void sceMpeg_11CAB459(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpeg_11CAB459 [0x11CAB459]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1300819544, version=150)
    public void sceMpeg_B27711A8(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpeg_B27711A8 [0xB27711A8]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-723685771, version=150)
    public void sceMpeg_D4DD6E75(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpeg_D4DD6E75 [0xD4DD6E75]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1018831150, version=150)
    public void sceMpeg_C345DED2(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpeg_C345DED2 [0xC345DED2]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1735483886, version=150)
    public void sceMpeg_988E9E12(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceMpeg_988E9E12 [0x988E9E12]");
        cpu.gpr[2] = -559038242;
    }

    public class AfterRingbufferPutCallback
    implements IAction {
        @Override
        public void execute() {
            sceMpeg.this.hleMpegRingbufferPostPut();
        }
    }

    private class StreamInfo {
        private int uid;
        private int type;

        public StreamInfo(int type) {
            this.type = type;
            this.uid = SceUidManager.getNewUid(sceMpeg.streamPurpose);
            sceMpeg.this.streamMap.put(this.uid, this);
        }

        public int getUid() {
            return this.uid;
        }

        public int getType() {
            return this.type;
        }

        public void release() {
            SceUidManager.releaseId(this.uid, sceMpeg.streamPurpose);
            this.uid = -1;
            this.type = -1;
        }
    }

    private class EnableMediaEngineSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceMpeg.setEnableMediaEngine(value);
        }
    }

    private class EnableConnectorSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableConnectorSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceMpeg.setEnableConnector(value);
        }
    }
}

