/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Wlan;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNet
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNet");
    protected int netMemSize;

    @Override
    public String getName() {
        return "sceNet";
    }

    @HLEFunction(nid=967784870, version=150)
    public void sceNetInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int poolSize = cpu.gpr[4];
        int calloutThreadPri = cpu.gpr[5];
        int calloutThreadStack = cpu.gpr[6];
        int netinitThreadPri = cpu.gpr[7];
        int netinitThreadStack = cpu.gpr[8];
        log.warn("IGNORING: sceNetInit (poolsize=0x" + Integer.toHexString(poolSize) + ", calloutThreadPri=0x" + Integer.toHexString(calloutThreadPri) + ", calloutThreadStack=0x" + Integer.toHexString(calloutThreadStack) + ", netinitThreadPri=0x" + Integer.toHexString(netinitThreadPri) + ", netinitThreadStack=0x" + Integer.toHexString(netinitThreadStack) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.netMemSize = poolSize;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=672737449, version=150)
    public void sceNetTerm(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("IGNORING: sceNetTerm");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1348760880, version=150)
    public void sceNetFreeThreadinfo(Processor processor) {
        CpuState cpu = processor.cpu;
        int thID = cpu.gpr[4];
        log.warn("IGNORING: sceNetFreeThreadinfo (thID=0x" + Integer.toHexString(thID) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1385675578, version=150)
    public void sceNetThreadAbort(Processor processor) {
        CpuState cpu = processor.cpu;
        int thID = cpu.gpr[4];
        log.warn("IGNORING: sceNetThreadAbort (thID=0x" + Integer.toHexString(thID) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1992947376, version=150)
    public void sceNetEtherNtostr(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int etherAddr = cpu.gpr[4];
        int strAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceNetEtherNtostr (etherAddr=0x" + Integer.toHexString(etherAddr) + ", strAddr=0x" + Integer.toHexString(strAddr) + ")");
        }
        if (Memory.isAddressGood(etherAddr) && Memory.isAddressGood(strAddr)) {
            StringBuilder str = new StringBuilder();
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(etherAddr, Wlan.MAC_ADDRESS_LENGTH, 1);
            for (int i = 0; i < Wlan.MAC_ADDRESS_LENGTH; ++i) {
                if (i > 0) {
                    str.append(":");
                }
                str.append(String.format("%02x", memoryReader.readNext()));
            }
            Utilities.writeStringZ(mem, strAddr, str.toString());
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    protected int parseHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        log.error(String.format("Cannot parse hex digit '%c'", Character.valueOf(c)));
        return 0;
    }

    @HLEFunction(nid=-763797047, version=150)
    public void sceNetEtherStrton(Processor processor) {
        CpuState cpu = processor.cpu;
        int strAddr = cpu.gpr[4];
        int etherAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceNetEtherStrton (strAddr=0x" + Integer.toHexString(strAddr) + ", etherAddr=0x" + Integer.toHexString(etherAddr) + ")");
        }
        if (Memory.isAddressGood(strAddr) && Memory.isAddressGood(etherAddr)) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(strAddr, 17, 1);
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(etherAddr, Wlan.MAC_ADDRESS_LENGTH, 1);
            for (int i = 0; i < Wlan.MAC_ADDRESS_LENGTH; ++i) {
                int n1 = this.parseHexDigit((char)memoryReader.readNext());
                int n2 = this.parseHexDigit((char)memoryReader.readNext());
                memoryReader.skip(1);
                memoryWriter.writeNext((n1 << 4) + n2);
            }
            memoryWriter.flush();
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    protected int networkSwap32(int value) {
        return Integer.reverseBytes(value);
    }

    protected int networkSwap16(int value) {
        return Integer.reverseBytes(value) >>> 16;
    }

    @HLEFunction(nid=-176136450, version=150)
    public void sceNetHtonl(Processor processor) {
        CpuState cpu = processor.cpu;
        int host32 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetHtonl(%08X)", host32));
        }
        cpu.gpr[2] = this.networkSwap32(host32);
    }

    @HLEFunction(nid=968998658, version=150)
    public void sceNetHtons(Processor processor) {
        CpuState cpu = processor.cpu;
        int host16 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetHtons(%04X)", host16));
        }
        cpu.gpr[2] = this.networkSwap16(host16);
    }

    @HLEFunction(nid=-1815826562, version=150)
    public void sceNetNtohl(Processor processor) {
        CpuState cpu = processor.cpu;
        int net32 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetNtohl(%08X)", net32));
        }
        cpu.gpr[2] = this.networkSwap32(net32);
    }

    @HLEFunction(nid=1289761287, version=150)
    public void sceNetNtohs(Processor processor) {
        CpuState cpu = processor.cpu;
        int net16 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetNtohs(%04X)", net16));
        }
        cpu.gpr[2] = this.networkSwap16(net16);
    }

    @HLEFunction(nid=200319918, version=150)
    public void sceNetGetLocalEtherAddr(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int etherAddr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceNetGetLocalEtherAddr (etherAddr=0x" + Integer.toHexString(etherAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(etherAddr)) {
            byte[] netAddr = Wlan.getMacAddress();
            for (int i = 0; i < netAddr.length; ++i) {
                mem.write8(etherAddr + i, netAddr[i]);
            }
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-868663736, version=150)
    public void sceNetGetMallocStat(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int statAddr = cpu.gpr[4];
        log.warn("PARTIAL: sceNetGetMallocStat (statAddr=0x" + Integer.toHexString(statAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(statAddr)) {
            mem.write32(statAddr, this.netMemSize);
            mem.write32(statAddr + 4, this.netMemSize);
            mem.write32(statAddr + 8, 0);
        }
        cpu.gpr[2] = 0;
    }
}

