/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetAdhocctl
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNetAdhocctl");
    public static final int PSP_ADHOCCTL_EVENT_ERROR = 0;
    public static final int PSP_ADHOCCTL_EVENT_CONNECTED = 1;
    public static final int PSP_ADHOCCTL_EVENT_DISCONNECTED = 2;
    public static final int PSP_ADHOCCTL_EVENT_SCAN = 3;
    public static final int PSP_ADHOCCTL_EVENT_GAME = 4;
    public static final int PSP_ADHOCCTL_EVENT_DISCOVER = 5;
    public static final int PSP_ADHOCCTL_EVENT_WOL = 6;
    public static final int PSP_ADHOCCTL_EVENT_WOL_INTERRUPTED = 7;
    public static final int PSP_ADHOCCTL_STATE_DISCONNECTED = 0;
    public static final int PSP_ADHOCCTL_STATE_CONNECTED = 1;
    public static final int PSP_ADHOCCTL_STATE_SCAN = 2;
    public static final int PSP_ADHOCCTL_STATE_GAME = 3;
    public static final int PSP_ADHOCCTL_STATE_DISCOVER = 4;
    public static final int PSP_ADHOCCTL_STATE_WOL = 5;
    protected int adhocctlCurrentState;
    protected String adhocctlCurrentGroup;
    private HashMap<Integer, AdhocctlHandler> adhocctlHandlerMap = new HashMap();
    private int adhocctlHandlerCount = 0;

    @Override
    public String getName() {
        return "sceNetAdhocctl";
    }

    protected void notifyAdhocctlHandler(int event, int error) {
        for (AdhocctlHandler handler : this.adhocctlHandlerMap.values()) {
            handler.setEvent(event);
            handler.setError(error);
            handler.triggerAdhocctlHandler();
        }
    }

    @HLEFunction(nid=-496033170, version=150)
    public void sceNetAdhocctlInit(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int threadStack = cpu.gpr[4];
        int threadPri = cpu.gpr[5];
        int adhocIDAddr = cpu.gpr[6];
        log.warn("PARTIAL: sceNetAdhocctlInit (threadStack=0x" + Integer.toHexString(threadStack) + ", threadPri=0x" + Integer.toHexString(threadPri) + ", adhocIDAddr=0x" + Integer.toHexString(adhocIDAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(adhocIDAddr)) {
            int adhocType = mem.read32(adhocIDAddr);
            String adhocParams = Utilities.readStringNZ(mem, adhocIDAddr + 4, 9);
            log.info("Found Adhoc ID data: type=" + adhocType + ", params=" + adhocParams);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1654088173, version=150)
    public void sceNetAdhocctlTerm(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("PARTIAL: sceNetAdhocctlTerm");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=181421037, version=150)
    public void sceNetAdhocctlConnect(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int groupNameAddr = cpu.gpr[4];
        log.warn("PARTIAL: sceNetAdhocctlConnect (groupNameAddr=0x" + Integer.toHexString(groupNameAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(groupNameAddr)) {
            String groupName;
            this.adhocctlCurrentGroup = groupName = Utilities.readStringNZ(mem, groupNameAddr, 8);
        }
        this.adhocctlCurrentState = 1;
        this.notifyAdhocctlHandler(1, 0);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-335137343, version=150)
    public void sceNetAdhocctlCreate(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int groupNameAddr = cpu.gpr[4];
        log.warn("PARTIAL: sceNetAdhocctlCreate (groupNameAddr=0x" + Integer.toHexString(groupNameAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(groupNameAddr)) {
            String groupName;
            this.adhocctlCurrentGroup = groupName = Utilities.readStringNZ(mem, groupNameAddr, 8);
        }
        this.adhocctlCurrentState = 1;
        this.notifyAdhocctlHandler(1, 0);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1585412553, version=150)
    public void sceNetAdhocctlJoin(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int scanInfoAddr = cpu.gpr[4];
        log.warn("PARTIAL: sceNetAdhocctlJoin (scanInfoAddr=0x" + Integer.toHexString(scanInfoAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(scanInfoAddr)) {
            int nextAddr = mem.read32(scanInfoAddr);
            int ch = mem.read32(scanInfoAddr + 4);
            String groupName = Utilities.readStringNZ(mem, scanInfoAddr + 8, 8);
            String bssID = Utilities.readStringNZ(mem, scanInfoAddr + 16, 6);
            int mode = mem.read32(scanInfoAddr + 24);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetAdhocctlJoin nextAddr 0x%08X, ch %d, groupName '%s', bssID '%s', mode %d", nextAddr, ch, groupName, bssID, mode));
            }
            this.adhocctlCurrentGroup = groupName;
        }
        this.adhocctlCurrentState = 1;
        this.notifyAdhocctlHandler(1, 0);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=150992800, version=150)
    public void sceNetAdhocctlScan(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("PARTIAL: sceNetAdhocctlScan");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.adhocctlCurrentState = 2;
        this.notifyAdhocctlHandler(3, 0);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=876617061, version=150)
    public void sceNetAdhocctlDisconnect(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("PARTIAL: sceNetAdhocctlDisconnect");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.adhocctlCurrentState = 0;
        this.notifyAdhocctlHandler(2, 0);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=548607904, version=150)
    public void sceNetAdhocctlAddHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        int adhocctlHandlerAddr = cpu.gpr[4];
        int adhocctlHandlerArg = cpu.gpr[5];
        log.warn("PARTIAL: sceNetAdhocctlAddHandler (adhocctlHandlerAddr=0x" + Integer.toHexString(adhocctlHandlerAddr) + ", adhocctlHandlerArg=0x" + Integer.toHexString(adhocctlHandlerArg) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        AdhocctlHandler adhocctlHandler = new AdhocctlHandler(this.adhocctlHandlerCount++, adhocctlHandlerAddr, adhocctlHandlerArg);
        int handle = adhocctlHandler.getHandle();
        this.adhocctlHandlerMap.put(handle, adhocctlHandler);
        cpu.gpr[2] = handle;
    }

    @HLEFunction(nid=1677871371, version=150)
    public void sceNetAdhocctlDelHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        int adhocctlHandler = cpu.gpr[4];
        log.warn("PARTIAL: sceNetAdhocctlDelHandler (adhocctlHandler=0x" + Integer.toHexString(adhocctlHandler) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.adhocctlHandlerMap.remove(adhocctlHandler);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1978454918, version=150)
    public void sceNetAdhocctlGetState(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int stateAddr = cpu.gpr[4];
        log.warn("PARTIAL: sceNetAdhocctlGetState (stateAddr=0x" + Integer.toHexString(stateAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(stateAddr)) {
            mem.write32(stateAddr, this.adhocctlCurrentState);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=908902031, version=150)
    public void sceNetAdhocctlGetAdhocId(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetAdhocId");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-513619180, version=150)
    public void sceNetAdhocctlGetPeerList(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetPeerList");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1917304868, version=150)
    public void sceNetAdhocctlGetPeerInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetPeerInfo");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1722414402, version=150)
    public void sceNetAdhocctlGetAddrByName(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetAddrByName");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1994997757, version=150)
    public void sceNetAdhocctlGetNameByAddr(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetNameByAddr");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-556150130, version=150)
    public void sceNetAdhocctlGetParameter(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetParameter");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-2119245378, version=150)
    public void sceNetAdhocctlGetScanInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetScanInfo");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1514121778, version=150)
    public void sceNetAdhocctlCreateEnterGameMode(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlCreateEnterGameMode");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1330114944, version=150)
    public void sceNetAdhocctlCreateEnterGameModeMin(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlCreateEnterGameModeMin");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=536385349, version=150)
    public void sceNetAdhocctlJoinEnterGameMode(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlJoinEnterGameMode");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-812775347, version=150)
    public void sceNetAdhocctlExitGameMode(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlExitGameMode");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1510034656, version=150)
    public void sceNetAdhocctlGetGameModeInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetAdhocctlGetGameModeInfo");
        cpu.gpr[2] = -559038242;
    }

    protected class AdhocctlHandler {
        private int entryAddr;
        private int currentEvent;
        private int currentError;
        private int currentArg;
        private int handle;

        private AdhocctlHandler(int num, int addr, int arg) {
            this.entryAddr = addr;
            this.currentArg = arg;
            this.handle = this.makeFakeAdhocctHandle(num);
        }

        protected void triggerAdhocctlHandler() {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (thread != null) {
                Modules.ThreadManForUserModule.executeCallback(thread, this.entryAddr, null, true, this.currentEvent, this.currentError, this.currentArg);
            }
        }

        protected int makeFakeAdhocctHandle(int num) {
            return 0xAD00 | num & 0xFFFF;
        }

        protected int getHandle() {
            return this.handle;
        }

        protected void setEvent(int event) {
            this.currentEvent = event;
        }

        protected void setError(int error) {
            this.currentError = error;
        }
    }
}

