/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetApctl
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNetApctl");
    public static final int PSP_NET_APCTL_STATE_DISCONNECTED = 0;
    public static final int PSP_NET_APCTL_STATE_SCANNING = 1;
    public static final int PSP_NET_APCTL_STATE_JOINING = 2;
    public static final int PSP_NET_APCTL_STATE_GETTING_IP = 3;
    public static final int PSP_NET_APCTL_STATE_GOT_IP = 4;
    public static final int PSP_NET_APCTL_STATE_EAP_AUTH = 5;
    public static final int PSP_NET_APCTL_STATE_KEY_EXCHANGE = 6;
    public static final int PSP_NET_APCTL_EVENT_CONNECT_REQUEST = 0;
    public static final int PSP_NET_APCTL_EVENT_SCAN_REQUEST = 1;
    public static final int PSP_NET_APCTL_EVENT_SCAN_COMPLETE = 2;
    public static final int PSP_NET_APCTL_EVENT_ESTABLISHED = 3;
    public static final int PSP_NET_APCTL_EVENT_GET_IP = 4;
    public static final int PSP_NET_APCTL_EVENT_DISCONNECT_REQUEST = 5;
    public static final int PSP_NET_APCTL_EVENT_ERROR = 6;
    public static final int PSP_NET_APCTL_EVENT_INFO = 7;
    public static final int PSP_NET_APCTL_EVENT_EAP_AUTH = 8;
    public static final int PSP_NET_APCTL_EVENT_KEY_EXCHANGE = 9;
    public static final int PSP_NET_APCTL_EVENT_RECONNECT = 10;
    public static final int PSP_NET_APCTL_INFO_PROFILE_NAME = 0;
    public static final int PSP_NET_APCTL_INFO_BSSID = 1;
    public static final int PSP_NET_APCTL_INFO_SSID = 2;
    public static final int PSP_NET_APCTL_INFO_SSID_LENGTH = 3;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE = 4;
    public static final int PSP_NET_APCTL_INFO_STRENGTH = 5;
    public static final int PSP_NET_APCTL_INFO_CHANNEL = 6;
    public static final int PSP_NET_APCTL_INFO_POWER_SAVE = 7;
    public static final int PSP_NET_APCTL_INFO_IP = 8;
    public static final int PSP_NET_APCTL_INFO_SUBNETMASK = 9;
    public static final int PSP_NET_APCTL_INFO_GATEWAY = 10;
    public static final int PSP_NET_APCTL_INFO_PRIMDNS = 11;
    public static final int PSP_NET_APCTL_INFO_SECDNS = 12;
    public static final int PSP_NET_APCTL_INFO_USE_PROXY = 13;
    public static final int PSP_NET_APCTL_INFO_PROXY_URL = 14;
    public static final int PSP_NET_APCTL_INFO_PROXY_PORT = 15;
    public static final int PSP_NET_APCTL_INFO_8021_EAP_TYPE = 16;
    public static final int PSP_NET_APCTL_INFO_START_BROWSER = 17;
    public static final int PSP_NET_APCTL_INFO_WIFISP = 18;
    private static final String[] apctlInfoNames = new String[]{"PROFILE_NAME", "BSSID", "SSID", "SSID_LENGTH", "SECURITY_TYPE", "STRENGTH", "CHANNEL", "POWER_SAVE", "IP", "SUBNETMASK", "GATEWAY", "PRIMDNS", "SECDNS", "USE_PROXY", "PROXY_URL", "PROXY_PORT", "8021_EAP_TYPE", "START_BROWSER", "WIFISP"};
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_NONE = 0;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_WEP = 1;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_WPA = 2;
    private static final String dummyPrimaryDNS = "1.2.3.4";
    private static final String dummySecondaryDNS = "1.2.3.5";
    private static final String dummyGateway = "1.2.3.0";
    private static final String dummySubnetMask = "255.255.255.0";
    private static final int dummySubnetMaskInt = -256;
    protected static final String uidPurpose = "sceNetApctl";
    protected int state = 0;
    private static String localHostIP;
    private HashMap<Integer, ApctlHandler> apctlHandlers = new HashMap();
    protected static final int stateTransitionDelay = 100000;
    protected SceKernelThreadInfo sceNetApctlThread;
    protected boolean sceNetApctlThreadTerminate;

    @Override
    public String getName() {
        return uidPurpose;
    }

    protected void notifyHandler(int oldState, int newState, int event, int error) {
        for (ApctlHandler handler : this.apctlHandlers.values()) {
            handler.triggerHandler(oldState, newState, event, error);
        }
    }

    protected void changeState(int newState) {
        int event;
        int oldState = this.state;
        int error = 0;
        if (newState == oldState) {
            return;
        }
        switch (newState) {
            case 2: {
                event = 0;
                break;
            }
            case 3: {
                event = 3;
                break;
            }
            case 4: {
                event = 4;
                break;
            }
            case 0: {
                event = 5;
                break;
            }
            default: {
                event = 0;
            }
        }
        this.state = newState;
        this.notifyHandler(oldState, newState, event, error);
        if (newState == 2) {
            this.triggerNetApctlThread();
        }
    }

    protected static String getApctlInfoName(int code) {
        if (code < 0 || code >= apctlInfoNames.length) {
            return String.format("Unknown Info %d", code);
        }
        return apctlInfoNames[code];
    }

    public static String getSSID() {
        String ssid = null;
        try {
            ssid = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getDisplayName();
        }
        catch (SocketException e) {
            log.error(e);
        }
        catch (UnknownHostException e) {
            log.error(e);
        }
        return ssid;
    }

    public static String getPrimaryDNS() {
        int lastDot;
        String ip = sceNetApctl.getLocalHostIP();
        if (ip != null && (lastDot = ip.lastIndexOf(".")) >= 0) {
            String primaryDNS = ip.substring(0, lastDot) + ".1";
            return primaryDNS;
        }
        return dummyPrimaryDNS;
    }

    public static String getSecondaryDNS() {
        return dummySecondaryDNS;
    }

    public static String getGateway() {
        return dummyGateway;
    }

    public static String getSubnetMask() {
        return dummySubnetMask;
    }

    public static int getSubnetMaskInt() {
        return -256;
    }

    public static String getLocalHostIP() {
        if (localHostIP == null) {
            localHostIP = "192.168.1.1";
            try {
                localHostIP = InetAddress.getLocalHost().getHostAddress();
                InetAddress localHostAddress = InetAddress.getLocalHost();
                InetAddress[] allLocalIPs = InetAddress.getAllByName(localHostAddress.getHostName());
                for (int i = 0; allLocalIPs != null && i < allLocalIPs.length; ++i) {
                    byte[] bytes = allLocalIPs[i].getAddress();
                    if (bytes == null || bytes.length != 4 || bytes[3] == 1) continue;
                    localHostIP = allLocalIPs[i].getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                log.error(e);
            }
        }
        return localHostIP;
    }

    public void hleNetApctlConnect(int index) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleNetApctlConnect index=%d", index));
        }
        this.changeState(2);
    }

    public int hleNetApctlGetState() {
        return this.state;
    }

    protected void triggerNetApctlThread() {
        if (this.sceNetApctlThread != null) {
            Modules.ThreadManForUserModule.hleKernelWakeupThread(this.sceNetApctlThread);
        }
    }

    public void hleNetApctlThread(Processor processor) {
        if (this.sceNetApctlThreadTerminate) {
            processor.cpu.gpr[2] = 0;
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
            this.sceNetApctlThread = null;
        } else {
            boolean stateTransitionCompleted = true;
            switch (this.state) {
                case 2: {
                    this.changeState(3);
                    stateTransitionCompleted = false;
                    break;
                }
                case 3: {
                    this.changeState(4);
                }
            }
            if (stateTransitionCompleted) {
                Modules.ThreadManForUserModule.hleKernelSleepThread(false);
            } else {
                Modules.ThreadManForUserModule.hleKernelDelayThread(100000, false);
            }
        }
    }

    @HLEFunction(nid=-486989925, version=150)
    public void sceNetApctlInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int stackSize = cpu.gpr[4];
        int initPriority = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlInit stackSize=%d, initPriority=%d", stackSize, initPriority));
        }
        if (this.sceNetApctlThread == null) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            this.sceNetApctlThread = threadMan.hleKernelCreateThread("SceNetApctl", 0x8000060, initPriority, stackSize, threadMan.getCurrentThread().attr, 0);
            this.sceNetApctlThreadTerminate = false;
            threadMan.hleKernelStartThread(this.sceNetApctlThread, 0, 0, this.sceNetApctlThread.gpReg_addr);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1276260116, version=150)
    public void sceNetApctlTerm(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlTerm", new Object[0]));
        }
        this.changeState(0);
        this.sceNetApctlThreadTerminate = true;
        this.triggerNetApctlThread();
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=737140515, version=150)
    public void sceNetApctlGetInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int code = cpu.gpr[4];
        int pInfo = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlGetInfo code=%d(%s), pInfo=0x%08X", code, sceNetApctl.getApctlInfoName(code), pInfo));
        }
        if (!Memory.isAddressGood(pInfo)) {
            log.warn(String.format("sceNetApctlGetInfo invalid address pInfo=0x%08X", pInfo));
            cpu.gpr[2] = -1;
        } else {
            cpu.gpr[2] = 0;
            switch (code) {
                case 8: {
                    String ip = sceNetApctl.getLocalHostIP();
                    Utilities.writeStringNZ(mem, pInfo, 16, ip);
                    if (!log.isDebugEnabled()) break;
                    log.debug(String.format("sceNetApctlGetInfo returning IP address '%s'", ip));
                    break;
                }
                case 2: {
                    String ssid = sceNetApctl.getSSID();
                    if (ssid == null) {
                        cpu.gpr[2] = -1;
                        break;
                    }
                    Utilities.writeStringNZ(mem, pInfo, 32, ssid);
                    if (!log.isDebugEnabled()) break;
                    log.debug(String.format("sceNetApctlGetInfo returning SSID '%s'", ssid));
                    break;
                }
                case 3: {
                    String ssid = sceNetApctl.getSSID();
                    if (ssid == null) {
                        cpu.gpr[2] = -1;
                        break;
                    }
                    mem.write32(pInfo, Math.min(ssid.length(), 32));
                    break;
                }
                case 11: {
                    Utilities.writeStringNZ(mem, pInfo, 16, sceNetApctl.getPrimaryDNS());
                    break;
                }
                case 12: {
                    Utilities.writeStringNZ(mem, pInfo, 16, sceNetApctl.getSecondaryDNS());
                    break;
                }
                case 10: {
                    Utilities.writeStringNZ(mem, pInfo, 16, sceNetApctl.getGateway());
                    break;
                }
                case 9: {
                    Utilities.writeStringNZ(mem, pInfo, 16, sceNetApctl.getSubnetMask());
                    break;
                }
                case 6: {
                    int channel = Settings.getInstance().readInt("emu.sysparam.adhocchannel", 0);
                    mem.write8(pInfo, (byte)channel);
                    break;
                }
                case 5: {
                    int signalStrength = 100;
                    mem.write8(pInfo, (byte)signalStrength);
                }
                default: {
                    cpu.gpr[2] = -1;
                    log.warn(String.format("sceNetApctlGetInfo unimplemented code=%d(%s)", code, sceNetApctl.getApctlInfoName(code)));
                }
            }
        }
    }

    @HLEFunction(nid=-1967465135, version=150)
    public void sceNetApctlAddHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        int handler = cpu.gpr[4];
        int pArg = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlAddHandler handler=0x%08X, pArg=0x%08X", handler, pArg));
        }
        int uid = SceUidManager.getNewUid(uidPurpose);
        ApctlHandler apctlHandler = new ApctlHandler(uid, handler, pArg);
        this.apctlHandlers.put(uid, apctlHandler);
        cpu.gpr[2] = uid;
    }

    @HLEFunction(nid=1499699483, version=150)
    public void sceNetApctlDelHandler(Processor processor) {
        CpuState cpu = processor.cpu;
        int handlerId = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlDelHandler handlerId=%d", handlerId));
        }
        if (!this.apctlHandlers.containsKey(handlerId)) {
            log.warn(String.format("sceNetApctlDelHandler unknown handlerId=%d", handlerId));
            cpu.gpr[2] = -1;
        } else {
            SceUidManager.releaseUid(handlerId, uidPurpose);
            this.apctlHandlers.remove(handlerId);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-809936954, version=150)
    public void sceNetApctlConnect(Processor processor) {
        CpuState cpu = processor.cpu;
        int connIndex = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlConnect connIndex=%d", connIndex));
        }
        this.hleNetApctlConnect(connIndex);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=620663201, version=150)
    public void sceNetApctlDisconnect(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceNetApctlDisconnect");
        }
        this.changeState(0);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1575667739, version=150)
    public void sceNetApctlGetState(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int pState = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetApctlGetState pState=0x%08X, state=%d", pState, this.state));
        }
        if (!Memory.isAddressGood(pState)) {
            log.warn(String.format("sceNetApctlGetState invalid address pState=0x%08X", pState));
            cpu.gpr[2] = -1;
        } else {
            mem.write32(pState, this.state);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=691389531, version=150)
    public void sceNetApctlGetBSSDescEntry2(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetApctlGetBSSDescEntry2 [0x2935C45B]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1545109997, version=150)
    public void sceNetApctlScanSSID2(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetApctlScanSSID2 [0xA3E77E13]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-228962298, version=150)
    public void sceNetApctlGetBSSDescIDList2(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetApctlGetBSSDescIDList2 [0xF25A5006]");
        cpu.gpr[2] = -559038242;
    }

    protected class ApctlHandler {
        private int id;
        private int addr;
        private int pArg;

        private ApctlHandler(int id, int addr, int pArg) {
            this.id = id;
            this.addr = addr;
            this.pArg = pArg;
        }

        protected void triggerHandler(int oldState, int newState, int event, int error) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (thread != null) {
                Modules.ThreadManForUserModule.executeCallback(thread, this.addr, null, true, oldState, newState, event, error, this.pArg);
            }
        }

        public String toString() {
            return String.format("ApctlHandler[id=%d, addr=0x%08X, pArg=0x%08X]", this.id, this.addr, this.pArg);
        }
    }
}

