/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import com.savarese.rocksaw.net.RawSocket;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspNetSockAddrInternet;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.network.RawChannel;
import jpcsp.network.RawSelector;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetInet
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetInet");
    public static final int AF_INET = 2;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    private static final String[] socketTypeNames = new String[]{"Unknown0", "SOCK_STREAM", "SOCK_DGRAM", "SOCK_RAW"};
    public static final int SOL_SOCKET = 65535;
    public static final int INADDR_ANY = 0;
    public static final int INADDR_BROADCAST = -1;
    public static final int EAGAIN = 11;
    public static final int EWOULDBLOCK = 11;
    public static final int EINPROGRESS = 119;
    public static final int ENOTCONN = 128;
    public static final int ECLOSED = 32;
    public static final int EIO = 5;
    public static final int EISCONN = 127;
    public static final int EALREADY = 120;
    public static final int EADDRNOTAVAIL = 125;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;
    public static final int SO_DEBUG = 1;
    public static final int SO_ACCEPTCONN = 2;
    public static final int SO_REUSEADDR = 4;
    public static final int SO_KEEPALIVE = 8;
    public static final int SO_DONTROUTE = 16;
    public static final int SO_BROADCAST = 32;
    public static final int SO_USELOOPBACK = 64;
    public static final int SO_LINGER = 128;
    public static final int SO_OOBINLINE = 256;
    public static final int SO_REUSEPORT = 512;
    public static final int SO_TIMESTAMP = 1024;
    public static final int SO_ONESBCAST = 2048;
    public static final int SO_SNDBUF = 4097;
    public static final int SO_RCVBUF = 4098;
    public static final int SO_SNDLOWAT = 4099;
    public static final int SO_RCVLOWAT = 4100;
    public static final int SO_SNDTIMEO = 4101;
    public static final int SO_RCVTIMEO = 4102;
    public static final int SO_ERROR = 4103;
    public static final int SO_TYPE = 4104;
    public static final int SO_OVERFLOWED = 4105;
    public static final int SO_NONBLOCK = 4105;
    public static final int POLLIN = 1;
    public static final int POLLPRI = 2;
    public static final int POLLOUT = 4;
    public static final int POLLERR = 8;
    public static final int POLLHUP = 16;
    public static final int POLLNVAL = 32;
    public static final int POLLRDNORM = 64;
    public static final int POLLRDBAND = 128;
    public static final int POLLWRBAND = 256;
    public static final int POLL_INFTIM = -1;
    protected static final int BLOCKED_OPERATION_POLLING_MICROS = 10000;
    protected static final int readSelectionKeyOperations = 17;
    protected static final int writeSelectionKeyOperations = 4;
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    public static final int MSG_EOR = 8;
    public static final int MSG_TRUNC = 16;
    public static final int MSG_CTRUNC = 32;
    public static final int MSG_WAITALL = 64;
    public static final int MSG_DONTWAIT = 128;
    public static final int MSG_BCAST = 256;
    public static final int MSG_MCAST = 512;
    protected HashMap<Integer, pspInetSocket> sockets;
    protected static final String idPurpose = "sceNetInet-socket";

    @Override
    public String getName() {
        return "sceNetInet";
    }

    @Override
    public void start() {
        this.sockets = new HashMap();
        super.start();
    }

    @Override
    public void stop() {
        for (pspInetSocket inetSocket : this.sockets.values()) {
            inetSocket.close();
        }
        this.sockets.clear();
        super.start();
    }

    public static void setErrno(int errno) {
        Modules.ThreadManForUserModule.getCurrentThread().errno = errno;
    }

    public static int getErrno() {
        return Modules.ThreadManForUserModule.getCurrentThread().errno;
    }

    protected int createSocketId() {
        return SceUidManager.getNewId(idPurpose, 1, 255);
    }

    protected pspInetSocket createSocket(int type, int protocol) {
        int uid = this.createSocketId();
        pspInetSocket inetSocket = null;
        if (type == 1) {
            inetSocket = new pspInetStreamSocket(uid);
        } else if (type == 2) {
            inetSocket = new pspInetDatagramSocket(uid);
        } else if (type == 3) {
            inetSocket = new pspInetRawSocket(uid, protocol);
        }
        this.sockets.put(uid, inetSocket);
        return inetSocket;
    }

    protected void releaseSocketId(int id) {
        SceUidManager.releaseId(id, idPurpose);
    }

    protected int readSocketList(Selector selector, RawSelector rawSelector, int address, int n, int selectorOperation, String comment) {
        int closedSocketsCount = 0;
        if (address != 0) {
            LinkedList<Integer> closedChannels = new LinkedList<Integer>();
            int length = (n + 7) / 8;
            if (selectorOperation != 0) {
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 4);
                int value = 0;
                for (int socket = 0; socket < n; ++socket) {
                    int registeredOperation;
                    SelectableChannel selectableChannel;
                    pspInetSocket inetSocket;
                    if (socket % 32 == 0) {
                        value = memoryReader.readNext();
                    }
                    int bit = value & 1;
                    value >>>= 1;
                    if (bit == 0 || (inetSocket = this.sockets.get(socket)) == null || (selectableChannel = inetSocket.getSelectableChannel()) == null || (registeredOperation = selectorOperation & selectableChannel.validOps()) == 0) continue;
                    Selector socketSelector = inetSocket.getSelector(selector, rawSelector);
                    if (selectableChannel.isRegistered()) {
                        SelectionKey selectionKey = selectableChannel.keyFor(socketSelector);
                        selectionKey.interestOps(selectionKey.interestOps() | registeredOperation);
                        continue;
                    }
                    try {
                        selectableChannel.register(socketSelector, registeredOperation, new Integer(socket));
                        continue;
                    }
                    catch (ClosedChannelException e) {
                        closedChannels.add(socket);
                        if (!log.isDebugEnabled()) continue;
                        log.debug(String.format("%s: %s", inetSocket.toString(), e.toString()));
                    }
                }
            }
            Processor.memory.memset(address, (byte)0, length);
            for (Integer socket : closedChannels) {
                this.setSelectBit(address, socket);
                ++closedSocketsCount;
            }
        }
        return closedSocketsCount;
    }

    protected String dumpSelectBits(int addr, int n) {
        if (addr == 0 || n <= 0) {
            return "";
        }
        StringBuilder dump = new StringBuilder();
        Memory mem = Processor.memory;
        for (int socket = 0; socket < n; ++socket) {
            int bit = 1 << socket % 8;
            int value = mem.read8(addr + socket / 8);
            if ((value & bit) == 0) continue;
            if (dump.length() > 0) {
                dump.append(", ");
            }
            dump.append(String.format("%d", socket));
        }
        return dump.toString();
    }

    protected void setSelectBit(int addr, int socket) {
        if (addr != 0) {
            Memory mem = Processor.memory;
            int value = 1 << socket % 8;
            mem.write8(addr += socket / 8, (byte)(mem.read8(addr) | value));
        }
    }

    protected void blockThread(BlockingState blockingState) {
        if (!blockingState.threadBlocked) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Blocking the current thread %s", Modules.ThreadManForUserModule.getCurrentThread().toString()));
            }
            Modules.ThreadManForUserModule.hleBlockCurrentThread(blockingState);
            blockingState.threadBlocked = true;
        }
        long schedule = Emulator.getClock().microTime() + 10000L;
        Emulator.getScheduler().addAction(schedule, blockingState);
    }

    protected void unblockThread(BlockingState blockingState, int returnValue) {
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getThreadById(blockingState.threadId);
        if (thread != null) {
            thread.cpuContext.gpr[2] = returnValue;
        }
        if (blockingState.threadBlocked) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Unblocking the thread %s", thread.toString()));
            }
            Modules.ThreadManForUserModule.hleUnblockThread(blockingState.threadId);
            blockingState.threadBlocked = false;
        }
    }

    protected int checkInvalidSelectedSockets(BlockingSelectState blockingState) {
        int countInvalidSocket = 0;
        for (SelectionKey selectionKey : blockingState.selector.keys()) {
            int interestOps;
            int socket;
            pspInetSocket inetSocket;
            if (!selectionKey.isValid() || (inetSocket = this.sockets.get(socket = ((Integer)selectionKey.attachment()).intValue())) != null && inetSocket.isValid()) continue;
            ++countInvalidSocket;
            try {
                interestOps = selectionKey.interestOps();
            }
            catch (CancelledKeyException e) {
                interestOps = 29;
            }
            if ((interestOps & 0x11) != 0) {
                this.setSelectBit(blockingState.readSocketsAddr, socket);
            }
            if ((interestOps & 4) == 0) continue;
            this.setSelectBit(blockingState.writeSocketsAddr, socket);
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("checkInvalidSelectedSockets returns %d", countInvalidSocket));
        }
        return countInvalidSocket;
    }

    protected void setPollResult(pspInetPollFd[] pollFds, int socket, int revents) {
        for (int i = 0; i < pollFds.length; ++i) {
            if (pollFds[i].fd != socket) continue;
            pollFds[i].revents |= revents;
            break;
        }
    }

    protected void blockedPoll(BlockingPollState blockingState) {
        try {
            boolean threadBlocked;
            for (int i = 0; i < blockingState.pollFds.length; ++i) {
                pspInetSocket inetSocket = this.sockets.get(blockingState.pollFds[i].fd);
                if (inetSocket == null) continue;
                inetSocket.finishConnect();
            }
            int count = blockingState.selector.selectNow();
            if (count <= 0) {
                if (blockingState.isTimeout()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sceNetInetPoll returns %d sockets (timeout)", count));
                    }
                    threadBlocked = false;
                } else {
                    threadBlocked = true;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetPoll returns %d sockets", count));
                }
                Iterator<SelectionKey> it = blockingState.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    int socket;
                    SelectionKey selectionKey = it.next();
                    it.remove();
                    if (selectionKey.isReadable()) {
                        socket = (Integer)selectionKey.attachment();
                        this.setPollResult(blockingState.pollFds, socket, 65);
                    }
                    if (!selectionKey.isWritable()) continue;
                    socket = (Integer)selectionKey.attachment();
                    this.setPollResult(blockingState.pollFds, socket, 4);
                }
                threadBlocked = false;
            }
            if (threadBlocked) {
                this.blockThread(blockingState);
            } else {
                blockingState.selector.close();
                Memory mem = Processor.memory;
                for (int i = 0; i < blockingState.pollFds.length; ++i) {
                    blockingState.pollFds[i].write(mem);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(String.format("sceNetInetPoll returning pollFd[%d]=%s", i, blockingState.pollFds[i].toString()));
                }
                this.unblockThread(blockingState, count);
            }
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    protected void processSelectedKey(Selector selector, BlockingSelectState blockingState) {
        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
        while (it.hasNext()) {
            int socket;
            SelectionKey selectionKey = it.next();
            it.remove();
            if ((selectionKey.readyOps() & 0x11) != 0) {
                socket = (Integer)selectionKey.attachment();
                this.setSelectBit(blockingState.readSocketsAddr, socket);
            }
            if ((selectionKey.readyOps() & 4) == 0) continue;
            socket = (Integer)selectionKey.attachment();
            this.setSelectBit(blockingState.writeSocketsAddr, socket);
        }
    }

    protected void blockedSelect(BlockingSelectState blockingState) {
        try {
            boolean threadBlocked;
            for (SelectionKey selectionKey : blockingState.selector.keys()) {
                Integer socket = (Integer)selectionKey.attachment();
                pspInetSocket inetSocket = this.sockets.get(socket);
                if (inetSocket == null) continue;
                inetSocket.finishConnect();
            }
            int count = blockingState.count;
            count += blockingState.selector.selectNow();
            count += blockingState.rawSelector.selectNow();
            if ((count += this.checkInvalidSelectedSockets(blockingState)) <= 0) {
                if (blockingState.isTimeout()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("sceNetInetSelect returns %d sockets (timeout)", count));
                    }
                    threadBlocked = false;
                } else {
                    threadBlocked = true;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSelect returns %d sockets", count));
                }
                this.processSelectedKey(blockingState.selector, blockingState);
                this.processSelectedKey(blockingState.rawSelector, blockingState);
                threadBlocked = false;
            }
            if (threadBlocked) {
                this.blockThread(blockingState);
            } else {
                blockingState.selector.close();
                blockingState.rawSelector.close();
                if (log.isDebugEnabled() && count > 0) {
                    if (blockingState.readSocketsAddr != 0) {
                        log.debug(String.format("sceNetInetSelect returning Read Sockets       : %s", this.dumpSelectBits(blockingState.readSocketsAddr, blockingState.numberSockets)));
                    }
                    if (blockingState.writeSocketsAddr != 0) {
                        log.debug(String.format("sceNetInetSelect returning Write Sockets      : %s", this.dumpSelectBits(blockingState.writeSocketsAddr, blockingState.numberSockets)));
                    }
                    if (blockingState.outOfBandSocketsAddr != 0) {
                        log.debug(String.format("sceNetInetSelect returning Out-of-band Sockets: %s", this.dumpSelectBits(blockingState.outOfBandSocketsAddr, blockingState.numberSockets)));
                    }
                }
                this.unblockThread(blockingState, count);
            }
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    public static String internetAddressToString(int address) {
        int n4 = address >> 24 & 0xFF;
        int n3 = address >> 16 & 0xFF;
        int n2 = address >> 8 & 0xFF;
        int n1 = address & 0xFF;
        return String.format("%d.%d.%d.%d", n1, n2, n3, n4);
    }

    public static int bytesToInternetAddress(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int inetAddress = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            inetAddress = inetAddress << 8 | bytes[i] & 0xFF;
        }
        return inetAddress;
    }

    public static byte[] internetAddressToBytes(int address) {
        byte[] bytes = new byte[4];
        int n4 = address >> 24 & 0xFF;
        int n3 = address >> 16 & 0xFF;
        int n2 = address >> 8 & 0xFF;
        int n1 = address & 0xFF;
        bytes[3] = (byte)n4;
        bytes[2] = (byte)n3;
        bytes[1] = (byte)n2;
        bytes[0] = (byte)n1;
        return bytes;
    }

    protected static String getSocketTypeNameString(int type) {
        if (type < 0 || type >= socketTypeNames.length) {
            return String.format("Unknown type %d", type);
        }
        return socketTypeNames[type];
    }

    protected static String getPollEventName(int event) {
        StringBuilder name = new StringBuilder();
        if ((event & 1) != 0) {
            name.append("|POLLIN");
        }
        if ((event & 2) != 0) {
            name.append("|POLLPRI");
        }
        if ((event & 4) != 0) {
            name.append("|POLLOUT");
        }
        if ((event & 8) != 0) {
            name.append("|POLLERR");
        }
        if ((event & 0x10) != 0) {
            name.append("|POLLHUP");
        }
        if ((event & 0x20) != 0) {
            name.append("|POLLNVAL");
        }
        if ((event & 0x40) != 0) {
            name.append("|POLLRDNORM");
        }
        if ((event & 0x80) != 0) {
            name.append("|POLLRDBAND");
        }
        if ((event & 0x100) != 0) {
            name.append("|POLLWRBAND");
        }
        if (name.length() > 0 && name.charAt(0) == '|') {
            name.deleteCharAt(0);
        }
        return name.toString();
    }

    protected static String getOptionNameString(int optionName) {
        switch (optionName) {
            case 1: {
                return "SO_DEBUG";
            }
            case 2: {
                return "SO_ACCEPTCONN";
            }
            case 4: {
                return "SO_REUSEADDR";
            }
            case 8: {
                return "SO_KEEPALIVE";
            }
            case 16: {
                return "SO_DONTROUTE";
            }
            case 32: {
                return "SO_BROADCAST";
            }
            case 64: {
                return "SO_USELOOPBACK";
            }
            case 128: {
                return "SO_LINGER";
            }
            case 256: {
                return "SO_OOBINLINE";
            }
            case 512: {
                return "SO_REUSEPORT";
            }
            case 1024: {
                return "SO_TIMESTAMP";
            }
            case 2048: {
                return "SO_ONESBCAST";
            }
            case 4097: {
                return "SO_SNDBUF";
            }
            case 4098: {
                return "SO_RCVBUF";
            }
            case 4099: {
                return "SO_SNDLOWAT";
            }
            case 4100: {
                return "SO_RCVLOWAT";
            }
            case 4101: {
                return "SO_SNDTIMEO";
            }
            case 4102: {
                return "SO_RCVTIMEO";
            }
            case 4103: {
                return "SO_ERROR";
            }
            case 4104: {
                return "SO_TYPE";
            }
            case 4105: {
                return "SO_NONBLOCK";
            }
        }
        return String.format("Unknown option 0x%X", optionName);
    }

    @HLEFunction(nid=395588505, version=150)
    public void sceNetInetInit(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("sceNetInetInit");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1444059463, version=150)
    public void sceNetInetTerm(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("sceNetInetTerm");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-620147173, version=150)
    public void sceNetInetAccept(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int address = cpu.gpr[5];
        int addressLengthAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetAccept socket=%d, address=0x%08X, addressLengthAddr=0x%08X", socket, address, addressLengthAddr));
        }
        if (!Memory.isAddressGood(address)) {
            log.warn(String.format("sceNetInetAccept invalid address=0x%08X", address));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(addressLengthAddr)) {
            log.warn(String.format("sceNetInetAccept invalid addressLengthAddr=0x%08X", addressLengthAddr));
            cpu.gpr[2] = -1;
        } else if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetAccept invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
            int addressLength = mem.read32(addressLengthAddr);
            if (addressLength < 0) {
                addressLength = Integer.MAX_VALUE;
            }
            sockAddrInternet.setMaxSize(addressLength);
            sockAddrInternet.write(mem, address);
            if (sockAddrInternet.sizeof() < addressLength) {
                mem.write32(addressLengthAddr, sockAddrInternet.sizeof());
            }
            cpu.gpr[2] = inetSocket.accept(sockAddrInternet);
        }
    }

    @HLEFunction(nid=439613870, version=150)
    public void sceNetInetBind(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int address = cpu.gpr[5];
        int addressLength = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetBind socket=%d, address=0x%08X, addressLength=%d", socket, address, addressLength));
        }
        if (!Memory.isAddressGood(address)) {
            log.warn(String.format("sceNetInetBind invalid address=0x%08X", address));
            cpu.gpr[2] = -1;
        } else if (addressLength < 16) {
            log.warn(String.format("sceNetInetBind invalid addressLength=%d", addressLength));
            cpu.gpr[2] = -1;
        } else if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetBind invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
            sockAddrInternet.read(mem, address);
            if (sockAddrInternet.sin_family != 2) {
                log.warn(String.format("sceNetInetBind invalid socket address family=%d", sockAddrInternet.sin_family));
                cpu.gpr[2] = -1;
            } else {
                cpu.gpr[2] = inetSocket.bind(sockAddrInternet);
                if (cpu.gpr[2] == 0) {
                    log.info(String.format("sceNetInetBind binding to %s", sockAddrInternet.toString()));
                } else {
                    log.info(String.format("sceNetInetBind failed binding to %s", sockAddrInternet.toString()));
                }
            }
        }
    }

    @HLEFunction(nid=-1921874710, version=150)
    public void sceNetInetClose(Processor processor) {
        CpuState cpu = processor.cpu;
        int socket = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetClose socket=%d", socket));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetClose invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.close();
            this.releaseSocketId(socket);
            this.sockets.remove(socket);
        }
    }

    @HLEFunction(nid=-2141912355, version=150)
    public void sceNetInetCloseWithRST(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetCloseWithRST [0x805502DD]");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1091253418, version=150)
    public void sceNetInetConnect(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int address = cpu.gpr[5];
        int addressLength = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetConnect socket=%d, address=0x%08X, addressLength=%d", socket, address, addressLength));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetConnect invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(address)) {
            log.warn(String.format("sceNetInetConnect invalid address=0x%08X", address));
            cpu.gpr[2] = -1;
        } else if (addressLength < 16) {
            log.warn(String.format("sceNetInetConnect invalid addressLength=%d", addressLength));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
            sockAddrInternet.read(mem, address);
            if (sockAddrInternet.sin_family != 2) {
                log.warn(String.format("sceNetInetConnect invalid socket address family=%d", sockAddrInternet.sin_family));
                cpu.gpr[2] = -1;
            } else {
                cpu.gpr[2] = inetSocket.connect(sockAddrInternet);
                if (log.isInfoEnabled()) {
                    if (cpu.gpr[2] == 0) {
                        log.info(String.format("sceNetInetConnect connected to %s", sockAddrInternet.toString()));
                    } else if (sceNetInet.getErrno() == 119) {
                        log.info(String.format("sceNetInetConnect connecting to %s", sockAddrInternet.toString()));
                    } else {
                        log.info(String.format("sceNetInetConnect failed connecting to %s (errno=%d)", sockAddrInternet.toString(), sceNetInet.getErrno()));
                    }
                }
            }
        }
    }

    @HLEFunction(nid=-498616618, version=150)
    public void sceNetInetGetpeername(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int address = cpu.gpr[5];
        int addressLengthAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetGetpeername socket=%d, address=0x%08X, addressLengthAddr=0x%08X", socket, address, addressLengthAddr));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetGetpeername invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(address)) {
            log.warn(String.format("sceNetInetGetpeername invalid address address=0x%08X", address));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(addressLengthAddr)) {
            log.warn(String.format("sceNetInetGetpeername invalid address addressLengthAddr=0x%08X", addressLengthAddr));
            cpu.gpr[2] = -1;
        } else {
            pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.getSockname(sockAddrInternet);
            sockAddrInternet.setMaxSize(mem.read32(addressLengthAddr));
            sockAddrInternet.write(mem, address);
            mem.write32(addressLengthAddr, sockAddrInternet.sizeof());
        }
    }

    @HLEFunction(nid=372142037, version=150)
    public void sceNetInetGetsockname(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int address = cpu.gpr[5];
        int addressLengthAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetGetsockname socket=%d, address=0x%08X, addressLengthAddr=0x%08X", socket, address, addressLengthAddr));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetGetsockname invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(address)) {
            log.warn(String.format("sceNetInetGetsockname invalid address address=0x%08X", address));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(addressLengthAddr)) {
            log.warn(String.format("sceNetInetGetsockname invalid address addressLengthAddr=0x%08X", addressLengthAddr));
            cpu.gpr[2] = -1;
        } else {
            pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.getSockname(sockAddrInternet);
            sockAddrInternet.setMaxSize(mem.read32(addressLengthAddr));
            sockAddrInternet.write(mem, address);
            mem.write32(addressLengthAddr, sockAddrInternet.sizeof());
        }
    }

    @HLEFunction(nid=1242647676, version=150)
    public void sceNetInetGetsockopt(Processor processor) {
        int optionLength;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int level = cpu.gpr[5];
        int optionName = cpu.gpr[6];
        int optionValue = cpu.gpr[7];
        int optionLengthAddr = cpu.gpr[8];
        int n = optionLength = Memory.isAddressGood(optionLengthAddr) ? mem.read32(optionLengthAddr) : 0;
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetGetsockopt socket=%d, level=%d, optionName=0x%X(%s), optionValue=0x%08X, optionLength=0x%08X(%d)", socket, level, optionName, sceNetInet.getOptionNameString(optionName), optionValue, optionLengthAddr, optionLength));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetGetsockopt unknown socket=%d", socket));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = 0;
            if (optionName == 4103 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.getErrorAndClear());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetGetsockopt SO_ERROR returning %d", mem.read32(optionValue)));
                }
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4105 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.isBlocking() ? 0 : 1);
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 32 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.isBroadcast() ? 1 : 0);
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4100 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.getReceiveLowWaterMark());
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4099 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.getSendLowWaterMark());
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4102 && optionLength >= 4) {
                int timeout = inetSocket.getReceiveTimeout();
                mem.write32(optionValue, timeout == Integer.MAX_VALUE ? 0 : timeout);
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4101 && optionLength >= 4) {
                int timeout = inetSocket.getSendTimeout();
                mem.write32(optionValue, timeout == Integer.MAX_VALUE ? 0 : timeout);
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4098 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.getReceiveBufferSize());
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 4097 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.getSendBufferSize());
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 8 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.isKeepAlive() ? 1 : 0);
                mem.write32(optionLengthAddr, 4);
            } else if (optionName == 128 && optionLength >= 8) {
                mem.write32(optionValue, inetSocket.isLingerEnabled() ? 1 : 0);
                mem.write32(optionValue + 4, inetSocket.getLinger());
                mem.write32(optionLengthAddr, 8);
            } else if (optionName == 4 && optionLength >= 4) {
                mem.write32(optionValue, inetSocket.isReuseAddress() ? 1 : 0);
                mem.write32(optionLengthAddr, 4);
            } else {
                log.warn(String.format("Unimplemented sceNetInetGetsockopt socket=%d, level=%d, optionName=0x%X, optionValue=0x%08X, optionLength=0x%08X(%d)", socket, level, optionName, optionValue, optionLengthAddr, optionLength));
            }
        }
    }

    @HLEFunction(nid=-787867014, version=150)
    public void sceNetInetListen(Processor processor) {
        CpuState cpu = processor.cpu;
        int socket = cpu.gpr[4];
        int backlog = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetListen socket=%d, backlog=%d", socket, backlog));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetListen unknown socket=%d", socket));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.listen(backlog);
        }
    }

    @HLEFunction(nid=-89411107, version=150)
    public void sceNetInetPoll(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int fds = cpu.gpr[4];
        int nfds = cpu.gpr[5];
        int timeout = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetPoll fds=0x%08X, nfds=%d, timeout=%d", fds, nfds, timeout));
        }
        long timeoutUsec = timeout == -1 ? 2147483647000000L : (long)timeout * 1000L;
        try {
            Selector selector = Selector.open();
            pspInetPollFd[] pollFds = new pspInetPollFd[nfds];
            for (int i = 0; i < nfds; ++i) {
                pspInetPollFd pollFd = new pspInetPollFd();
                pollFd.read(mem, fds + i * pollFd.sizeof());
                pollFds[i] = pollFd;
                if (pollFd.fd == -1) {
                    pollFd.revents = 0;
                } else {
                    pspInetSocket inetSocket = this.sockets.get(pollFd.fd);
                    if (inetSocket == null) {
                        pollFd.revents = 32;
                    } else {
                        SelectableChannel selectableChannel = inetSocket.getSelectableChannel();
                        if (selectableChannel == null) {
                            pollFd.revents = 16;
                        } else {
                            int registeredOperations = 0;
                            if ((pollFd.events & 0xC3) != 0) {
                                registeredOperations |= 1;
                            }
                            if ((pollFd.events & 0x104) != 0) {
                                registeredOperations |= 4;
                            }
                            registeredOperations &= selectableChannel.validOps();
                            if (selectableChannel.isRegistered()) {
                                log.warn(String.format("sceNetInetPoll channel already registered pollFd[%d]=%s", i, pollFd));
                            } else {
                                try {
                                    selectableChannel.register(selector, registeredOperations, new Integer(pollFd.fd));
                                    pollFd.revents = 0;
                                }
                                catch (ClosedChannelException e) {
                                    pollFd.revents = 16;
                                }
                            }
                        }
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("sceNetInetPoll pollFd[%d]=%s", i, pollFd));
            }
            BlockingPollState blockingState = new BlockingPollState(selector, pollFds, timeoutUsec);
            sceNetInet.setErrno(0);
            cpu.gpr[2] = 0;
            blockingState.execute();
        }
        catch (IOException e) {
            log.error(e);
            sceNetInet.setErrno(-1);
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-844604263, version=150)
    public void sceNetInetRecv(Processor processor) {
        CpuState cpu = processor.cpu;
        int socket = cpu.gpr[4];
        int buffer = cpu.gpr[5];
        int bufferLength = cpu.gpr[6];
        int flags = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetRecv socket=%d, buffer=0x%08X, bufferLength=%d, flags=0x%X", socket, buffer, bufferLength, flags));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetRecv invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(buffer)) {
            log.warn(String.format("sceNetInetRecv invalid buffer address 0x%08X", buffer));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.recv(buffer, bufferLength, flags);
        }
    }

    @HLEFunction(nid=-921615644, version=150)
    public void sceNetInetRecvfrom(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int buffer = cpu.gpr[5];
        int bufferLength = cpu.gpr[6];
        int flags = cpu.gpr[7];
        int from = cpu.gpr[8];
        int fromLengthAddr = cpu.gpr[9];
        int fromLength = mem.read32(fromLengthAddr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetRecvfrom socket=%d, buffer=0x%08X, bufferLength=%d, flags=0x%X, from=0x%08X, fromLengthAddr=0x%08X(fromLength=%d)", socket, buffer, bufferLength, flags, from, fromLengthAddr, fromLength));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetRecvfrom invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(buffer)) {
            log.warn(String.format("sceNetInetRecvfrom invalid buffer address 0x%08X", buffer));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            pspNetSockAddrInternet fromAddrInternet = new pspNetSockAddrInternet();
            fromAddrInternet.setMaxSize(fromLength);
            fromAddrInternet.write(mem, from);
            if (fromAddrInternet.sizeof() < fromLength) {
                mem.write32(fromLengthAddr, fromAddrInternet.sizeof());
            }
            cpu.gpr[2] = inetSocket.recvfrom(buffer, bufferLength, flags, fromAddrInternet);
        }
    }

    @HLEFunction(nid=-288464430, version=150)
    public void sceNetInetRecvmsg(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetRecvmsg [0xEECE61D2]");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1541985685, version=150)
    public void sceNetInetSelect(Processor processor) {
        long timeoutUsec;
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int numberSockets = cpu.gpr[4];
        int readSocketsAddr = cpu.gpr[5];
        int writeSocketsAddr = cpu.gpr[6];
        int outOfBandSocketsAddr = cpu.gpr[7];
        int timeoutAddr = cpu.gpr[8];
        numberSockets = Math.min(numberSockets, 256);
        if (Memory.isAddressGood(timeoutAddr)) {
            timeoutUsec = (long)mem.read32(timeoutAddr) * 1000000L;
            timeoutUsec += (long)mem.read32(timeoutAddr + 4);
        } else {
            timeoutUsec = 2147483647000000L;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetSelect numberSockets=%d, readSocketsAddr=0x%08X, writeSocketsAddr=0x%08X, outOfBandSocketsAddr=0x%08X, timeoutAddr=0x%08X(%d us)", numberSockets, readSocketsAddr, writeSocketsAddr, outOfBandSocketsAddr, timeoutAddr, timeoutUsec));
            if (readSocketsAddr != 0) {
                log.debug(String.format("sceNetInetSelect Read Sockets       : %s", this.dumpSelectBits(readSocketsAddr, numberSockets)));
            }
            if (writeSocketsAddr != 0) {
                log.debug(String.format("sceNetInetSelect Write Sockets      : %s", this.dumpSelectBits(writeSocketsAddr, numberSockets)));
            }
            if (outOfBandSocketsAddr != 0) {
                log.debug(String.format("sceNetInetSelect Out-of-band Sockets: %s", this.dumpSelectBits(outOfBandSocketsAddr, numberSockets)));
            }
        }
        try {
            Selector selector = Selector.open();
            RawSelector rawSelector = RawSelector.open();
            int count = 0;
            count += this.readSocketList(selector, rawSelector, readSocketsAddr, numberSockets, 17, "readSockets");
            count += this.readSocketList(selector, rawSelector, writeSocketsAddr, numberSockets, 4, "writeSockets");
            BlockingSelectState blockingState = new BlockingSelectState(selector, rawSelector, numberSockets, readSocketsAddr, writeSocketsAddr, outOfBandSocketsAddr, timeoutUsec, count += this.readSocketList(selector, rawSelector, outOfBandSocketsAddr, numberSockets, 0, "outOfBandSockets"));
            sceNetInet.setErrno(0);
            cpu.gpr[2] = 0;
            blockingState.execute();
        }
        catch (IOException e) {
            log.error(e);
            sceNetInet.setErrno(-1);
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=2057728444, version=150)
    public void sceNetInetSend(Processor processor) {
        CpuState cpu = processor.cpu;
        int socket = cpu.gpr[4];
        int buffer = cpu.gpr[5];
        int bufferLength = cpu.gpr[6];
        int flags = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetSend socket=%d, buffer=0x%08X, bufferLength=%d, flags=0x%X, buffer: %s", socket, buffer, bufferLength, flags, Utilities.getMemoryDump(buffer, bufferLength, 4, 16)));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetSend invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(buffer)) {
            log.warn(String.format("sceNetInetSend invalid buffer address 0x%08X", buffer));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.send(buffer, bufferLength, flags);
        }
    }

    @HLEFunction(nid=84119495, version=150)
    public void sceNetInetSendto(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int buffer = cpu.gpr[5];
        int bufferLength = cpu.gpr[6];
        int flags = cpu.gpr[7];
        int to = cpu.gpr[8];
        int toLength = cpu.gpr[9];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetSendto socket=%d, buffer=0x%08X, bufferLength=%d, flags=0x%X, to=0x%08X, toLength=%d, buffer: %s", socket, buffer, bufferLength, flags, to, toLength, Utilities.getMemoryDump(buffer, bufferLength, 4, 16)));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetSendto invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (!Memory.isAddressGood(to)) {
            log.warn(String.format("sceNetInetSendto invalid address to=0x%08X", to));
            cpu.gpr[2] = -1;
        } else if (toLength < 16) {
            log.warn(String.format("sceNetInetSendto invalid length toLength=%d", toLength));
            cpu.gpr[2] = -1;
        } else {
            pspNetSockAddrInternet toSockAddress = new pspNetSockAddrInternet();
            toSockAddress.read(mem, to);
            if (toSockAddress.sin_family != 2) {
                log.warn(String.format("sceNetInetSendto invalid socket address familiy sin_family=%d", toSockAddress.sin_family));
                cpu.gpr[2] = -1;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSendto sending to %s", toSockAddress.toString()));
                }
                pspInetSocket inetSocket = this.sockets.get(socket);
                cpu.gpr[2] = inetSocket.sendto(buffer, bufferLength, flags, toSockAddress);
            }
        }
    }

    @HLEFunction(nid=2001614580, version=150)
    public void sceNetInetSendmsg(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetSendmsg [0x774E36F4]");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=803676135, version=150)
    public void sceNetInetSetsockopt(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int socket = cpu.gpr[4];
        int level = cpu.gpr[5];
        int optionName = cpu.gpr[6];
        int optionValueAddr = cpu.gpr[7];
        int optionLength = cpu.gpr[8];
        int optionValue = 0;
        if (Memory.isAddressGood(optionValueAddr) && optionLength >= 4) {
            optionValue = mem.read32(optionValueAddr);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetSetsockopt socket=%d, level=%d, optionName=%d(%s), optionValueAddr=0x%08X, optionLength=%d, optionValue: %s", socket, level, optionName, sceNetInet.getOptionNameString(optionName), optionValueAddr, optionLength, Utilities.getMemoryDump(optionValueAddr, optionLength, 4, 16)));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetSetsockopt invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            if (level == 65535) {
                if (optionName == 4105 && optionLength == 4) {
                    cpu.gpr[2] = inetSocket.setBlocking(optionValue == 0);
                } else if (optionName == 32 && optionLength == 4) {
                    cpu.gpr[2] = inetSocket.setBroadcast(optionValue != 0);
                } else if (optionName == 4100 && optionLength == 4) {
                    inetSocket.setReceiveLowWaterMark(optionValue);
                    cpu.gpr[2] = 0;
                } else if (optionName == 4099 && optionLength == 4) {
                    inetSocket.setSendLowWaterMark(optionValue);
                    cpu.gpr[2] = 0;
                } else if (optionName == 4102 && optionLength == 4) {
                    inetSocket.setReceiveTimeout(optionValue == 0 ? Integer.MAX_VALUE : optionValue);
                    cpu.gpr[2] = 0;
                } else if (optionName == 4101 && optionLength == 4) {
                    inetSocket.setSendTimeout(optionValue == 0 ? Integer.MAX_VALUE : optionValue);
                    cpu.gpr[2] = 0;
                } else if (optionName == 4098 && optionLength == 4) {
                    cpu.gpr[2] = inetSocket.setReceiveBufferSize(optionValue);
                } else if (optionName == 4097 && optionLength == 4) {
                    cpu.gpr[2] = inetSocket.setSendBufferSize(optionValue);
                } else if (optionName == 8 && optionLength == 4) {
                    cpu.gpr[2] = inetSocket.setKeepAlive(optionValue != 0);
                } else if (optionName == 128 && optionLength == 8) {
                    cpu.gpr[2] = inetSocket.setLinger(optionValue != 0, mem.read32(optionValueAddr + 4));
                } else if (optionName == 4 && optionLength == 4) {
                    cpu.gpr[2] = inetSocket.setReuseAddress(optionValue != 0);
                } else {
                    log.warn(String.format("Unimplemented sceNetInetSetsockopt socket=%d, level=%d, optionName=%d(%s), optionValue=0x%08X, optionLength=%d, optionValue: %s", socket, level, optionName, sceNetInet.getOptionNameString(optionName), optionValueAddr, optionLength, Utilities.getMemoryDump(optionValueAddr, optionLength, 4, 16)));
                    cpu.gpr[2] = 0;
                }
            } else {
                log.warn(String.format("Unimplemented sceNetInetSetsockopt socket=%d, level=%d (unknown level), optionName=%d(%s), optionValue=0x%08X, optionLength=%d, optionValue: %s", socket, level, optionName, sceNetInet.getOptionNameString(optionName), optionValueAddr, optionLength, Utilities.getMemoryDump(optionValueAddr, optionLength, 4, 16)));
                cpu.gpr[2] = 0;
            }
        }
    }

    @HLEFunction(nid=1291734614, version=150)
    public void sceNetInetShutdown(Processor processor) {
        CpuState cpu = processor.cpu;
        int socket = cpu.gpr[4];
        int how = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetShutdown socket=%d, how=%d", socket, how));
        }
        if (!this.sockets.containsKey(socket)) {
            log.warn(String.format("sceNetInetShutdown invalid socket=%d", socket));
            cpu.gpr[2] = -1;
        } else if (how < 0 || how > 2) {
            log.warn(String.format("sceNetInetShutdown invalid how=%d", how));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.sockets.get(socket);
            cpu.gpr[2] = inetSocket.shutdown(how);
        }
    }

    @HLEFunction(nid=-1954864625, version=150)
    public void sceNetInetSocket(Processor processor) {
        CpuState cpu = processor.cpu;
        int domain = cpu.gpr[4];
        int type = cpu.gpr[5];
        int protocol = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetSocket domain=%d, type=%d(%s), protocol=%d", domain, type, sceNetInet.getSocketTypeNameString(type), protocol));
        }
        if (domain != 2) {
            log.warn(String.format("sceNetInetSocket unsupported domain=%d, type=%d(%s), protocol=%d", domain, type, sceNetInet.getSocketTypeNameString(type), protocol));
            cpu.gpr[2] = -1;
        } else if (type != 2 && type != 1 && type != 3) {
            log.warn(String.format("sceNetInetSocket unsupported type=%d(%s), domain=%d, protocol=%d", type, sceNetInet.getSocketTypeNameString(type), domain, protocol));
            cpu.gpr[2] = -1;
        } else {
            pspInetSocket inetSocket = this.createSocket(type, protocol);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetInetSocket created socket=%d", inetSocket.getUid()));
            }
            cpu.gpr[2] = inetSocket.getUid();
        }
    }

    @HLEFunction(nid=-2136859971, version=150)
    public void sceNetInetSocketAbort(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetSocketAbort [0x80A21ABD]");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-72621039, version=150)
    public void sceNetInetGetErrno(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetGetErrno returning 0x%08X(%1$d)", sceNetInet.getErrno()));
        }
        cpu.gpr[2] = sceNetInet.getErrno();
    }

    @HLEFunction(nid=-1282897196, version=150)
    public void sceNetInetGetTcpcbstat(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetGetTcpcbstat [0xB3888AD4]");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=967886803, version=150)
    public void sceNetInetGetUdpcbstat(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetGetUdpcbstat [0x39B0C7D3]");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1218618614, version=150)
    public void sceNetInetInetAddr(Processor processor) {
        CpuState cpu = processor.cpu;
        int nameAddr = cpu.gpr[4];
        String name = Utilities.readStringZ(nameAddr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetInetAddr 0x%08X('%s')", nameAddr, name));
        }
        try {
            byte[] inetAddressBytes = InetAddress.getByName(name).getAddress();
            int inetAddress = sceNetInet.bytesToInternetAddress(inetAddressBytes);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetInetInetAddr 0x%08X('%s') returning 0x%08X", nameAddr, name, inetAddress));
            }
            cpu.gpr[2] = inetAddress;
        }
        catch (UnknownHostException e) {
            log.error(e);
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=467623187, version=150)
    public void sceNetInetInetAton(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int hostnameAddr = cpu.gpr[4];
        int addr = cpu.gpr[5];
        String hostname = Utilities.readStringZ(hostnameAddr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetInetAton hostnameAddr=0x%08X('%s'), addr=0x%08X", hostnameAddr, hostname, addr));
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            int resolvedAddress = sceNetInet.bytesToInternetAddress(inetAddress.getAddress());
            mem.write32(addr, resolvedAddress);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetInetInetAton returning address 0x%08X('%s')", resolvedAddress, sceNetInet.internetAddressToString(resolvedAddress)));
            } else if (log.isInfoEnabled()) {
                log.info(String.format("sceNetInetInetAton resolved '%s' into '%s'", hostname, sceNetInet.internetAddressToString(resolvedAddress)));
            }
            cpu.gpr[2] = 1;
        }
        catch (UnknownHostException e) {
            log.error(e);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-797366682, version=150)
    public void sceNetInetInetNtop(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int familiy = cpu.gpr[4];
        int srcAddr = cpu.gpr[5];
        int buffer = cpu.gpr[6];
        int bufferLength = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetInetNtop family=%d, srcAddr=0x%08X, buffer=0x%08X, bufferLength=%d", familiy, srcAddr, buffer, bufferLength));
        }
        if (familiy != 2) {
            log.warn(String.format("sceNetInetInetNtop unsupported family %d", familiy));
            cpu.gpr[2] = 0;
        } else {
            int addr = mem.read32(srcAddr);
            String ip = sceNetInet.internetAddressToString(addr);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetInetInetNtop returning %s for 0x%08X", ip, addr));
            }
            Utilities.writeStringNZ(mem, buffer, bufferLength, ip);
            cpu.gpr[2] = buffer;
        }
    }

    @HLEFunction(nid=-485782503, version=150)
    public void sceNetInetInetPton(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int familiy = cpu.gpr[4];
        int srcAddr = cpu.gpr[5];
        int buffer = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetInetInetPton family=%d, srcAddr=0x%08X, buffer=0x%08X", familiy, srcAddr, buffer));
        }
        if (familiy != 2) {
            log.warn(String.format("sceNetInetInetPton unsupported family %d", familiy));
            cpu.gpr[2] = -1;
        } else {
            String src = Utilities.readStringZ(srcAddr);
            try {
                byte[] inetAddressBytes = InetAddress.getByName(src).getAddress();
                int inetAddress = sceNetInet.bytesToInternetAddress(inetAddressBytes);
                mem.write32(buffer, inetAddress);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetInetPton returning 0x%08X for '%s'", inetAddress, src));
                }
                cpu.gpr[2] = 1;
            }
            catch (UnknownHostException e) {
                log.warn(String.format("sceNetInetInetPton returned error '%s' for '%s'", e.toString(), src));
                cpu.gpr[2] = 0;
            }
        }
    }

    @HLEFunction(nid=-1935431298, version=150)
    public void sceNetInetGetPspError(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function sceNetInetGetPspError [0x8CA3A97E]");
        cpu.gpr[2] = -559038242;
    }

    protected static class pspInetPollFd
    extends pspAbstractMemoryMappedStructure {
        public int fd;
        public int events;
        public int revents;

        protected pspInetPollFd() {
        }

        @Override
        protected void read() {
            this.fd = this.read32();
            this.events = this.read16();
            this.revents = this.read16();
        }

        @Override
        protected void write() {
            this.write32(this.fd);
            this.write16((short)this.events);
            this.write16((short)this.revents);
        }

        @Override
        public int sizeof() {
            return 8;
        }

        public String toString() {
            return String.format("PollFd[fd=%d, events=0x%04X(%s), revents=0x%04X(%s)]", this.fd, this.events, sceNetInet.getPollEventName(this.events), this.revents, sceNetInet.getPollEventName(this.revents));
        }
    }

    protected class pspInetRawSocket
    extends pspInetSocket {
        private RawChannel rawChannel;
        private int protocol;
        private boolean isAvailable;

        public pspInetRawSocket(int uid, int protocol) {
            super(uid);
            this.protocol = protocol;
            this.isAvailable = true;
        }

        protected boolean openChannel() throws IllegalStateException {
            if (!this.isAvailable) {
                return false;
            }
            if (this.rawChannel == null) {
                try {
                    this.rawChannel = new RawChannel();
                }
                catch (UnsatisfiedLinkError e) {
                    log.error(String.format("The rocksaw library is not available on your system (%s). This library is required to implement RAW sockets. Disabling this feature.", e.toString()));
                    this.isAvailable = false;
                    return false;
                }
                try {
                    this.rawChannel.socket().open(RawSocket.PF_INET, this.protocol);
                    this.rawChannel.configureBlocking(false);
                }
                catch (IOException e) {
                    log.error(String.format("You need to start Jpcsp with administator right to be able to open RAW sockets (%s). Disabling this feature.", e.toString()));
                    this.isAvailable = false;
                    return false;
                }
            }
            return this.rawChannel.socket().isOpen();
        }

        @Override
        public int bind(pspNetSockAddrInternet addr) {
            if (!this.openChannel()) {
                return -1;
            }
            try {
                this.rawChannel.socket().bind(this.getInetAddress(addr));
            }
            catch (IllegalStateException e) {
                log.error(e);
                return -1;
            }
            catch (UnknownHostException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int close() {
            if (this.rawChannel != null) {
                try {
                    this.rawChannel.close();
                }
                catch (IOException e) {
                    log.error(e);
                    this.setError(e);
                    int n = -1;
                    return n;
                }
                finally {
                    this.rawChannel = null;
                }
            }
            return 0;
        }

        @Override
        public int connect(pspNetSockAddrInternet addr) {
            log.error(String.format("sceNetInetConnect is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public boolean finishConnect() {
            return this.openChannel();
        }

        @Override
        public int getPeername(pspNetSockAddrInternet sockAddrInternet) {
            log.error(String.format("sceNetInetGetpeername is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public SelectableChannel getSelectableChannel() {
            if (!this.openChannel()) {
                return null;
            }
            return this.rawChannel;
        }

        @Override
        public int getSockname(pspNetSockAddrInternet sockAddrInternet) {
            log.error(String.format("sceNetInetGetsockname is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public boolean isValid() {
            return this.openChannel();
        }

        @Override
        public int listen(int backlog) {
            log.error(String.format("sceNetInetListen is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public int recv(int buffer, int bufferLength, int flags, BlockingReceiveState blockingState) {
            log.error(String.format("sceNetInetRecv is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, BlockingReceiveFromState blockingState) {
            try {
                if (!this.openChannel()) {
                    return -1;
                }
                if (!this.rawChannel.socket().isSelectedForRead()) {
                    if (!this.isBlocking(flags)) {
                        sceNetInet.setErrno(11);
                        return -1;
                    }
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveFromState(this, buffer, bufferLength, flags, fromAddr, 0);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                byte[] bytes = new byte[bufferLength];
                byte[] address = new byte[4];
                int length = this.rawChannel.socket().read(bytes, address);
                this.storeBytes(buffer, length, bytes);
                if (blockingState != null) {
                    blockingState.receivedLength += length;
                }
                fromAddr.sin_family = 2;
                fromAddr.sin_addr = sceNetInet.bytesToInternetAddress(address);
                fromAddr.write(Processor.memory);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetRecvfrom socket=%d received %d bytes from %s: %s", this.getUid(), length, fromAddr, Utilities.getMemoryDump(buffer, length, 4, 16)));
                }
                return length;
            }
            catch (InterruptedIOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int send(int buffer, int bufferLength, int flags, BlockingSendState blockignState) {
            log.error(String.format("sceNetInetSend is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, BlockingSendToState blockingState) {
            try {
                if (!this.openChannel()) {
                    return -1;
                }
                if (!this.rawChannel.socket().isSelectedForWrite()) {
                    if (!this.isBlocking(flags)) {
                        sceNetInet.setErrno(11);
                        return -1;
                    }
                    if (blockingState == null) {
                        blockingState = new BlockingSendToState(this, buffer, bufferLength, flags, toAddr, 0);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                InetAddress inetAddress = this.getInetAddress(toAddr);
                byte[] data = this.getByteArray(buffer, bufferLength);
                int length = this.rawChannel.socket().write(inetAddress, data);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSendto socket=%d successfully sent %d bytes", this.getUid(), length));
                }
                if (blockingState != null) {
                    blockingState.sentLength += length;
                }
                return length;
            }
            catch (IllegalStateException e) {
                log.error(e);
                return -1;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int shutdown(int how) {
            log.warn(String.format("sceNetInetShutdown is not supported on Raw sockets: %s", this.toString()));
            return 0;
        }

        @Override
        public Selector getSelector(Selector selector, RawSelector rawSelector) {
            return rawSelector;
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet, BlockingAcceptState blockingState) {
            log.error(String.format("sceNetInetAccept is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }
    }

    protected class pspInetDatagramSocket
    extends pspInetSocket {
        private DatagramChannel datagramChannel;

        public pspInetDatagramSocket(int uid) {
            super(uid);
            this.receiveBufferSize = 41600;
            this.sendBufferSize = 9216;
        }

        private void openChannel() throws IOException {
            if (this.datagramChannel == null) {
                this.datagramChannel = DatagramChannel.open();
                this.datagramChannel.configureBlocking(false);
                this.datagramChannel.socket().setReceiveBufferSize(this.receiveBufferSize);
                this.datagramChannel.socket().setSendBufferSize(this.sendBufferSize);
            }
        }

        @Override
        public int connect(pspNetSockAddrInternet addr) {
            try {
                this.openChannel();
                this.datagramChannel.connect(this.getSocketAddress(addr));
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            this.clearError();
            return 0;
        }

        @Override
        public int bind(pspNetSockAddrInternet addr) {
            try {
                this.openChannel();
                this.datagramChannel.socket().bind(this.getSocketAddress(addr));
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            this.clearError();
            return 0;
        }

        @Override
        public int close() {
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.close();
                    this.datagramChannel = null;
                }
                catch (IOException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            this.clearError();
            return 0;
        }

        @Override
        public int recv(int buffer, int bufferLength, int flags, BlockingReceiveState blockingState) {
            try {
                byte[] bytes = new byte[bufferLength];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                SocketAddress socketAddress = this.datagramChannel.receive(byteBuffer);
                int length = byteBuffer.position();
                this.storeBytes(buffer, length, bytes);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetRecv socket=%d received %d bytes from %s: %s", this.getUid(), length, socketAddress, Utilities.getMemoryDump(buffer, length, 4, 16)));
                }
                if (length < 0) {
                    this.clearError();
                    return 0;
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    sceNetInet.setErrno(11);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.receivedLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveState(this, buffer, bufferLength, flags, length);
                    }
                    if (blockingState.receivedLength < this.getReceiveLowWaterMark() && length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError();
                return length;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int send(int buffer, int bufferLength, int flags, BlockingSendState blockingState) {
            log.warn("sceNetInetSend not supported on datagram socket");
            this.setError(-1);
            return -1;
        }

        @Override
        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, BlockingReceiveFromState blockingState) {
            try {
                byte[] bytes = new byte[bufferLength];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                SocketAddress socketAddress = this.datagramChannel.receive(byteBuffer);
                int length = byteBuffer.position();
                this.storeBytes(buffer, length, bytes);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetRecvfrom socket=%d received %d bytes from %s: %s", this.getUid(), length, socketAddress, Utilities.getMemoryDump(buffer, length, 4, 16)));
                }
                if (socketAddress == null) {
                    if (!this.isBlocking(flags)) {
                        sceNetInet.setErrno(11);
                        return -1;
                    }
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveFromState(this, buffer, bufferLength, flags, fromAddr, length);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    fromAddr.readFromInetSocketAddress(inetSocketAddress);
                    fromAddr.write(Processor.memory);
                }
                this.clearError();
                return length;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, BlockingSendToState blockingState) {
            try {
                this.openChannel();
                ByteBuffer byteBuffer = this.getByteBuffer(buffer, bufferLength);
                SocketAddress socketAddress = this.getSocketAddress(toAddr);
                int length = this.datagramChannel.send(byteBuffer, socketAddress);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSendto socket=%d successfully sent %d bytes", this.getUid(), length));
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    sceNetInet.setErrno(11);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.sentLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingSendToState(this, buffer, bufferLength, flags, toAddr, length);
                    }
                    if (length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError();
                return length;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int setBroadcast(boolean broadcast) {
            super.setBroadcast(broadcast);
            try {
                this.openChannel();
                this.datagramChannel.socket().setBroadcast(broadcast);
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            this.clearError();
            return 0;
        }

        @Override
        public SelectableChannel getSelectableChannel() {
            return this.datagramChannel;
        }

        @Override
        public boolean isValid() {
            return this.datagramChannel != null && !this.datagramChannel.socket().isClosed();
        }

        @Override
        public int setReceiveBufferSize(int receiveBufferSize) {
            super.setReceiveBufferSize(receiveBufferSize);
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.socket().setReceiveBufferSize(receiveBufferSize);
                }
                catch (SocketException e) {
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setSendBufferSize(int sendBufferSize) {
            super.setSendBufferSize(sendBufferSize);
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int getPeername(pspNetSockAddrInternet sockAddrInternet) {
            if (this.datagramChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.datagramChannel.socket().getInetAddress();
            sockAddrInternet.readFromInetAddress(inetAddress);
            return 0;
        }

        @Override
        public int getSockname(pspNetSockAddrInternet sockAddrInternet) {
            if (this.datagramChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.datagramChannel.socket().getLocalAddress();
            sockAddrInternet.readFromInetAddress(inetAddress);
            return 0;
        }

        @Override
        public int setReuseAddress(boolean reuseAddress) {
            super.setReuseAddress(reuseAddress);
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.socket().setReuseAddress(reuseAddress);
                }
                catch (SocketException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int shutdown(int how) {
            log.error(String.format("Shutdown not supported on datagram socket: how=%d, %s", how, this.toString()));
            return -1;
        }

        @Override
        public boolean finishConnect() {
            return true;
        }

        @Override
        public int listen(int backlog) {
            log.error(String.format("Listen not supported on datagram socket: backlog=%d, %s", backlog, this.toString()));
            return -1;
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet, BlockingAcceptState blockingState) {
            log.error(String.format("Accept not supported on datagram socket: sockAddrInternet=%s, %s", sockAddrInternet.toString(), this.toString()));
            return -1;
        }
    }

    protected class pspInetStreamSocket
    extends pspInetSocket {
        private SocketChannel socketChannel;
        private ServerSocketChannel serverSocketChannel;
        private boolean isServerSocket;
        private SocketAddress pendingBindAddress;
        private int backlog;

        public pspInetStreamSocket(int uid) {
            super(uid);
        }

        private void configureSocketChannel() throws IOException {
            this.socketChannel.configureBlocking(false);
            this.socketChannel.socket().setReceiveBufferSize(this.receiveBufferSize);
            this.socketChannel.socket().setSendBufferSize(this.sendBufferSize);
            this.socketChannel.socket().setKeepAlive(this.keepAlive);
            this.socketChannel.socket().setReuseAddress(this.reuseAddress);
            this.socketChannel.socket().setSoLinger(this.lingerEnabled, this.linger);
            this.socketChannel.socket().setTcpNoDelay(this.tcpNoDelay);
            this.socketChannel.socket().setSoTimeout(0);
        }

        private void openChannel() throws IOException {
            if (this.isServerSocket) {
                if (this.serverSocketChannel == null) {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocketChannel.configureBlocking(false);
                    if (this.socketChannel != null) {
                        if (this.socketChannel.socket().getLocalSocketAddress() != null) {
                            this.pendingBindAddress = this.socketChannel.socket().getLocalSocketAddress();
                        }
                        this.socketChannel.close();
                        this.socketChannel = null;
                    }
                }
            } else if (this.socketChannel == null) {
                this.socketChannel = SocketChannel.open();
                this.configureSocketChannel();
            }
        }

        private void bindChannel() throws IOException {
            if (this.pendingBindAddress != null) {
                if (this.isServerSocket) {
                    this.serverSocketChannel.socket().bind(this.pendingBindAddress, this.backlog);
                } else {
                    this.socketChannel.socket().bind(this.pendingBindAddress);
                }
                this.pendingBindAddress = null;
            }
        }

        @Override
        public boolean finishConnect() {
            if (!this.isBlocking() && this.socketChannel.isConnectionPending()) {
                try {
                    return this.socketChannel.finishConnect();
                }
                catch (IOException e) {
                    log.error(e);
                    this.setSocketError(e);
                    return false;
                }
            }
            return true;
        }

        @Override
        public int connect(pspNetSockAddrInternet addr) {
            if (this.isServerSocket) {
                log.error(String.format("connect not supported on server socket stream addr=%s, %s", addr.toString(), this.toString()));
                return -1;
            }
            try {
                this.openChannel();
                this.bindChannel();
                if (!this.finishConnect()) {
                    sceNetInet.setErrno(120);
                    return -1;
                }
                if (this.socketChannel.isConnected()) {
                    sceNetInet.setErrno(127);
                    return -1;
                }
                boolean connected = this.socketChannel.connect(this.getSocketAddress(addr));
                if (this.isBlocking()) {
                    while (!this.socketChannel.finishConnect()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if (!connected) {
                    sceNetInet.setErrno(119);
                    return -1;
                }
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            this.clearError();
            return 0;
        }

        @Override
        public int bind(pspNetSockAddrInternet addr) {
            try {
                this.openChannel();
                if (this.isServerSocket) {
                    this.pendingBindAddress = this.getSocketAddress(addr);
                } else {
                    this.pendingBindAddress = null;
                    this.socketChannel.socket().bind(this.getSocketAddress(addr));
                }
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            this.clearError();
            return 0;
        }

        @Override
        public int recv(int buffer, int bufferLength, int flags, BlockingReceiveState blockingState) {
            try {
                if (!this.finishConnect()) {
                    sceNetInet.setErrno(11);
                    return -1;
                }
                byte[] bytes = new byte[bufferLength];
                int length = this.socketChannel.read(ByteBuffer.wrap(bytes));
                this.storeBytes(buffer, length, bytes);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetRecv socket=%d received %d bytes: %s", this.getUid(), length, Utilities.getMemoryDump(buffer, length, 4, 16)));
                }
                if (length < 0) {
                    this.clearError();
                    return 0;
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    sceNetInet.setErrno(11);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.receivedLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveState(this, buffer, bufferLength, flags, length);
                    }
                    if (blockingState.receivedLength < this.getReceiveLowWaterMark() && length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError();
                return length;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int send(int buffer, int bufferLength, int flags, BlockingSendState blockingState) {
            try {
                if (!this.finishConnect()) {
                    this.setError(128);
                    return -1;
                }
                ByteBuffer byteBuffer = this.getByteBuffer(buffer, bufferLength);
                int length = this.socketChannel.write(byteBuffer);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSend socket=%d successfully sent %d bytes", this.getUid(), length));
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    sceNetInet.setErrno(11);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.sentLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingSendState(this, buffer, bufferLength, flags, length);
                    }
                    if (length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError();
                return length;
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
        }

        @Override
        public int close() {
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.close();
                    this.socketChannel = null;
                }
                catch (IOException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            if (this.serverSocketChannel != null) {
                try {
                    this.serverSocketChannel.close();
                    this.serverSocketChannel = null;
                }
                catch (IOException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            this.clearError();
            return 0;
        }

        @Override
        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, BlockingReceiveFromState blockingState) {
            log.warn("sceNetInetRecvfrom not supported on stream socket");
            this.setError(-1);
            return -1;
        }

        @Override
        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, BlockingSendToState blockingState) {
            log.warn("sceNetInetSendto not supported on stream socket");
            this.setError(-1);
            return -1;
        }

        @Override
        public SelectableChannel getSelectableChannel() {
            if (this.isServerSocket) {
                return this.serverSocketChannel;
            }
            return this.socketChannel;
        }

        @Override
        public boolean isValid() {
            if (this.isServerSocket) {
                return this.serverSocketChannel != null;
            }
            if (this.socketChannel == null) {
                return false;
            }
            if (this.socketChannel.isConnectionPending()) {
                try {
                    this.socketChannel.finishConnect();
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%s: %s", this.toString(), e.toString()));
                    }
                    return false;
                }
            } else if (!this.socketChannel.isConnected()) {
                return false;
            }
            return !this.socketChannel.socket().isClosed();
        }

        @Override
        public int setReceiveBufferSize(int receiveBufferSize) {
            super.setReceiveBufferSize(receiveBufferSize);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setReceiveBufferSize(receiveBufferSize);
                }
                catch (SocketException e) {
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setSendBufferSize(int sendBufferSize) {
            super.setSendBufferSize(sendBufferSize);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int getPeername(pspNetSockAddrInternet sockAddrInternet) {
            if (this.socketChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.socketChannel.socket().getInetAddress();
            sockAddrInternet.readFromInetAddress(inetAddress);
            return 0;
        }

        @Override
        public int getSockname(pspNetSockAddrInternet sockAddrInternet) {
            if (this.socketChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.socketChannel.socket().getLocalAddress();
            sockAddrInternet.readFromInetAddress(inetAddress);
            return 0;
        }

        @Override
        public int setKeepAlive(boolean keepAlive) {
            super.setKeepAlive(keepAlive);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setKeepAlive(keepAlive);
                }
                catch (SocketException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setLinger(boolean enabled, int linger) {
            super.setLinger(enabled, linger);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setSoLinger(enabled, linger);
                }
                catch (SocketException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setReuseAddress(boolean reuseAddress) {
            super.setReuseAddress(reuseAddress);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setReuseAddress(reuseAddress);
                }
                catch (SocketException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setTcpNoDelay(boolean tcpNoDelay) {
            super.setTcpNoDelay(tcpNoDelay);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setTcpNoDelay(tcpNoDelay);
                }
                catch (SocketException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int shutdown(int how) {
            if (this.socketChannel != null) {
                try {
                    switch (how) {
                        case 0: {
                            this.socketChannel.socket().shutdownInput();
                            break;
                        }
                        case 1: {
                            this.socketChannel.socket().shutdownOutput();
                            break;
                        }
                        case 2: {
                            this.socketChannel.socket().shutdownInput();
                            this.socketChannel.socket().shutdownOutput();
                        }
                    }
                }
                catch (IOException e) {
                    log.error(e);
                    this.setError(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int listen(int backlog) {
            this.isServerSocket = true;
            this.backlog = backlog;
            try {
                this.openChannel();
                this.bindChannel();
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            return 0;
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet) {
            if (!this.isServerSocket) {
                log.error(String.format("sceNetInetAccept on non-server socket stream not allowed addr=%s, %s", sockAddrInternet.toString(), this.toString()));
                return -1;
            }
            return super.accept(sockAddrInternet);
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet, BlockingAcceptState blockingState) {
            SocketChannel socketChannel;
            try {
                this.openChannel();
                this.bindChannel();
                socketChannel = this.serverSocketChannel.accept();
            }
            catch (IOException e) {
                log.error(e);
                this.setError(e);
                return -1;
            }
            if (socketChannel == null) {
                if (this.isBlocking()) {
                    if (blockingState == null) {
                        blockingState = new BlockingAcceptState((pspInetSocket)this, sockAddrInternet);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                sceNetInet.setErrno(11);
                return -1;
            }
            pspInetStreamSocket inetSocket = (pspInetStreamSocket)sceNetInet.this.createSocket(1, 0);
            inetSocket.socketChannel = socketChannel;
            inetSocket.copySocketAttributes(this);
            try {
                inetSocket.configureSocketChannel();
            }
            catch (IOException e) {
                log.error(e);
            }
            sockAddrInternet.readFromInetSocketAddress((InetSocketAddress)socketChannel.socket().getRemoteSocketAddress());
            sockAddrInternet.write(Processor.memory);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetInetAccept accepted connection from %s on socket %s", sockAddrInternet.toString(), inetSocket.toString()));
            } else if (log.isInfoEnabled()) {
                log.info(String.format("sceNetInetAccept accepted connection from %s", sockAddrInternet.toString()));
            }
            return inetSocket.getUid();
        }
    }

    protected abstract class pspInetSocket {
        public static final long NO_TIMEOUT = 2147483647000000L;
        public static final int NO_TIMEOUT_INT = Integer.MAX_VALUE;
        private int uid;
        protected boolean blocking = true;
        protected boolean broadcast;
        protected boolean onesBroadcast;
        protected int receiveLowWaterMark = 1;
        protected int sendLowWaterMark = 2048;
        protected int receiveTimeout = Integer.MAX_VALUE;
        protected int sendTimeout = Integer.MAX_VALUE;
        protected int receiveBufferSize = 16384;
        protected int sendBufferSize = 16384;
        protected int error;
        protected boolean reuseAddress;
        protected boolean keepAlive;
        protected boolean lingerEnabled;
        protected int linger;
        protected boolean tcpNoDelay;

        public pspInetSocket(int uid) {
            this.uid = uid;
        }

        public int getUid() {
            return this.uid;
        }

        public abstract int connect(pspNetSockAddrInternet var1);

        public abstract int bind(pspNetSockAddrInternet var1);

        public abstract int recv(int var1, int var2, int var3, BlockingReceiveState var4);

        public abstract int send(int var1, int var2, int var3, BlockingSendState var4);

        public abstract int recvfrom(int var1, int var2, int var3, pspNetSockAddrInternet var4, BlockingReceiveFromState var5);

        public abstract int sendto(int var1, int var2, int var3, pspNetSockAddrInternet var4, BlockingSendToState var5);

        public abstract int close();

        public abstract SelectableChannel getSelectableChannel();

        public abstract boolean isValid();

        public abstract int getSockname(pspNetSockAddrInternet var1);

        public abstract int getPeername(pspNetSockAddrInternet var1);

        public abstract int shutdown(int var1);

        public abstract int listen(int var1);

        public abstract int accept(pspNetSockAddrInternet var1, BlockingAcceptState var2);

        public abstract boolean finishConnect();

        public int setBlocking(boolean blocking) {
            this.blocking = blocking;
            return 0;
        }

        public boolean isBlocking() {
            return this.blocking;
        }

        public boolean isBlocking(int flags) {
            if ((flags & 0x80) != 0) {
                return false;
            }
            return this.isBlocking();
        }

        protected SocketAddress getSocketAddress(int address, int port) throws UnknownHostException {
            InetSocketAddress socketAddress;
            if (address == 0) {
                socketAddress = new InetSocketAddress(port);
            } else if (address == -1 && !this.isOnesBroadcast()) {
                InetAddress localInetAddress = InetAddress.getByName(sceNetApctl.getLocalHostIP());
                int localAddress = sceNetInet.bytesToInternetAddress(localInetAddress.getAddress());
                int subnetMask = Integer.reverseBytes(sceNetApctl.getSubnetMaskInt());
                int localBroadcastAddress = localAddress & subnetMask;
                socketAddress = new InetSocketAddress(InetAddress.getByAddress(sceNetInet.internetAddressToBytes(localBroadcastAddress |= address & ~subnetMask)), port);
            } else {
                socketAddress = new InetSocketAddress(InetAddress.getByAddress(sceNetInet.internetAddressToBytes(address)), port);
            }
            return socketAddress;
        }

        protected SocketAddress getSocketAddress(pspNetSockAddrInternet addr) throws UnknownHostException {
            return this.getSocketAddress(addr.sin_addr, addr.sin_port);
        }

        protected InetAddress getInetAddress(int address) throws UnknownHostException {
            InetAddress inetAddress = InetAddress.getByAddress(sceNetInet.internetAddressToBytes(address));
            return inetAddress;
        }

        protected InetAddress getInetAddress(pspNetSockAddrInternet addr) throws UnknownHostException {
            return this.getInetAddress(addr.sin_addr);
        }

        protected void copySocketAttributes(pspInetSocket from) {
            this.setBlocking(from.isBlocking());
            this.setBroadcast(from.isBroadcast());
            this.setOnesBroadcast(from.isOnesBroadcast());
            this.setReceiveLowWaterMark(from.getReceiveLowWaterMark());
            this.setSendLowWaterMark(from.getSendLowWaterMark());
            this.setReceiveTimeout(from.getReceiveTimeout());
            this.setSendTimeout(from.getSendTimeout());
            this.setReceiveBufferSize(from.getReceiveBufferSize());
            this.setSendBufferSize(from.getSendBufferSize());
            this.setReuseAddress(from.isReuseAddress());
            this.setKeepAlive(from.isKeepAlive());
            this.setLinger(from.isLingerEnabled(), from.getLinger());
            this.setTcpNoDelay(from.isTcpNoDelay());
        }

        public boolean isBroadcast() {
            return this.broadcast;
        }

        public int setBroadcast(boolean broadcast) {
            this.broadcast = broadcast;
            return 0;
        }

        public int getReceiveLowWaterMark() {
            return this.receiveLowWaterMark;
        }

        public void setReceiveLowWaterMark(int receiveLowWaterMark) {
            this.receiveLowWaterMark = receiveLowWaterMark;
        }

        public int getSendLowWaterMark() {
            return this.sendLowWaterMark;
        }

        public void setSendLowWaterMark(int sendLowWaterMark) {
            this.sendLowWaterMark = sendLowWaterMark;
        }

        protected byte[] getByteArray(int address, int length) {
            byte[] bytes = new byte[length];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)memoryReader.readNext();
            }
            return bytes;
        }

        protected ByteBuffer getByteBuffer(int address, int length) {
            return ByteBuffer.wrap(this.getByteArray(address, length));
        }

        public String toString() {
            return String.format("pspInetSocket[uid=%d]", this.uid);
        }

        public boolean isOnesBroadcast() {
            return this.onesBroadcast;
        }

        public void setOnesBroadcast(boolean onesBroadcast) {
            this.onesBroadcast = onesBroadcast;
        }

        public int getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(int receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public int getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(int sendTimeout) {
            this.sendTimeout = sendTimeout;
        }

        public int getErrorAndClear() {
            int value = this.error;
            this.clearError();
            return value;
        }

        protected void setSocketError(int error) {
            this.error = error;
        }

        protected void setSocketError(Exception e) {
            if (e instanceof NotYetConnectedException) {
                this.setSocketError(128);
            } else if (e instanceof ClosedChannelException) {
                this.setSocketError(32);
            } else if (e instanceof AsynchronousCloseException) {
                this.setSocketError(32);
            } else if (e instanceof ClosedByInterruptException) {
                this.setSocketError(32);
            } else if (e instanceof BindException) {
                this.setSocketError(125);
            } else if (e instanceof IOException) {
                this.setSocketError(5);
            } else {
                this.setSocketError(-1);
            }
        }

        protected void setError(IOException e) {
            this.setSocketError(e);
            sceNetInet.setErrno(this.error);
        }

        protected void setError(int error) {
            this.setSocketError(error);
            sceNetInet.setErrno(this.error);
        }

        protected void clearError() {
            this.error = 0;
            sceNetInet.setErrno(0);
        }

        public int getReceiveBufferSize() {
            return this.receiveBufferSize;
        }

        public int setReceiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return 0;
        }

        public int getSendBufferSize() {
            return this.sendBufferSize;
        }

        public int setSendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return 0;
        }

        public boolean isReuseAddress() {
            return this.reuseAddress;
        }

        public int setReuseAddress(boolean reuseAddress) {
            this.reuseAddress = reuseAddress;
            return 0;
        }

        public boolean isKeepAlive() {
            return this.keepAlive;
        }

        public int setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return 0;
        }

        public boolean isLingerEnabled() {
            return this.lingerEnabled;
        }

        public int getLinger() {
            return this.linger;
        }

        public int setLinger(boolean enabled, int linger) {
            this.lingerEnabled = enabled;
            this.linger = linger;
            return 0;
        }

        public boolean isTcpNoDelay() {
            return this.tcpNoDelay;
        }

        public int setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return 0;
        }

        protected void storeBytes(int address, int length, byte[] bytes) {
            if (length > 0) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, length, 1);
                for (int i = 0; i < length; ++i) {
                    memoryWriter.writeNext(bytes[i]);
                }
                memoryWriter.flush();
            }
        }

        public Selector getSelector(Selector selector, RawSelector rawSelector) {
            return selector;
        }

        public int recv(int buffer, int bufferLength, int flags) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn(String.format("sceNetInetRecv unsupported flag 0x%X on socket", flags));
            }
            return this.recv(buffer, bufferLength, flags, null);
        }

        public void blockedRecv(BlockingReceiveState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetRecv socket=%d returning %d (timeout)", this.getUid(), blockingState.receivedLength));
                }
                sceNetInet.setErrno(11);
                sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
            } else {
                int length = this.recv(blockingState.buffer + blockingState.receivedLength, blockingState.bufferLength - blockingState.receivedLength, blockingState.flags, blockingState);
                if (length >= 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
                }
            }
        }

        public int send(int buffer, int bufferLength, int flags) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn(String.format("sceNetInetSend unsupported flag 0x%X on socket", flags));
            }
            return this.send(buffer, bufferLength, flags, null);
        }

        public void blockedSend(BlockingSendState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSend socket=%d returning %d (timeout)", this.getUid(), blockingState.sentLength));
                }
                sceNetInet.setErrno(11);
                sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
            } else {
                int length = this.send(blockingState.buffer + blockingState.sentLength, blockingState.bufferLength - blockingState.sentLength, blockingState.flags, blockingState);
                if (length > 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
                }
            }
        }

        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn(String.format("sceNetInetSendto unsupported flag 0x%X on socket", flags));
            }
            return this.sendto(buffer, bufferLength, flags, toAddr, null);
        }

        public void blockedSendto(BlockingSendToState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetSendto socket=%d returning %d (timeout)", this.getUid(), blockingState.sentLength));
                }
                sceNetInet.setErrno(11);
                sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
            } else {
                int length = this.sendto(blockingState.buffer + blockingState.sentLength, blockingState.bufferLength - blockingState.sentLength, blockingState.flags, blockingState.toAddr, blockingState);
                if (length > 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
                }
            }
        }

        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn(String.format("sceNetInetRecvfrom unsupported flag 0x%X on socket", flags));
            }
            return this.recvfrom(buffer, bufferLength, flags, fromAddr, null);
        }

        public void blockedRecvfrom(BlockingReceiveFromState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("sceNetInetRecvfrom socket=%d returning %d (timeout)", this.getUid(), blockingState.receivedLength));
                }
                sceNetInet.setErrno(11);
                sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
            } else {
                int length = this.recvfrom(blockingState.buffer + blockingState.receivedLength, blockingState.bufferLength - blockingState.receivedLength, blockingState.flags, blockingState.fromAddr, blockingState);
                if (length >= 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
                }
            }
        }

        public int accept(pspNetSockAddrInternet sockAddrInternet) {
            return this.accept(sockAddrInternet, null);
        }

        public void blockedAccept(BlockingAcceptState blockingState) {
            int socketUid = this.accept(blockingState.acceptAddr, blockingState);
            if (socketUid >= 0) {
                sceNetInet.this.unblockThread(blockingState, socketUid);
            }
        }
    }

    protected static class BlockingSendToState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public pspNetSockAddrInternet toAddr;
        public int sentLength;

        public BlockingSendToState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, int sentLength) {
            super(inetSocket, inetSocket.getSendTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.toAddr = toAddr;
            this.sentLength = sentLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedSendto(this);
        }
    }

    protected static class BlockingSendState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public int sentLength;

        public BlockingSendState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, int sentLength) {
            super(inetSocket, inetSocket.getSendTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.sentLength = sentLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedSend(this);
        }
    }

    protected static class BlockingReceiveFromState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public pspNetSockAddrInternet fromAddr;
        public int receivedLength;

        public BlockingReceiveFromState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, int receivedLength) {
            super(inetSocket, inetSocket.getReceiveTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.fromAddr = fromAddr;
            this.receivedLength = receivedLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedRecvfrom(this);
        }
    }

    protected static class BlockingReceiveState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public int receivedLength;

        public BlockingReceiveState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, int receivedLength) {
            super(inetSocket, inetSocket.getReceiveTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.receivedLength = receivedLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedRecv(this);
        }
    }

    protected static class BlockingSelectState
    extends BlockingState {
        public Selector selector;
        public RawSelector rawSelector;
        public int numberSockets;
        public int readSocketsAddr;
        public int writeSocketsAddr;
        public int outOfBandSocketsAddr;
        public int count;

        public BlockingSelectState(Selector selector, RawSelector rawSelector, int numberSockets, int readSocketsAddr, int writeSocketsAddr, int outOfBandSocketsAddr, long timeout, int count) {
            super(null, timeout);
            this.selector = selector;
            this.rawSelector = rawSelector;
            this.numberSockets = numberSockets;
            this.readSocketsAddr = readSocketsAddr;
            this.writeSocketsAddr = writeSocketsAddr;
            this.outOfBandSocketsAddr = outOfBandSocketsAddr;
            this.count = count;
        }

        @Override
        protected void executeBlockingState() {
            Modules.sceNetInetModule.blockedSelect(this);
        }
    }

    protected static class BlockingPollState
    extends BlockingState {
        public Selector selector;
        public pspInetPollFd[] pollFds;

        public BlockingPollState(Selector selector, pspInetPollFd[] pollFds, long timeout) {
            super(null, timeout);
            this.selector = selector;
            this.pollFds = pollFds;
        }

        @Override
        protected void executeBlockingState() {
            Modules.sceNetInetModule.blockedPoll(this);
        }
    }

    protected static class BlockingAcceptState
    extends BlockingState {
        public pspNetSockAddrInternet acceptAddr;

        public BlockingAcceptState(pspInetSocket inetSocket, pspNetSockAddrInternet acceptAddr) {
            super(inetSocket, 2147483647000000L);
            this.acceptAddr = acceptAddr;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedAccept(this);
        }
    }

    protected static abstract class BlockingState
    implements IAction {
        public pspInetSocket inetSocket;
        public int threadId;
        public boolean threadBlocked;
        public long timeout;
        public long start;
        private boolean insideExecute;

        public BlockingState(pspInetSocket inetSocket, long timeout) {
            this.inetSocket = inetSocket;
            this.threadId = Modules.ThreadManForUserModule.getCurrentThreadID();
            this.threadBlocked = false;
            this.start = Emulator.getClock().microTime();
            this.timeout = timeout;
        }

        public boolean isTimeout() {
            long now = Emulator.getClock().microTime();
            return now >= this.start + this.timeout;
        }

        @Override
        public void execute() {
            if (!this.insideExecute) {
                this.insideExecute = true;
                this.executeBlockingState();
                this.insideExecute = false;
            }
        }

        protected abstract void executeBlockingState();
    }
}

