/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceNetInet;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetResolver
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNetResolver");
    protected HashMap<Integer, ResolverID> RIDs = new HashMap();

    @Override
    public String getName() {
        return "sceNetResolver";
    }

    @HLEFunction(nid=-214495647, version=150)
    public void sceNetResolverInit(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.warn("sceNetResolverInit");
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1631066442, version=150)
    public void sceNetResolverTerm(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug("sceNetResolverTerm");
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=608268975, version=150)
    public void sceNetResolverCreate(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int pRid = cpu.gpr[4];
        int buffer = cpu.gpr[5];
        int bufferLength = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetResolverCreate pRid=0x%08X, buffer=0x%08X, bufferLength=5d", pRid, buffer, bufferLength));
        }
        int newID = SceUidManager.getNewUid("sceNetResolver-NetResolver");
        ResolverID newRID = new ResolverID(newID, true);
        this.RIDs.put(newID, newRID);
        mem.write32(pRid, newRID.getID());
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1806549495, version=150)
    public void sceNetResolverDelete(Processor processor) {
        CpuState cpu = processor.cpu;
        int rid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetResolverDelete rid=%d", rid));
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=575430468, version=150)
    public void sceNetResolverStartNtoA(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int rid = cpu.gpr[4];
        int hostnameAddr = cpu.gpr[5];
        int addr = cpu.gpr[6];
        int timeout = cpu.gpr[7];
        int retry = cpu.gpr[8];
        String hostname = Utilities.readStringZ(hostnameAddr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetResolverStartNtoA rid=%d, hostnameAddr=0x%08X('%s'), addr=0x%08X, timeout=%d, retry=%d", rid, hostnameAddr, hostname, addr, timeout, retry));
        }
        cpu.gpr[2] = 0;
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            int resolvedAddress = sceNetInet.bytesToInternetAddress(inetAddress.getAddress());
            mem.write32(addr, resolvedAddress);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetResolverStartNtoA returning address 0x%08X('%s')", resolvedAddress, sceNetInet.internetAddressToString(resolvedAddress)));
            } else if (log.isInfoEnabled()) {
                log.info(String.format("sceNetResolverStartNtoA resolved '%s' into '%s'", hostname, sceNetInet.internetAddressToString(resolvedAddress)));
            }
        }
        catch (UnknownHostException e) {
            log.error(e);
            cpu.gpr[2] = -2143222764;
        }
    }

    @HLEFunction(nid=1654534071, version=150)
    public void sceNetResolverStartAtoN(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int rid = cpu.gpr[4];
        int addr = cpu.gpr[5];
        int hostnameAddr = cpu.gpr[6];
        int hostnameLength = cpu.gpr[7];
        int timeout = cpu.gpr[8];
        int retry = cpu.gpr[9];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetResolverStartAtoN rid=%d, addr=0x%08X, hostnameAddr=0x%08X, hostnameLength=%d, timeout=%d, retry=%d", rid, addr, hostnameAddr, hostnameLength, timeout, retry));
        }
        cpu.gpr[2] = 0;
        try {
            byte[] bytes = sceNetInet.internetAddressToBytes(addr);
            InetAddress inetAddress = InetAddress.getByAddress(bytes);
            String hostName = inetAddress.getHostName();
            Utilities.writeStringNZ(mem, hostnameAddr, hostnameLength, hostName);
            if (log.isDebugEnabled()) {
                log.debug(String.format("sceNetResolverStartAtoN returning host name '%s'", hostName));
            }
        }
        catch (UnknownHostException e) {
            log.error(e);
            cpu.gpr[2] = -2143222764;
        }
    }

    @HLEFunction(nid=-2138087325, version=150)
    public void sceNetResolverStop(Processor processor) {
        CpuState cpu = processor.cpu;
        int rid = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceNetResolverStop rid=%d", rid));
        }
        if (this.RIDs.containsKey(rid)) {
            ResolverID currentRID = this.RIDs.get(rid);
            if (currentRID.getIDStatus()) {
                currentRID.stop();
                cpu.gpr[2] = 0;
            } else {
                cpu.gpr[2] = -2143222774;
            }
        } else {
            cpu.gpr[2] = -2143222776;
        }
    }

    @HLEFunction(nid=348225273, version=150)
    public void sceNetResolverStartNtoAAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetResolverStartNtoAAsync");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1430220412, version=150)
    public void sceNetResolverStartAtoNAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetResolverStartAtoNAsync");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1323930456, version=150)
    public void sceNetResolverPollAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetResolverPollAsync");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=309628601, version=150)
    public void sceNetResolverWaitAsync(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceNetResolverWaitAsync");
        cpu.gpr[2] = -559038242;
    }

    protected static class ResolverID {
        private int id;
        private boolean isRunning;

        public ResolverID(int id, boolean running) {
            this.id = id;
            this.isRunning = running;
        }

        public int getID() {
            return this.id;
        }

        public boolean getIDStatus() {
            return this.isRunning;
        }

        public void stop() {
            this.isRunning = false;
        }
    }
}

