/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceNpService
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNpService");
    private int npManagerMemSize;
    private int npManagerMaxMemSize;
    private int npManagerFreeMemSize;

    @Override
    public String getName() {
        return "sceNpService";
    }

    @HLEFunction(nid=261052449, version=150)
    public void sceNpService_0F8F5821(Processor processor) {
        CpuState cpu = processor.cpu;
        int poolSize = cpu.gpr[4];
        int stackSize = cpu.gpr[5];
        int threadPriority = cpu.gpr[6];
        log.warn("IGNORING: sceNpService_0F8F5821 (poolsize=0x" + Integer.toHexString(poolSize) + ", stackSize=0x" + Integer.toHexString(stackSize) + ", threadPriority=0x" + Integer.toHexString(threadPriority) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.npManagerMemSize = poolSize;
        this.npManagerMaxMemSize = poolSize / 2;
        this.npManagerFreeMemSize = poolSize - 16;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=11336387, version=150)
    public void sceNpService_00ACFAC3(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int memStatAddr = cpu.gpr[4];
        log.warn("PARTIAL: sceNpService_00ACFAC3 (memStatAddr=0x" + Integer.toHexString(memStatAddr) + ")");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(memStatAddr)) {
            mem.write32(memStatAddr, this.npManagerMemSize);
            mem.write32(memStatAddr + 4, this.npManagerMaxMemSize);
            mem.write32(memStatAddr + 8, this.npManagerFreeMemSize);
        }
        cpu.gpr[2] = 0;
    }
}

