/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Processor;
import jpcsp.hardware.Battery;
import org.apache.log4j.Logger;

public class scePower
extends HLEModule {
    protected static Logger log = Modules.getLogger("scePower");
    public static final int PSP_POWER_CB_POWER_SWITCH = Integer.MIN_VALUE;
    public static final int PSP_POWER_CB_HOLD_SWITCH = 0x40000000;
    public static final int PSP_POWER_CB_STANDBY = 524288;
    public static final int PSP_POWER_CB_RESUME_COMPLETE = 262144;
    public static final int PSP_POWER_CB_RESUMING = 131072;
    public static final int PSP_POWER_CB_SUSPENDING = 65536;
    public static final int PSP_POWER_CB_AC_POWER = 4096;
    public static final int PSP_POWER_CB_BATTERY_LOW = 256;
    public static final int PSP_POWER_CB_BATTERY_EXIST = 128;
    public static final int PSP_POWER_CB_BATTPOWER = 127;
    public static final int PSP_POWER_CB_SLOT_AUTO = -1;
    protected int[] powerCBSlots = new int[16];
    protected int pllClock = 222;
    protected int cpuClock = 222;
    protected int busClock = 111;
    protected static final int backlightMaximum = 4;

    @Override
    public String getName() {
        return "scePower";
    }

    @HLEFunction(nid=726793775, version=150)
    public void scePower_2B51FE2F(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePower_2B51FE2F [0x2B51FE2F]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1143733164, version=150)
    public void scePowerGetBacklightMaximum(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBacklightMaximum backlightMaxium=4");
        cpu.gpr[2] = 4;
    }

    @HLEFunction(nid=-271333021, version=150)
    public void scePowerTick(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("Unimplemented NID function scePowerTick [0xEFD3C963]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-306102299, version=150)
    public void scePowerGetIdleTimer(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerGetIdleTimer [0xEDC13FE5]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=2133898161, version=150)
    public void scePowerIdleTimerEnable(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerIdleTimerEnable [0x7F30B3B1]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1758664383, version=150)
    public void scePowerIdleTimerDisable(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerIdleTimerDisable [0x972CE941]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=670247212, version=150)
    public void scePowerBatteryUpdateInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerBatteryUpdateInfo [0x27F3292C]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-387653116, version=150)
    public void scePowerGetForceSuspendCapacity(Processor processor) {
        CpuState cpu = processor.cpu;
        int forceSuspendCapacity = Battery.getForceSuspendPercent() * Battery.getFullCapacity() / 100;
        log.debug("scePowerGetForceSuspendCapacity " + forceSuspendCapacity + "mAh");
        cpu.gpr[2] = forceSuspendCapacity;
    }

    @HLEFunction(nid=-1181149108, version=150)
    public void scePowerGetLowBatteryCapacity(Processor processor) {
        CpuState cpu = processor.cpu;
        int lowBatteryCapacity = Battery.getLowPercent() * Battery.getFullCapacity() / 100;
        log.debug("scePowerGetLowBatteryCapacity " + lowBatteryCapacity + "mAh");
        cpu.gpr[2] = lowBatteryCapacity;
    }

    @HLEFunction(nid=-2025582754, version=150)
    public void scePowerIsPowerOnline(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerIsPowerOnline pluggedIn=" + Battery.isPluggedIn());
        cpu.gpr[2] = Battery.isPluggedIn() ? 1 : 0;
    }

    @HLEFunction(nid=184356235, version=150)
    public void scePowerIsBatteryExist(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerIsBatteryExist batteryPresent=" + Battery.isPresent());
        cpu.gpr[2] = Battery.isPresent() ? 1 : 0;
    }

    @HLEFunction(nid=508101633, version=150)
    public void scePowerIsBatteryCharging(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerIsBatteryCharging batteryCharging=" + Battery.isCharging());
        cpu.gpr[2] = Battery.isCharging() ? 1 : 0;
    }

    @HLEFunction(nid=-1270666296, version=150)
    public void scePowerGetBatteryChargingStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        int status = 0;
        if (Battery.isPresent()) {
            status |= 0x80;
        }
        if (Battery.isPluggedIn()) {
            status |= 0x1000;
        }
        if (Battery.isCharging()) {
            status |= 0x7F;
        }
        log.debug("scePowerGetBatteryChargingStatus status=0x" + Integer.toHexString(status));
        cpu.gpr[2] = status;
    }

    @HLEFunction(nid=-754493146, version=150)
    public void scePowerIsLowBattery(Processor processor) {
        CpuState cpu = processor.cpu;
        int isLow = Battery.getCurrentPowerPercent() <= Battery.getLowPercent() ? 1 : 0;
        log.debug("scePowerIsLowBattery " + isLow);
        cpu.gpr[2] = isLow;
    }

    @HLEFunction(nid=2023860118, version=150)
    public void scePowerIsSuspendRequired(Processor processor) {
        CpuState cpu = processor.cpu;
        int isSuspendRequired = Battery.getCurrentPowerPercent() <= Battery.getForceSuspendPercent() ? 1 : 0;
        log.debug("scePowerIsSuspendRequired isSuspendRequired=" + isSuspendRequired);
        cpu.gpr[2] = isSuspendRequired;
    }

    @HLEFunction(nid=-1795840705, version=150)
    public void scePowerGetBatteryRemainCapacity(Processor processor) {
        CpuState cpu = processor.cpu;
        int batteryRemainCapacity = Battery.getCurrentPowerPercent() * Battery.getFullCapacity() / 100;
        log.debug("scePowerGetBatteryRemainCapacity " + batteryRemainCapacity + "mAh");
        cpu.gpr[2] = batteryRemainCapacity;
    }

    @HLEFunction(nid=-48717569, version=150)
    public void scePowerGetBatteryFullCapacity(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBatteryFullCapacity " + Battery.getFullCapacity() + "mAh");
        cpu.gpr[2] = Battery.getFullCapacity();
    }

    @HLEFunction(nid=545640797, version=150)
    public void scePowerGetBatteryLifePercent(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBatteryLifePercent percent=" + Battery.getCurrentPowerPercent());
        cpu.gpr[2] = Battery.getCurrentPowerPercent();
    }

    @HLEFunction(nid=-1896136798, version=150)
    public void scePowerGetBatteryLifeTime(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBatteryLifeTime batteryLifeTime=" + Battery.getLifeTime());
        cpu.gpr[2] = Battery.getLifeTime();
    }

    @HLEFunction(nid=685842467, version=150)
    public void scePowerGetBatteryTemp(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBatteryTemp batteryTemp=" + Battery.getTemperature());
        cpu.gpr[2] = Battery.getTemperature();
    }

    @HLEFunction(nid=-2044010074, version=150)
    public void scePowerGetBatteryElec(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerGetBatteryElec [0x862AE1A6]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1211951211, version=150)
    public void scePowerGetBatteryVolt(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBatteryVolt batteryVoltage=" + Battery.getVoltage());
        cpu.gpr[2] = Battery.getVoltage();
    }

    @HLEFunction(nid=591620682, version=150)
    public void scePower_23436A4A(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePower_23436A4A [0x23436A4A]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=215096095, version=150)
    public void scePowerSetPowerSwMode(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerSetPowerSwMode [0x0CD21B1F]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=375185541, version=150)
    public void scePowerGetPowerSwMode(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerGetPowerSwMode [0x165CE085]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=599990270, version=150)
    public void scePowerVolatileMemLock(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerVolatileMemLock [0x23C31FFE]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-90724967, version=150)
    public void scePowerVolatileMemTryLock(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerVolatileMemTryLock [0xFA97A599]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1276258303, version=150)
    public void scePowerVolatileMemUnlock(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerVolatileMemUnlock [0xB3EDD801]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-691005713, version=150)
    public void scePowerLock(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerLock [0xD6D016EF]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-901958463, version=150)
    public void scePowerUnlock(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerUnlock [0xCA3D34C1]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-614282801, version=150)
    public void scePowerCancelRequest(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerCancelRequest [0xDB62C9CF]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=2141456093, version=150)
    public void scePowerIsRequest(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerIsRequest [0x7FA406DD]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=729578740, version=150)
    public void scePowerRequestStandby(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerRequestStandby [0x2B7C7CF4]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1405957684, version=150)
    public void scePowerRequestSuspend(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerRequestSuspend [0xAC32C9CC]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=678795595, version=150)
    public void scePower_2875994B(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePower_2875994B [0x2875994B]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=961654611, version=150)
    public void scePowerWaitRequestCompletion(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerWaitRequestCompletion [0x3951AF53]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=7663515, version=150)
    public void scePowerGetResumeCount(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerGetResumeCount [0x0074EF9B]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=79132270, version=150)
    public void scePowerRegisterCallback(Processor processor) {
        ThreadManForUser threadMan;
        CpuState cpu = processor.cpu;
        int slot = cpu.gpr[4];
        int uid = cpu.gpr[5];
        log.info(String.format("scePowerRegisterCallback slot=%d, SceUID=0x%X", slot, uid));
        boolean notifyCallback = false;
        if (slot == -1) {
            cpu.gpr[2] = -2147483614;
            for (int i = 0; i < this.powerCBSlots.length; ++i) {
                if (this.powerCBSlots[i] != 0) continue;
                this.powerCBSlots[i] = uid;
                cpu.gpr[2] = i;
                notifyCallback = true;
                break;
            }
        } else if (slot >= 0 && slot < this.powerCBSlots.length) {
            if (this.powerCBSlots[slot] == 0) {
                this.powerCBSlots[slot] = uid;
                cpu.gpr[2] = 0;
                notifyCallback = true;
            } else {
                cpu.gpr[2] = -2147483616;
            }
        } else {
            cpu.gpr[2] = -1;
        }
        if (notifyCallback && (threadMan = Modules.ThreadManForUserModule).hleKernelRegisterCallback(4, uid)) {
            threadMan.hleKernelNotifyCallback(4, uid, 4096);
        }
    }

    @HLEFunction(nid=-542590216, version=150)
    public void scePowerUnregisterCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int slot = cpu.gpr[4];
        log.info(String.format("scePowerUnregisterCallback slot=%d", slot));
        if (slot >= 0 && slot < this.powerCBSlots.length) {
            if (this.powerCBSlots[slot] != 0) {
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                threadMan.hleKernelUnRegisterCallback(4, this.powerCBSlots[slot]);
                this.powerCBSlots[slot] = 0;
            }
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-610457379, version=150)
    public void scePowerUnregitserCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented NID function scePowerUnregitserCallback [0xDB9D28DD]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-2076197053, version=150)
    public void scePowerSetCpuClockFrequency(Processor processor) {
        CpuState cpu = processor.cpu;
        int freq = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        log.debug("scePowerSetCpuClockFrequency : " + freq);
        this.cpuClock = freq;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1193823237, version=150)
    public void scePowerSetBusClockFrequency(Processor processor) {
        CpuState cpu = processor.cpu;
        int freq = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        log.debug("scePowerSetBusClockFrequency : " + freq);
        this.busClock = freq;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-18859473, version=150)
    public void scePowerGetCpuClockFrequency(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetCpuClockFrequency ret:" + this.cpuClock);
        cpu.gpr[2] = this.cpuClock;
    }

    @HLEFunction(nid=1200613109, version=150)
    public void scePowerGetBusClockFrequency(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBusClockFrequency ret:" + this.busClock);
        cpu.gpr[2] = this.busClock;
    }

    @HLEFunction(nid=-38420503, version=150)
    public void scePowerGetCpuClockFrequencyInt(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetCpuClockFrequencyInt ret:" + this.cpuClock);
        cpu.gpr[2] = this.cpuClock;
    }

    @HLEFunction(nid=-1117251223, version=150)
    public void scePowerGetBusClockFrequencyInt(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBusClockFrequencyInt ret:" + this.busClock);
        cpu.gpr[2] = this.busClock;
    }

    @HLEFunction(nid=888783971, version=150)
    public void scePowerGetPllClockFrequencyInt(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetPllClockFrequencyInt ret:" + this.pllClock);
        cpu.gpr[2] = this.pllClock;
    }

    @HLEFunction(nid=-1314575229, version=150)
    public void scePowerGetCpuClockFrequencyFloat(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetCpuClockFrequencyFloat ret:" + Float.intBitsToFloat(this.cpuClock));
        cpu.fpr[0] = this.cpuClock;
    }

    @HLEFunction(nid=-1683115029, version=150)
    public void scePowerGetBusClockFrequencyFloat(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetBusClockFrequencyInt ret:" + Float.intBitsToFloat(this.busClock));
        cpu.fpr[0] = this.busClock;
    }

    @HLEFunction(nid=-365417945, version=150)
    public void scePowerGetPllClockFrequencyFloat(Processor processor) {
        CpuState cpu = processor.cpu;
        log.debug("scePowerGetPllClockFrequencyInt ret:" + Float.intBitsToFloat(this.pllClock));
        cpu.fpr[0] = this.pllClock;
    }

    @HLEFunction(nid=1937016562, version=150)
    public int scePowerSetClockFrequency(int pllClock, int cpuClock, int busClock) {
        this.pllClock = pllClock;
        this.cpuClock = cpuClock;
        this.busClock = busClock;
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePowerSetClockFrequency pll: %d, cpu: %d, bus: %d", pllClock, cpuClock, busClock));
        }
        return 0;
    }

    @HLEFunction(nid=-338593834, version=150)
    public int scePower_EBD177D6(int pllClock, int cpuClock, int busClock) {
        this.pllClock = pllClock;
        this.cpuClock = cpuClock;
        this.busClock = busClock;
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePower_EBD177D6 pll: %d, cpu: %d, bus: %d", pllClock, cpuClock, busClock));
        }
        return 0;
    }
}

