/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class scePsmf
extends HLEModule {
    private static Logger log = Modules.getLogger("scePsmf");
    private HashMap<Integer, PSMFHeader> psmfHeaderMap;

    @Override
    public String getName() {
        return "scePsmf";
    }

    @Override
    public void start() {
        this.psmfHeaderMap = new HashMap();
        super.start();
    }

    private PSMFHeader getPsmfHeader(int psmf) {
        if (Memory.isAddressGood(psmf)) {
            Memory mem = Memory.getInstance();
            int headerAddress = mem.read32(psmf + 24);
            return this.psmfHeaderMap.get(headerAddress);
        }
        return null;
    }

    protected int endianSwap16(int x) {
        return x >> 8 | x << 8 & 0xFF00;
    }

    @HLEFunction(nid=-1037270233, version=150)
    public void scePsmfSetPsmf(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int buffer_addr = cpu.gpr[5];
        if (log.isInfoEnabled()) {
            log.info("scePsmfSetPsmf (psmf=0x" + Integer.toHexString(psmf) + " buffer_addr=0x" + Integer.toHexString(buffer_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        Modules.sceMpegModule.setCurrentMpegAnalyzed(false);
        PSMFHeader header = new PSMFHeader(buffer_addr);
        this.psmfHeaderMap.put(header.getHeaderOffset(), header);
        mem.write32(psmf, header.getVersion());
        mem.write32(psmf + 4, header.getHeaderSize());
        mem.write32(psmf + 8, header.getStreamSize());
        mem.write32(psmf + 12, 0);
        mem.write32(psmf + 16, 0);
        mem.write32(psmf + 20, header.getCurrentStreamNumber());
        mem.write32(psmf + 24, header.getHeaderOffset());
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-941933989, version=150)
    public void scePsmfGetCurrentStreamType(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int type_addr = cpu.gpr[5];
        int ch_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetCurrentStreamType (psmf=0x" + Integer.toHexString(psmf) + ", type_addr=0x" + Integer.toHexString(type_addr) + ", ch_addr=0x" + Integer.toHexString(ch_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int streamType = header.getCurrentStreamType();
            int streamCh = header.getCurrentStreamChannel();
            mem.write32(type_addr, streamType);
            mem.write32(ch_addr, streamCh);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=673449320, version=150)
    public void scePsmfGetCurrentStreamNumber(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetCurrentStreamNumber psmf=0x" + Integer.toHexString(psmf));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null ? header.getCurrentStreamNumber() : -2141106139;
    }

    @HLEFunction(nid=510496787, version=150)
    public void scePsmfSpecifyStreamWithStreamType(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        int type = cpu.gpr[5];
        int ch = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfSpecifyStreamWithStreamType (psmf=0x" + Integer.toHexString(psmf) + ", type=" + type + ", ch=" + ch + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            header.setStreamType(type, ch);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=1271512544, version=150)
    public void scePsmfSpecifyStream(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        int streamNum = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfSpecifyStream (psmf=0x" + Integer.toHexString(psmf) + ", streamNum=" + streamNum + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            header.setStreamNum(streamNum);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=1993584314, version=150)
    public void scePsmfGetPresentationStartTime(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int startTimeAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetPresentationStartTime (psmf=0x" + Integer.toHexString(psmf) + ", startTimeAddr=0x" + Integer.toHexString(startTimeAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int startTime = header.getPresentationStartTime();
            mem.write32(startTimeAddr, startTime);
            if (log.isDebugEnabled()) {
                log.debug(String.format("scePsmfGetPresentationStartTime startTime=%d", startTime));
            }
            cpu.gpr[2] = 0;
        } else {
            mem.write32(startTimeAddr, 0);
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=-1114971944, version=150)
    public void scePsmfGetPresentationEndTime(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int endTimeAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetPresentationEndTime (psmf=0x" + Integer.toHexString(psmf) + ", endTimeAddr=0x" + Integer.toHexString(endTimeAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int endTime = header.getPresentationEndTime();
            mem.write32(endTimeAddr, endTime);
            if (log.isDebugEnabled()) {
                log.debug(String.format("scePsmfGetPresentationEndTime endTime=%d", endTime));
            }
            cpu.gpr[2] = 0;
        } else {
            mem.write32(endTimeAddr, 0);
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=-353531443, version=150)
    public void scePsmfGetNumberOfStreams(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetNumberOfStreams psmf=0x" + Integer.toHexString(psmf));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null ? header.getNumberOfStreams() : -2141106139;
    }

    @HLEFunction(nid=1955710008, version=150)
    public void scePsmfGetNumberOfEPentries(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetNumberOfEPentries (psmf=0x" + Integer.toHexString(psmf) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null ? header.getEPMapEntriesNum() : -2141106139;
    }

    @HLEFunction(nid=195368165, version=150)
    public void scePsmfGetVideoInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int videoInfoAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetVideoInfo (psmf=0x" + Integer.toHexString(psmf) + ", videoInfoAddr=0x" + Integer.toHexString(videoInfoAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int width = header.getVideoWidth();
            int height = header.getvideoHeigth();
            mem.write32(videoInfoAddr, width);
            mem.write32(videoInfoAddr + 4, height);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=-1472237293, version=150)
    public void scePsmfGetAudioInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int audioInfoAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetAudioInfo (psmf=0x" + Integer.toHexString(psmf) + ", audioInfoAddr=0x" + Integer.toHexString(audioInfoAddr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int chConfig = header.getAudioChannelConfig();
            int sampleFreq = header.getAudioSampleFrequency();
            mem.write32(audioInfoAddr, chConfig);
            mem.write32(audioInfoAddr + 4, sampleFreq);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=-1759888752, version=150)
    public void scePsmfCheckEPmap(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfCheckEPmap (psmf=0x" + Integer.toHexString(psmf) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null && header.hasEPMap() ? 0 : -2141106139;
    }

    @HLEFunction(nid=1315064372, version=150)
    public void scePsmfGetEPWithId(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int id = cpu.gpr[5];
        int out_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetEPWithId (psmf=0x" + Integer.toHexString(psmf) + ", id=0x" + Integer.toHexString(id) + ", out_addr=0x" + Integer.toHexString(out_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null && header.hasEPMap()) {
            PSMFHeader.PSMFEntry entry = header.getEPMapEntry(id);
            if (entry != null) {
                int pts = entry.getEntryPTS();
                int offset = entry.getEntryOffset();
                int index = entry.getEntryIndex();
                int picOffset = entry.getEntryPicOffset();
                mem.write32(out_addr, pts);
                mem.write32(out_addr + 4, offset);
                mem.write32(out_addr + 8, index);
                mem.write32(out_addr + 12, picOffset);
                cpu.gpr[2] = 0;
            } else {
                cpu.gpr[2] = -2141105920;
            }
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=2081323715, version=150)
    public void scePsmfGetEPWithTimestamp(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int ts = cpu.gpr[5];
        int entry_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetEPWithTimestamp (psmf=0x" + Integer.toHexString(psmf) + ", ts=" + ts + ", entry_addr=0x" + Integer.toHexString(entry_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null && header.hasEPMap()) {
            if (ts < header.getPresentationStartTime()) {
                cpu.gpr[2] = -2141104896;
            } else {
                PSMFHeader.PSMFEntry entry = header.getEPMapEntryWithTimestamp(ts);
                if (entry == null) {
                    cpu.gpr[2] = -1;
                } else {
                    int pts = entry.getEntryPTS();
                    int offset = entry.getEntryOffset();
                    int index = entry.getEntryIndex();
                    int picOffset = entry.getEntryPicOffset();
                    mem.write32(entry_addr, pts);
                    mem.write32(entry_addr + 4, offset);
                    mem.write32(entry_addr + 8, index);
                    mem.write32(entry_addr + 12, picOffset);
                    cpu.gpr[2] = 0;
                }
            }
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=1598387477, version=150)
    public void scePsmfGetEPidWithTimestamp(Processor processor) {
        PSMFHeader.PSMFEntry entry;
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        int ts = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetEPidWithTimestamp (psmf=0x" + Integer.toHexString(psmf) + ", ts=" + ts + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null && header.hasEPMap() ? (ts < header.getPresentationStartTime() ? -2141104896 : ((entry = header.getEPMapEntryWithTimestamp(ts)) == null ? -1 : entry.getId())) : -2141106139;
    }

    @HLEFunction(nid=1534131393, version=150)
    public void scePsmfQueryStreamOffset(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int buffer_addr = cpu.gpr[4];
        int offset_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfQueryStreamOffset (buffer_addr=0x" + Integer.toHexString(buffer_addr) + ", offset_addr=0x" + Integer.toHexString(offset_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        int offset = Utilities.endianSwap32(mem.read32(buffer_addr + 8));
        mem.write32(offset_addr, offset);
        Modules.sceMpegModule.analyseMpeg(buffer_addr);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1789670255, version=150)
    public void scePsmfQueryStreamSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int buffer_addr = cpu.gpr[4];
        int size_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfQueryStreamSize (buffer_addr=0x" + Integer.toHexString(buffer_addr) + ", size_addr=0x" + Integer.toHexString(size_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        int size = Utilities.endianSwap32(mem.read32(buffer_addr + 12));
        if ((size & 0x7FF) != 0) {
            mem.write32(size_addr, 0);
            cpu.gpr[2] = -2141105666;
        } else {
            mem.write32(size_addr, size);
            cpu.gpr[2] = 0;
        }
        Modules.sceMpegModule.analyseMpeg(buffer_addr);
    }

    @HLEFunction(nid=1758733096, version=150)
    public void scePsmfGetNumberOfSpecificStreams(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        int stream_type = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetNumberOfSpecificStreams (psmf=0x" + Integer.toHexString(psmf) + ", stream_type=" + stream_type + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null ? header.getSpecificStreamNum(stream_type) : -2141106139;
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePsmfGetNumberOfSpecificStreams (psmf=0x%08X, stream_type=%d) returning 0x%08X", psmf, stream_type, cpu.gpr[2]));
        }
    }

    @HLEFunction(nid=202509853, version=150)
    public void scePsmfSpecifyStreamWithStreamTypeNumber(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        int type = cpu.gpr[5];
        int type_num = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfSpecifyStreamWithStreamTypeNumber (psmf=0x" + Integer.toHexString(psmf) + ", type=" + type + ", type_num=" + type_num + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            header.setStreamTypeNum(type, type_num);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=645096555, version=150)
    public void scePsmfVerifyPsmf(Processor processor) {
        int version;
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int buffer_addr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfVerifyPsmf (buffer_addr=0x" + Integer.toHexString(buffer_addr) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = Memory.isAddressGood(buffer_addr) ? ((version = mem.read32(buffer_addr + 4)) > 892416048 ? -2141104895 : 0) : -2141104895;
    }

    @HLEFunction(nid=-1215383063, version=150)
    public void scePsmfGetHeaderSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int size_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetHeaderSize (psmf=0x" + Integer.toHexString(psmf) + ", size_addr=0x" + size_addr + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int size = header.getHeaderSize();
            mem.write32(size_addr, size);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=-1511260543, version=150)
    public void scePsmfGetStreamSize(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmf = cpu.gpr[4];
        int size_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetStreamSize (psmf=0x" + Integer.toHexString(psmf) + ", size_addr=0x" + size_addr + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (header != null) {
            int size = header.getStreamSize();
            mem.write32(size_addr, size);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2141106139;
        }
    }

    @HLEFunction(nid=-517457771, version=150)
    public void scePsmfGetPsmfVersion(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmf = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfGetPsmfVersion (psmf=0x" + Integer.toHexString(psmf) + ")");
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        PSMFHeader header = this.getPsmfHeader(psmf);
        cpu.gpr[2] = header != null ? header.getVersion() : -2141106139;
    }

    protected class PSMFHeader {
        private static final int size = 2048;
        private static final int PSMF_VIDEO_STREAM_ID = 224;
        private static final int PSMF_AUDIO_STREAM_ID = 189;
        private static final int PSMF_AVC_STREAM = 0;
        private static final int PSMF_ATRAC_STREAM = 1;
        private static final int PSMF_PCM_STREAM = 2;
        private static final int PSMF_DATA_STREAM = 3;
        private static final int PSMF_AUDIO_STREAM = 15;
        private int streamOffset;
        private int streamSize;
        private int version;
        private int presentationStartTime;
        private int presentationEndTime;
        private int streamNum;
        private int audioSampleFrequency;
        private int audioChannelConfig;
        private int videoWidth;
        private int videoHeigth;
        private int EPMapEntriesNum;
        private int headerOffset;
        private int EPMapOffset;
        private HashMap<Integer, PSMFEntry> EPMap;
        private int currentEntryNumber;
        private HashMap<Integer, PSMFStream> streamMap;
        private int currentStreamNumber;
        private int currentVideoStreamNumber;
        private int videoStreamNum;
        private int currentAudioStreamNumber;
        private int audioStreamNum;

        public PSMFHeader(int addr) {
            int i;
            Memory mem = Memory.getInstance();
            if (mem.read32(addr) != 1179472720) {
                log.warn("Invalid PSMF detected!");
            }
            this.headerOffset = addr;
            this.version = mem.read32(addr + 4);
            this.streamOffset = Utilities.endianSwap32(mem.read32(addr + 8));
            this.streamSize = Utilities.endianSwap32(mem.read32(addr + 12));
            int streamDataTotalSize = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 80));
            this.presentationStartTime = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 86));
            this.presentationEndTime = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 92));
            int unk = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 96));
            int streamDataNextBlockSize = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 106));
            int streamDataNextInnerBlockSize = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 124));
            this.streamNum = scePsmf.this.endianSwap16(mem.read16(addr + 128));
            if (log.isDebugEnabled()) {
                log.debug(String.format("PSMFHeader: streamDataTotalSize=%d, unk=0x%08X, streamDataNextBlockSize=%d, streamDataNextInnerBlockSize=%d", streamDataTotalSize, unk, streamDataNextBlockSize, streamDataNextInnerBlockSize));
            }
            this.streamMap = new HashMap();
            this.currentStreamNumber = -1;
            this.currentVideoStreamNumber = -1;
            this.currentAudioStreamNumber = -1;
            this.videoStreamNum = 0;
            this.audioStreamNum = 0;
            for (i = 0; i < this.streamNum; ++i) {
                PSMFStream stream = null;
                int currentStreamAddr = addr + 130 + i * 16;
                int streamID = mem.read8(currentStreamAddr);
                if ((streamID & 0xE0) == 224) {
                    stream = new PSMFStream(0, 0);
                    stream.readMPEGVideoStreamParams(currentStreamAddr);
                    ++this.currentVideoStreamNumber;
                    ++this.videoStreamNum;
                } else if ((streamID & 0xBD) == 189) {
                    stream = new PSMFStream(1, 1);
                    stream.readPrivateAudioStreamParams(currentStreamAddr);
                    ++this.currentAudioStreamNumber;
                    ++this.audioStreamNum;
                }
                if (stream == null) continue;
                ++this.currentStreamNumber;
                this.streamMap.put(this.currentStreamNumber, stream);
            }
            this.EPMap = new HashMap();
            for (i = 0; i < this.EPMapEntriesNum; ++i) {
                int id;
                int index = mem.read8(addr + this.EPMapOffset + i * 10);
                int picOffset = mem.read8(addr + this.EPMapOffset + 1 + i * 10);
                int pts = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + this.EPMapOffset + 2 + i * 10));
                int offset = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + this.EPMapOffset + 6 + i * 10));
                ++this.currentEntryNumber;
                PSMFEntry pEnt = new PSMFEntry(id, index, picOffset, pts, offset);
                this.EPMap.put(id, pEnt);
            }
        }

        public int getVersion() {
            return this.version;
        }

        public int getHeaderSize() {
            return 2048;
        }

        public int getHeaderOffset() {
            return this.headerOffset;
        }

        public int getStreamOffset() {
            return this.streamOffset;
        }

        public int getStreamSize() {
            return this.streamSize;
        }

        public int getPresentationStartTime() {
            return this.presentationStartTime;
        }

        public int getPresentationEndTime() {
            return this.presentationEndTime;
        }

        public int getVideoWidth() {
            return this.videoWidth;
        }

        public int getvideoHeigth() {
            return this.videoHeigth;
        }

        public int getAudioSampleFrequency() {
            return this.audioSampleFrequency;
        }

        public int getAudioChannelConfig() {
            return this.audioChannelConfig;
        }

        public int getEPMapOffset() {
            return this.EPMapOffset;
        }

        public int getEPMapEntriesNum() {
            return this.EPMapEntriesNum;
        }

        public boolean hasEPMap() {
            return this.getEPMapEntriesNum() > 0;
        }

        public PSMFEntry getEPMapEntry(int id) {
            return this.EPMap.get(id);
        }

        public PSMFEntry getEPMapEntryWithTimestamp(int ts) {
            PSMFEntry foundEntry = null;
            for (PSMFEntry entry : this.EPMap.values()) {
                if (foundEntry == null || entry.getEntryPTS() <= ts) {
                    foundEntry = entry;
                    continue;
                }
                if (entry.getEntryPTS() <= ts) continue;
                break;
            }
            return foundEntry;
        }

        public int getNumberOfStreams() {
            return this.streamNum;
        }

        public int getCurrentStreamNumber() {
            return this.currentStreamNumber;
        }

        public int getCurrentStreamType() {
            if (this.streamMap.get(this.currentStreamNumber) != null) {
                return this.streamMap.get(this.currentStreamNumber).getStreamType();
            }
            return -1;
        }

        public int getCurrentStreamChannel() {
            if (this.streamMap.get(this.currentStreamNumber) != null) {
                return this.streamMap.get(this.currentStreamNumber).getStreamChannel();
            }
            return -1;
        }

        public int getSpecificStreamNum(int type) {
            switch (type) {
                case 0: {
                    if (this.currentVideoStreamNumber == -1) break;
                    return 1;
                }
                case 1: 
                case 2: 
                case 15: {
                    if (this.currentAudioStreamNumber == -1) break;
                    return 1;
                }
                case 3: {
                    if (this.currentVideoStreamNumber != -1) {
                        return 1;
                    }
                    if (this.currentAudioStreamNumber == -1) break;
                    return 1;
                }
                default: {
                    log.warn(String.format("scePsmfGetNumberOfSpecificStreams unknown stream type %d", type));
                }
            }
            return 0;
        }

        public void setStreamNum(int id) {
            this.currentStreamNumber = id;
        }

        public void setStreamType(int type, int channel) {
            switch (type) {
                case 0: {
                    if (this.currentVideoStreamNumber == -1) break;
                    this.currentStreamNumber = this.currentVideoStreamNumber;
                    break;
                }
                case 1: 
                case 2: 
                case 15: {
                    if (this.currentAudioStreamNumber == -1) break;
                    this.currentStreamNumber = this.currentAudioStreamNumber;
                    break;
                }
                case 3: {
                    if (this.currentVideoStreamNumber != -1) {
                        this.currentStreamNumber = this.currentVideoStreamNumber;
                        break;
                    }
                    if (this.currentAudioStreamNumber == -1) break;
                    this.currentStreamNumber = this.currentAudioStreamNumber;
                    break;
                }
                default: {
                    log.warn(String.format("scePsmfSpecifyStreamWithStreamType unknown stream type %d", type));
                }
            }
        }

        public void setStreamTypeNum(int type, int tid) {
            this.currentStreamNumber = tid;
        }

        protected class PSMFStream {
            private int StreamType;
            private int StreamChannel;

            public PSMFStream(int type, int channel) {
                this.StreamType = type;
                this.StreamChannel = channel;
            }

            public int getStreamType() {
                return this.StreamType;
            }

            public int getStreamChannel() {
                return this.StreamChannel;
            }

            public void readMPEGVideoStreamParams(int addr) {
                Memory mem = Memory.getInstance();
                int streamID = mem.read8(addr);
                int privateStreamID = mem.read8(addr + 1);
                int unk1 = mem.read8(addr + 2);
                int unk2 = mem.read8(addr + 3);
                PSMFHeader.this.EPMapOffset = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 4));
                PSMFHeader.this.EPMapEntriesNum = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 8));
                PSMFHeader.this.videoWidth = mem.read8(addr + 12) * 16;
                PSMFHeader.this.videoHeigth = mem.read8(addr + 13) * 16;
                log.info("Found PSMF MPEG video stream data: streamID=0x" + Integer.toHexString(streamID) + ", privateStreamID=0x" + Integer.toHexString(privateStreamID) + ", unk1=0x" + Integer.toHexString(unk1) + ", unk2=0x" + Integer.toHexString(unk2) + ", EPMapOffset=0x" + Integer.toHexString(PSMFHeader.this.EPMapOffset) + ", EPMapEntriesNum=" + PSMFHeader.this.EPMapEntriesNum + ", videoWidth=" + PSMFHeader.this.videoWidth + ", videoHeigth=" + PSMFHeader.this.videoHeigth);
            }

            public void readPrivateAudioStreamParams(int addr) {
                Memory mem = Memory.getInstance();
                int streamID = mem.read8(addr);
                int privateStreamID = mem.read8(addr + 1);
                int unk1 = mem.read8(addr + 2);
                int unk2 = mem.read8(addr + 3);
                PSMFHeader.this.audioChannelConfig = mem.read8(addr + 14);
                PSMFHeader.this.audioSampleFrequency = mem.read8(addr + 15);
                log.info("Found PSMF private audio stream data: streamID=0x" + Integer.toHexString(streamID) + ", privateStreamID=0x" + Integer.toHexString(privateStreamID) + ", unk1=0x" + Integer.toHexString(unk1) + ", unk2=0x" + Integer.toHexString(unk2) + ", audioChannelConfig=" + PSMFHeader.this.audioChannelConfig + ", audioSampleFrequency=" + PSMFHeader.this.audioSampleFrequency);
            }
        }

        protected class PSMFEntry {
            private int EPIndex;
            private int EPPicOffset;
            private int EPPts;
            private int EPOffset;
            private int id;

            public PSMFEntry(int id, int index, int picOffset, int pts, int offset) {
                this.id = id;
                this.EPIndex = index;
                this.EPPicOffset = picOffset;
                this.EPPts = pts;
                this.EPOffset = offset;
            }

            public int getEntryIndex() {
                return this.EPIndex;
            }

            public int getEntryPicOffset() {
                return this.EPPicOffset;
            }

            public int getEntryPTS() {
                return this.EPPts;
            }

            public int getEntryOffset() {
                return this.EPOffset;
            }

            public int getId() {
                return this.id;
            }
        }
    }
}

