/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceMpeg;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.graphics.VideoEngine;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class scePsmfPlayer
extends HLEModule {
    private static Logger log = Modules.getLogger("scePsmfPlayer");
    protected static final int psmfPlayerVideoTimestampStep = 3003;
    protected static final int psmfPlayerAudioTimestampStep = 4180;
    protected static final int psmfTimestampPerSecond = 90000;
    protected int psmfMaxAheadTimestamp = 40000;
    protected Date psmfPlayerLastDate;
    protected long psmfPlayerLastTimestamp;
    protected SceMpegAu psmfPlayerAvcAu;
    protected SceMpegAu psmfPlayerAtracAu;
    protected static final int PSMF_PLAYER_STATUS_NONE = 0;
    protected static final int PSMF_PLAYER_STATUS_INIT = 1;
    protected static final int PSMF_PLAYER_STATUS_STANDBY = 2;
    protected static final int PSMF_PLAYER_STATUS_PLAYING = 4;
    protected static final int PSMF_PLAYER_STATUS_ERROR = 256;
    protected static final int PSMF_PLAYER_STATUS_PLAYING_FINISHED = 512;
    protected int psmfPlayerStatus;
    protected static final int PSMF_PLAYER_MODE_PLAY = 0;
    protected static final int PSMF_PLAYER_MODE_SLOWMOTION = 1;
    protected static final int PSMF_PLAYER_MODE_STEPFRAME = 2;
    protected static final int PSMF_PLAYER_MODE_PAUSE = 3;
    protected static final int PSMF_PLAYER_MODE_FORWARD = 4;
    protected static final int PSMF_PLAYER_MODE_REWIND = 5;
    protected static final int PSMF_PLAYER_STREAM_AVC = 0;
    protected static final int PSMF_PLAYER_STREAM_ATRAC = 1;
    protected static final int PSMF_PLAYER_STREAM_PCM = 2;
    protected static final int PSMF_PLAYER_STREAM_VIDEO = 14;
    protected static final int PSMF_PLAYER_STREAM_AUDIO = 15;
    protected static final int PSMF_PLAYER_SPEED_SLOW = 1;
    protected static final int PSMF_PLAYER_SPEED_NORMAL = 2;
    protected static final int PSMF_PLAYER_SPEED_FAST = 3;
    protected static final int PSMF_PLAYER_CONFIG_MODE_LOOP = 0;
    protected static final int PSMF_PLAYER_CONFIG_MODE_PIXEL_TYPE = 1;
    protected static final int PSMF_PLAYER_CONFIG_LOOP = 0;
    protected static final int PSMF_PLAYER_CONFIG_NO_LOOP = 1;
    protected static final int PSMF_PLAYER_PIXEL_TYPE_NONE = -1;
    protected static final int PSMF_PLAYER_PIXEL_TYPE_565 = 0;
    protected static final int PSMF_PLAYER_PIXEL_TYPE_5551 = 1;
    protected static final int PSMF_PLAYER_PIXEL_TYPE_4444 = 2;
    protected static final int PSMF_PLAYER_PIXEL_TYPE_8888 = 3;
    protected static final int PSMF_PLAYER_VERSION_FULL = 0;
    protected static final int PSMF_PLAYER_VERSION_BASIC = 1;
    protected static final int PSMF_PLAYER_VERSION_NET = 2;
    protected String pmfFilePath;
    protected byte[] pmfFileData;
    protected int psmfCurrentPts = 0;
    protected int psmfAvcStreamNum = 1;
    protected int psmfAtracStreamNum = 1;
    protected int psmfPcmStreamNum = 0;
    protected int psmfPlayerVersion = 0;
    protected int displayBuffer;
    protected int displayBufferSize;
    protected int playbackThreadPriority;
    protected int videoCodec;
    protected int videoStreamNum;
    protected int audioCodec;
    protected int audioStreamNum;
    protected int playMode;
    protected int playSpeed;
    protected int videoDataFrameWidth = 512;
    protected int videoDataDisplayBuffer;
    protected int videoDataDisplayPts;
    protected int videoPixelMode = 3;
    protected int videoLoopStatus = 1;
    protected final int audioSamples = 2048;
    protected final int audioSamplesBytes = 8192;
    protected PacketChannel pmfFileChannel;
    protected MediaEngine me;
    protected boolean useMediaEngine = false;
    protected byte[] audioDecodeBuffer;

    @Override
    public String getName() {
        return "scePsmfPlayer";
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.useMediaEngine", new EnableMediaEngineSettingsListener());
        super.start();
    }

    protected boolean checkMediaEngineState() {
        return this.useMediaEngine;
    }

    private void setEnableMediaEngine(boolean state) {
        this.useMediaEngine = state;
    }

    protected Date convertPsmfTimestampToDate(long timestamp) {
        long millis = timestamp / 90L;
        return new Date(millis);
    }

    private void generateFakePSMFVideo(int dest_addr, int frameWidth) {
        Memory mem = Memory.getInstance();
        Random random = new Random();
        int pixelSize = 3;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(this.videoPixelMode);
        for (int y = 0; y < 270; y += 3) {
            int address = dest_addr + y * frameWidth * bytesPerPixel;
            int width = Math.min(480, frameWidth);
            for (int x = 0; x < width; x += 3) {
                int j;
                int i;
                int n = random.nextInt(256);
                int color = 0xFF000000 | n << 16 | n << 8 | n;
                int pixelColor = Debug.getPixelColor(color, this.videoPixelMode);
                if (bytesPerPixel == 4) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write32(address + (i * frameWidth + j) * 4, pixelColor);
                        }
                    }
                } else if (bytesPerPixel == 2) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write16(address + (i * frameWidth + j) * 2, (short)pixelColor);
                        }
                    }
                }
                address += 3 * bytesPerPixel;
            }
        }
        Date currentDate = this.convertPsmfTimestampToDate(this.psmfPlayerAvcAu.pts);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Debug.printFramebuffer(dest_addr, frameWidth, 10, 250, -1, -16777216, this.videoPixelMode, 1, " This is a faked PSMF Player video. ");
        if (this.psmfPlayerLastDate != null) {
            String displayedString = String.format(" %s / %s ", dateFormat.format(currentDate), dateFormat.format(this.psmfPlayerLastDate));
            Debug.printFramebuffer(dest_addr, frameWidth, 10, 10, -1, -16777216, this.videoPixelMode, 2, displayedString);
        }
    }

    protected int getPsmfFileDataInt8(int index) {
        return this.pmfFileData[index] & 0xFF;
    }

    protected int getPsmfFileDataInt32(int index) {
        return this.getPsmfFileDataInt8(index) << 24 | this.getPsmfFileDataInt8(index + 1) << 16 | this.getPsmfFileDataInt8(index + 2) << 8 | this.getPsmfFileDataInt8(index + 3);
    }

    protected void analyzePSMFLastTimestamp() {
        if (this.pmfFileData != null) {
            this.psmfPlayerLastTimestamp = this.getPsmfFileDataInt32(92);
            this.psmfPlayerLastDate = this.convertPsmfTimestampToDate(this.psmfPlayerLastTimestamp);
        }
    }

    protected boolean checkPlayerInitialized(int psmfPlayer) {
        if (this.psmfPlayerStatus == 0) {
            Emulator.getProcessor().cpu.gpr[2] = -2141102079;
            return false;
        }
        return true;
    }

    protected void startMediaEngine() {
        if (this.checkMediaEngineState() && this.pmfFileChannel != null && this.me == null) {
            this.me = new MediaEngine();
            this.audioDecodeBuffer = new byte[8192];
            this.me.init(this.pmfFileData);
            this.me.init(this.pmfFileChannel, true, true);
        }
    }

    @HLEFunction(nid=593332103, version=150)
    public void scePsmfPlayerCreate(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmfPlayer = cpu.gpr[4];
        int psmfPlayerDataAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerCreate psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", psmfPlayerDataAddr=0x" + Integer.toHexString(psmfPlayerDataAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.displayBuffer = mem.read32(psmfPlayerDataAddr);
        this.displayBufferSize = mem.read32(psmfPlayerDataAddr + 4);
        this.playbackThreadPriority = mem.read32(psmfPlayerDataAddr + 8);
        log.info("PSMF Player Data: displayBuffer=0x" + Integer.toHexString(this.displayBuffer) + ", displayBufferSize=0x" + Integer.toHexString(this.displayBufferSize) + ", playbackThreadPriority=0x" + Integer.toHexString(this.playbackThreadPriority));
        this.psmfPlayerAtracAu = new SceMpegAu();
        this.psmfPlayerAvcAu = new SceMpegAu();
        this.psmfMaxAheadTimestamp = sceMpeg.getMaxAheadTimestamp(581);
        this.psmfPlayerStatus = 1;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1687051660, version=150)
    public void scePsmfPlayerDelete(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerDelete psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.checkMediaEngineState()) {
            if (this.me != null) {
                this.me.finish();
                this.me = null;
            }
            if (this.pmfFileChannel != null) {
                this.pmfFileChannel = null;
            }
        }
        VideoEngine.getInstance().resetVideoTextures();
        this.psmfPlayerStatus = 0;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1030563241, version=150)
    public void scePsmfPlayerSetPsmf(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        int fileAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSetPsmf psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", fileAddr=0x" + Integer.toHexString(fileAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.pmfFilePath = Utilities.readStringZ(fileAddr);
        try {
            SeekableDataInput psmfFile = Modules.IoFileMgrForUserModule.getFile(this.pmfFilePath, 0);
            this.pmfFileData = new byte[(int)psmfFile.length()];
            psmfFile.readFully(this.pmfFileData);
            log.info("'" + this.pmfFilePath + "' PSMF file loaded.");
            if (this.checkMediaEngineState()) {
                this.pmfFileChannel = new PacketChannel(this.pmfFileData);
            }
        }
        catch (IOException e) {
            log.error(e);
        }
        this.psmfPlayerStatus = 2;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1488467319, version=150)
    public void scePsmfPlayerSetPsmfCB(Processor processor) {
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSetPsmfCB redirecting to scePsmfPlayerSetPsmf");
        }
        this.scePsmfPlayerSetPsmf(processor);
        Modules.ThreadManForUserModule.hleRescheduleCurrentThread(true);
    }

    @HLEFunction(nid=-409809516, version=150)
    public void scePsmfPlayerReleasePsmf(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerReleasePsmf psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.checkMediaEngineState()) {
            if (this.me != null) {
                this.me.finish();
                this.me = null;
            }
            if (this.pmfFileChannel != null) {
                this.pmfFileChannel = null;
            }
        }
        VideoEngine.getInstance().resetVideoTextures();
        this.psmfPlayerStatus = 1;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1784131867, version=150)
    public void scePsmfPlayerStart(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmfPlayer = cpu.gpr[4];
        int initPlayInfoAddr = cpu.gpr[5];
        int initPts = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerStart psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", initPlayInfoAddr=0x" + Integer.toHexString(initPlayInfoAddr) + ", initPts=" + initPts);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(initPlayInfoAddr)) {
            this.videoCodec = mem.read32(initPlayInfoAddr);
            this.videoStreamNum = mem.read32(initPlayInfoAddr + 4);
            this.audioCodec = mem.read32(initPlayInfoAddr + 8);
            this.audioStreamNum = mem.read32(initPlayInfoAddr + 12);
            this.playMode = mem.read32(initPlayInfoAddr + 16);
            this.playSpeed = mem.read32(initPlayInfoAddr + 20);
            log.info("Found play info data: videoCodec=0x" + Integer.toHexString(this.videoCodec) + ", videoStreamNum=" + this.videoStreamNum + ", audioCodec=0x" + Integer.toHexString(this.audioCodec) + ", audioStreamNum=" + this.audioStreamNum + ", playMode=" + this.playMode + ", playSpeed=" + this.playSpeed);
        }
        this.psmfPlayerAtracAu.dts = initPts;
        this.psmfPlayerAtracAu.pts = initPts;
        this.psmfPlayerAvcAu.dts = initPts;
        this.psmfPlayerAvcAu.pts = initPts;
        this.analyzePSMFLastTimestamp();
        this.startMediaEngine();
        this.psmfPlayerStatus = 4;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1051208267, version=150)
    public void scePsmfPlayerGetAudioOutSize(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetAudioOutSize psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 8192;
    }

    @HLEFunction(nid=276348936, version=150)
    public void scePsmfPlayerStop(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerStop psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.checkMediaEngineState()) {
            if (this.me != null) {
                this.me.finish();
                this.me = null;
            }
            if (this.pmfFileChannel != null) {
                this.pmfFileChannel = null;
            }
        }
        VideoEngine.getInstance().resetVideoTextures();
        this.psmfPlayerStatus = 2;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1598502315, version=150)
    public void scePsmfPlayerUpdate(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerUpdate psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (this.psmfPlayerAvcAu.pts > 0L && this.psmfPlayerAvcAu.pts > this.psmfPlayerLastTimestamp) {
            this.psmfPlayerStatus = 512;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1190535051, version=150)
    public void scePsmfPlayerGetVideoData(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int psmfPlayer = cpu.gpr[4];
        int videoDataAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePsmfPlayerGetVideoData psmfPlayer=0x%X, videoDataAddr=0x%08X", psmfPlayer, videoDataAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.checkPlayerInitialized(psmfPlayer)) {
            if (this.psmfPlayerAtracAu.pts != 0L && this.psmfPlayerAvcAu.pts > this.psmfPlayerAtracAu.pts + (long)this.psmfMaxAheadTimestamp) {
                cpu.gpr[2] = -2141102068;
                sceMpeg.delayThread(100);
            } else {
                if (Memory.isAddressGood(videoDataAddr)) {
                    this.videoDataFrameWidth = mem.read32(videoDataAddr);
                    this.videoDataDisplayBuffer = mem.read32(videoDataAddr + 4);
                    this.videoDataDisplayPts = mem.read32(videoDataAddr + 8);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("scePsmfPlayerGetVideoData videoDataFrameWidth=%d, videoDataDisplayBuffer=0x%08X, videoDataDisplayPts=%d", this.videoDataFrameWidth, this.videoDataDisplayBuffer, this.videoDataDisplayPts));
                    }
                }
                if (Memory.isAddressGood(this.videoDataDisplayBuffer)) {
                    this.displayBuffer = this.videoDataDisplayBuffer;
                } else {
                    mem.write32(videoDataAddr + 4, this.displayBuffer);
                    if (this.videoDataFrameWidth <= 0 || this.videoDataFrameWidth > 512) {
                        this.videoDataFrameWidth = 512;
                        mem.write32(videoDataAddr, this.videoDataFrameWidth);
                    }
                }
                VideoEngine.getInstance().addVideoTexture(this.displayBuffer, this.displayBuffer + 272 * this.videoDataFrameWidth * sceDisplay.getPixelFormatBytes(this.videoPixelMode));
                long startTime = Emulator.getClock().microTime();
                if (this.checkMediaEngineState() && this.pmfFileChannel != null) {
                    Emulator.getClock().pause();
                    this.startMediaEngine();
                    if (this.me.stepVideo()) {
                        this.me.writeVideoImage(this.displayBuffer, this.videoDataFrameWidth, this.videoPixelMode);
                        this.me.getCurrentVideoAu(this.psmfPlayerAvcAu);
                    } else {
                        this.psmfPlayerAvcAu.pts += 3003L;
                        this.psmfPlayerAvcAu.dts = this.psmfPlayerAvcAu.pts - 3003L;
                    }
                    Emulator.getClock().resume();
                } else {
                    this.psmfPlayerAvcAu.pts += 3003L;
                    this.psmfPlayerAvcAu.dts = this.psmfPlayerAvcAu.pts - 3003L;
                    this.generateFakePSMFVideo(this.displayBuffer, this.videoDataFrameWidth);
                }
                if (Memory.isAddressGood(videoDataAddr)) {
                    mem.write32(videoDataAddr + 8, (int)this.psmfPlayerAvcAu.dts);
                }
                cpu.gpr[2] = 0;
                sceMpeg.delayThread(startTime, 5400);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePsmfPlayerGetVideoData avcAu=[%s], returning 0x%08X", this.psmfPlayerAvcAu, cpu.gpr[2]));
        }
    }

    @HLEFunction(nid=-1182496140, version=150)
    public void scePsmfPlayerGetAudioData(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmfPlayer = cpu.gpr[4];
        int audioDataAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetAudioData psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", audioDataAddr=0x" + Integer.toHexString(audioDataAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.checkPlayerInitialized(psmfPlayer)) {
            if (this.psmfPlayerAvcAu.pts != 0L && this.psmfPlayerAtracAu.pts > this.psmfPlayerAvcAu.pts + (long)this.psmfMaxAheadTimestamp) {
                cpu.gpr[2] = -2141102068;
                sceMpeg.delayThread(100);
            } else {
                long startTime = Emulator.getClock().microTime();
                if (Memory.isAddressGood(audioDataAddr)) {
                    int bytes = 0;
                    if (this.checkMediaEngineState() && this.pmfFileChannel != null) {
                        Emulator.getClock().pause();
                        this.startMediaEngine();
                        if (this.me.stepAudio(8192)) {
                            bytes = this.me.getCurrentAudioSamples(this.audioDecodeBuffer);
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("scePsmfPlayerGetAudioData ME returned %d bytes (audioSamplesBytes=%d)", bytes, 8192));
                            }
                            mem.copyToMemory(audioDataAddr, ByteBuffer.wrap(this.audioDecodeBuffer, 0, bytes), bytes);
                            this.me.getCurrentAudioAu(this.psmfPlayerAtracAu);
                        } else {
                            this.psmfPlayerAtracAu.pts += 4180L;
                        }
                        Emulator.getClock().resume();
                    } else {
                        this.psmfPlayerAtracAu.pts += 4180L;
                        this.psmfPlayerAtracAu.dts = -1L;
                    }
                    mem.memset(audioDataAddr + bytes, (byte)0, 8192 - bytes);
                }
                cpu.gpr[2] = 0;
                sceMpeg.delayThread(startTime, 3000);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePsmfPlayerGetAudioData atracAu=[%s], avcAu=[%s], returning 0x%08X", this.psmfPlayerAtracAu, this.psmfPlayerAvcAu, cpu.gpr[2]));
        }
    }

    @HLEFunction(nid=-118552410, version=150)
    public void scePsmfPlayerGetCurrentStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("scePsmfPlayerGetCurrentStatus psmfPlayer=0x%X, returning status=%d", psmfPlayer, this.psmfPlayerStatus));
        }
        if (this.checkPlayerInitialized(psmfPlayer)) {
            cpu.gpr[2] = this.psmfPlayerStatus;
        }
    }

    @HLEFunction(nid=-553085312, version=150)
    public void scePsmfPlayerGetPsmfInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int psmfPlayer = cpu.gpr[4];
        int psmfInfoAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetPsmfInfo psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", psmfInfoAddr=0x" + Integer.toHexString(psmfInfoAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(psmfInfoAddr)) {
            mem.write32(psmfInfoAddr, this.psmfCurrentPts);
            mem.write32(psmfInfoAddr + 4, this.psmfAvcStreamNum);
            mem.write32(psmfInfoAddr + 8, this.psmfAtracStreamNum);
            mem.write32(psmfInfoAddr + 12, this.psmfPcmStreamNum);
            mem.write32(psmfInfoAddr + 16, this.psmfPlayerVersion);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=509061351, version=150)
    public void scePsmfPlayerConfigPlayer(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        int configMode = cpu.gpr[5];
        int configAttr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerConfigPlayer psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", configMode=" + configMode + ", configAttr=" + configAttr);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (configMode == 0) {
            this.videoLoopStatus = configAttr;
        } else if (configMode == 1) {
            this.videoPixelMode = configAttr;
        } else {
            log.warn("scePsmfPlayerConfigPlayer unknown config mode.");
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1546120855, version=150)
    public void scePsmfPlayerChangePlayMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        int newPlayMode = cpu.gpr[5];
        int newPlaySpeed = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerChangePlayMode psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", newPlayMode=" + newPlayMode + ", newPlaySpeed=" + newPlaySpeed);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.playMode = newPlayMode;
        this.playSpeed = newPlaySpeed;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1760588149, version=150)
    public void scePsmfPlayerGetCurrentAudioStream(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int psmfPlayer = cpu.gpr[4];
        int audioCodecAddr = cpu.gpr[5];
        int audioStreamNumAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetCurrentAudioStream psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", audioCodecAddr=0x" + Integer.toHexString(audioCodecAddr) + ", audioStreamNumAddr=0x" + Integer.toHexString(audioStreamNumAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(audioCodecAddr)) {
            mem.write32(audioCodecAddr, this.audioCodec);
        }
        if (Memory.isAddressGood(audioStreamNumAddr)) {
            mem.write32(audioStreamNumAddr, this.audioStreamNum);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-202397039, version=150)
    public void scePsmfPlayerGetCurrentPlayMode(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int psmfPlayer = cpu.gpr[4];
        int playModeAddr = cpu.gpr[5];
        int playSpeedAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetCurrentPlayMode psmfplayer=0x" + Integer.toHexString(psmfPlayer) + ", playModeAddr=0x" + Integer.toHexString(playModeAddr) + ", playSpeedAddr=0x" + Integer.toHexString(playSpeedAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(playModeAddr)) {
            mem.write32(playModeAddr, this.playMode);
        }
        if (Memory.isAddressGood(playSpeedAddr)) {
            mem.write32(playSpeedAddr, this.playSpeed);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1054220851, version=150)
    public void scePsmfPlayerGetCurrentPts(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int psmfPlayer = cpu.gpr[4];
        int currentPtsAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetCurrentPts psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", currentPtsAddr=0x" + Integer.toHexString(currentPtsAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(currentPtsAddr)) {
            mem.write32(currentPtsAddr, (int)this.psmfPlayerAvcAu.pts);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1611484441, version=150)
    public void scePsmfPlayerGetCurrentVideoStream(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int psmfPlayer = cpu.gpr[4];
        int videoCodecAddr = cpu.gpr[5];
        int videoStreamNumAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerGetCurrentVideoStream psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", videoCodecAddr=0x" + Integer.toHexString(videoCodecAddr) + ", videoStreamNumAddr=0x" + Integer.toHexString(videoStreamNumAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(videoCodecAddr)) {
            mem.write32(videoCodecAddr, this.videoCodec);
        }
        if (Memory.isAddressGood(videoStreamNumAddr)) {
            mem.write32(videoStreamNumAddr, this.videoStreamNum);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=736826729, version=150)
    public void scePsmfPlayerBreak(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        log.warn("IGNORING: scePsmfPlayerBreak psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1992357038, version=150)
    public void scePsmfPlayerSetPsmfOffset(Processor processor) {
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSetPsmfOffset redirecting to scePsmfPlayerSetPsmf");
        }
        this.scePsmfPlayerSetPsmf(processor);
    }

    @HLEFunction(nid=-1490176775, version=150)
    public void scePsmfPlayerSetPsmfOffsetCB(Processor processor) {
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSetPsmfOffsetCB redirecting to scePsmfPlayerSetPsmfCB");
        }
        this.scePsmfPlayerSetPsmfCB(processor);
    }

    @HLEFunction(nid=755912202, version=150)
    public void scePsmfPlayerSetTempBuf(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        log.warn("IGNORING: scePsmfPlayerSetTempBuf psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1978679202, version=150)
    public void scePsmfPlayerSelectSpecificVideo(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        int newVideoCodec = cpu.gpr[5];
        int newVideoStreamNum = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSelectSpecificVideo psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", newVideoCodec=0x" + Integer.toHexString(newVideoCodec) + ", newVideoStreamNum=" + newVideoStreamNum);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.videoCodec = newVideoCodec;
        this.videoStreamNum = newVideoStreamNum;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-2059002113, version=150)
    public void scePsmfPlayerSelectSpecificAudio(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        int newAudioCodec = cpu.gpr[5];
        int newAudioStreamNum = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSelectSpecificVideo psmfPlayer=0x" + Integer.toHexString(psmfPlayer) + ", newAudioCodec=0x" + Integer.toHexString(newAudioCodec) + ", newAudioStreamNum=" + newAudioStreamNum);
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.audioCodec = newAudioCodec;
        this.audioStreamNum = newAudioStreamNum;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1969308211, version=150)
    public void scePsmfPlayerSelectVideo(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSelectVideo psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        ++this.videoStreamNum;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1194259370, version=150)
    public void scePsmfPlayerSelectAudio(Processor processor) {
        CpuState cpu = processor.cpu;
        int psmfPlayer = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("scePsmfPlayerSelectAudio psmfPlayer=0x" + Integer.toHexString(psmfPlayer));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        ++this.audioStreamNum;
        cpu.gpr[2] = 0;
    }

    private class EnableMediaEngineSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            scePsmfPlayer.this.setEnableMediaEngine(value);
        }
    }
}

