/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceSsl
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceSsl");
    private boolean isSslInit;
    private int maxMemSize;
    private int currentMemSize;

    @Override
    public String getName() {
        return "sceSsl";
    }

    @HLEFunction(nid=-1786852382, version=150)
    public void sceSslInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int heapSize = cpu.gpr[4];
        log.info("sceSslInit: heapSize=" + Integer.toHexString(heapSize));
        if (this.isSslInit) {
            cpu.gpr[2] = -2143072224;
        } else if (heapSize <= 0) {
            cpu.gpr[2] = -2143071746;
        } else {
            this.maxMemSize = heapSize;
            this.currentMemSize = heapSize / 2;
            this.isSslInit = true;
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=421322495, version=150)
    public void sceSslEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.info("sceSslEnd");
        if (!this.isSslInit) {
            cpu.gpr[2] = -2143072255;
        } else {
            this.isSslInit = false;
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1543203681, version=150)
    public void sceSslGetNotAfter(Processor processor) {
        CpuState cpu = processor.cpu;
        int sslCertAddr = cpu.gpr[4];
        int endTimeAddr = cpu.gpr[5];
        log.warn("UNIMPLEMENTED: sceSslGetNotAfter: sslCertAddr=" + Integer.toHexString(sslCertAddr) + ", endTimeAddr=" + Integer.toHexString(endTimeAddr));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=396430796, version=150)
    public void sceSslGetNotBefore(Processor processor) {
        CpuState cpu = processor.cpu;
        int sslCertAddr = cpu.gpr[4];
        int startTimeAddr = cpu.gpr[5];
        log.warn("UNIMPLEMENTED: sceSslGetNotAfter: sslCertAddr=" + Integer.toHexString(sslCertAddr) + ", startTimeAddr=" + Integer.toHexString(startTimeAddr));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1037426723, version=150)
    public void sceSslGetSubjectName(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceSslGetSubjectName");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=461144465, version=150)
    public void sceSslGetIssuerName(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceSslGetIssuerName");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-871818832, version=150)
    public void sceSslGetSerialNumber(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceSslGetSerialNumber");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=93135296, version=150)
    public void sceSslGetNameEntryCount(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceSslGetNameEntryCount");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-690972748, version=150)
    public void sceSslGetNameEntryInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceSslGetNameEntryInfo");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1180770710, version=150)
    public void sceSslGetUsedMemoryMax(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int maxMemAddr = cpu.gpr[4];
        log.info("sceSslGetUsedMemoryMax: maxMemAddr=" + Integer.toHexString(maxMemAddr));
        if (Memory.isAddressGood(maxMemAddr)) {
            mem.write32(maxMemAddr, this.maxMemSize);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = !this.isSslInit ? -2143072255 : -2143071746;
        }
    }

    @HLEFunction(nid=246692614, version=150)
    public void sceSslGetUsedMemoryCurrent(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int currentMemAddr = cpu.gpr[4];
        log.info("sceSslGetUsedMemoryCurrent: currentMemAddr=" + Integer.toHexString(currentMemAddr));
        if (Memory.isAddressGood(currentMemAddr)) {
            mem.write32(currentMemAddr, this.currentMemSize);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = !this.isSslInit ? -2143072255 : -2143071746;
        }
    }

    @HLEFunction(nid=-176724525, version=150)
    public void sceSslGetKeyUsage(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("UNIMPLEMENTED: sceSslGetKeyUsage");
        cpu.gpr[2] = -559038242;
    }
}

