/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Screen;
import org.apache.log4j.Logger;

public class sceSuspendForUser
extends HLEModule {
    private static Logger log = Modules.getLogger("sceSuspendForUser");
    public static final int KERNEL_POWER_TICK_SUSPEND_AND_DISPLAY = 0;
    public static final int KERNEL_POWER_TICK_SUSPEND = 1;
    public static final int KERNEL_POWER_TICK_DISPLAY = 6;
    private boolean volatileMemLocked;

    @Override
    public String getName() {
        return "sceSuspendForUser";
    }

    @Override
    public void start() {
        this.volatileMemLocked = false;
        super.start();
    }

    @HLEFunction(nid=-354739241, version=150)
    public void sceKernelPowerLock(Processor processor) {
        CpuState cpu = processor.cpu;
        int type = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("IGNORING:sceKernelPowerLock type=" + type);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=988705377, version=150)
    public void sceKernelPowerUnlock(Processor processor) {
        CpuState cpu = processor.cpu;
        int type = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("IGNORING:sceKernelPowerUnlock type=" + type);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=151833407, version=150)
    public void sceKernelPowerTick(Processor processor) {
        CpuState cpu = processor.cpu;
        int flag = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        switch (flag) {
            case 0: {
                Screen.hleKernelPowerTick();
                if (!log.isTraceEnabled()) break;
                log.trace("IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_SUSPEND_AND_DISPLAY)");
                break;
            }
            case 1: {
                if (!log.isTraceEnabled()) break;
                log.trace("IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_SUSPEND)");
                break;
            }
            case 6: {
                Screen.hleKernelPowerTick();
                if (!log.isTraceEnabled()) break;
                log.trace("IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_DISPLAY)");
                break;
            }
            default: {
                log.warn("IGNORING:sceKernelPowerTick(" + flag + ")");
            }
        }
        cpu.gpr[2] = 0;
    }

    protected void hleKernelVolatileMemLock(Processor processor, boolean trylock) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int type = cpu.gpr[4];
        int paddr = cpu.gpr[5];
        int psize = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("hleKernelVolatileMemLock type=%d, paddr=0x%08X, psize=0x%08X, trylock=%b", type, paddr, psize, trylock));
        }
        if (type != 0) {
            log.warn("hleKernelVolatileMemLock bad param: type != 0");
            cpu.gpr[2] = -2147483137;
        } else if (!this.volatileMemLocked) {
            this.volatileMemLocked = true;
            if (Memory.isAddressGood(paddr)) {
                mem.write32(paddr, 0x8400000);
            }
            if (Memory.isAddressGood(psize)) {
                mem.write32(psize, 0x400000);
            }
            cpu.gpr[2] = 0;
        } else {
            log.warn("hleKernelVolatileMemLock already locked");
            cpu.gpr[2] = trylock ? -2144665088 : -1;
        }
    }

    @HLEFunction(nid=1040347603, version=150)
    public void sceKernelVolatileMemLock(Processor processor) {
        CpuState cpu = processor.cpu;
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        this.hleKernelVolatileMemLock(processor, false);
    }

    @HLEFunction(nid=-1588641614, version=150)
    public void sceKernelVolatileMemTryLock(Processor processor) {
        this.hleKernelVolatileMemLock(processor, true);
    }

    @HLEFunction(nid=-1519786971, version=150)
    public void sceKernelVolatileMemUnlock(Processor processor) {
        CpuState cpu = processor.cpu;
        int type = cpu.gpr[4];
        log.debug("sceKernelVolatileMemUnlock(type=" + type + ")");
        if (type != 0) {
            log.warn("sceKernelVolatileMemUnlock bad param: type != 0");
            cpu.gpr[2] = -2147483137;
        } else if (!this.volatileMemLocked) {
            log.warn("sceKernelVolatileMemUnlock - Volatile Memory was not locked!");
            cpu.gpr[2] = -1;
        } else {
            this.volatileMemLocked = false;
            cpu.gpr[2] = 0;
        }
    }
}

