/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.sound.AudioBlockingOutputAction;
import jpcsp.sound.SoundChannel;
import org.apache.log4j.Logger;

public class sceVaudio
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceVaudio");
    protected static final int PSP_VAUDIO_VOLUME_BASE = 32768;
    protected static final int PSP_VAUDIO_SAMPLE_MIN = 256;
    protected static final int PSP_VAUDIO_SAMPLE_MAX = 2048;
    protected static final int PSP_VAUDIO_FORMAT_MONO = 0;
    protected static final int PSP_VAUDIO_FORMAT_STEREO = 2;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_NONE = 0;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_1 = 1;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_2 = 2;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_3 = 3;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_4 = 4;
    protected static final int PSP_VAUDIO_ALC_MODE_NONE = 0;
    protected static final int PSP_VAUDIO_ALC_MODE_1 = 1;
    protected SoundChannel pspVaudioChannel;

    @Override
    public String getName() {
        return "sceVaudio";
    }

    @Override
    public void start() {
        SoundChannel.init();
        this.pspVaudioChannel = new SoundChannel(9);
        super.start();
    }

    protected int doAudioOutput(SoundChannel channel, int pvoid_buf) {
        int ret = -1;
        if (channel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("doAudioOuput(%s, 0x%08X)", channel.toString(), pvoid_buf));
            }
            int bytesPerSample = channel.isFormatStereo() ? 4 : 2;
            int nbytes = bytesPerSample * channel.getSampleLength();
            byte[] data = new byte[nbytes];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(pvoid_buf, nbytes, 2);
            if (channel.isFormatMono()) {
                int volume = Audio.getVolume(channel.getLeftVolume());
                for (int i = 0; i < nbytes; i += 2) {
                    short sample = (short)memoryReader.readNext();
                    sample = SoundChannel.adjustSample(sample, volume);
                    SoundChannel.storeSample(sample, data, i);
                }
            } else {
                int leftVolume = Audio.getVolume(channel.getLeftVolume());
                int rightVolume = Audio.getVolume(channel.getRightVolume());
                for (int i = 0; i < nbytes; i += 4) {
                    short lsample = (short)memoryReader.readNext();
                    short rsample = (short)memoryReader.readNext();
                    lsample = SoundChannel.adjustSample(lsample, leftVolume);
                    rsample = SoundChannel.adjustSample(rsample, rightVolume);
                    SoundChannel.storeSample(lsample, data, i);
                    SoundChannel.storeSample(rsample, data, i + 2);
                }
            }
            channel.play(data);
            ret = channel.getSampleLength();
        } else {
            log.warn("doAudioOutput: channel " + channel.getIndex() + " not reserved");
        }
        return ret;
    }

    protected void blockThreadOutput(SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        this.blockThreadOutput(threadMan.getCurrentThreadID(), channel, addr, leftVolume, rightVolume);
        threadMan.hleBlockCurrentThread();
    }

    protected void blockThreadOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        AudioBlockingOutputAction action = new AudioBlockingOutputAction(threadId, channel, addr, leftVolume, rightVolume);
        int delayMicros = channel.getUnblockOutputDelayMicros(addr == 0);
        long schedule = Emulator.getClock().microTime() + (long)delayMicros;
        Emulator.getScheduler().addAction(schedule, action);
    }

    protected int changeChannelVolume(SoundChannel channel, int leftvol, int rightvol) {
        int ret = -1;
        if (channel.isReserved()) {
            channel.setLeftVolume(leftvol);
            channel.setRightVolume(rightvol);
            ret = 0;
        }
        return ret;
    }

    @HLEFunction(nid=1733844477, version=150)
    public void sceVaudioChRelease(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("PARTIAL: sceVaudioChRelease");
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.pspVaudioChannel.isReserved()) {
            this.pspVaudioChannel.release();
            this.pspVaudioChannel.setReserved(false);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2144993272;
        }
    }

    @HLEFunction(nid=62292093, version=150)
    public void sceVaudioChReserve(Processor processor) {
        CpuState cpu = processor.cpu;
        int samplecount = cpu.gpr[4];
        int freq = cpu.gpr[5];
        int format = cpu.gpr[6];
        log.warn("PARTIAL: sceVaudioChReserve: samplecount=" + samplecount + ", freq=" + freq + ", format=" + format);
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (!this.pspVaudioChannel.isReserved()) {
            this.pspVaudioChannel.setReserved(true);
            this.pspVaudioChannel.setSampleLength(samplecount);
            this.pspVaudioChannel.setSampleRate(freq);
            this.pspVaudioChannel.setFormat(format);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-1987696290, version=150)
    public void sceVaudioOutputBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        int vol = cpu.gpr[4];
        int buf = cpu.gpr[5];
        log.warn("PARTIAL: sceVaudioOutputBlocking: vol=0x" + Integer.toHexString(vol) + ", buf=0x" + Integer.toHexString(buf));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (!Memory.isAddressGood(buf)) {
            log.warn("sceVaudioOutputBlocking bad pointer " + String.format("0x%08X", buf));
            cpu.gpr[2] = -2144993276;
        } else if (!this.pspVaudioChannel.isOutputBlocking()) {
            if (log.isDebugEnabled()) {
                log.debug("sceVaudioOutputBlocking[not blocking] " + this.pspVaudioChannel.toString());
            }
            if ((vol & 0x8000) != 32768) {
                this.changeChannelVolume(this.pspVaudioChannel, vol, vol);
            }
            cpu.gpr[2] = this.doAudioOutput(this.pspVaudioChannel, buf);
            if (log.isDebugEnabled()) {
                log.debug("sceVaudioOutputBlocking[not blocking] returning " + cpu.gpr[2] + " (" + this.pspVaudioChannel.toString() + ")");
            }
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("sceVaudioOutputBlocking[blocking] " + this.pspVaudioChannel.toString());
            }
            this.blockThreadOutput(this.pspVaudioChannel, buf, vol, vol);
        }
    }

    @HLEFunction(nid=879738516, version=150)
    public void sceVaudioSetEffectType(Processor processor) {
        CpuState cpu = processor.cpu;
        int type = cpu.gpr[4];
        int vol = cpu.gpr[5];
        log.warn("UNIMPLEMENTED: sceVaudioSetEffectType: type=" + type + ", vol=0x" + Integer.toHexString(vol));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-875254703, version=150)
    public void sceVaudioSetAlcMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int alcMode = cpu.gpr[4];
        log.warn("UNIMPLEMENTED: sceVaudioSetAlcMode: alcMode=" + alcMode);
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = 0;
    }
}

