/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules200;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.SceUtilityInstallParams;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules150.sceUtility;
import jpcsp.Processor;
import jpcsp.filesystems.SeekableDataInput;

public class sceUtility
extends jpcsp.HLE.modules150.sceUtility {
    public static final String[] utilityNetModuleNames = new String[]{"PSP_NET_MODULE_UNKNOWN(1)", "PSP_NET_MODULE_COMMON", "PSP_NET_MODULE_ADHOC", "PSP_NET_MODULE_INET", "PSP_NET_MODULE_PARSEURI", "PSP_NET_MODULE_PARSEHTTP", "PSP_NET_MODULE_HTTP", "PSP_NET_MODULE_SSL"};
    public static final int PSP_NET_MODULE_COMMON = 1;
    public static final int PSP_NET_MODULE_ADHOC = 2;
    public static final int PSP_NET_MODULE_INET = 3;
    public static final int PSP_NET_MODULE_PARSEURI = 4;
    public static final int PSP_NET_MODULE_PARSEHTTP = 5;
    public static final int PSP_NET_MODULE_HTTP = 6;
    public static final int PSP_NET_MODULE_SSL = 7;
    protected HashMap<Integer, SceModule> loadedNetModules = new HashMap();
    protected HashMap<Integer, String> waitingNetModules = new HashMap();
    protected InstallUtilityDialogState installState;

    @Override
    public void start() {
        super.start();
        this.installState = new InstallUtilityDialogState("sceUtilityInstall");
    }

    private String getNetModuleName(int module) {
        if (module < 0 || module >= utilityNetModuleNames.length) {
            return "PSP_NET_MODULE_UNKNOWN_" + module;
        }
        return utilityNetModuleNames[module];
    }

    protected int hleUtilityLoadNetModule(int module, String moduleName) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (this.loadedNetModules.containsKey(module) || this.waitingNetModules.containsKey(module)) {
            return -2146367486;
        }
        if (!moduleManager.hasFlash0Module(moduleName)) {
            this.waitingNetModules.put(module, moduleName);
            return -2146367487;
        }
        int sceModuleId = moduleManager.LoadFlash0Module(moduleName);
        SceModule sceModule = Managers.modules.getModuleByUID(sceModuleId);
        this.loadedNetModules.put(module, sceModule);
        return 0;
    }

    protected int hleUtilityUnloadNetModule(int module) {
        if (this.loadedNetModules.containsKey(module)) {
            HLEModuleManager moduleManager = HLEModuleManager.getInstance();
            SceModule sceModule = this.loadedNetModules.remove(module);
            moduleManager.UnloadFlash0Module(sceModule);
            return 0;
        }
        if (this.waitingNetModules.containsKey(module)) {
            this.waitingNetModules.remove(module);
            return 0;
        }
        return -2146367485;
    }

    @HLEFunction(nid=360292697, version=200)
    public void sceUtilityLoadNetModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String moduleName = this.getNetModuleName(module);
        int result = this.hleUtilityLoadNetModule(module, moduleName);
        if (result == -2146367487) {
            log.info(String.format("IGNORING: sceUtilityLoadNetModule(module=0x%04X) %s", module, moduleName));
            result = 0;
        } else {
            log.info(String.format("sceUtilityLoadNetModule(module=0x%04X) %s loaded", module, moduleName));
        }
        cpu.gpr[2] = result;
    }

    @HLEFunction(nid=1691683926, version=200)
    public void sceUtilityUnloadNetModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        String moduleName = this.getNetModuleName(module);
        log.info(String.format("sceUtilityUnloadNetModule(module=0x%04X) %s unloaded", module, moduleName));
        cpu.gpr[2] = this.hleUtilityUnloadNetModule(module);
    }

    @HLEFunction(nid=310499982, version=200)
    public void sceUtilityInstallInitStart(Processor processor) {
        this.installState.executeInitStart(processor);
    }

    @HLEFunction(nid=1592902218, version=200)
    public void sceUtilityInstallShutdownStart(Processor processor) {
        this.installState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-1606604358, version=200)
    public void sceUtilityInstallUpdate(Processor processor) {
        this.installState.executeUpdate(processor);
    }

    @HLEFunction(nid=-999288925, version=200)
    public void sceUtilityInstallGetStatus(Processor processor) {
        this.installState.executeGetStatus(processor);
    }

    protected static class InstallUtilityDialogState
    extends sceUtility.UtilityDialogState {
        protected SceUtilityInstallParams installParams;

        public InstallUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            boolean keepVisible = false;
            log.warn(String.format("Partial sceUtilityInstallUpdate %s", this.installParams.toString()));
            String fileName = String.format("ms0:/PSP/GAME/%s/EBOOT.PBP", this.installParams.gameName);
            try {
                SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(fileName, 1);
                if (moduleInput != null) {
                    byte[] moduleBytes = new byte[(int)moduleInput.length()];
                    moduleInput.readFully(moduleBytes);
                    ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                    SceModule module = Emulator.getInstance().load(this.name, moduleBuffer, true);
                    Emulator.getClock().resume();
                    if ((module.fileFormat & 1) == 1) {
                        this.installParams.base.result = 0;
                        keepVisible = false;
                    } else {
                        log.warn("sceUtilityInstall - failed, target is not an ELF");
                        this.installParams.base.result = -1;
                    }
                    moduleInput.close();
                }
            }
            catch (GeneralJpcspException e) {
                log.error("General Error : " + e.getMessage());
                Emulator.PauseEmu();
            }
            catch (IOException e) {
                log.error(String.format("sceUtilityInstall - Error while loading module %s: %s", fileName, e.getMessage()));
                this.installParams.base.result = -1;
            }
            return keepVisible;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.installParams = new SceUtilityInstallParams();
            return this.installParams;
        }
    }
}

