/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules250;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules150.sceAtrac3plus;
import jpcsp.Memory;
import jpcsp.Processor;

public class sceAtrac3plus
extends jpcsp.HLE.modules150.sceAtrac3plus {
    @Override
    public String getName() {
        return "sceAtrac3plus";
    }

    @HLEFunction(nid=-1279930302, version=250)
    public void sceAtracGetOutputChannel(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int atID = cpu.gpr[4];
        int outputChannelAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracGetOutputChannel: atracID = %d, outputChannelAddr = 0x%08X", atID, outputChannelAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn("sceAtracGetOutputChannel: bad atracID= " + atID);
            cpu.gpr[2] = -2140995579;
        } else {
            if (Memory.isAddressGood(outputChannelAddr)) {
                mem.write32(outputChannelAddr, 2);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-324851047, version=250)
    public void sceAtracIsSecondBufferNeeded(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracIsSecondBufferNeeded atracId=%d", atID));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn("sceAtracGetOutputChannel: bad atracID= " + atID);
            cpu.gpr[2] = -2140995579;
        } else {
            cpu.gpr[2] = ((sceAtrac3plus.AtracID)this.atracIDs.get(atID)).isSecondBufferNeeded() ? 1 : 0;
        }
    }

    @HLEFunction(nid=321855178, version=250)
    public void sceAtracReinit(Processor processor) {
        CpuState cpu = processor.cpu;
        int at3IDNum = cpu.gpr[4];
        int at3plusIDNum = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracReinit at3IDNum=%d at3plusIDNum=%d", at3IDNum, at3plusIDNum));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (at3IDNum + at3plusIDNum * 2 > 6) {
            cpu.gpr[2] = -2140995581;
        } else {
            this.hleAtracReinit(at3IDNum, at3plusIDNum);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=768860824, version=250)
    public void sceAtracGetBufferInfoForResetting(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4];
        int sample = cpu.gpr[5];
        int bufferInfoAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracGetBufferInfoForResetting atracID=%d, sample=%d, bufferInfoAddr=0x%08x", atID, sample, bufferInfoAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn("sceAtracGetOutputChannel: bad atracID= " + atID);
            cpu.gpr[2] = -2140995579;
        } else {
            ((sceAtrac3plus.AtracID)this.atracIDs.get(atID)).getBufferInfoForReseting(sample, bufferInfoAddr);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1559877714, version=250)
    public void sceAtracSetMOutHalfwayBuffer(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int MOutHalfBuffer = cpu.gpr[5];
        int readSize = cpu.gpr[6];
        int MOutHalfBufferSize = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracSetMOutHalfwayBuffer: atID = %d, buffer = 0x%08X, readSize = 0x%08X, bufferSize = 0x%08X", atID, MOutHalfBuffer, readSize, MOutHalfBufferSize));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn("sceAtracSetMOutHalfwayBuffer: bad atracID= " + atID);
            cpu.gpr[2] = -2140995579;
        } else {
            ((sceAtrac3plus.AtracID)this.atracIDs.get(atID)).setData(MOutHalfBuffer, readSize, MOutHalfBufferSize, false);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-159155686, version=250)
    public void sceAtracSetMOutData(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented function sceAtracSetMOutData " + String.format("%08x %08x %08x %08x %08x %08x", cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1194211365, version=250)
    public void sceAtracSetMOutDataAndGetID(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented function sceAtracSetMOutDataAndGetID " + String.format("%08x %08x %08x %08x %08x %08x", cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1663574525, version=250)
    public void sceAtracSetMOutHalfwayBufferAndGetID(Processor processor) {
        int codecType;
        CpuState cpu = processor.cpu;
        int MOutHalfBuffer = cpu.gpr[4];
        int readSize = cpu.gpr[5];
        int MOutHalfBufferSize = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracSetMOutHalfwayBufferAndGetID buffer = 0x%08X, readSize = 0x%08X, bufferSize = 0x%08X", MOutHalfBuffer, readSize, MOutHalfBufferSize));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        int atID = 0;
        if (Memory.isAddressGood(MOutHalfBuffer) && this.atracIDs.containsKey(atID = this.hleCreateAtracID(codecType = sceAtrac3plus.getCodecType(MOutHalfBuffer)))) {
            ((sceAtrac3plus.AtracID)this.atracIDs.get(atID)).setData(MOutHalfBuffer, readSize, MOutHalfBufferSize, false);
        }
        cpu.gpr[2] = atID;
    }

    @HLEFunction(nid=1445115841, version=250)
    public void sceAtracSetAA3DataAndGetID(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int buffer = cpu.gpr[4];
        int bufferSize = cpu.gpr[5];
        int fileSize = cpu.gpr[6];
        int metadataSizeAddr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceAtracSetAA3DataAndGetID buffer = 0x%08X, bufferSize = 0x%08X, fileSize = 0x%08X, metadataSizeAddr = 0x%08X", buffer, bufferSize, fileSize, metadataSizeAddr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        int atID = 0;
        if (Memory.isAddressGood(buffer)) {
            int codecType = sceAtrac3plus.getCodecType(buffer);
            atID = this.hleCreateAtracID(codecType);
            if (this.atracIDs.containsKey(atID)) {
                ((sceAtrac3plus.AtracID)this.atracIDs.get(atID)).setData(buffer, bufferSize, bufferSize, false);
            }
            mem.write32(metadataSizeAddr, 1024);
        }
        cpu.gpr[2] = atID;
    }

    @HLEFunction(nid=1574331784, version=250)
    public void sceAtracSetAA3HalfwayBufferAndGetID(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn("Unimplemented function sceAtracSetAA3HalfwayBufferAndGetID " + String.format("%08x %08x %08x %08x %08x %08x", cpu.gpr[4], cpu.gpr[5], cpu.gpr[6], cpu.gpr[7], cpu.gpr[8], cpu.gpr[9]));
        cpu.gpr[2] = 0;
    }
}

