/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules271;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspUsbCamSetupStillExParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupStillParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupVideoExParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupVideoParam;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceUsbCam
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceUsbCam");
    public static final int PSP_USBCAM_PID = 642;
    public static final String PSP_USBCAM_DRIVERNAME = "USBCamDriver";
    public static final String PSP_USBCAMMIC_DRIVERNAME = "USBCamMicDriver";
    public static final int PSP_USBCAM_RESOLUTION_160_120 = 0;
    public static final int PSP_USBCAM_RESOLUTION_176_144 = 1;
    public static final int PSP_USBCAM_RESOLUTION_320_240 = 2;
    public static final int PSP_USBCAM_RESOLUTION_352_288 = 3;
    public static final int PSP_USBCAM_RESOLUTION_640_480 = 4;
    public static final int PSP_USBCAM_RESOLUTION_1024_768 = 5;
    public static final int PSP_USBCAM_RESOLUTION_1280_960 = 6;
    public static final int PSP_USBCAM_RESOLUTION_480_272 = 7;
    public static final int PSP_USBCAM_RESOLUTION_360_272 = 8;
    public static final int PSP_USBCAM_RESOLUTION_EX_160_120 = 0;
    public static final int PSP_USBCAM_RESOLUTION_EX_176_144 = 1;
    public static final int PSP_USBCAM_RESOLUTION_EX_320_240 = 2;
    public static final int PSP_USBCAM_RESOLUTION_EX_352_288 = 3;
    public static final int PSP_USBCAM_RESOLUTION_EX_360_272 = 4;
    public static final int PSP_USBCAM_RESOLUTION_EX_480_272 = 5;
    public static final int PSP_USBCAM_RESOLUTION_EX_640_480 = 6;
    public static final int PSP_USBCAM_RESOLUTION_EX_1024_768 = 7;
    public static final int PSP_USBCAM_RESOLUTION_EX_1280_960 = 8;
    public static final int PSP_USBCAM_FLIP = 1;
    public static final int PSP_USBCAM_MIRROR = 256;
    public static final int PSP_USBCAM_NODELAY = 0;
    public static final int PSP_USBCAM_DELAY_10SEC = 1;
    public static final int PSP_USBCAM_DELAY_20SEC = 2;
    public static final int PSP_USBCAM_DELAY_30SEC = 3;
    public static final int PSP_USBCAM_FRAMERATE_3_75_FPS = 0;
    public static final int PSP_USBCAM_FRAMERATE_5_FPS = 1;
    public static final int PSP_USBCAM_FRAMERATE_7_5_FPS = 2;
    public static final int PSP_USBCAM_FRAMERATE_10_FPS = 3;
    public static final int PSP_USBCAM_FRAMERATE_15_FPS = 4;
    public static final int PSP_USBCAM_FRAMERATE_20_FPS = 5;
    public static final int PSP_USBCAM_FRAMERATE_30_FPS = 6;
    public static final int PSP_USBCAM_FRAMERATE_60_FPS = 7;
    public static final int PSP_USBCAM_WB_AUTO = 0;
    public static final int PSP_USBCAM_WB_DAYLIGHT = 1;
    public static final int PSP_USBCAM_WB_FLUORESCENT = 2;
    public static final int PSP_USBCAM_WB_INCADESCENT = 3;
    public static final int PSP_USBCAM_EFFECTMODE_NORMAL = 0;
    public static final int PSP_USBCAM_EFFECTMODE_NEGATIVE = 1;
    public static final int PSP_USBCAM_EFFECTMODE_BLACKWHITE = 2;
    public static final int PSP_USBCAM_EFFECTMODE_SEPIA = 3;
    public static final int PSP_USBCAM_EFFECTMODE_BLUE = 4;
    public static final int PSP_USBCAM_EFFECTMODE_RED = 5;
    public static final int PSP_USBCAM_EFFECTMODE_GREEN = 6;
    public static final int PSP_USBCAM_EVLEVEL_2_0_POSITIVE = 0;
    public static final int PSP_USBCAM_EVLEVEL_1_7_POSITIVE = 1;
    public static final int PSP_USBCAM_EVLEVEL_1_5_POSITIVE = 2;
    public static final int PSP_USBCAM_EVLEVEL_1_3_POSITIVE = 3;
    public static final int PSP_USBCAM_EVLEVEL_1_0_POSITIVE = 4;
    public static final int PSP_USBCAM_EVLEVEL_0_7_POSITIVE = 5;
    public static final int PSP_USBCAM_EVLEVEL_0_5_POSITIVE = 6;
    public static final int PSP_USBCAM_EVLEVEL_0_3_POSITIVE = 7;
    public static final int PSP_USBCAM_EVLEVEL_0_0 = 8;
    public static final int PSP_USBCAM_EVLEVEL_0_3_NEGATIVE = 9;
    public static final int PSP_USBCAM_EVLEVEL_0_5_NEGATIVE = 10;
    public static final int PSP_USBCAM_EVLEVEL_0_7_NEGATIVE = 11;
    public static final int PSP_USBCAM_EVLEVEL_1_0_NEGATIVE = 12;
    public static final int PSP_USBCAM_EVLEVEL_1_3_NEGATIVE = 13;
    public static final int PSP_USBCAM_EVLEVEL_1_5_NEGATIVE = 14;
    public static final int PSP_USBCAM_EVLEVEL_1_7_NEGATIVE = 15;
    public static final int PSP_USBCAM_EVLEVEL_2_0_NEGATIVE = 16;
    protected int workArea;
    protected int workAreaSize;
    protected int jpegBuffer;
    protected int jpegBufferSize;
    protected int resolution;
    protected int frameRate;
    protected int whiteBalance;
    protected int frameSize;
    protected int saturation;
    protected int brightness;
    protected int contrast;
    protected int sharpness;
    protected int imageEffectMode;
    protected int evLevel;
    protected boolean flip;
    protected boolean mirror;
    protected int zoom;
    protected boolean autoImageReverseSW;
    protected boolean lensDirectionAtYou;

    @Override
    public String getName() {
        return "sceUsbCam";
    }

    protected int convertResolutionExToResolution(int resolutionEx) {
        switch (resolutionEx) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
        }
        return resolutionEx;
    }

    protected int readFakeVideoFrame() {
        Memory mem = Processor.memory;
        mem.memset(this.jpegBuffer, (byte)0, this.jpegBufferSize);
        return this.jpegBufferSize;
    }

    @HLEFunction(nid=402109179, version=271)
    public void sceUsbCamSetupVideo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int param = cpu.gpr[4];
        int workArea = cpu.gpr[5];
        int workAreaSize = cpu.gpr[6];
        pspUsbCamSetupVideoParam usbCamSetupVideoParam = new pspUsbCamSetupVideoParam();
        usbCamSetupVideoParam.read(mem, param);
        log.warn(String.format("Partial sceUsbCamSetupVideo param=0x%08X, workArea=0x%08X, workAreaSize=%d, param=%s", param, workArea, workAreaSize, usbCamSetupVideoParam.toString()));
        this.workArea = workArea;
        this.workAreaSize = workAreaSize;
        this.resolution = usbCamSetupVideoParam.resolution;
        this.frameRate = usbCamSetupVideoParam.framerate;
        this.whiteBalance = usbCamSetupVideoParam.wb;
        this.saturation = usbCamSetupVideoParam.saturation;
        this.brightness = usbCamSetupVideoParam.brightness;
        this.contrast = usbCamSetupVideoParam.contrast;
        this.sharpness = usbCamSetupVideoParam.sharpness;
        this.imageEffectMode = usbCamSetupVideoParam.effectmode;
        this.frameSize = usbCamSetupVideoParam.framesize;
        this.evLevel = usbCamSetupVideoParam.evlevel;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-113490327, version=271)
    public void sceUsbCamAutoImageReverseSW(Processor processor) {
        CpuState cpu = processor.cpu;
        int on = cpu.gpr[4];
        this.autoImageReverseSW = on != 1;
        log.warn(String.format("Partial sceUsbCamAutoImageReverseSW on=%d", on));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1464503359, version=271)
    public void sceUsbCamStartVideo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Ignoring sceUsbCamStartVideo", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1827876025, version=271)
    public void sceUsbCamStopVideo(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Ignoring sceUsbCamStopVideo", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=65895042, version=271)
    public void sceUsbCamSetupMic(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamSetupMic", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-2103033808, version=271)
    public void sceUsbCamStartMic(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Ignoring sceUsbCamStartMic", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=2108427377, version=271)
    public void sceUsbCamReadVideoFrameBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        int jpegBuffer = cpu.gpr[4];
        int jpegBufferSize = cpu.gpr[5];
        log.warn(String.format("Unimplemented sceUsbCamReadVideoFrameBlocking jpegBuffer=0x%08X, jpegBufferSize=%d", jpegBuffer, jpegBufferSize));
        this.jpegBuffer = jpegBuffer;
        this.jpegBufferSize = jpegBufferSize;
        cpu.gpr[2] = this.readFakeVideoFrame();
    }

    @HLEFunction(nid=-1713872255, version=271)
    public void sceUsbCamReadVideoFrame(Processor processor) {
        CpuState cpu = processor.cpu;
        int jpegBuffer = cpu.gpr[4];
        int jpegBufferSize = cpu.gpr[5];
        log.warn(String.format("Unimplemented sceUsbCamReadVideoFrame jpegBuffer=0x%08X, jpegBufferSize=%d", jpegBuffer, jpegBufferSize));
        this.jpegBuffer = jpegBuffer;
        this.jpegBufferSize = jpegBufferSize;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1105673877, version=271)
    public void sceUsbCamPollReadVideoFrameEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamPollReadVideoFrameEnd", new Object[0]));
        cpu.gpr[2] = this.readFakeVideoFrame();
    }

    @HLEFunction(nid=-116710765, version=271)
    public void sceUsbCamWaitReadVideoFrameEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamWaitReadVideoFrameEnd", new Object[0]));
        cpu.gpr[2] = this.readFakeVideoFrame();
    }

    @HLEFunction(nid=1278539091, version=271)
    public void sceUsbCamGetLensDirection(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamGetLensDirection", new Object[0]));
        cpu.gpr[2] = this.lensDirectionAtYou ? 1 : 0;
    }

    @HLEFunction(nid=1057813129, version=271)
    public void sceUsbCamSetupStill(Processor processor) {
        CpuState cpu = processor.cpu;
        int paramAddr = cpu.gpr[4];
        pspUsbCamSetupStillParam usbCamSetupStillParam = new pspUsbCamSetupStillParam();
        usbCamSetupStillParam.read(Processor.memory, paramAddr);
        log.warn(String.format("Unimplemented sceUsbCamSetupStill param=0x%08X, %s", paramAddr, usbCamSetupStillParam.toString()));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=172073624, version=271)
    public void sceUsbCamSetupStillEx(Processor processor) {
        CpuState cpu = processor.cpu;
        int paramAddr = cpu.gpr[4];
        pspUsbCamSetupStillExParam usbCamSetupStillExParam = new pspUsbCamSetupStillExParam();
        usbCamSetupStillExParam.read(Processor.memory, paramAddr);
        log.warn(String.format("Unimplemented sceUsbCamSetupStillEx param=0x%08X, %s", paramAddr, usbCamSetupStillExParam.toString()));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1639865516, version=271)
    public void sceUsbCamStillInputBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        int buffer = cpu.gpr[4];
        int size = cpu.gpr[5];
        log.warn(String.format("Unimplemented sceUsbCamStillInputBlocking buffer=0x%08X, size=%d", buffer, size));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-83202979, version=271)
    public void sceUsbCamStillInput(Processor processor) {
        CpuState cpu = processor.cpu;
        int buffer = cpu.gpr[4];
        int size = cpu.gpr[5];
        log.warn(String.format("Unimplemented sceUsbCamStillInput buffer=0x%08X, size=%d", buffer, size));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1969467297, version=271)
    public void sceUsbCamStillWaitInputEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamStillWaitInputEnd", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=440848359, version=271)
    public void sceUsbCamStillPollInputEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamStillPollInputEnd", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1491037316, version=271)
    public void sceUsbCamStillCancelInput(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamStillCancelInput", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-443179978, version=271)
    public void sceUsbCamStillGetInputLength(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamStillGetInputLength", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-806753895, version=271)
    public void sceUsbCamSetupVideoEx(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int param = cpu.gpr[4];
        int workArea = cpu.gpr[5];
        int workAreaSize = cpu.gpr[6];
        pspUsbCamSetupVideoExParam usbCamSetupVideoExParam = new pspUsbCamSetupVideoExParam();
        usbCamSetupVideoExParam.read(mem, param);
        log.warn(String.format("Partial sceUsbCamSetupVideoEx param=0x%08X, workArea=0x%08X, workAreaSize=%d, param=%s", param, workArea, workAreaSize, usbCamSetupVideoExParam.toString()));
        this.workArea = workArea;
        this.workAreaSize = workAreaSize;
        this.resolution = this.convertResolutionExToResolution(usbCamSetupVideoExParam.resolution);
        this.frameRate = usbCamSetupVideoExParam.framerate;
        this.whiteBalance = usbCamSetupVideoExParam.wb;
        this.saturation = usbCamSetupVideoExParam.saturation;
        this.brightness = usbCamSetupVideoExParam.brightness;
        this.contrast = usbCamSetupVideoExParam.contrast;
        this.sharpness = usbCamSetupVideoExParam.sharpness;
        this.imageEffectMode = usbCamSetupVideoExParam.effectmode;
        this.frameSize = usbCamSetupVideoExParam.framesize;
        this.evLevel = usbCamSetupVideoExParam.evlevel;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-543355758, version=271)
    public void sceUsbCamGetReadVideoFrameSize(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamGetReadVideoFrameSize", new Object[0]));
        cpu.gpr[2] = this.jpegBufferSize;
    }

    @HLEFunction(nid=1847613812, version=271)
    public void sceUsbCamSetSaturation(Processor processor) {
        CpuState cpu = processor.cpu;
        int saturation = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetSaturation %d", saturation));
        this.saturation = saturation;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1329431765, version=271)
    public void sceUsbCamSetBrightness(Processor processor) {
        CpuState cpu = processor.cpu;
        int brightness = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetBrightness %d", brightness));
        this.brightness = brightness;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=163736702, version=271)
    public void sceUsbCamSetContrast(Processor processor) {
        CpuState cpu = processor.cpu;
        int contrast = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetContrast %d", contrast));
        this.contrast = contrast;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1647281100, version=271)
    public void sceUsbCamSetSharpness(Processor processor) {
        CpuState cpu = processor.cpu;
        int sharpness = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetSharpness %d", sharpness));
        this.sharpness = sharpness;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-729325197, version=271)
    public void sceUsbCamSetImageEffectMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int effectMode = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetImageEffectMode %d", effectMode));
        this.imageEffectMode = effectMode;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=493381744, version=271)
    public void sceUsbCamSetEvLevel(Processor processor) {
        CpuState cpu = processor.cpu;
        int evLevel = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetEvLevel %d", evLevel));
        this.evLevel = evLevel;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1793331723, version=271)
    public void sceUsbCamSetReverseMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int reverseMode = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetReverseMode %d", reverseMode));
        this.flip = (reverseMode & 1) != 0;
        this.mirror = (reverseMode & 0x100) != 0;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-997945313, version=271)
    public void sceUsbCamSetZoom(Processor processor) {
        CpuState cpu = processor.cpu;
        int zoom = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamSetZoom %d", zoom));
        this.zoom = zoom;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=943628200, version=271)
    public void sceUsbCamGetSaturation(Processor processor) {
        CpuState cpu = processor.cpu;
        int saturationAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetSaturation 0x%08X", saturationAddr));
        Processor.memory.write32(saturationAddr, this.saturation);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1895113413, version=271)
    public void sceUsbCamGetBrightness(Processor processor) {
        CpuState cpu = processor.cpu;
        int brightnessAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetBrightness 0x%08X", brightnessAddr));
        Processor.memory.write32(brightnessAddr, this.brightness);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1604081321, version=271)
    public void sceUsbCamGetContrast(Processor processor) {
        CpuState cpu = processor.cpu;
        int contrastAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetContrast 0x%08X", contrastAddr));
        Processor.memory.write32(contrastAddr, this.contrast);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-38368221, version=271)
    public void sceUsbCamGetSharpness(Processor processor) {
        CpuState cpu = processor.cpu;
        int sharpnessAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetSharpness 0x%08X", sharpnessAddr));
        Processor.memory.write32(sharpnessAddr, this.sharpness);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1723567648, version=271)
    public void sceUsbCamGetImageEffectMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int effectModeAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetImageEffectMode 0x%08X", effectModeAddr));
        Processor.memory.write32(effectModeAddr, this.imageEffectMode);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=734875840, version=271)
    public void sceUsbCamGetEvLevel(Processor processor) {
        CpuState cpu = processor.cpu;
        int evLevelAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetEvLevel 0x%08X", evLevelAddr));
        Processor.memory.write32(evLevelAddr, this.evLevel);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-718826695, version=271)
    public void sceUsbCamGetReverseMode(Processor processor) {
        CpuState cpu = processor.cpu;
        int reverseModeAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetReverseMode 0x%08X", reverseModeAddr));
        int reverseMode = 0;
        if (this.mirror) {
            reverseMode |= 0x100;
        }
        if (this.flip) {
            reverseMode |= 1;
        }
        Processor.memory.write32(reverseModeAddr, reverseMode);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1635078259, version=271)
    public void sceUsbCamGetZoom(Processor processor) {
        CpuState cpu = processor.cpu;
        int zoomAddr = cpu.gpr[4];
        log.warn(String.format("Unimplemented sceUsbCamGetZoom 0x%08X", zoomAddr));
        Processor.memory.write32(zoomAddr, this.zoom);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=295825704, version=271)
    public void sceUsbCamGetAutoImageReverseState(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamGetAutoImageReverseState", new Object[0]));
        cpu.gpr[2] = this.autoImageReverseSW ? 1 : 0;
    }

    @HLEFunction(nid=145680778, version=271)
    public void sceUsbCamSetMicGain(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamSetMicGain", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=781386340, version=271)
    public void sceUsbCamSetupMicEx(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamSetupMicEx", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=912484645, version=271)
    public void sceUsbCamReadMicBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamReadMicBlocking", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1035995278, version=271)
    public void sceUsbCamReadMic(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamReadMic", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1106151319, version=271)
    public void sceUsbCamUnregisterLensRotationCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamUnregisterLensRotationCallback", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1363510922, version=271)
    public void sceUsbCamStopMic(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamStopMic", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1467528274, version=271)
    public void sceUsbCamGetMicDataLength(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamGetMicDataLength", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1736763048, version=271)
    public void sceUsbCamSetAntiFlicker(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamSetAntiFlicker", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1434610502, version=271)
    public void sceUsbCamGetAntiFlicker(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamGetAntiFlicker", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1337416067, version=271)
    public void sceUsbCamWaitReadMicEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamWaitReadMicEnd", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-762076928, version=271)
    public void sceUsbCamRegisterLensRotationCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamRegisterLensRotationCallback", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-125534368, version=271)
    public void sceUsbCamPollReadMicEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn(String.format("Unimplemented sceUsbCamPollReadMicEnd", new Object[0]));
        cpu.gpr[2] = 0;
    }
}

