/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules500;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceHeap
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceHeap");
    protected static final int PSP_HEAP_ATTR_ADDR_HIGH = 16384;
    protected static final int PSP_HEAP_ATTR_EXT = 32768;
    private HashMap<Integer, SysMemUserForUser.SysMemInfo> heapMap = new HashMap();
    private HashMap<Integer, SysMemUserForUser.SysMemInfo> heapMemMap = new HashMap();

    @Override
    public String getName() {
        return "sceHeap";
    }

    @HLEFunction(nid=243751296, version=500)
    public void sceHeapReallocHeapMemory(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        int mem_addr = cpu.gpr[5];
        int memSize = cpu.gpr[6];
        log.warn("UNIMPLEMENTED: sceHeapReallocHeapMemory heap_addr=0x" + Integer.toHexString(heap_addr) + ", mem_addr=0x" + Integer.toHexString(mem_addr) + ", memSize=0x" + Integer.toHexString(memSize));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=478459277, version=500)
    public void sceHeapReallocHeapMemoryWithOption(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        int mem_addr = cpu.gpr[5];
        int memSize = cpu.gpr[6];
        int param_addr = cpu.gpr[7];
        log.warn("UNIMPLEMENTED: sceHeapReallocHeapMemory heap_addr=0x" + Integer.toHexString(heap_addr) + ", mem_addr=0x" + Integer.toHexString(mem_addr) + ", memSize=0x" + Integer.toHexString(memSize) + ", param_addr=0x" + Integer.toHexString(param_addr));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=716889187, version=500)
    public void sceHeapFreeHeapMemory(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        int mem_addr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceHeapFreeHeapMemory heap_addr=0x" + Integer.toHexString(heap_addr) + ", mem_addr=0x" + Integer.toHexString(mem_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.heapMemMap.containsKey(mem_addr)) {
            Modules.SysMemUserForUserModule.free(this.heapMemMap.get(mem_addr));
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = this.heapMap.containsKey(heap_addr) ? -2147483392 : -2147483389;
        }
    }

    @HLEFunction(nid=705437705, version=500)
    public void sceHeapGetMallinfo(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        int info_addr = cpu.gpr[5];
        log.warn("UNIMPLEMENTED: sceHeapGetMallinfo heap_addr=0x" + Integer.toHexString(heap_addr) + ", info_addr=0x" + Integer.toHexString(info_addr));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=728930776, version=500)
    public void sceHeapAllocHeapMemoryWithOption(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int heap_addr = cpu.gpr[4];
        int memSize = cpu.gpr[5];
        int param_addr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug("sceHeapAllocHeapMemoryWithOption heap_addr=0x" + Integer.toHexString(heap_addr) + ", memSize=0x" + Integer.toHexString(memSize) + ", param_addr=0x" + Integer.toHexString(param_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (Memory.isAddressGood(param_addr)) {
            int paramSize = mem.read32(param_addr);
            if (paramSize >= 4 && paramSize <= 8) {
                int memAlign = mem.read32(param_addr + 4);
                if (log.isDebugEnabled()) {
                    log.debug("sceHeapAllocHeapMemoryWithOption options: struct size=" + paramSize + ", alignment=0x" + Integer.toHexString(memAlign));
                }
            } else {
                log.warn("sceHeapAllocHeapMemoryWithOption option at 0x" + Integer.toHexString(param_addr) + " (size=" + paramSize + ")");
            }
        }
        SysMemUserForUser.SysMemInfo heapInfo = null;
        SysMemUserForUser.SysMemInfo heapMemInfo = null;
        if (this.heapMap.containsKey(heap_addr)) {
            heapInfo = this.heapMap.get(heap_addr);
            heapMemInfo = Modules.SysMemUserForUserModule.malloc(heapInfo.partitionid, "ThreadMan-HeapMem", heapInfo.type, memSize, 0);
        }
        if (heapMemInfo != null) {
            this.heapMemMap.put(heapMemInfo.addr, heapMemInfo);
            cpu.gpr[2] = heapMemInfo.addr;
        } else {
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1227469837, version=500)
    public void sceHeapGetTotalFreeSize(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        log.warn("UNIMPLEMENTED: sceHeapGetTotalFreeSize heap_addr=0x" + Integer.toHexString(heap_addr));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1880275933, version=500)
    public void sceHeapIsAllocatedHeapMemory(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        int mem_addr = cpu.gpr[5];
        log.warn("UNIMPLEMENTED: sceHeapIsAllocatedHeapMemory heap_addr=0x" + Integer.toHexString(heap_addr) + ", mem_addr=0x" + Integer.toHexString(mem_addr));
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1881213811, version=500)
    public void sceHeapDeleteHeap(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug("sceHeapDeleteHeap heap_addr=0x" + Integer.toHexString(heap_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.heapMap.containsKey(heap_addr)) {
            Modules.SysMemUserForUserModule.free(this.heapMap.get(heap_addr));
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2147483392;
        }
    }

    @HLEFunction(nid=2111996354, version=500)
    public void sceHeapCreateHeap(Processor processor) {
        CpuState cpu = processor.cpu;
        int name_addr = cpu.gpr[4];
        int heapSize = cpu.gpr[5];
        int attr = cpu.gpr[6];
        int param_addr = cpu.gpr[7];
        String name = Utilities.readStringZ(name_addr);
        if (log.isDebugEnabled()) {
            log.debug("sceHeapCreateHeap name='" + name + "', heapSize=0x" + Integer.toHexString(heapSize) + ", attr=0x" + Integer.toHexString(attr) + ", param_addr=0x" + Integer.toHexString(param_addr));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        if (param_addr != 0) {
            log.warn("sceHeapCreateHeap option at 0x" + Integer.toHexString(param_addr));
        }
        SysMemUserForUser.SysMemInfo info = null;
        int totalHeapSize = heapSize + 3 & 0xFFFFFFFC;
        int maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize();
        if (totalHeapSize <= maxFreeSize) {
            info = Modules.SysMemUserForUserModule.malloc(2, "ThreadMan-Heap", memType, totalHeapSize, 0);
        } else {
            Modules.log.warn("sceHeapCreateHeap not enough free mem (want=" + totalHeapSize + ", free=" + maxFreeSize + ", diff=" + (totalHeapSize - maxFreeSize) + ")");
        }
        if (info != null) {
            this.heapMap.put(info.addr, info);
            cpu.gpr[2] = info.addr;
        } else {
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1461648736, version=500)
    public void sceHeapAllocHeapMemory(Processor processor) {
        CpuState cpu = processor.cpu;
        int heap_addr = cpu.gpr[4];
        int memSize = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug("sceHeapAllocHeapMemoryWithOption heap_addr=0x" + Integer.toHexString(heap_addr) + ", memSize=0x" + Integer.toHexString(memSize));
        }
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        SysMemUserForUser.SysMemInfo heapInfo = null;
        SysMemUserForUser.SysMemInfo heapMemInfo = null;
        if (this.heapMap.containsKey(heap_addr)) {
            heapInfo = this.heapMap.get(heap_addr);
            heapMemInfo = Modules.SysMemUserForUserModule.malloc(heapInfo.partitionid, "ThreadMan-HeapMem", heapInfo.type, memSize, 0);
        }
        if (heapMemInfo != null) {
            this.heapMemMap.put(heapMemInfo.addr, heapMemInfo);
            cpu.gpr[2] = heapMemInfo.addr;
        } else {
            cpu.gpr[2] = 0;
        }
    }
}

