/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules630;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.Processor;

public class ThreadManForUser
extends jpcsp.HLE.modules380.ThreadManForUser {
    public int checkStackSize(int size) {
        if (size < 512) {
            throw new SceKernelErrorException(-2147352172);
        }
        return size + 255 & 0xFFFFFF00;
    }

    @HLEFunction(nid=-1132401540, version=630, checkInsideInterrupt=true)
    public int sceKernelExtendThreadStack(Processor processor, @CheckArgument(value="checkStackSize") int size, TPointer entryAddr, int entryParameter) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug(String.format("sceKernelExtendThreadStack size=0x%X, entryAddr=%s, entryParameter=0x%08X", size, entryAddr, entryParameter));
        }
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        int extendedStackAddr = thread.extendStack(size);
        AfterSceKernelExtendThreadStackAction afterAction = new AfterSceKernelExtendThreadStackAction(thread, cpu.pc, cpu.gpr[29], cpu.gpr[31]);
        cpu.gpr[4] = entryParameter;
        cpu.gpr[29] = extendedStackAddr + size;
        Modules.ThreadManForUserModule.callAddress(entryAddr.getAddress(), afterAction, false);
        return 0;
    }

    private static class AfterSceKernelExtendThreadStackAction
    implements IAction {
        private SceKernelThreadInfo thread;
        private int savedPc;
        private int savedSp;
        private int savedRa;

        public AfterSceKernelExtendThreadStackAction(SceKernelThreadInfo thread, int savedPc, int savedSp, int savedRa) {
            this.thread = thread;
            this.savedPc = savedPc;
            this.savedSp = savedSp;
            this.savedRa = savedRa;
        }

        @Override
        public void execute() {
            CpuState cpu = Emulator.getProcessor().cpu;
            if (log.isDebugEnabled()) {
                log.debug(String.format("AfterSceKernelExtendThreadStackAction savedSp=0x%08X, savedRa=0x%08X", this.savedSp, this.savedRa));
            }
            cpu.pc = this.savedPc;
            cpu.gpr[29] = this.savedSp;
            cpu.gpr[31] = this.savedRa;
            this.thread.freeExtendedStack();
        }
    }
}

