/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.Emulator;
import jpcsp.MemoryMap;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.DirectBufferMemory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.SafeDirectBufferMemory;
import jpcsp.memory.SafeFastMemory;
import jpcsp.memory.StandardMemory;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public abstract class Memory {
    public static Logger log = Logger.getLogger("memory");
    private static Memory instance = null;
    public static boolean useDirectBufferMemory = false;
    public static boolean useSafeMemory = true;
    public static boolean useDebuggerMemory = false;
    public static final int addressMask = 0x3FFFFFFF;
    private boolean ignoreInvalidMemoryAccess = false;
    protected static final int MEMORY_PAGE_SHIFT = 12;
    protected static boolean[] validMemoryPage = new boolean[0x100000];

    public static Memory getInstance() {
        if (instance == null) {
            if (Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess")) {
                useSafeMemory = false;
            }
            instance = useDirectBufferMemory ? (useSafeMemory ? new SafeDirectBufferMemory() : new DirectBufferMemory()) : (useSafeMemory ? new SafeFastMemory() : new FastMemory());
            if (instance != null && !instance.allocate()) {
                instance = null;
            }
            if (instance == null && !(instance = new StandardMemory()).allocate()) {
                instance = null;
            }
            if (instance == null) {
                throw new OutOfMemoryError("Cannot allocate memory");
            }
            if (useDebuggerMemory || new File(DebuggerMemory.mBrkFilePath).exists()) {
                DebuggerMemory.install();
            }
            log.debug("Using " + instance.getClass().getName());
        }
        return instance;
    }

    protected Memory() {
        Settings.getInstance().registerSettingsListener("Memory", "emu.ignoreInvalidMemoryAccess", new IgnoreInvalidMemoryAccessSettingsListerner());
    }

    public static void setInstance(Memory mem) {
        instance = mem;
    }

    public void invalidMemoryAddress(int address, String prefix, int status) {
        String message = String.format("%s - Invalid memory address : 0x%X PC=%08X", prefix, address, Emulator.getProcessor().cpu.pc);
        if (this.ignoreInvalidMemoryAccess) {
            log.warn("IGNORED: " + message);
        } else {
            log.error(message);
            Emulator.PauseEmuWithStatus(status);
        }
    }

    public boolean read32AllowedInvalidAddress(int address) {
        if (address >= -1887436768 && address <= -1887436372 || address >= 260046880 && address <= 260047276) {
            log.debug("read32 - ignoring pspSdkInstallNoPlainModuleCheckPatch");
            return true;
        }
        return false;
    }

    public abstract void Initialise();

    public abstract int read8(int var1);

    public abstract int read16(int var1);

    public abstract int read32(int var1);

    public abstract void write8(int var1, byte var2);

    public abstract void write16(int var1, short var2);

    public abstract void write32(int var1, int var2);

    public abstract void memset(int var1, byte var2, int var3);

    public abstract Buffer getMainMemoryByteBuffer();

    public abstract Buffer getBuffer(int var1, int var2);

    public abstract void copyToMemory(int var1, ByteBuffer var2, int var3);

    protected abstract void memcpy(int var1, int var2, int var3, boolean var4);

    public int strlen(int address) {
        int len = 0;
        while (this.read8(address) != 0) {
            ++len;
            ++address;
        }
        return len;
    }

    public static final boolean isAddressGood(int address) {
        return validMemoryPage[address >>> 12];
    }

    public static final boolean isRawAddressGood(int rawAddress) {
        return validMemoryPage[rawAddress >> 12];
    }

    public boolean allocate() {
        for (int i = 0; i < validMemoryPage.length; ++i) {
            int address = this.normalizeAddress(i << 12);
            boolean isValid = false;
            if (address >= 0x8000000 && address <= MemoryMap.END_RAM) {
                isValid = true;
            } else if (address >= 0x4000000 && address <= 0x41FFFFF) {
                isValid = true;
            } else if (address >= 65536 && address <= 81919) {
                isValid = true;
            }
            Memory.validMemoryPage[i] = isValid;
        }
        return true;
    }

    public long read64(int address) {
        long low = this.read32(address);
        long high = this.read32(address + 4);
        return low | high << 32;
    }

    public void write64(int address, long data) {
        this.write32(address, (int)data);
        this.write32(address + 4, (int)(data >> 32));
    }

    public ByteBuffer readChunkZ(int address) {
        return this.readChunk(address, this.strlen(address));
    }

    public ByteBuffer readChunk(int address, int size) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        for (int n = 0; n < size; ++n) {
            byteBuffer.put((byte)this.read8(address + n));
        }
        return byteBuffer;
    }

    public void memcpy(int destination, int source, int length) {
        this.memcpy(destination, source, length, false);
    }

    public void memmove(int destination, int source, int length) {
        this.memcpy(destination, source, length, true);
    }

    public int normalizeAddress(int address) {
        if (((address &= 0x3FFFFFFF) & 0xFF000000) == 0x4000000) {
            address &= 0xFF1FFFFF;
        }
        return address;
    }

    protected boolean areOverlapping(int destination, int source, int length) {
        return source + length > destination && destination + length > source;
    }

    public void load(ByteBuffer buffer) {
    }

    public void save(ByteBuffer buffer) {
    }

    public boolean isIgnoreInvalidMemoryAccess() {
        return this.ignoreInvalidMemoryAccess;
    }

    private void setIgnoreInvalidMemoryAccess(boolean ignoreInvalidMemoryAccess) {
        this.ignoreInvalidMemoryAccess = ignoreInvalidMemoryAccess;
        log.info("Ignore invalid memory access: " + ignoreInvalidMemoryAccess);
    }

    private class IgnoreInvalidMemoryAccessSettingsListerner
    extends AbstractBoolSettingsListener {
        private IgnoreInvalidMemoryAccessSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            Memory.this.setIgnoreInvalidMemoryAccess(value);
        }
    }
}

