/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.nio.ByteBuffer;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Debugger.StepLogger;
import jpcsp.Memory;
import jpcsp.ParameterReader;
import org.apache.log4j.Logger;

public class Processor {
    public static boolean ENABLE_STEP_TRACE = false;
    public static boolean ENABLE_INSN_EXECUTE_COUNT = false;
    private static final boolean ENABLE_INSN_CACHE = false;
    public CpuState cpu = new CpuState();
    public static final Memory memory = Memory.getInstance();
    public static Logger log = Logger.getLogger("cpu");
    public ParameterReader parameterReader;
    private final int INSN_CACHE_SIZE = 4096;
    private final int INSN_CACHE_MASK = 4095;
    private CacheLine[] insnCache = new CacheLine[4096];
    private long insnCacheHits;
    private long insnCacheMisses;
    private long insnCount;

    public Processor() {
        for (int i = 0; i < 4096; ++i) {
            this.insnCache[i] = new CacheLine();
        }
        this.reset();
        this.parameterReader = new ParameterReader(this.cpu, memory);
    }

    public void setCpu(CpuState cpu) {
        this.cpu = cpu;
    }

    public void reset() {
        this.invalidateICache();
        this.cpu.reset();
    }

    public void load(ByteBuffer buffer) {
        this.cpu.pc = buffer.getInt();
        this.cpu.npc = buffer.getInt();
        for (int i = 0; i < 32; ++i) {
            this.cpu.gpr[i] = buffer.getInt();
        }
    }

    public void save(ByteBuffer buffer) {
        buffer.putInt(this.cpu.pc);
        buffer.putInt(this.cpu.npc);
        for (int i = 0; i < 32; ++i) {
            buffer.putInt(this.cpu.gpr[i]);
        }
    }

    public void invalidateICache() {
        if (this.insnCount != 0L) {
            log.info("icache hits:" + this.insnCacheHits + " (" + this.insnCacheHits * 100L / this.insnCount + "%)" + " misses:" + this.insnCacheMisses + " (" + this.insnCacheMisses * 100L / this.insnCount + "%)");
        }
        for (CacheLine line : this.insnCache) {
            line.valid = false;
        }
        this.insnCount = 0L;
        this.insnCacheMisses = 0L;
        this.insnCacheHits = 0L;
    }

    private CacheLine fetchDecodedInstruction() {
        CacheLine line = this.insnCache[this.cpu.pc & 0xFFF];
        if (!line.valid || line.address != this.cpu.pc) {
            line.valid = true;
            line.address = this.cpu.pc;
            line.opcode = memory.read32(this.cpu.pc);
            line.insn = Decoder.instruction(line.opcode);
            ++this.insnCacheMisses;
        } else {
            ++this.insnCacheHits;
        }
        ++this.insnCount;
        this.cpu.pc = this.cpu.npc = this.cpu.pc + 4;
        return line;
    }

    private CacheLine nextDecodedInstruction() {
        CacheLine line = this.insnCache[this.cpu.pc & 0xFFF];
        if (!line.valid || line.address != this.cpu.pc) {
            line.valid = true;
            line.address = this.cpu.pc;
            line.opcode = memory.read32(this.cpu.pc);
            line.insn = Decoder.instruction(line.opcode);
            ++this.insnCacheMisses;
        } else {
            ++this.insnCacheHits;
        }
        ++this.insnCount;
        this.cpu.pc += 4;
        return line;
    }

    public void interpret() {
        if (ENABLE_STEP_TRACE) {
            StepLogger.append(this.cpu);
        }
        int opcode = this.cpu.fetchOpcode();
        Common.Instruction insn = Decoder.instruction(opcode);
        insn.interpret(this, opcode);
        if (ENABLE_INSN_EXECUTE_COUNT) {
            insn.increaseCount();
        }
    }

    public void interpretDelayslot() {
        if (ENABLE_STEP_TRACE) {
            StepLogger.append(this.cpu);
        }
        int opcode = this.cpu.nextOpcode();
        Common.Instruction insn = Decoder.instruction(opcode);
        insn.interpret(this, opcode);
        if (ENABLE_INSN_EXECUTE_COUNT) {
            insn.increaseCount();
        }
        this.cpu.nextPc();
    }

    public void step() {
        this.interpret();
    }

    static class CacheLine {
        boolean valid;
        int address;
        int opcode;
        Common.Instruction insn;

        CacheLine() {
        }
    }
}

