/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resource {
    protected static LinkedList<ResourceBundle> bundles = new LinkedList();
    protected static LinkedList<ResourceBundle> bundlesEnglish = new LinkedList();

    public LinkedList<ResourceBundle> getBundles() {
        return bundles;
    }

    private static void add(List<ResourceBundle> bundles, String basename) {
        bundles.add(ResourceBundle.getBundle(basename));
    }

    public static void setLanguage(String language) {
        bundles.clear();
        Resource.add(bundles, "jpcsp.languages." + language);
        Resource.add(bundles, "jpcsp.languages.common");
        bundlesEnglish.clear();
        Resource.add(bundlesEnglish, "jpcsp.languages.en_EN");
        Resource.add(bundlesEnglish, "jpcsp.languages.common");
    }

    public static String get(String key) {
        return Resource.getResource(bundles, key);
    }

    public static String getEnglish(String key) {
        return Resource.getResource(bundlesEnglish, key);
    }

    protected static String getResource(List<ResourceBundle> bundles, String key) {
        for (ResourceBundle bundle : bundles) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException mrex) {
            }
        }
        return null;
    }
}

