/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.connector;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.connector.Connector;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;

public class MpegCodec {
    private int mpegAvcCurrentTimestamp;
    private int mpegAtracCurrentTimestamp;
    private int packetsConsumed;
    protected String id;
    protected int previousVideoBuffer;
    RawFileState videoRawFileState = new RawFileState("VideoStream");
    RawFileState audioRawFileState = new RawFileState("AudioStream");
    FileState mpegFileState = new FileState("Movie.pmf");
    protected int mpegVersion;

    protected String generateID(int streamSize, long lastTimestamp) {
        return String.format("Mpeg-%d", streamSize);
    }

    public static String getMpegBaseDirectory(String id) {
        return String.format("%s%s\\%s\\", Connector.baseDirectory, State.discId, id);
    }

    public void init(int mpegVersion, int streamSize, long lastTimestamp) {
        this.id = this.generateID(streamSize, lastTimestamp);
        this.mpegVersion = mpegVersion;
        new File(MpegCodec.getMpegBaseDirectory(this.id)).mkdirs();
        this.generateCommandFile();
        this.videoRawFileState.init();
        this.audioRawFileState.init();
        this.mpegFileState.init(this.id, mpegVersion);
    }

    public void finish() {
        try {
            this.videoRawFileState.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.audioRawFileState.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mpegFileState.finish();
    }

    protected void generateCommandFile() {
        try {
            PrintWriter command = new PrintWriter(String.format("%s%s", MpegCodec.getMpegBaseDirectory(this.id), "command.txt"));
            command.println("DecodeVideo");
            command.println("ms0:/tmp/" + this.mpegFileState.name);
            command.println("Exit");
            command.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void writeVideo(int address, int length) {
        this.mpegFileState.write(address, length);
    }

    private boolean checkRawFileState(RawFileState rawFileState, int frameCount) {
        return rawFileState.currentInputPosition < rawFileState.currentInputLength || this.readNextRawFile(rawFileState, frameCount);
    }

    public boolean readVideoAu(SceMpegAu au, int frameCount) {
        if (!this.checkRawFileState(this.videoRawFileState, frameCount)) {
            return false;
        }
        try {
            this.decodeVideoAu(this.videoRawFileState, au);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean readVideoFrame(int buffer, int frameWidth, int width, int height, int pixelMode, int frameCount) {
        if (!this.checkRawFileState(this.videoRawFileState, frameCount)) {
            return false;
        }
        try {
            this.decodeVideoFrame(this.videoRawFileState, buffer, frameWidth, width, height, pixelMode);
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    public byte[] readEncodedVideoFrame(int frameCount) {
        if (!this.checkRawFileState(this.videoRawFileState, frameCount)) {
            return null;
        }
        try {
            return this.readEncodedVideoFrame(this.videoRawFileState, frameCount);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] readEncodedVideoFrame(RawFileState rawFileState, int frameCount) throws IOException {
        byte[] encodedVideoFrame = null;
        rawFileState.read(4);
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 4) {
            int fileSize = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            if (rawFileState.currentInputLength - rawFileState.currentInputPosition < fileSize) {
                fileSize = rawFileState.currentInputLength - rawFileState.currentInputPosition;
            }
            rawFileState.read(fileSize);
            encodedVideoFrame = new byte[fileSize];
            System.arraycopy(rawFileState.currentInputBuffer, rawFileState.currentInputPosition, encodedVideoFrame, 0, fileSize);
            rawFileState.currentInputPosition += fileSize;
        }
        return encodedVideoFrame;
    }

    public void decodeVideoFrame(byte[] encodedVideoFrame, int buffer, int frameWidth, int width, int height, int pixelMode, int frameCount) {
        RawBufferState rawBufferState = new RawBufferState(encodedVideoFrame);
        try {
            this.decodeVideoFrame(rawBufferState, buffer, frameWidth, width, height, pixelMode);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean readAudioAu(SceMpegAu au, int frameCount) {
        if (!this.checkRawFileState(this.audioRawFileState, frameCount)) {
            return false;
        }
        try {
            this.decodeAudioAu(this.audioRawFileState, au);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean readAudioFrame(int buffer, int frameCount) {
        if (!this.checkRawFileState(this.audioRawFileState, frameCount)) {
            return false;
        }
        try {
            this.decodeAudioFrame(this.audioRawFileState, buffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    protected boolean readNextRawFile(RawFileState rawFileState, int frameCount) {
        boolean result = false;
        File rawStreamFile = new File(String.format("%s%s-%d.raw", MpegCodec.getMpegBaseDirectory(this.id), rawFileState.name, frameCount));
        if (rawStreamFile.exists()) {
            Modules.log.info("Reading raw stream file " + rawStreamFile);
            try {
                if (rawFileState.currentInputBuffer == null || rawStreamFile.length() > (long)rawFileState.currentInputBuffer.length) {
                    rawFileState.currentInputBuffer = new byte[(int)rawStreamFile.length()];
                }
                rawFileState.open(rawStreamFile);
                rawFileState.currentInputPosition = 0;
                rawFileState.currentInputLength = (int)rawStreamFile.length();
                rawFileState.read(4);
                rawFileState.currentFileVersion = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
                rawFileState.currentInputPosition += 4;
                if (rawFileState.currentFileVersion <= 0 || rawFileState.currentFileVersion > 1) {
                    Modules.log.warn("Unsupported raw file version " + rawFileState.currentFileVersion);
                }
                result = true;
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected void decodeVideoAu(RawFileState rawFileState, SceMpegAu au) throws IOException {
        rawFileState.read(8);
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 8) {
            au.pts = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition + 4);
        }
    }

    protected void decodeVideoFrame(RawFileState rawFileState, int buffer, int frameWidth, int width, int height, int pixelMode) throws IOException {
        int fileSize = 0;
        int fileStartPosition = rawFileState.currentInputPosition;
        rawFileState.read(16);
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 4) {
            fileSize = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            rawFileState.currentInputPosition += 4;
        }
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 4) {
            this.mpegAvcCurrentTimestamp = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            rawFileState.currentInputPosition += 4;
        }
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 8) {
            this.packetsConsumed = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            rawFileState.currentInputPosition += 4;
            int totalBytes = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            rawFileState.currentInputPosition += 4;
            if (Modules.log.isDebugEnabled()) {
                Modules.log.debug("Raw video stream: packetsConsumed=" + this.packetsConsumed + ", totalBytes=" + totalBytes);
            }
        }
        rawFileState.read(fileSize - 16);
        Memory mem = Memory.getInstance();
        int dst = buffer;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(pixelMode);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dst, frameWidth * height * bytesPerPixel, bytesPerPixel);
        for (int y = 0; y < height && rawFileState.currentInputPosition < rawFileState.currentInputLength; ++y) {
            int x = 0;
            while (x < width) {
                int c0 = rawFileState.currentInputBuffer[rawFileState.currentInputPosition + 0] & 0xFF;
                int c1 = rawFileState.currentInputBuffer[rawFileState.currentInputPosition + 1] & 0xFF;
                int c2 = rawFileState.currentInputBuffer[rawFileState.currentInputPosition + 2] & 0xFF;
                int flags = rawFileState.currentInputBuffer[rawFileState.currentInputPosition + 3] & 0xFF;
                int c = Debug.getPixelColor(c0 | c1 << 8 | c2 << 16 | 0xFF000000, pixelMode);
                int count = (flags & 0x7F) + 1;
                if ((flags & 0x80) == 0) {
                    for (int i = 0; i < count; ++i) {
                        memoryWriter.writeNext(c);
                    }
                    x += count;
                    dst += count * bytesPerPixel;
                } else {
                    memoryWriter.skip(count);
                    if (buffer != this.previousVideoBuffer) {
                        int offset = dst - buffer;
                        mem.memcpy(dst, this.previousVideoBuffer + offset, count * bytesPerPixel);
                    }
                    dst += count * bytesPerPixel;
                    x += count;
                    memoryWriter.writeNext(c);
                    dst += bytesPerPixel;
                    ++x;
                }
                rawFileState.currentInputPosition += 4;
            }
            memoryWriter.skip(frameWidth - x);
            dst += (frameWidth - x) * bytesPerPixel;
        }
        memoryWriter.flush();
        this.previousVideoBuffer = buffer;
        if (rawFileState.currentInputPosition - fileStartPosition != fileSize) {
            Modules.log.warn(String.format("Video decoding not using complete file: from %d to %d, size=%d", fileStartPosition, rawFileState.currentInputPosition, fileSize));
            rawFileState.currentInputPosition = fileStartPosition + fileSize;
        }
    }

    protected void decodeAudioAu(RawFileState rawFileState, SceMpegAu au) throws IOException {
        rawFileState.read(8);
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 8) {
            au.pts = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition + 4);
        }
    }

    protected void decodeAudioFrame(RawFileState rawFileState, int buffer) throws IOException {
        int fileSize = 0;
        rawFileState.read(8);
        int fileStartPosition = rawFileState.currentInputPosition;
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 4) {
            fileSize = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            rawFileState.currentInputPosition += 4;
        }
        if (rawFileState.currentInputLength - rawFileState.currentInputPosition >= 4) {
            this.mpegAtracCurrentTimestamp = MpegCodec.getInt32(rawFileState.currentInputBuffer, rawFileState.currentInputPosition);
            rawFileState.currentInputPosition += 4;
        }
        int length = Math.min(8192, rawFileState.currentInputLength - rawFileState.currentInputPosition);
        if (fileSize != 8200) {
            Modules.log.warn("Unknown fileSize " + fileSize);
        }
        rawFileState.read(length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawFileState.currentInputBuffer, rawFileState.currentInputPosition, length);
        rawFileState.currentInputPosition += length;
        Memory.getInstance().copyToMemory(buffer, byteBuffer, length);
        if (rawFileState.currentInputPosition - fileStartPosition != fileSize) {
            Modules.log.warn(String.format("Audio decoding not using complete file: from %d to %d, size=%d", fileStartPosition, rawFileState.currentInputPosition, fileSize));
            rawFileState.currentInputPosition = fileStartPosition + fileSize;
        }
    }

    protected static int getInt32(byte[] buffer, int offset) {
        int n0 = buffer[offset + 0] & 0xFF;
        int n1 = buffer[offset + 1] & 0xFF;
        int n2 = buffer[offset + 2] & 0xFF;
        int n3 = buffer[offset + 3] & 0xFF;
        return n0 << 0 | n1 << 8 | n2 << 16 | n3 << 24;
    }

    public int getMpegAvcCurrentTimestamp() {
        return this.mpegAvcCurrentTimestamp;
    }

    public int getMpegAtracCurrentTimestamp() {
        return this.mpegAtracCurrentTimestamp;
    }

    public int getPacketsConsumed() {
        return this.packetsConsumed;
    }

    public void postFakedVideo(int buffer, int frameWidth, int videoPixelMode) {
        int line = 0;
        this.displayFakedVideoLine("", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("The real video file is being saved under", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("   " + this.mpegFileState.getFileName(), line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("Let the faked video run until the end (100%)", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("and then copy the PMF file to your real PSP under", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("   ms0:/tmp/" + this.mpegFileState.name, line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("Afterwards, run the 'Jpcsp Connector 3xx' on your", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("PSP and move all the generated RAW files from your", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("PSP", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("   ms0:/tmp/*.raw", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("to your computer under Jpcsp:", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("   " + MpegCodec.getMpegBaseDirectory(this.id), line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("You can then delete the raw files on your PSP.", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("After this, the video should be displayed", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("correctly in Jpcsp when you restart the game.", line++, buffer, frameWidth, videoPixelMode);
        this.displayFakedVideoLine("", line++, buffer, frameWidth, videoPixelMode);
    }

    protected void displayFakedVideoLine(String text, int line, int buffer, int frameWidth, int videoPixelMode) {
        int baseOffset = 80;
        int lineWidth = 50;
        String lineText = String.format(" %-50s ", text);
        Debug.printFramebuffer(buffer, frameWidth, 10, 80 + line * Debug.Font.charHeight, -1, -16777216, videoPixelMode, 1, lineText);
    }

    protected static class FileState {
        public String name;
        public String id;
        protected RandomAccessFile output;
        public int mpegVersion;
        protected ByteBuffer byteBuffer;

        public FileState(String name) {
            this.name = name;
        }

        public void init(String id, int mpegVersion) {
            this.id = id;
            this.mpegVersion = mpegVersion;
            this.output = null;
        }

        public String getFileName() {
            return String.format("%s%s", MpegCodec.getMpegBaseDirectory(this.id), this.name);
        }

        public void finish() {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    Modules.log.error(e);
                }
                this.output = null;
            }
        }

        public void write(int address, int length) {
            if (length <= 0 || !Memory.isAddressGood(address)) {
                return;
            }
            try {
                if (this.output == null) {
                    this.output = new RandomAccessFile(this.getFileName(), "rw");
                }
                if (this.byteBuffer == null || this.byteBuffer.capacity() < length) {
                    this.byteBuffer = ByteBuffer.allocateDirect(length);
                }
                this.byteBuffer.clear();
                this.byteBuffer.limit(length);
                Buffer memoryBuffer = Memory.getInstance().getBuffer(address, length);
                Utilities.putBuffer(this.byteBuffer, memoryBuffer, ByteOrder.LITTLE_ENDIAN);
                this.byteBuffer.rewind();
                this.output.getChannel().write(this.byteBuffer);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Modules.log.error(e);
            }
        }
    }

    protected static class RawBufferState
    extends RawFileState {
        public RawBufferState(byte[] buffer) {
            super(null);
            this.currentInputBuffer = buffer;
            this.currentInputLength = buffer.length;
            this.currentInputPosition = 0;
            this.inputStreamPosition = this.currentInputLength;
        }
    }

    protected static class RawFileState {
        public String name;
        public byte[] currentInputBuffer;
        public int currentInputLength;
        public int currentInputPosition;
        public int currentFileVersion;
        private FileInputStream inputStream;
        protected int inputStreamPosition;

        public RawFileState(String name) {
            this.name = name;
        }

        public void init() {
            this.currentInputLength = 0;
            this.currentInputPosition = 0;
        }

        public void read(int length) throws IOException {
            int requiredPosition = this.currentInputPosition + length;
            if (this.inputStreamPosition < requiredPosition) {
                int readLength = requiredPosition - this.inputStreamPosition;
                readLength = this.inputStream.read(this.currentInputBuffer, this.inputStreamPosition, readLength);
                this.inputStreamPosition += readLength;
            }
        }

        public void open(File rawFile) throws IOException {
            this.close();
            this.inputStream = new FileInputStream(rawFile);
            this.inputStreamPosition = 0;
        }

        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
                this.inputStreamPosition = 0;
            }
        }
    }
}

