/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;

public class ECDSA {
    private KeyPair keyPair;
    private ECCurve curve;
    private ECParameterSpec spec;
    private KeyPairGenerator g;
    private KeyFactory f;

    public void setCurve() {
        try {
            this.curve = new ECCurve.Fp(new BigInteger("FFFFFFFFFFFFFFFF00000001FFFFFFFFFFFFFFFF", 16), new BigInteger("FFFFFFFFFFFFFFFF00000001FFFFFFFFFFFFFFFC", 16), new BigInteger("A68BEDC33418029C1D3CE33B9A321FCCBB9E0F0B", 16));
            this.spec = new ECParameterSpec(this.curve, this.curve.decodePoint(Hex.decode("128EC456487FD8FDF64E2437BC0A1F6D5AFDE2C5958557EB1DB001260425524DBC379D5AC5F4ADF")), new BigInteger("00FFFFFFFFFFFFFFFEFFFFB5AE3C523E63944F2127"));
            this.g = KeyPairGenerator.getInstance("ECDSA", "BC");
            this.f = KeyFactory.getInstance("ECDSA", "BC");
            this.g.initialize(this.spec, new SecureRandom());
            this.keyPair = this.g.generateKeyPair();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sign(byte[] hash, byte[] priv, byte[] R, byte[] S) {
    }

    public void verify(byte[] hash, byte[] pub, byte[] R, byte[] S) {
    }

    public byte[] getPrivateKey() {
        return this.keyPair.getPrivate().getEncoded();
    }

    public byte[] getPublicKey() {
        return this.keyPair.getPublic().getEncoded();
    }

    public byte[] multiplyPublicKey(byte[] pub, byte[] priv) {
        Key multPubKey = null;
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(priv), this.spec);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(this.curve.decodePoint(pub), this.spec);
        ECPublicKeySpec newPublicKeySpec = new ECPublicKeySpec(publicKeySpec.getQ().multiply(privateKeySpec.getD()), this.spec);
        try {
            multPubKey = this.f.generatePublic(newPublicKeySpec);
        }
        catch (Exception e) {
            // empty catch block
        }
        return multPubKey.getEncoded();
    }
}

