/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.HashMap;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.iso9660.Iso9660Directory;
import jpcsp.filesystems.umdiso.iso9660.Iso9660File;
import jpcsp.filesystems.umdiso.iso9660.Iso9660Handler;
import jpcsp.util.Utilities;
import org.bolet.jgz.Inflater;

public class UmdIsoReader {
    public static int startSector = 16;
    RandomAccessFile fileReader;
    private HashMap<String, Iso9660File> fileCache = new HashMap();
    private HashMap<String, Iso9660Directory> dirCache = new HashMap();
    FileFormat format;
    int numSectors;
    long[] sectorOffsets;
    int offsetShift;
    String name;

    private int Ubyte(byte b) {
        return b & 0xFF;
    }

    private int BytesToInt(byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
        return this.Ubyte(bytes[offset + 0]) | this.Ubyte(bytes[offset + 1]) << 8 | this.Ubyte(bytes[offset + 2]) << 16 | bytes[offset + 3] << 24;
    }

    public UmdIsoReader(String umdFilename) throws IOException, FileNotFoundException {
        this.name = umdFilename;
        this.fileReader = new RandomAccessFile(umdFilename, "r");
        this.format = FileFormat.Uncompressed;
        this.numSectors = (int)(this.fileReader.length() / 2048L);
        byte[] id = new byte[24];
        this.fileReader.seek(0L);
        this.fileReader.read(id);
        if ((char)id[0] == 'C' && (char)id[1] == 'I' && (char)id[2] == 'S' && (char)id[3] == 'O') {
            this.format = FileFormat.CompressedCSO;
            int lenInbytes = this.BytesToInt(id, 8);
            int sectorSize = this.BytesToInt(id, 16);
            this.offsetShift = this.Ubyte(id[21]);
            this.numSectors = lenInbytes / sectorSize;
            this.sectorOffsets = new long[this.numSectors + 1];
            byte[] offsetData = new byte[(this.numSectors + 1) * 4];
            this.fileReader.readFully(offsetData);
            for (int i = 0; i <= this.numSectors; ++i) {
                this.sectorOffsets[i] = (long)this.BytesToInt(offsetData, i * 4) & 0xFFFFFFFFL;
                if (i <= 0 || (this.sectorOffsets[i] & Integer.MAX_VALUE) >= (this.sectorOffsets[i - 1] & Integer.MAX_VALUE)) continue;
                throw new IOException("Invalid offset [" + i + "]: " + this.sectorOffsets[i] + "<" + this.sectorOffsets[i - 1]);
            }
        }
        id = new byte[6];
        UmdIsoFile f = null;
        try {
            f = new UmdIsoFile(this, startSector, 2048L, null, null);
            f.read(id);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            try {
                this.format = FileFormat.Unknown;
                throw new IOException("Unsupported file format or corrupt file.");
            }
            catch (Throwable throwable) {
                Utilities.close(f);
                throw throwable;
            }
        }
        Utilities.close(f);
        if ((char)id[1] == 'C' && (char)id[2] == 'D' && (char)id[3] == '0' && (char)id[4] == '0' && (char)id[5] == '1') {
            if (this.format == FileFormat.Uncompressed) {
                this.numSectors = (int)(this.fileReader.length() / 2048L);
            }
            return;
        }
        this.format = FileFormat.Unknown;
        throw new IOException("Unsupported file format or corrupt file.");
    }

    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        if (sectorNumber < 0 || sectorNumber + numberSectors > this.numSectors) {
            throw new ArrayIndexOutOfBoundsException("Sectors Start=" + sectorNumber + ",Length=" + numberSectors + " out of bounds.");
        }
        if (this.format == FileFormat.Uncompressed) {
            this.fileReader.seek(2048L * (long)sectorNumber);
            this.fileReader.read(buffer, offset, numberSectors * 2048);
        } else {
            for (int i = 0; i < numberSectors; ++i) {
                this.readSector(sectorNumber + i, buffer, offset + i * 2048);
            }
        }
        return numberSectors;
    }

    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        if (sectorNumber < 0 || sectorNumber >= this.numSectors) {
            throw new ArrayIndexOutOfBoundsException("Sector number " + sectorNumber + " out of bounds.");
        }
        if (this.format == FileFormat.Uncompressed) {
            this.fileReader.seek(2048L * (long)sectorNumber);
            this.fileReader.read(buffer, offset, 2048);
            return;
        }
        if (this.format == FileFormat.CompressedCSO) {
            long sectorOffset = this.sectorOffsets[sectorNumber];
            long sectorEnd = this.sectorOffsets[sectorNumber + 1];
            if ((sectorOffset & Integer.MIN_VALUE) != 0L) {
                long realOffset = (sectorOffset & Integer.MAX_VALUE) << this.offsetShift;
                this.fileReader.seek(realOffset);
                this.fileReader.read(buffer, offset, 2048);
                return;
            }
            int compressedLength = (int)((sectorEnd = (sectorEnd & Integer.MAX_VALUE) << this.offsetShift) - (sectorOffset = (sectorOffset & Integer.MAX_VALUE) << this.offsetShift));
            if (compressedLength < 0) {
                for (int i = 0; i < 2048; ++i) {
                    buffer[offset + i] = 0;
                }
                return;
            }
            byte[] compressedData = new byte[compressedLength];
            this.fileReader.seek(sectorOffset);
            this.fileReader.read(compressedData);
            try {
                Inflater inf = new Inflater();
                ByteArrayInputStream b = new ByteArrayInputStream(compressedData);
                inf.reset(b);
                inf.readAll(buffer, offset, 2048);
            }
            catch (IOException e) {
                throw new IOException("Exception while uncompressing sector from " + this.name);
            }
            return;
        }
        throw new IOException("Unsupported file format or corrupt file.");
    }

    public byte[] readSector(int sectorNumber) throws IOException {
        byte[] buffer = new byte[2048];
        this.readSector(sectorNumber, buffer, 0);
        return buffer;
    }

    private int removePath(String[] path, int index, int length) {
        if (index < 0 || index >= length) {
            return length;
        }
        for (int i = index + 1; i < length; ++i) {
            path[i - 1] = path[i];
        }
        return length - 1;
    }

    private Iso9660File getFileEntry(String filePath) throws IOException, FileNotFoundException {
        int index;
        String parentDirectory;
        Iso9660Directory dir;
        Iso9660File info = this.fileCache.get(filePath);
        if (info != null) {
            return info;
        }
        int parentDirectoryIndex = filePath.lastIndexOf(47);
        if (parentDirectoryIndex >= 0 && (dir = this.dirCache.get(parentDirectory = filePath.substring(0, parentDirectoryIndex))) != null && (info = dir.getEntryByIndex(index = dir.getFileIndex(filePath.substring(parentDirectoryIndex + 1)))) != null) {
            this.fileCache.put(filePath, info);
            return info;
        }
        Iso9660Directory dir2 = new Iso9660Handler(this);
        String[] path = filePath.split("[\\/]");
        int pathLength = path.length;
        int i = 0;
        while (i < pathLength) {
            if (path[i].equals(".")) {
                pathLength = this.removePath(path, i, pathLength);
                continue;
            }
            if (path[i].equals("..")) {
                pathLength = this.removePath(path, i, pathLength);
                pathLength = this.removePath(path, i - 1, pathLength);
                continue;
            }
            ++i;
        }
        for (i = 0; i < pathLength; ++i) {
            int index2 = ((Iso9660Directory)dir2).getFileIndex(path[i]);
            info = ((Iso9660Directory)dir2).getEntryByIndex(index2);
            if ((info.getProperties() & 2) != 2) continue;
            dir2 = new Iso9660Directory(this, info.getLBA(), info.getSize());
            StringBuilder dirPath = new StringBuilder(path[0]);
            for (int j = 1; j <= i; ++j) {
                dirPath.append("/").append(path[j]);
            }
            this.dirCache.put(dirPath.toString(), dir2);
        }
        if (info != null) {
            this.fileCache.put(filePath, info);
        }
        return info;
    }

    public UmdIsoFile getFile(String filePath) throws IOException, FileNotFoundException {
        long fileLength;
        int fileStart;
        Date timestamp = null;
        String fileName = null;
        if (filePath != null && filePath.startsWith("sce_lbn")) {
            filePath = filePath.substring(7);
            int sep = filePath.indexOf("_size");
            fileStart = (int)Utilities.parseHexLong(filePath.substring(0, sep));
            fileLength = Utilities.parseHexLong(filePath.substring(sep + 5));
            timestamp = new Date();
            fileName = "";
            if (fileStart < 0 || fileStart >= this.numSectors) {
                throw new IOException("File '" + filePath + "': Invalid Start Sector");
            }
        } else if (filePath != null && filePath.length() == 0) {
            fileStart = 0;
            fileLength = this.numSectors * 2048;
            timestamp = new Date();
        } else {
            Iso9660File info = this.getFileEntry(filePath);
            if (info != null && (info.getProperties() & 2) == 2) {
                info = null;
            }
            if (info == null) {
                throw new FileNotFoundException("File '" + filePath + "' not found or not a file.");
            }
            fileStart = info.getLBA();
            fileLength = info.getSize();
            timestamp = info.getTimestamp();
            fileName = info.getFileName();
        }
        return new UmdIsoFile(this, fileStart, fileLength, timestamp, fileName);
    }

    public String resolveSectorPath(int start, long length) {
        String fileName = null;
        while (fileName == null || start <= startSector) {
            fileName = this.getFileName(start);
            --start;
        }
        return fileName;
    }

    public String[] listDirectory(String filePath) throws IOException, FileNotFoundException {
        Iso9660Directory dir = null;
        if (filePath.compareTo("") == 0) {
            dir = new Iso9660Handler(this);
        } else {
            Iso9660File info = this.getFileEntry(filePath);
            if (info != null && (info.getProperties() & 2) == 2) {
                dir = new Iso9660Directory(this, info.getLBA(), info.getSize());
            }
        }
        if (dir == null) {
            throw new FileNotFoundException("File '" + filePath + "' not found or not a directory.");
        }
        return ((Iso9660Directory)dir).getFileList();
    }

    public int getFileProperties(String filePath) throws IOException, FileNotFoundException {
        if (filePath.compareTo("") == 0) {
            return 2;
        }
        Iso9660File info = this.getFileEntry(filePath);
        if (info == null) {
            throw new FileNotFoundException("File '" + filePath + "' not found.");
        }
        return info.getProperties();
    }

    public boolean isDirectory(String filePath) throws IOException, FileNotFoundException {
        return (this.getFileProperties(filePath) & 2) == 2;
    }

    public String getFilename() {
        return this.name;
    }

    private String getFileNameRecursive(int fileStartSector, String path, String[] files) throws FileNotFoundException, IOException {
        for (String file : files) {
            String filePath = path + "/" + file;
            Iso9660File info = null;
            if (path.length() == 0) {
                filePath = file;
            } else {
                info = this.getFileEntry(filePath);
                if (info != null && info.getLBA() == fileStartSector) {
                    return info.getFileName();
                }
            }
            if (info != null && (info.getProperties() & 2) != 2 || file.equals(".") || file.equals("\u0001")) continue;
            try {
                String[] childFiles = this.listDirectory(filePath);
                String fileName = this.getFileNameRecursive(fileStartSector, filePath, childFiles);
                if (fileName == null) continue;
                return fileName;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    public String getFileName(int fileStartSector) {
        try {
            String[] files = this.listDirectory("");
            return this.getFileNameRecursive(fileStartSector, "", files);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public long dumpIndexRecursive(PrintWriter out, String path, String[] files) throws IOException {
        long size = 0L;
        for (String file : files) {
            String filePath = path + "/" + file;
            Iso9660File info = null;
            int fileStart = 0;
            long fileLength = 0L;
            if (path.length() == 0) {
                filePath = file;
            }
            if ((info = this.getFileEntry(filePath)) != null) {
                fileStart = info.getLBA();
                fileLength = info.getSize();
                size += fileLength + 2047L & 0xFFFFFFFFFFFFF800L;
            }
            if (!(info != null && (info.getProperties() & 2) != 2 || file.equals(".") || file.equals("\u0001"))) {
                out.println(String.format("D %08X %10d %s", fileStart, fileLength, filePath));
                String[] childFiles = this.listDirectory(filePath);
                size += this.dumpIndexRecursive(out, filePath, childFiles);
                continue;
            }
            out.println(String.format("  %08X %10d %s", fileStart, fileLength, filePath));
        }
        return size;
    }

    public void dumpIndexFile(String filename) throws IOException, FileNotFoundException {
        PrintWriter out = new PrintWriter(new FileOutputStream(filename));
        out.println("  Start    Size       Name");
        String[] files = this.listDirectory("");
        long size = this.dumpIndexRecursive(out, "", files);
        out.println(String.format("Total Size %10d", size));
        out.println(String.format("Image Size %10d", this.numSectors * 2048));
        out.println(String.format("Missing    %10d (%d sectors)", (long)(this.numSectors * 2048) - size, (long)this.numSectors - size / 2048L));
        out.close();
    }

    static enum FileFormat {
        Uncompressed,
        CompressedCSO,
        CompressedDAX,
        Unknown;

    }
}

