/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.format.Elf32Header;
import jpcsp.format.Elf32ProgramHeader;
import jpcsp.format.Elf32SectionHeader;
import jpcsp.util.Utilities;

public class Elf32 {
    private int elfOffset;
    private Elf32Header header;
    private List<Elf32ProgramHeader> programHeaderList;
    private List<Elf32SectionHeader> sectionHeaderList;
    private HashMap<String, Elf32SectionHeader> sectionHeaderMap;
    private Elf32SectionHeader shstrtab;
    private String ElfInfo;
    private String ProgInfo;
    private String SectInfo;

    public Elf32(ByteBuffer f) throws IOException {
        this.elfOffset = f.position();
        this.loadHeader(f);
        if (this.header.isValid()) {
            this.loadProgramHeaders(f);
            this.loadSectionHeaders(f);
        }
    }

    private void loadHeader(ByteBuffer f) throws IOException {
        this.header = new Elf32Header(f);
        this.ElfInfo = this.header.toString();
    }

    private void loadProgramHeaders(ByteBuffer f) throws IOException {
        this.programHeaderList = new LinkedList<Elf32ProgramHeader>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.header.getE_phnum(); ++i) {
            f.position((int)((long)this.elfOffset + this.header.getE_phoff() + (long)(i * this.header.getE_phentsize())));
            Elf32ProgramHeader phdr = new Elf32ProgramHeader(f);
            this.programHeaderList.add(phdr);
            sb.append("-----PROGRAM HEADER #" + i + "-----" + "\n");
            sb.append(phdr.toString());
            if (i != 0 || (phdr.getP_paddr() & 0x80000000L) != 0x80000000L) continue;
            Emulator.log.debug("Kernel mode PRX detected");
        }
        this.ProgInfo = sb.toString();
    }

    private void loadSectionHeaders(ByteBuffer f) throws IOException {
        this.sectionHeaderList = new LinkedList<Elf32SectionHeader>();
        this.sectionHeaderMap = new HashMap();
        for (int i = 0; i < this.header.getE_shnum(); ++i) {
            f.position((int)((long)this.elfOffset + this.header.getE_shoff() + (long)(i * this.header.getE_shentsize())));
            Elf32SectionHeader shdr = new Elf32SectionHeader(f);
            this.sectionHeaderList.add(shdr);
            if (shdr.getSh_type() != 3 || this.shstrtab != null || shdr.getSh_size() <= 1L) continue;
            this.shstrtab = shdr;
        }
        if (this.shstrtab == null) {
            Emulator.log.warn(".shstrtab section not found");
            return;
        }
        StringBuilder sb = new StringBuilder();
        int SectionCounter = 0;
        for (Elf32SectionHeader shdr : this.sectionHeaderList) {
            int position = (int)((long)this.elfOffset + this.shstrtab.getSh_offset() + shdr.getSh_name());
            f.position(position);
            sb.append("-----SECTION HEADER #" + SectionCounter + "-----" + "\n");
            String SectionName = Utilities.readStringZ(f);
            if (SectionName.length() > 0) {
                shdr.setSh_namez(SectionName);
                sb.append(SectionName + "\n");
                this.sectionHeaderMap.put(SectionName, shdr);
            }
            sb.append(shdr.toString());
            ++SectionCounter;
        }
        this.SectInfo = sb.toString();
    }

    public int getElfOffset() {
        return this.elfOffset;
    }

    public Elf32Header getHeader() {
        return this.header;
    }

    public List<Elf32ProgramHeader> getProgramHeaderList() {
        return this.programHeaderList;
    }

    public Elf32ProgramHeader getProgramHeader(int index) {
        return this.programHeaderList.get(index);
    }

    public List<Elf32SectionHeader> getSectionHeaderList() {
        return this.sectionHeaderList;
    }

    public Elf32SectionHeader getSectionHeader(int index) {
        return this.sectionHeaderList.get(index);
    }

    public Elf32SectionHeader getSectionHeader(String name) {
        return this.sectionHeaderMap.get(name);
    }

    public String getElfInfo() {
        return this.ElfInfo;
    }

    public String getProgInfo() {
        return this.ProgInfo;
    }

    public String getSectInfo() {
        return this.SectInfo;
    }
}

