/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jpcsp.graphics.RE.BaseRenderingEngine;
import jpcsp.graphics.RE.DirectBufferUtilities;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.RenderingEngineLwjgl12;
import jpcsp.graphics.RE.RenderingEngineLwjgl15;
import jpcsp.graphics.RE.RenderingEngineLwjgl31;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VertexInfo;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.EXTGeometryShader4;
import org.lwjgl.opengl.EXTMultiDrawArrays;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

public class RenderingEngineLwjgl
extends BaseRenderingEngine {
    protected static final int[] flagToGL = new int[]{3008, 2929, 3089, 2960, 3042, 2884, 3024, 2912, 0, 3553, 2896, 16384, 16385, 16386, 16387, 2848, 0, 0, 3058, 0, 0, 0, 2903, 3168, 3169};
    protected static final int[] shadeModelToGL = new int[]{7424, 7425};
    protected static final int[] colorTypeToGL = new int[]{4608, 5632, 4609, 4610};
    protected static final int[] lightModeToGL = new int[]{33273, 33274};
    protected static final int[] blendSrcToGL = new int[]{774, 775, 770, 771, 772, 773, 770, 771, 772, 773, 32769, 32770, 0, 1};
    protected static final int[] blendDstToGL = new int[]{768, 769, 770, 771, 772, 773, 770, 771, 772, 773, 32769, 32770, 0, 1};
    protected static final int[] logicOpToGL = new int[]{5376, 5377, 5378, 5379, 5380, 5381, 5382, 5383, 5384, 5385, 5386, 5387, 5388, 5389, 5390, 5391};
    protected static final int[] wrapModeToGL = new int[]{10497, 33071};
    protected static final int[] colorMaterialToGL = new int[]{4608, 4608, 4609, 5634, 4610, 4608, 4609, 5634};
    protected static final int[] depthFuncToGL = new int[]{512, 519, 514, 517, 513, 515, 516, 518};
    protected static final int[] texEnvNameToGL = new int[]{34161, 34162, 34163, 3356, 34176, 34177, 34178, 34184, 34185, 34186, 34192, 34193, 34194, 34200, 34201, 34202, 8704};
    protected static final int[] texEnvParamToGL = new int[]{8448, 8449, 3042, 7681, 260, 34165, 34023, 5890, 34166, 34168, 768, 770, 34160};
    protected static final int[] shaderTypeToGL = new int[]{35633, 35632, 36313};
    protected static final int[] primitiveToGL = new int[]{0, 1, 3, 4, 5, 6, 7, 7, 10, 12, 13};
    protected static final int[] clientStateToGL = new int[]{32888, 32886, 32885, 32884};
    protected static final int[] pointerTypeToGL = new int[]{5120, 5121, 5122, 5123, 5124, 5125, 5126, 5130};
    protected static final int[] bufferUsageToGL = new int[]{35040, 35041, 35042, 35044, 35045, 35046, 35048, 35049, 35050};
    protected static final int[] mipmapFilterToGL = new int[]{9728, 9729, 9728, 9728, 9984, 9985, 9986, 9987};
    protected static final int[] textureFormatToGL = new int[]{6407, 6408, 6408, 6408, 36244, 36244, 36244, 36244, 33776, 33778, 33779, 6407, 6408, 6408, 6408};
    protected static final int[] textureInternalFormatToGL = new int[]{6407, 6408, 6408, 6408, 33330, 33330, 33332, 33334, 33776, 33778, 33779, 6407, 6408, 6408, 6408, 6402, 6401};
    protected static final int[] textureTypeToGL = new int[]{33636, 33638, 33637, 5121, 5121, 5121, 5123, 5125, 33776, 33778, 33779, 33636, 33638, 33637, 5121};
    protected static final int[] stencilOpToGL = new int[]{7680, 0, 7681, 5386, 7682, 7683};
    protected static final int[] stencilFuncToGL = new int[]{512, 519, 514, 517, 513, 515, 516, 518};
    protected static final int[] alphaFuncToGL = new int[]{512, 519, 514, 517, 513, 515, 516, 518};
    protected static final int[] blendModeToGL = new int[]{32774, 32778, 32779, 32775, 32776, 32774};
    protected static final int[] programParameterToGL = new int[]{36315, 36316, 36314};
    protected static final int[] bufferTargetToGL = new int[]{34962, 35345};
    protected static final int[] matrixModeToGL = new int[]{5889, 5888, 5888, 5890, 5888};
    protected static final int[] framebufferTargetToGL = new int[]{36160, 36008, 36009};
    protected static final int[] attachmentToGL = new int[]{36096, 36128, 33306, 36064, 36065, 36066, 36067, 36068, 36069, 36070, 36071};
    protected static final int[] pixelTransferToGL = new int[]{3344, 3345, 3346, 3347, 3348, 3352, 3354, 3356, 3359, 3349, 3353, 3355, 3357, 3359};
    protected static final int[] pixelMapToGL = new int[]{3184, 3185, 3186, 3187, 3188, 3189, 3190, 3191, 3192, 3193};

    public static String getVersion() {
        return GL11.glGetString(7938);
    }

    public static IRenderingEngine newInstance() {
        if (GLContext.getCapabilities().OpenGL31) {
            log.info("Using RenderingEngineLwjgl31");
            return new RenderingEngineLwjgl31();
        }
        if (GLContext.getCapabilities().OpenGL15) {
            log.info("Using RenderingEngineLwjgl15");
            return new RenderingEngineLwjgl15();
        }
        if (GLContext.getCapabilities().OpenGL12) {
            log.info("Using RenderingEngineLwjgl12");
            return new RenderingEngineLwjgl12();
        }
        log.info("Using RenderingEngineLwjgl");
        return new RenderingEngineLwjgl();
    }

    public RenderingEngineLwjgl() {
        this.init();
    }

    protected void init() {
        String s;
        String openGLVersion = GL11.glGetString(7938);
        log.info("OpenGL version: " + openGLVersion);
        if (GLContext.getCapabilities().OpenGL20) {
            String shadingLanguageVersion = GL11.glGetString(35724);
            log.info("Shading Language version: " + shadingLanguageVersion);
        }
        if (GLContext.getCapabilities().OpenGL30) {
            int contextFlags = GL11.glGetInteger(33310);
            s = String.format("GL_CONTEXT_FLAGS; 0x%X", contextFlags);
            if ((contextFlags & 1) != 0) {
                s = s + " (GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT)";
            }
            log.info(s);
        }
        if (GLContext.getCapabilities().OpenGL32) {
            int contextProfileMask = GL11.glGetInteger(37158);
            s = String.format("GL_CONTEXT_PROFILE_MASK: 0x%X", contextProfileMask);
            if ((contextProfileMask & 1) != 0) {
                s = s + " (GL_CONTEXT_CORE_PROFILE_BIT)";
            }
            if ((contextProfileMask & 2) != 0) {
                s = s + " (GL_CONTEXT_COMPATIBILITY_PROFILE_BIT)";
            }
            log.info(s);
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void endDirectRendering() {
    }

    @Override
    public void startDirectRendering(boolean textureEnabled, boolean depthWriteEnabled, boolean colorWriteEnabled, boolean setOrthoMatrix, boolean orthoInverted, int width, int height) {
    }

    @Override
    public void startDisplay() {
    }

    @Override
    public void endDisplay() {
    }

    @Override
    public void disableFlag(int flag) {
        int glFlag = flagToGL[flag];
        if (glFlag != 0) {
            GL11.glDisable(glFlag);
        }
    }

    @Override
    public void enableFlag(int flag) {
        int glFlag = flagToGL[flag];
        if (glFlag != 0) {
            GL11.glEnable(glFlag);
        }
    }

    @Override
    public void setMorphWeight(int index, float value) {
    }

    @Override
    public void setPatchDiv(int s, int t) {
    }

    @Override
    public void setPatchPrim(int prim) {
    }

    @Override
    public void setDepthRange(float zpos, float zscale, float near, float far) {
        GL11.glDepthRange(near, far);
    }

    @Override
    public void setDepthFunc(int func) {
        GL11.glDepthFunc(depthFuncToGL[func]);
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        GL11.glViewport(x, y, width, height);
    }

    @Override
    public void setShadeModel(int model) {
        GL11.glShadeModel(shadeModelToGL[model]);
    }

    @Override
    public void setMaterialEmissiveColor(float[] color) {
        GL11.glMaterial(1028, 5632, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setMaterialAmbientColor(float[] color) {
        GL11.glMaterial(1028, 4608, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setMaterialDiffuseColor(float[] color) {
        GL11.glMaterial(1028, 4609, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setMaterialSpecularColor(float[] color) {
        GL11.glMaterial(1028, 4610, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void endModelViewMatrixUpdate() {
    }

    @Override
    public void setLightModelAmbientColor(float[] color) {
        GL11.glLightModel(2899, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightMode(int mode) {
        GL11.glLightModeli(33272, lightModeToGL[mode]);
    }

    @Override
    public void setLightAmbientColor(int light, float[] color) {
        GL11.glLight(16384 + light, 4608, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightDiffuseColor(int light, float[] color) {
        GL11.glLight(16384 + light, 4609, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightSpecularColor(int light, float[] color) {
        GL11.glLight(16384 + light, 4610, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightConstantAttenuation(int light, float constant) {
        GL11.glLightf(16384 + light, 4615, constant);
    }

    @Override
    public void setLightLinearAttenuation(int light, float linear) {
        GL11.glLightf(16384 + light, 4616, linear);
    }

    @Override
    public void setLightQuadraticAttenuation(int light, float quadratic) {
        GL11.glLightf(16384 + light, 4617, quadratic);
    }

    @Override
    public void setLightDirection(int light, float[] direction) {
        GL11.glLight(16384 + light, 4612, DirectBufferUtilities.getDirectBuffer(direction));
    }

    @Override
    public void setLightPosition(int light, float[] position) {
        GL11.glLight(16384 + light, 4611, DirectBufferUtilities.getDirectBuffer(position));
    }

    @Override
    public void setLightSpotCutoff(int light, float cutoff) {
        GL11.glLightf(16384 + light, 4614, cutoff);
    }

    @Override
    public void setLightSpotExponent(int light, float exponent) {
        GL11.glLightf(16384 + light, 4613, exponent);
    }

    @Override
    public void setLightType(int light, int type, int kind) {
    }

    @Override
    public void setBlendColor(float[] color) {
        try {
            GL14.glBlendColor(color[0], color[1], color[2], color[3]);
        }
        catch (IllegalStateException e) {
            log.warn("VideoEngine: " + e.getMessage());
        }
    }

    @Override
    public void setBlendFunc(int src, int dst) {
        try {
            GL11.glBlendFunc(blendSrcToGL[src], blendDstToGL[dst]);
        }
        catch (IllegalStateException e) {
            log.warn("VideoEngine: " + e.getMessage());
        }
    }

    @Override
    public void setLogicOp(int logicOp) {
        GL11.glLogicOp(logicOpToGL[logicOp]);
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        GL11.glColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        GL11.glDepthMask(depthWriteEnabled);
    }

    @Override
    public void setTextureWrapMode(int s, int t) {
        GL11.glTexParameteri(3553, 10242, wrapModeToGL[s]);
        GL11.glTexParameteri(3553, 10243, wrapModeToGL[t]);
    }

    @Override
    public void setTextureMipmapMinLevel(int level) {
        GL11.glTexParameteri(3553, 33084, level);
    }

    @Override
    public void setTextureMipmapMaxLevel(int level) {
        GL11.glTexParameteri(3553, 33085, level);
    }

    @Override
    public void setTextureMipmapMinFilter(int filter) {
        GL11.glTexParameteri(3553, 10241, mipmapFilterToGL[filter]);
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
        GL11.glTexParameteri(3553, 10240, mipmapFilterToGL[filter]);
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
        int index = (ambient ? 1 : 0) | (diffuse ? 2 : 0) | (specular ? 4 : 0);
        GL11.glColorMaterial(1032, colorMaterialToGL[index]);
    }

    @Override
    public void setTextureEnvironmentMapping(int u, int v) {
        GL11.glTexGeni(8192, 9472, 9218);
        GL11.glTexGeni(8193, 9472, 9218);
    }

    @Override
    public void setVertexColor(float[] color) {
        GL11.glColor4f(color[0], color[1], color[2], color[3]);
    }

    @Override
    public void setUniform(int id, int value) {
        GL20.glUniform1i(id, value);
    }

    @Override
    public void setUniform(int id, int value1, int value2) {
        GL20.glUniform2i(id, value1, value2);
    }

    @Override
    public void setUniform(int id, float value) {
        GL20.glUniform1f(id, value);
    }

    @Override
    public void setUniform2(int id, int[] values) {
        GL20.glUniform2i(id, values[0], values[1]);
    }

    @Override
    public void setUniform3(int id, int[] values) {
        GL20.glUniform3i(id, values[0], values[1], values[2]);
    }

    @Override
    public void setUniform3(int id, float[] values) {
        GL20.glUniform3f(id, values[0], values[1], values[2]);
    }

    @Override
    public void setUniform4(int id, int[] values) {
        GL20.glUniform4i(id, values[0], values[1], values[2], values[3]);
    }

    @Override
    public void setUniform4(int id, float[] values) {
        GL20.glUniform4f(id, values[0], values[1], values[2], values[3]);
    }

    @Override
    public void setUniformMatrix4(int id, int count, float[] values) {
        GL20.glUniformMatrix4(id, false, DirectBufferUtilities.getDirectBuffer(values, count * 16));
    }

    @Override
    public void setColorTestFunc(int func) {
    }

    @Override
    public void setColorTestMask(int[] values) {
    }

    @Override
    public void setColorTestReference(int[] values) {
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
    }

    @Override
    public int setBones(int count, float[] values) {
        return 0;
    }

    @Override
    public void setTextureMapMode(int mode, int proj) {
    }

    @Override
    public void setTexEnv(int name, int param) {
        GL11.glTexEnvi(8960, texEnvNameToGL[name], texEnvParamToGL[param]);
    }

    @Override
    public void setTexEnv(int name, float param) {
        GL11.glTexEnvf(8960, texEnvNameToGL[name], param);
    }

    @Override
    public void endClearMode() {
    }

    @Override
    public void startClearMode(boolean color, boolean stencil, boolean depth) {
    }

    @Override
    public void attachShader(int program, int shader) {
        GL20.glAttachShader(program, shader);
    }

    @Override
    public boolean compilerShader(int shader, String source) {
        GL20.glShaderSource(shader, source);
        GL20.glCompileShader(shader);
        return GL20.glGetShader(shader, 35713) == 1;
    }

    @Override
    public int createProgram() {
        return GL20.glCreateProgram();
    }

    @Override
    public void useProgram(int program) {
        GL20.glUseProgram(program);
    }

    @Override
    public int createShader(int type) {
        return GL20.glCreateShader(shaderTypeToGL[type]);
    }

    @Override
    public int getAttribLocation(int program, String name) {
        return GL20.glGetAttribLocation(program, name);
    }

    @Override
    public void bindAttribLocation(int program, int index, String name) {
        GL20.glBindAttribLocation(program, index, name);
    }

    @Override
    public int getUniformLocation(int program, String name) {
        return GL20.glGetUniformLocation(program, name);
    }

    @Override
    public boolean linkProgram(int program) {
        GL20.glLinkProgram(program);
        return GL20.glGetProgram(program, 35714) == 1;
    }

    @Override
    public boolean validateProgram(int program) {
        GL20.glValidateProgram(program);
        return GL20.glGetProgram(program, 35715) == 1;
    }

    @Override
    public String getProgramInfoLog(int program) {
        int infoLogLength = GL20.glGetProgram(program, 35716);
        if (infoLogLength <= 1) {
            return null;
        }
        String infoLog = GL20.glGetProgramInfoLog(program, infoLogLength);
        while (infoLog.length() > 0 && infoLog.charAt(infoLog.length() - 1) == '\u0000') {
            infoLog = infoLog.substring(0, infoLog.length() - 1);
        }
        return infoLog;
    }

    @Override
    public String getShaderInfoLog(int shader) {
        int infoLogLength = GL20.glGetShader(shader, 35716);
        if (infoLogLength <= 1) {
            return null;
        }
        String infoLog = GL20.glGetShaderInfoLog(shader, infoLogLength);
        while (infoLog.length() > 0 && infoLog.charAt(infoLog.length() - 1) == '\u0000') {
            infoLog = infoLog.substring(0, infoLog.length() - 1);
        }
        return infoLog;
    }

    @Override
    public boolean isExtensionAvailable(String name) {
        String extensions = GL11.glGetString(7939);
        if (extensions == null) {
            return false;
        }
        return (" " + extensions + " ").indexOf(" " + name + " ") >= 0;
    }

    @Override
    public void drawArrays(int primitive, int first, int count) {
        GL11.glDrawArrays(primitiveToGL[primitive], first, count);
    }

    @Override
    public void deleteBuffer(int buffer) {
        ARBBufferObject.glDeleteBuffersARB(buffer);
    }

    @Override
    public int genBuffer() {
        return ARBBufferObject.glGenBuffersARB();
    }

    @Override
    public void setBufferData(int target, int size, Buffer buffer, int usage) {
        if (buffer instanceof ByteBuffer) {
            ARBBufferObject.glBufferDataARB(bufferTargetToGL[target], DirectBufferUtilities.getDirectBuffer(size, (ByteBuffer)buffer), bufferUsageToGL[usage]);
        } else if (buffer instanceof IntBuffer) {
            ARBBufferObject.glBufferDataARB(bufferTargetToGL[target], DirectBufferUtilities.getDirectBuffer(size, (IntBuffer)buffer), bufferUsageToGL[usage]);
        } else if (buffer instanceof ShortBuffer) {
            ARBBufferObject.glBufferDataARB(bufferTargetToGL[target], DirectBufferUtilities.getDirectBuffer(size, (ShortBuffer)buffer), bufferUsageToGL[usage]);
        } else if (buffer instanceof FloatBuffer) {
            ARBBufferObject.glBufferDataARB(bufferTargetToGL[target], DirectBufferUtilities.getDirectBuffer(size, (FloatBuffer)buffer), bufferUsageToGL[usage]);
        } else if (buffer == null) {
            ARBBufferObject.glBufferDataARB(bufferTargetToGL[target], size, bufferUsageToGL[usage]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setBufferSubData(int target, int offset, int size, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            ARBBufferObject.glBufferSubDataARB(bufferTargetToGL[target], (long)offset, DirectBufferUtilities.getDirectBuffer(size, (ByteBuffer)buffer));
        } else if (buffer instanceof IntBuffer) {
            ARBBufferObject.glBufferSubDataARB(bufferTargetToGL[target], (long)offset, DirectBufferUtilities.getDirectBuffer(size, (IntBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            ARBBufferObject.glBufferSubDataARB(bufferTargetToGL[target], (long)offset, DirectBufferUtilities.getDirectBuffer(size, (ShortBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            ARBBufferObject.glBufferSubDataARB(bufferTargetToGL[target], (long)offset, DirectBufferUtilities.getDirectBuffer(size, (FloatBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void enableClientState(int type) {
        GL11.glEnableClientState(clientStateToGL[type]);
    }

    @Override
    public void enableVertexAttribArray(int id) {
        GL20.glEnableVertexAttribArray(id);
    }

    @Override
    public void disableClientState(int type) {
        GL11.glDisableClientState(clientStateToGL[type]);
    }

    @Override
    public void disableVertexAttribArray(int id) {
        GL20.glDisableVertexAttribArray(id);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, long offset) {
        GL11.glColorPointer(size, pointerTypeToGL[type], stride, offset);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        switch (type) {
            case 6: {
                GL11.glColorPointer(size, stride, DirectBufferUtilities.getDirectFloatBuffer(bufferSize, buffer));
                break;
            }
            case 0: {
                GL11.glColorPointer(size, false, stride, DirectBufferUtilities.getDirectByteBuffer(bufferSize, buffer));
                break;
            }
            case 1: {
                GL11.glColorPointer(size, true, stride, DirectBufferUtilities.getDirectByteBuffer(bufferSize, buffer));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setNormalPointer(int type, int stride, long offset) {
        GL11.glNormalPointer(pointerTypeToGL[type], stride, offset);
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        switch (type) {
            case 6: {
                GL11.glNormalPointer(stride, DirectBufferUtilities.getDirectFloatBuffer(bufferSize, buffer));
                break;
            }
            case 0: {
                GL11.glNormalPointer(stride, DirectBufferUtilities.getDirectByteBuffer(bufferSize, buffer));
                break;
            }
            case 4: {
                GL11.glNormalPointer(stride, DirectBufferUtilities.getDirectIntBuffer(bufferSize, buffer));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, long offset) {
        GL11.glTexCoordPointer(size, pointerTypeToGL[type], stride, offset);
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        switch (type) {
            case 6: {
                GL11.glTexCoordPointer(size, stride, DirectBufferUtilities.getDirectFloatBuffer(bufferSize, buffer));
                break;
            }
            case 2: {
                GL11.glTexCoordPointer(size, stride, DirectBufferUtilities.getDirectShortBuffer(bufferSize, buffer));
                break;
            }
            case 4: {
                GL11.glTexCoordPointer(size, stride, DirectBufferUtilities.getDirectIntBuffer(bufferSize, buffer));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, long offset) {
        GL11.glVertexPointer(size, pointerTypeToGL[type], stride, offset);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        switch (type) {
            case 6: {
                GL11.glVertexPointer(size, stride, DirectBufferUtilities.getDirectFloatBuffer(bufferSize, buffer));
                break;
            }
            case 2: {
                GL11.glVertexPointer(size, stride, DirectBufferUtilities.getDirectShortBuffer(bufferSize, buffer));
                break;
            }
            case 4: {
                GL11.glVertexPointer(size, stride, DirectBufferUtilities.getDirectIntBuffer(bufferSize, buffer));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, long offset) {
        GL20.glVertexAttribPointer(id, size, pointerTypeToGL[type], normalized, stride, offset);
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, int bufferSize, Buffer buffer) {
        switch (type) {
            case 6: {
                GL20.glVertexAttribPointer(id, size, false, stride, DirectBufferUtilities.getDirectFloatBuffer(bufferSize, buffer));
                break;
            }
            case 2: {
                GL20.glVertexAttribPointer(id, size, false, false, stride, DirectBufferUtilities.getDirectShortBuffer(bufferSize, buffer));
                break;
            }
            case 3: {
                GL20.glVertexAttribPointer(id, size, true, false, stride, DirectBufferUtilities.getDirectShortBuffer(bufferSize, buffer));
                break;
            }
            case 4: {
                GL20.glVertexAttribPointer(id, size, false, false, stride, DirectBufferUtilities.getDirectIntBuffer(bufferSize, buffer));
                break;
            }
            case 5: {
                GL20.glVertexAttribPointer(id, size, true, false, stride, DirectBufferUtilities.getDirectIntBuffer(bufferSize, buffer));
                break;
            }
            case 0: {
                GL20.glVertexAttribPointer(id, size, false, false, stride, DirectBufferUtilities.getDirectByteBuffer(bufferSize, buffer));
                break;
            }
            case 1: {
                GL20.glVertexAttribPointer(id, size, true, false, stride, DirectBufferUtilities.getDirectByteBuffer(bufferSize, buffer));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        GL11.glPixelStorei(3314, rowLength);
        GL11.glPixelStorei(3317, alignment);
        GL11.glPixelStorei(3330, rowLength);
        GL11.glPixelStorei(3333, alignment);
    }

    @Override
    public int genTexture() {
        return GL11.glGenTextures();
    }

    @Override
    public void bindTexture(int texture) {
        GL11.glBindTexture(3553, texture);
    }

    @Override
    public void deleteTexture(int texture) {
        GL11.glDeleteTextures(texture);
    }

    @Override
    public void setCompressedTexImage(int level, int internalFormat, int width, int height, int compressedSize, Buffer buffer) {
        GL13.glCompressedTexImage2D(3553, level, textureInternalFormatToGL[internalFormat], width, height, 0, DirectBufferUtilities.getDirectByteBuffer(compressedSize, buffer));
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        if (buffer instanceof ByteBuffer || buffer == null) {
            GL11.glTexImage2D(3553, level, textureInternalFormatToGL[internalFormat], width, height, 0, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer));
        } else if (buffer instanceof IntBuffer) {
            GL11.glTexImage2D(3553, level, textureInternalFormatToGL[internalFormat], width, height, 0, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (IntBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glTexImage2D(3553, level, textureInternalFormatToGL[internalFormat], width, height, 0, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (ShortBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glTexImage2D(3553, level, textureInternalFormatToGL[internalFormat], width, height, 0, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (FloatBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setTexSubImage(int level, int xOffset, int yOffset, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        if (buffer instanceof ByteBuffer || buffer == null) {
            GL11.glTexSubImage2D(3553, level, xOffset, yOffset, width, height, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer));
        } else if (buffer instanceof IntBuffer) {
            GL11.glTexSubImage2D(3553, level, xOffset, yOffset, width, height, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (IntBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glTexSubImage2D(3553, level, xOffset, yOffset, width, height, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (ShortBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glTexSubImage2D(3553, level, xOffset, yOffset, width, height, textureFormatToGL[format], textureTypeToGL[type], DirectBufferUtilities.getDirectBuffer(textureSize, (FloatBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp(stencilOpToGL[fail], stencilOpToGL[zfail], stencilOpToGL[zpass]);
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc(stencilFuncToGL[func], ref, mask);
    }

    @Override
    public void setAlphaFunc(int func, int ref) {
        GL11.glAlphaFunc(alphaFuncToGL[func], (float)ref / 255.0f);
    }

    @Override
    public void setFogColor(float[] color) {
        GL11.glFog(2918, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setFogDist(float start, float end) {
        GL11.glFogf(2915, start);
        GL11.glFogf(2916, end);
    }

    @Override
    public void setTextureEnvColor(float[] color) {
        GL11.glTexEnv(8960, 8705, DirectBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setFrontFace(boolean cw) {
        GL11.glFrontFace(cw ? 2304 : 2305);
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        GL11.glScissor(x, y, width, height);
    }

    @Override
    public void setBlendEquation(int mode) {
        try {
            GL14.glBlendEquation(blendModeToGL[mode]);
        }
        catch (IllegalStateException e) {
            log.warn("VideoEngine: " + e.getMessage());
        }
    }

    @Override
    public void setFogHint() {
        GL11.glFogi(2917, 9729);
        GL11.glHint(3156, 4352);
    }

    @Override
    public void setLineSmoothHint() {
        GL11.glHint(3154, 4354);
    }

    @Override
    public void setMaterialShininess(float shininess) {
        GL11.glMaterialf(1028, 5633, shininess);
    }

    @Override
    public void beginDraw(int primitive) {
        GL11.glBegin(primitiveToGL[primitive]);
    }

    @Override
    public void beginQuery(int id) {
        GL15.glBeginQuery(35092, id);
    }

    @Override
    public void drawVertex3(float[] values) {
        GL11.glVertex3f(values[0], values[1], values[2]);
    }

    @Override
    public void endDraw() {
        GL11.glEnd();
    }

    @Override
    public void endQuery() {
        GL15.glEndQuery(35092);
    }

    @Override
    public void drawColor(float value1, float value2, float value3) {
        GL11.glColor3f(value1, value2, value3);
    }

    @Override
    public void drawColor(float value1, float value2, float value3, float value4) {
        GL11.glColor4f(value1, value2, value3, value4);
    }

    @Override
    public void drawTexCoord(float value1, float value2) {
        GL11.glTexCoord2f(value1, value2);
    }

    @Override
    public void drawVertex(int value1, int value2) {
        GL11.glVertex2i(value1, value2);
    }

    @Override
    public void drawVertex(float value1, float value2) {
        GL11.glVertex2f(value1, value2);
    }

    @Override
    public int genQuery() {
        return GL15.glGenQueries();
    }

    @Override
    public void drawBoundingBox(float[][] values) {
    }

    @Override
    public void endBoundingBox(VertexInfo vinfo) {
    }

    @Override
    public void beginBoundingBox(int numberOfVertexBoundingBox) {
    }

    @Override
    public boolean hasBoundingBox() {
        return true;
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return true;
    }

    @Override
    public boolean getQueryResultAvailable(int id) {
        return GL15.glGetQueryObjecti(id, 34919) != 0;
    }

    @Override
    public int getQueryResult(int id) {
        return GL15.glGetQueryObjecti(id, 34918);
    }

    @Override
    public void copyTexSubImage(int level, int xOffset, int yOffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D(3553, level, xOffset, yOffset, x, y, width, height);
    }

    @Override
    public void getTexImage(int level, int format, int type, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            ByteBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((ByteBuffer)buffer);
            GL11.glGetTexImage(3553, level, textureFormatToGL[format], textureTypeToGL[type], (ByteBuffer)buffer);
            DirectBufferUtilities.copyBuffer((ByteBuffer)buffer, directBuffer);
        } else if (buffer instanceof IntBuffer) {
            IntBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((IntBuffer)buffer);
            GL11.glGetTexImage(3553, level, textureFormatToGL[format], textureTypeToGL[type], directBuffer);
            DirectBufferUtilities.copyBuffer((IntBuffer)buffer, directBuffer);
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((ShortBuffer)buffer);
            GL11.glGetTexImage(3553, level, textureFormatToGL[format], textureTypeToGL[type], (ShortBuffer)buffer);
            DirectBufferUtilities.copyBuffer((ShortBuffer)buffer, directBuffer);
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((FloatBuffer)buffer);
            GL11.glGetTexImage(3553, level, textureFormatToGL[format], textureTypeToGL[type], (FloatBuffer)buffer);
            DirectBufferUtilities.copyBuffer((FloatBuffer)buffer, directBuffer);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void readPixels(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            ByteBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((ByteBuffer)buffer);
            GL11.glReadPixels(x, y, width, height, textureFormatToGL[format], textureTypeToGL[type], (ByteBuffer)buffer);
            DirectBufferUtilities.copyBuffer((ByteBuffer)buffer, directBuffer);
        } else if (buffer instanceof IntBuffer) {
            IntBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((IntBuffer)buffer);
            GL11.glReadPixels(x, y, width, height, textureFormatToGL[format], textureTypeToGL[type], (IntBuffer)buffer);
            DirectBufferUtilities.copyBuffer((IntBuffer)buffer, directBuffer);
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((ShortBuffer)buffer);
            GL11.glReadPixels(x, y, width, height, textureFormatToGL[format], textureTypeToGL[type], (ShortBuffer)buffer);
            DirectBufferUtilities.copyBuffer((ShortBuffer)buffer, directBuffer);
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer((FloatBuffer)buffer);
            GL11.glReadPixels(x, y, width, height, textureFormatToGL[format], textureTypeToGL[type], (FloatBuffer)buffer);
            DirectBufferUtilities.copyBuffer((FloatBuffer)buffer, directBuffer);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void clear(float red, float green, float blue, float alpha) {
        GL11.glClearColor(red, green, blue, alpha);
        GL11.glClear(16384);
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, long offset) {
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
    }

    @Override
    public IREBufferManager getBufferManager() {
        return null;
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        return false;
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        return false;
    }

    @Override
    public void setVertexInfo(VertexInfo vinfo, boolean allNativeVertexInfo, boolean useVertexColor, boolean useTexture, int type) {
    }

    @Override
    public void setProgramParameter(int program, int parameter, int value) {
        if (parameter == 0 || parameter == 1) {
            value = primitiveToGL[value];
        }
        EXTGeometryShader4.glProgramParameteriEXT(program, programParameterToGL[parameter], value);
    }

    @Override
    public boolean isQueryAvailable() {
        return GLContext.getCapabilities().OpenGL15;
    }

    @Override
    public boolean isShaderAvailable() {
        return GLContext.getCapabilities().OpenGL20;
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        ARBBufferObject.glBindBufferARB(bufferTargetToGL[target], buffer);
    }

    @Override
    public void bindBufferBase(int target, int bindingPoint, int buffer) {
        ARBUniformBufferObject.glBindBufferBase(bufferTargetToGL[target], bindingPoint, buffer);
    }

    @Override
    public int getUniformBlockIndex(int program, String name) {
        return ARBUniformBufferObject.glGetUniformBlockIndex(program, name);
    }

    @Override
    public void setUniformBlockBinding(int program, int blockIndex, int bindingPoint) {
        ARBUniformBufferObject.glUniformBlockBinding(program, blockIndex, bindingPoint);
    }

    @Override
    public int getUniformIndex(int program, String name) {
        IntBuffer indicesBuffer = DirectBufferUtilities.allocateDirectBuffer(4).asIntBuffer();
        ARBUniformBufferObject.glGetUniformIndices(program, new String[]{name}, indicesBuffer);
        return indicesBuffer.get(0);
    }

    @Override
    public int[] getUniformIndices(int program, String[] names) {
        IntBuffer indicesBuffer = DirectBufferUtilities.allocateDirectBuffer(names.length << 2).asIntBuffer();
        ARBUniformBufferObject.glGetUniformIndices(program, names, indicesBuffer);
        int[] indices = new int[names.length];
        indicesBuffer.get(indices);
        return indices;
    }

    @Override
    public int getActiveUniformOffset(int program, int uniformIndex) {
        return ARBUniformBufferObject.glGetActiveUniforms(program, uniformIndex, 35387);
    }

    @Override
    public void setMatrix(float[] values) {
        if (values != null) {
            GL11.glLoadMatrix(DirectBufferUtilities.getDirectBuffer(values));
        } else {
            GL11.glLoadIdentity();
        }
    }

    @Override
    public void setMatrixMode(int type) {
        GL11.glMatrixMode(matrixModeToGL[type]);
    }

    @Override
    public void multMatrix(float[] values) {
        if (values != null) {
            GL11.glMultMatrix(DirectBufferUtilities.getDirectBuffer(values));
        }
    }

    @Override
    public int genFramebuffer() {
        return ARBFramebufferObject.glGenFramebuffers();
    }

    @Override
    public void bindFramebuffer(int target, int framebuffer) {
        ARBFramebufferObject.glBindFramebuffer(framebufferTargetToGL[target], framebuffer);
    }

    @Override
    public void bindRenderbuffer(int renderbuffer) {
        ARBFramebufferObject.glBindRenderbuffer(36161, renderbuffer);
    }

    @Override
    public void deleteFramebuffer(int framebuffer) {
        ARBFramebufferObject.glDeleteFramebuffers(framebuffer);
    }

    @Override
    public void deleteRenderbuffer(int renderbuffer) {
        ARBFramebufferObject.glDeleteRenderbuffers(renderbuffer);
    }

    @Override
    public int genRenderbuffer() {
        return ARBFramebufferObject.glGenRenderbuffers();
    }

    @Override
    public void setFramebufferRenderbuffer(int target, int attachment, int renderbuffer) {
        ARBFramebufferObject.glFramebufferRenderbuffer(framebufferTargetToGL[target], attachmentToGL[attachment], 36161, renderbuffer);
    }

    @Override
    public void setRenderbufferStorage(int internalFormat, int width, int height) {
        ARBFramebufferObject.glRenderbufferStorage(36161, textureInternalFormatToGL[internalFormat], width, height);
    }

    @Override
    public void setFramebufferTexture(int target, int attachment, int texture, int level) {
        ARBFramebufferObject.glFramebufferTexture2D(framebufferTargetToGL[target], attachmentToGL[attachment], 3553, texture, level);
    }

    @Override
    public boolean isFramebufferObjectAvailable() {
        return GLContext.getCapabilities().GL_ARB_framebuffer_object;
    }

    @Override
    public void bindVertexArray(int id) {
        ARBVertexArrayObject.glBindVertexArray(id);
    }

    @Override
    public void deleteVertexArray(int id) {
        ARBVertexArrayObject.glDeleteVertexArrays(id);
    }

    @Override
    public int genVertexArray() {
        return ARBVertexArrayObject.glGenVertexArrays();
    }

    @Override
    public boolean isVertexArrayAvailable() {
        return GLContext.getCapabilities().GL_ARB_vertex_array_object;
    }

    @Override
    public void multiDrawArrays(int primitive, IntBuffer first, IntBuffer count) {
        EXTMultiDrawArrays.glMultiDrawArraysEXT(primitive, first, count);
    }

    @Override
    public void drawArraysBurstMode(int primitive, int first, int count) {
        this.drawArrays(primitive, first, count);
    }

    @Override
    public void setPixelTransfer(int parameter, int value) {
        GL11.glPixelTransferi(pixelTransferToGL[parameter], value);
    }

    @Override
    public void setPixelTransfer(int parameter, float value) {
        GL11.glPixelTransferf(pixelTransferToGL[parameter], value);
    }

    @Override
    public void setPixelTransfer(int parameter, boolean value) {
        GL11.glPixelTransferi(pixelTransferToGL[parameter], value ? 1 : 0);
    }

    @Override
    public void setPixelMap(int map, int mapSize, Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            GL11.glPixelMapu(pixelMapToGL[map], DirectBufferUtilities.getDirectBuffer(mapSize, (IntBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glPixelMap(pixelMapToGL[map], DirectBufferUtilities.getDirectBuffer(mapSize, (FloatBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glPixelMapu(pixelMapToGL[map], DirectBufferUtilities.getDirectBuffer(mapSize, (ShortBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean canNativeClut() {
        return GLContext.getCapabilities().OpenGL30;
    }

    @Override
    public void setActiveTexture(int index) {
        GL13.glActiveTexture(33984 + index);
    }

    @Override
    public void setTextureFormat(int pixelFormat, boolean swizzle) {
    }

    @Override
    public void bindActiveTexture(int index, int texture) {
    }

    @Override
    public float getMaxTextureAnisotropy() {
        return GL11.glGetFloat(34047);
    }

    @Override
    public void setTextureAnisotropy(float value) {
        GL11.glTexParameterf(3553, 34046, value);
    }

    @Override
    public String getShadingLanguageVersion() {
        if (GLContext.getCapabilities().OpenGL20) {
            return GL11.glGetString(35724);
        }
        return null;
    }

    @Override
    public void setBlendDFix(float[] color) {
    }

    @Override
    public void setBlendSFix(float[] color) {
    }
}

