/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexArray;
import jpcsp.graphics.VertexBuffer;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.CpuDurationStatistics;

public class VertexArrayManager {
    private static VertexArrayManager instance;
    private static final int maxSize = 1000;
    private List<VertexArray> vertexArrays = new LinkedList<VertexArray>();
    private CpuDurationStatistics statistics = new CpuDurationStatistics("VertexArrayManager");
    private HashMap<Integer, VertexArray> fastLookup = new HashMap();

    public static VertexArrayManager getInstance() {
        if (instance == null) {
            instance = new VertexArrayManager();
        }
        return instance;
    }

    public static void exit() {
        if (instance != null) {
            // empty if block
        }
    }

    private static int getFastLookupKey(int vtype, VertexBuffer vertexBuffer, int address, int stride) {
        return vertexBuffer.getId() + (vtype << 8);
    }

    public VertexArray getVertexArray(IRenderingEngine re, int vtype, VertexBuffer vertexBuffer, int address, int stride) {
        VertexArray toBeDeleted;
        this.statistics.start();
        int fastLookupKey = VertexArrayManager.getFastLookupKey(vtype, vertexBuffer, address, stride);
        VertexArray vertexArray = this.fastLookup.get(fastLookupKey);
        if (vertexArray != null && vertexArray.isMatching(vtype, vertexBuffer, address, stride)) {
            this.statistics.end();
            return vertexArray;
        }
        boolean first = true;
        ListIterator<VertexArray> lit = this.vertexArrays.listIterator();
        while (lit.hasNext()) {
            vertexArray = lit.next();
            if (vertexArray.isMatching(vtype, vertexBuffer, address, stride)) {
                if (!first) {
                    lit.remove();
                    this.vertexArrays.add(0, vertexArray);
                }
                this.fastLookup.put(fastLookupKey, vertexArray);
                this.statistics.end();
                return vertexArray;
            }
            first = false;
        }
        vertexArray = new VertexArray(vtype, vertexBuffer, stride);
        this.vertexArrays.add(0, vertexArray);
        if (this.vertexArrays.size() > 1000 && (toBeDeleted = this.vertexArrays.remove(this.vertexArrays.size() - 1)) != null) {
            toBeDeleted.delete(re);
        }
        this.statistics.end();
        return vertexArray;
    }

    public void onVertexBufferDeleted(IRenderingEngine re, VertexBuffer vertexBuffer) {
        ListIterator<VertexArray> lit = this.vertexArrays.listIterator();
        while (lit.hasNext()) {
            VertexArray vertexArray = lit.next();
            if (vertexArray.getVertexBuffer() != vertexBuffer) continue;
            lit.remove();
            vertexArray.delete(re);
        }
    }

    public void forceReloadAllVertexArrays() {
        for (VertexArray vertexArray : this.vertexArrays) {
            vertexArray.forceReload();
        }
    }

    protected void displayStatistics() {
        for (VertexArray vertexArray : this.vertexArrays) {
            VideoEngine.log.info(vertexArray);
        }
        VideoEngine.log.info(String.format("VertexArrayManager: %d VAOs", this.vertexArrays.size()));
    }
}

