/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.FastMemory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class VertexBuffer {
    private static Logger log = VideoEngine.log;
    private int bufferId = -1;
    private int bufferAddress;
    private int bufferLength;
    private int stride;
    private int[] cachedMemory;
    private ByteBuffer cachedBuffer;
    private int cachedBufferOffset;
    private HashMap<Integer, Integer> addressAlreadyChecked = new HashMap();
    private AddressRange[] dirtyRanges = new AddressRange[0];
    private int numberDirtyRanges = 0;
    private boolean reloadBufferDataPending = false;
    private static final int bufferUsage = 6;
    private static final int bufferTarget = 0;

    public VertexBuffer(int address, int stride) {
        this.bufferAddress = Memory.getInstance().normalizeAddress(address);
        this.bufferLength = 0;
        this.stride = stride;
    }

    public void bind(IRenderingEngine re) {
        if (this.bufferId == -1) {
            this.bufferId = re.genBuffer();
        }
        re.bindBuffer(0, this.bufferId);
    }

    private int getBufferAlignment(Buffer buffer, int address) {
        if ((address & 3) == 0) {
            return 0;
        }
        if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
            return address & 3;
        }
        if (buffer instanceof ShortBuffer) {
            return address & 1;
        }
        return 0;
    }

    private boolean extend(Buffer buffer, int address, int length) {
        boolean overflowBottom = address < this.bufferAddress;
        boolean overflowTop = address + length > this.bufferAddress + this.bufferLength;
        boolean extended = false;
        if (overflowBottom || overflowTop) {
            if (this.bufferLength == 0 || overflowBottom && overflowTop) {
                this.cachedBufferOffset = this.getBufferAlignment(buffer, address);
                this.cachedBuffer = ByteBuffer.allocateDirect(length + this.cachedBufferOffset).order(ByteOrder.LITTLE_ENDIAN);
                this.bufferAddress = address;
                this.bufferLength = length;
                this.cachedMemory = new int[this.bufferLength >> 2];
                this.reloadBufferDataPending = true;
                extended = true;
            } else if (overflowBottom) {
                this.cachedBufferOffset = this.getBufferAlignment(buffer, address);
                int extendLength = this.bufferAddress - address + this.cachedBufferOffset;
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(extendLength + this.cachedBuffer.capacity()).order(ByteOrder.LITTLE_ENDIAN);
                newBuffer.position(extendLength);
                this.cachedBuffer.clear();
                newBuffer.put(this.cachedBuffer);
                newBuffer.rewind();
                this.cachedBuffer = newBuffer;
                this.bufferLength += extendLength;
                int[] newCachedMemory = new int[this.bufferLength >> 2];
                System.arraycopy(this.cachedMemory, 0, newCachedMemory, extendLength >> 2, this.cachedMemory.length);
                this.cachedMemory = newCachedMemory;
                this.bufferAddress = address;
                this.reloadBufferDataPending = true;
                extended = true;
            } else if (overflowTop) {
                int extendLength = address + length - (this.bufferAddress + this.bufferLength);
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(extendLength + this.cachedBuffer.capacity()).order(ByteOrder.LITTLE_ENDIAN);
                this.cachedBuffer.clear();
                newBuffer.put(this.cachedBuffer);
                newBuffer.rewind();
                this.cachedBuffer = newBuffer;
                this.bufferLength += extendLength;
                int[] newCachedMemory = new int[this.bufferLength >> 2];
                System.arraycopy(this.cachedMemory, 0, newCachedMemory, 0, this.cachedMemory.length);
                this.cachedMemory = newCachedMemory;
                this.reloadBufferDataPending = true;
                extended = true;
            }
        }
        return extended;
    }

    private void position(int address) {
        this.cachedBuffer.clear();
        this.cachedBuffer.position(this.getBufferOffset(address) + this.cachedBufferOffset);
    }

    private void position(int address, int bufferAlignment) {
        this.position(address - bufferAlignment);
    }

    private void copyToCachedMemory(int address, int length) {
        Memory mem = Memory.getInstance();
        int offset = this.getBufferOffset(address) >> 2;
        int n = length >> 2;
        if (mem instanceof FastMemory) {
            int[] allMem = ((FastMemory)mem).getAll();
            System.arraycopy(allMem, address >> 2, this.cachedMemory, offset, n);
        } else {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 4);
            for (int i = 0; i < n; ++i) {
                this.cachedMemory[offset + i] = memoryReader.readNext();
            }
        }
    }

    private void checkDirty(IRenderingEngine re) {
        if (this.reloadBufferDataPending) {
            this.bind(re);
            this.position(this.bufferAddress);
            re.setBufferData(0, this.cachedBuffer.remaining(), this.cachedBuffer, 6);
            this.reloadBufferDataPending = false;
            this.numberDirtyRanges = 0;
        } else if (this.numberDirtyRanges > 0) {
            this.bind(re);
            for (int i = 0; i < this.numberDirtyRanges; ++i) {
                this.position(this.dirtyRanges[i].address);
                re.setBufferSubData(0, this.cachedBuffer.position(), this.dirtyRanges[i].length, this.cachedBuffer);
            }
            this.numberDirtyRanges = 0;
        }
    }

    private boolean cachedMemoryEquals(int address, int length) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 4);
        int n = length >> 2;
        int offset = this.getBufferOffset(address) >> 2;
        for (int i = 0; i < n; ++i) {
            if (this.cachedMemory[offset + i] == memoryReader.readNext()) continue;
            if (log.isTraceEnabled()) {
                log.trace(String.format("VertexBuffer.cachedMemoryEquals(0x%08X, %d): are not equal", address, length));
            }
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("VertexBuffer.cachedMemoryEquals(0x%08X, %d): are equal", address, length));
        }
        return true;
    }

    private void addDirtyRange(int address, int length) {
        for (int i = 0; i < this.numberDirtyRanges; ++i) {
            if (this.dirtyRanges[i].address != address) continue;
            if (length > this.dirtyRanges[i].length) {
                this.dirtyRanges[i].length = length;
            }
            return;
        }
        if (this.numberDirtyRanges >= this.dirtyRanges.length) {
            AddressRange[] newDirtyRanges = new AddressRange[this.dirtyRanges.length + 10];
            System.arraycopy(this.dirtyRanges, 0, newDirtyRanges, 0, this.dirtyRanges.length);
            for (int i = this.dirtyRanges.length; i < newDirtyRanges.length; ++i) {
                newDirtyRanges[i] = new AddressRange();
            }
            this.dirtyRanges = newDirtyRanges;
        }
        this.dirtyRanges[this.numberDirtyRanges].setRange(address, length);
        ++this.numberDirtyRanges;
    }

    public synchronized void preLoad(Buffer buffer, int address, int length) {
        this.load(null, buffer, address, length);
    }

    public synchronized void load(IRenderingEngine re, Buffer buffer, int address, int length) {
        address = Memory.getInstance().normalizeAddress(address);
        if (log.isTraceEnabled()) {
            log.trace(String.format("VertexBuffer.load(0x%08X, %d) in %s", address, length, this.toString()));
        }
        if (!this.addressAlreadyChecked(address, length)) {
            boolean extended = this.extend(buffer, address, length);
            if (extended || !this.cachedMemoryEquals(address, length)) {
                int bufferAlignment = this.getBufferAlignment(buffer, address);
                this.position(address, bufferAlignment);
                Utilities.putBuffer(this.cachedBuffer, buffer, ByteOrder.LITTLE_ENDIAN, length + bufferAlignment);
                buffer.rewind();
                if (re != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(String.format("VertexBuffer reload buffer 0x%08X, %d, extended=%b", address, length, extended));
                    }
                    boolean updateSubData = !this.reloadBufferDataPending;
                    this.checkDirty(re);
                    if (updateSubData) {
                        this.position(address);
                        this.bind(re);
                        re.setBufferSubData(0, this.cachedBuffer.position(), length, this.cachedBuffer);
                    }
                } else {
                    this.addDirtyRange(address, length);
                }
                this.copyToCachedMemory(address, length);
            } else if (re != null) {
                this.checkDirty(re);
            }
            this.setAddressAlreadyChecked(address, length);
        } else if (re != null) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("VertexBuffer address already checked 0x%08X, %d", address, length));
            }
            this.checkDirty(re);
        }
    }

    public synchronized void forceReload() {
        if (this.cachedBuffer != null) {
            Buffer vertexData = Memory.getInstance().getBuffer(this.bufferAddress, this.bufferLength);
            this.position(this.bufferAddress);
            Utilities.putBuffer(this.cachedBuffer, vertexData, ByteOrder.LITTLE_ENDIAN, this.bufferLength);
            this.copyToCachedMemory(this.bufferAddress, this.bufferLength);
            this.reloadBufferDataPending = true;
        }
    }

    public synchronized void delete(IRenderingEngine re) {
        if (this.bufferId != -1) {
            re.deleteBuffer(this.bufferId);
            this.bufferId = -1;
        }
        this.bufferLength = 0;
        this.bufferAddress = 0;
        this.stride = 0;
        this.cachedBuffer = null;
        this.cachedMemory = null;
    }

    public int getBufferOffset(int address) {
        address = Memory.getInstance().normalizeAddress(address);
        return address - this.bufferAddress;
    }

    public boolean isAddressInside(int address, int length, int gapSize) {
        address = Memory.getInstance().normalizeAddress(address);
        int endAddress = address + length;
        int startBuffer = this.bufferAddress - gapSize;
        int endBuffer = this.bufferAddress + this.bufferLength + gapSize;
        if (startBuffer <= address && address < endBuffer) {
            return true;
        }
        if (startBuffer <= endAddress && endAddress < endBuffer) {
            return true;
        }
        return address < startBuffer && endBuffer < endAddress;
    }

    public synchronized void resetAddressAlreadyChecked() {
        this.addressAlreadyChecked.clear();
    }

    private boolean addressAlreadyChecked(int address, int length) {
        Integer checkedLength = this.addressAlreadyChecked.get(address);
        if (checkedLength == null) {
            return false;
        }
        return checkedLength >= length;
    }

    private void setAddressAlreadyChecked(int address, int length) {
        this.addressAlreadyChecked.put(address, length);
    }

    public int getStride() {
        return this.stride;
    }

    public int getLength() {
        return this.bufferLength;
    }

    public int getId() {
        return this.bufferId;
    }

    public String toString() {
        return String.format("VertexBuffer[0x%08X-0x%08X, length %d, stride %d, id %d]", this.bufferAddress, this.bufferAddress + this.bufferLength, this.bufferLength, this.stride, this.bufferId);
    }

    private static class AddressRange {
        public int address;
        public int length;

        public void setRange(int address, int length) {
            this.address = address;
            this.length = length;
        }

        public String toString() {
            return String.format("AddressRange[0x%08X-0x%08X, length %d]", this.address, this.address + this.length, this.length);
        }
    }
}

