/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexCache;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class VertexInfo {
    public static final int vtypeMask = 0x9DDFFF;
    public boolean transform2D;
    public int skinningWeightCount;
    public int morphingVertexCount;
    public int texture;
    public int color;
    public int normal;
    public int position;
    public int weight;
    public int index;
    public int vtype;
    public int ptr_vertex;
    public int ptr_index;
    public int vertexSize;
    public int oneVertexSize;
    public int textureOffset;
    public int colorOffset;
    public int normalOffset;
    public int positionOffset;
    public int alignmentSize;
    public int tempAddr;
    private static int[] size_mapping = new int[]{0, 1, 2, 4};
    private static int[] size_padding = new int[]{0, 0, 1, 3};
    private static int[] color_size_mapping = new int[]{0, 1, 1, 1, 2, 2, 2, 4};
    private static int[] color_size_padding = new int[]{0, 0, 0, 0, 1, 1, 1, 3};
    private float[] morph_weight = new float[8];
    private static String[] texture_info = new String[]{null, "GU_TEXTURE_8BIT", "GU_TEXTURE_16BIT", "GU_TEXTURE_32BITF"};
    private static String[] color_info = new String[]{null, "GU_COLOR_UNK2", "GU_COLOR_UNK3", "GU_COLOR_UNK4", "GU_COLOR_5650", "GU_COLOR_5551", "GU_COLOR_4444", "GU_COLOR_8888"};
    private static String[] normal_info = new String[]{null, "GU_NORMAL_8BIT", "GU_NORMAL_16BIT", "GU_NORMAL_32BITF"};
    private static String[] vertex_info = new String[]{null, "GU_VERTEX_8BIT", "GU_VERTEX_16BIT", "GU_VERTEX_32BITF"};
    private static String[] weight_info = new String[]{null, "GU_WEIGHT_8BIT", "GU_WEIGHT_16BIT", "GU_WEIGHT_32BITF"};
    private static String[] index_info = new String[]{null, "GU_INDEX_8BIT", "GU_INDEX_16BIT", "GU_INDEX_UNK3"};
    private static String[] transform_info = new String[]{"GU_TRANSFORM_3D", "GU_TRANSFORM_2D"};
    private int bufferId = -1;
    private int vertexArrayId = -1;
    private int[] cachedVertices;
    private int[] cachedIndices;
    private int cachedNumberOfVertex;
    private float[] cachedMorphWeights;
    private float[][] cachedBoneMatrix;
    private ByteBuffer cachedBuffer;
    private VertexCache vertexCache;
    public VertexState lastVertex = new VertexState();

    public VertexInfo() {
    }

    public VertexInfo(VertexInfo vertexInfo) {
        this.vtype = vertexInfo.vtype;
        this.transform2D = vertexInfo.transform2D;
        this.skinningWeightCount = vertexInfo.skinningWeightCount;
        this.morphingVertexCount = vertexInfo.morphingVertexCount;
        this.texture = vertexInfo.texture;
        this.color = vertexInfo.color;
        this.normal = vertexInfo.normal;
        this.position = vertexInfo.position;
        this.weight = vertexInfo.weight;
        this.index = vertexInfo.index;
        this.ptr_vertex = vertexInfo.ptr_vertex;
        this.ptr_index = vertexInfo.ptr_index;
        this.vertexSize = vertexInfo.vertexSize;
        this.oneVertexSize = vertexInfo.oneVertexSize;
        this.textureOffset = vertexInfo.textureOffset;
        this.colorOffset = vertexInfo.colorOffset;
        this.normalOffset = vertexInfo.normalOffset;
        this.positionOffset = vertexInfo.positionOffset;
        this.alignmentSize = vertexInfo.alignmentSize;
        this.morph_weight = vertexInfo.morph_weight;
        this.cachedIndices = vertexInfo.cachedIndices;
        this.cachedVertices = vertexInfo.cachedVertices;
        this.vertexCache = vertexInfo.vertexCache;
    }

    public void processType(int param) {
        this.vtype = param & 0x9DDFFF;
        this.texture = param >> 0 & 3;
        this.color = param >> 2 & 7;
        this.normal = param >> 5 & 3;
        this.position = param >> 7 & 3;
        this.weight = param >> 9 & 3;
        this.index = param >> 11 & 3;
        this.skinningWeightCount = (param >> 14 & 7) + 1;
        this.morphingVertexCount = (param >> 18 & 7) + 1;
        this.transform2D = (param >> 23 & 1) != 0;
        this.vertexSize = 0;
        this.vertexSize += size_mapping[this.weight] * this.skinningWeightCount;
        this.textureOffset = this.vertexSize = this.vertexSize + size_padding[this.texture] & ~size_padding[this.texture];
        this.vertexSize += size_mapping[this.texture] * 2;
        this.colorOffset = this.vertexSize = this.vertexSize + color_size_padding[this.color] & ~color_size_padding[this.color];
        this.vertexSize += color_size_mapping[this.color];
        this.normalOffset = this.vertexSize = this.vertexSize + size_padding[this.normal] & ~size_padding[this.normal];
        this.vertexSize += size_mapping[this.normal] * 3;
        this.positionOffset = this.vertexSize = this.vertexSize + size_padding[this.position] & ~size_padding[this.position];
        this.vertexSize += size_mapping[this.position] * 3;
        this.oneVertexSize = this.vertexSize;
        this.vertexSize *= this.morphingVertexCount;
        this.alignmentSize = Math.max(size_mapping[this.weight], Math.max(color_size_mapping[this.color], Math.max(size_mapping[this.normal], Math.max(size_mapping[this.texture], size_mapping[this.position]))));
        this.vertexSize = this.vertexSize + this.alignmentSize - 1 & ~(this.alignmentSize - 1);
        this.oneVertexSize = this.oneVertexSize + this.alignmentSize - 1 & ~(this.alignmentSize - 1);
    }

    public int getAddress(Memory mem, int i) {
        if (this.ptr_index != 0 && this.index != 0) {
            int addr = this.ptr_index + i * this.index;
            switch (this.index) {
                case 1: {
                    i = mem.read8(addr);
                    break;
                }
                case 2: {
                    i = mem.read16(addr);
                    break;
                }
                case 3: {
                    i = mem.read32(addr);
                }
            }
        }
        return this.ptr_vertex + i * this.vertexSize;
    }

    public void setMorphWeights(float[] mw) {
        this.morph_weight = mw;
        if (this.morphingVertexCount == 1) {
            this.morph_weight[0] = 1.0f;
        }
    }

    public VertexState readVertex(Memory mem, int addr) {
        float z;
        float y;
        float x;
        int morphCounter;
        VertexState v = new VertexState();
        this.tempAddr = addr;
        if (this.weight != 0) {
            block27: for (int i = 0; i < this.skinningWeightCount; ++i) {
                switch (this.weight) {
                    case 1: {
                        v.boneWeights[i] = mem.read8(addr);
                        ++addr;
                        int n = i;
                        v.boneWeights[n] = v.boneWeights[n] / 128.0f;
                        continue block27;
                    }
                    case 2: {
                        addr = addr + 1 & 0xFFFFFFFE;
                        v.boneWeights[i] = mem.read16(addr);
                        addr += 2;
                        int n = i;
                        v.boneWeights[n] = v.boneWeights[n] / 32768.0f;
                        continue block27;
                    }
                    case 3: {
                        addr = addr + 3 & 0xFFFFFFFC;
                        v.boneWeights[i] = Float.intBitsToFloat(mem.read32(addr));
                        addr += 4;
                    }
                }
            }
            if (VideoEngine.log.isTraceEnabled()) {
                VideoEngine.log.trace(String.format("Weight(%d) %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f", this.skinningWeightCount, Float.valueOf(v.boneWeights[0]), Float.valueOf(v.boneWeights[1]), Float.valueOf(v.boneWeights[2]), Float.valueOf(v.boneWeights[3]), Float.valueOf(v.boneWeights[4]), Float.valueOf(v.boneWeights[5]), Float.valueOf(v.boneWeights[6]), Float.valueOf(v.boneWeights[7])));
            }
        }
        switch (this.texture) {
            case 1: {
                float tv;
                float tu;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.textureOffset;
                    tu = mem.read8(addr) & 0xFF;
                    tv = mem.read8(++addr) & 0xFF;
                    ++addr;
                    if (!this.transform2D) {
                        v.t[0] = v.t[0] + (tu /= 128.0f) * this.morph_weight[morphCounter];
                        v.t[1] = v.t[1] + (tv /= 128.0f) * this.morph_weight[morphCounter];
                        continue;
                    }
                    v.t[0] = tu;
                    v.t[1] = tv;
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("texture type 1 " + v.t[0] + ", " + v.t[1] + " transform2D=" + this.transform2D);
                break;
            }
            case 2: {
                float tv;
                float tu;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.textureOffset;
                    addr = addr + 1 & 0xFFFFFFFE;
                    tu = mem.read16(addr) & 0xFFFF;
                    tv = mem.read16(addr += 2) & 0xFFFF;
                    addr += 2;
                    if (!this.transform2D) {
                        v.t[0] = v.t[0] + (tu /= 32768.0f) * this.morph_weight[morphCounter];
                        v.t[1] = v.t[1] + (tv /= 32768.0f) * this.morph_weight[morphCounter];
                        continue;
                    }
                    v.t[0] = tu;
                    v.t[1] = tv;
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("texture type 2 " + v.t[0] + ", " + v.t[1] + " transform2D=" + this.transform2D);
                break;
            }
            case 3: {
                float tv;
                float tu;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.textureOffset;
                    addr = addr + 3 & 0xFFFFFFFC;
                    tu = Float.intBitsToFloat(mem.read32(addr));
                    tv = Float.intBitsToFloat(mem.read32(addr += 4));
                    addr += 4;
                    v.t[0] = v.t[0] + tu * this.morph_weight[morphCounter];
                    v.t[1] = v.t[1] + tv * this.morph_weight[morphCounter];
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("texture type 3 " + v.t[0] + ", " + v.t[1] + " transform2D=" + this.transform2D);
            }
        }
        switch (this.color) {
            case 1: 
            case 2: 
            case 3: {
                VideoEngine.log.warn("unimplemented color type " + this.color);
                ++addr;
                break;
            }
            case 4: {
                float a;
                float b;
                float g;
                float r;
                int bBits;
                int gBits;
                int rBits;
                int packed;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.colorOffset;
                    addr = addr + 1 & 0xFFFFFFFE;
                    packed = mem.read16(addr);
                    addr += 2;
                    rBits = packed & 0x1F;
                    gBits = packed >> 5 & 0x3F;
                    bBits = packed >> 11 & 0x1F;
                    r = (float)(rBits << 3 | rBits >> 2) / 255.0f;
                    g = (float)(gBits << 2 | gBits >> 4) / 255.0f;
                    b = (float)(bBits << 3 | bBits >> 2) / 255.0f;
                    a = 1.0f;
                    v.c[0] = v.c[0] + r * this.morph_weight[morphCounter];
                    v.c[1] = v.c[1] + g * this.morph_weight[morphCounter];
                    v.c[2] = v.c[2] + b * this.morph_weight[morphCounter];
                    v.c[3] = v.c[3] + a * this.morph_weight[morphCounter];
                }
                break;
            }
            case 5: {
                float a;
                float b;
                float g;
                float r;
                int bBits;
                int gBits;
                int rBits;
                int packed;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.colorOffset;
                    addr = addr + 1 & 0xFFFFFFFE;
                    packed = mem.read16(addr);
                    addr += 2;
                    rBits = packed & 0x1F;
                    gBits = packed >> 5 & 0x1F;
                    bBits = packed >> 10 & 0x1F;
                    r = (float)(rBits << 3 | rBits >> 2) / 255.0f;
                    g = (float)(gBits << 3 | gBits >> 2) / 255.0f;
                    b = (float)(bBits << 3 | bBits >> 2) / 255.0f;
                    a = (float)(packed >> 15 & 1) / 1.0f;
                    v.c[0] = v.c[0] + r * this.morph_weight[morphCounter];
                    v.c[1] = v.c[1] + g * this.morph_weight[morphCounter];
                    v.c[2] = v.c[2] + b * this.morph_weight[morphCounter];
                    v.c[3] = v.c[3] + a * this.morph_weight[morphCounter];
                }
                break;
            }
            case 6: {
                float a;
                float b;
                float g;
                float r;
                int bBits;
                int gBits;
                int rBits;
                int packed;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.colorOffset;
                    addr = addr + 1 & 0xFFFFFFFE;
                    packed = mem.read16(addr);
                    addr += 2;
                    rBits = packed & 0xF;
                    gBits = packed >> 4 & 0xF;
                    bBits = packed >> 8 & 0xF;
                    int aBits = packed >> 12 & 0xF;
                    r = (float)(rBits << 4 | rBits) / 255.0f;
                    g = (float)(gBits << 4 | gBits) / 255.0f;
                    b = (float)(bBits << 4 | bBits) / 255.0f;
                    a = (float)(aBits << 4 | aBits) / 255.0f;
                    v.c[0] = v.c[0] + r * this.morph_weight[morphCounter];
                    v.c[1] = v.c[1] + g * this.morph_weight[morphCounter];
                    v.c[2] = v.c[2] + b * this.morph_weight[morphCounter];
                    v.c[3] = v.c[3] + a * this.morph_weight[morphCounter];
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("color type 6 " + String.format("r=%.1f g=%.1f b=%.1f a=%.1f ", Float.valueOf(v.c[0]), Float.valueOf(v.c[1]), Float.valueOf(v.c[2]), Float.valueOf(v.c[3])));
                break;
            }
            case 7: {
                float a;
                float b;
                float g;
                float r;
                int packed;
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.colorOffset;
                    addr = addr + 3 & 0xFFFFFFFC;
                    packed = mem.read32(addr);
                    addr += 4;
                    r = (float)(packed & 0xFF) / 255.0f;
                    g = (float)(packed >> 8 & 0xFF) / 255.0f;
                    b = (float)(packed >> 16 & 0xFF) / 255.0f;
                    a = (float)(packed >> 24 & 0xFF) / 255.0f;
                    v.c[0] = v.c[0] + r * this.morph_weight[morphCounter];
                    v.c[1] = v.c[1] + g * this.morph_weight[morphCounter];
                    v.c[2] = v.c[2] + b * this.morph_weight[morphCounter];
                    v.c[3] = v.c[3] + a * this.morph_weight[morphCounter];
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("color type 7 " + String.format("r=%.1f g=%.1f b=%.1f a=%.1f", Float.valueOf(v.c[0]), Float.valueOf(v.c[1]), Float.valueOf(v.c[2]), Float.valueOf(v.c[3])));
            }
        }
        switch (this.normal) {
            case 1: {
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.normalOffset;
                    x = (byte)mem.read8(addr);
                    y = (byte)mem.read8(++addr);
                    z = (byte)mem.read8(++addr);
                    ++addr;
                    if (!this.transform2D) {
                        v.n[0] = v.n[0] + (x /= 127.0f) * this.morph_weight[morphCounter];
                        v.n[1] = v.n[1] + (y /= 127.0f) * this.morph_weight[morphCounter];
                        v.n[2] = v.n[2] + (z /= 127.0f) * this.morph_weight[morphCounter];
                        continue;
                    }
                    v.n[0] = x;
                    v.n[1] = y;
                    v.n[2] = z;
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("normal type 1 " + v.n[0] + ", " + v.n[1] + ", " + v.n[2] + " transform2D=" + this.transform2D);
                break;
            }
            case 2: {
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.normalOffset;
                    addr = addr + 1 & 0xFFFFFFFE;
                    x = (short)mem.read16(addr);
                    y = (short)mem.read16(addr += 2);
                    z = (short)mem.read16(addr += 2);
                    addr += 2;
                    if (!this.transform2D) {
                        v.n[0] = v.n[0] + (x /= 32767.0f) * this.morph_weight[morphCounter];
                        v.n[1] = v.n[1] + (y /= 32767.0f) * this.morph_weight[morphCounter];
                        v.n[2] = v.n[2] + (z /= 32767.0f) * this.morph_weight[morphCounter];
                        continue;
                    }
                    v.n[0] = x;
                    v.n[1] = y;
                    v.n[2] = z;
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("normal type 2 " + v.n[0] + ", " + v.n[1] + ", " + v.n[2] + " transform2D=" + this.transform2D);
                break;
            }
            case 3: {
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.normalOffset;
                    addr = addr + 3 & 0xFFFFFFFC;
                    x = Float.intBitsToFloat(mem.read32(addr));
                    y = Float.intBitsToFloat(mem.read32(addr += 4));
                    z = Float.intBitsToFloat(mem.read32(addr += 4));
                    addr += 4;
                    v.n[0] = v.n[0] + x * this.morph_weight[morphCounter];
                    v.n[1] = v.n[1] + y * this.morph_weight[morphCounter];
                    v.n[2] = v.n[2] + z * this.morph_weight[morphCounter];
                }
                break;
            }
        }
        switch (this.position) {
            case 1: {
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.positionOffset;
                    if (this.transform2D) {
                        v.p[0] = (byte)mem.read8(addr);
                        v.p[1] = (byte)mem.read8(++addr);
                        v.p[2] = mem.read8(++addr);
                        ++addr;
                        continue;
                    }
                    x = (float)((byte)mem.read8(addr)) / 127.0f;
                    y = (float)((byte)mem.read8(++addr)) / 127.0f;
                    z = (float)((byte)mem.read8(++addr)) / 127.0f;
                    ++addr;
                    v.p[0] = v.p[0] + x * this.morph_weight[morphCounter];
                    v.p[1] = v.p[1] + y * this.morph_weight[morphCounter];
                    v.p[2] = v.p[2] + z * this.morph_weight[morphCounter];
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("vertex type 1 " + v.p[0] + ", " + v.p[1] + ", " + v.p[2] + " transform2D=" + this.transform2D);
                break;
            }
            case 2: {
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.positionOffset;
                    addr = addr + 1 & 0xFFFFFFFE;
                    if (this.transform2D) {
                        v.p[0] = (short)mem.read16(addr);
                        v.p[1] = (short)mem.read16(addr += 2);
                        v.p[2] = mem.read16(addr += 2);
                        addr += 2;
                        continue;
                    }
                    x = (float)((short)mem.read16(addr)) / 32767.0f;
                    y = (float)((short)mem.read16(addr += 2)) / 32767.0f;
                    z = (float)((short)mem.read16(addr += 2)) / 32767.0f;
                    addr += 2;
                    v.p[0] = v.p[0] + x * this.morph_weight[morphCounter];
                    v.p[1] = v.p[1] + y * this.morph_weight[morphCounter];
                    v.p[2] = v.p[2] + z * this.morph_weight[morphCounter];
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("vertex type 2 " + v.p[0] + ", " + v.p[1] + ", " + v.p[2] + " transform2D=" + this.transform2D + ", addr=0x" + Integer.toHexString(addr - 6));
                break;
            }
            case 3: {
                for (morphCounter = 0; morphCounter < this.morphingVertexCount; ++morphCounter) {
                    addr = this.tempAddr + morphCounter * this.oneVertexSize + this.positionOffset;
                    addr = addr + 3 & 0xFFFFFFFC;
                    x = Float.intBitsToFloat(mem.read32(addr));
                    y = Float.intBitsToFloat(mem.read32(addr += 4));
                    z = Float.intBitsToFloat(mem.read32(addr += 4));
                    addr += 4;
                    if (this.transform2D) {
                        z = z < 0.0f ? 0.0f : (float)((int)z);
                        v.p[0] = x;
                        v.p[1] = y;
                        v.p[2] = z;
                        continue;
                    }
                    v.p[0] = v.p[0] + x * this.morph_weight[morphCounter];
                    v.p[1] = v.p[1] + y * this.morph_weight[morphCounter];
                    v.p[2] = v.p[2] + z * this.morph_weight[morphCounter];
                }
                if (!VideoEngine.log.isTraceEnabled()) break;
                VideoEngine.log.trace("vertex type 3 " + v.p[0] + ", " + v.p[1] + ", " + v.p[2] + " transform2D=" + this.transform2D + ", addr=0x" + Integer.toHexString(addr - 12));
            }
        }
        this.lastVertex = v;
        return v;
    }

    public void setDirty() {
        this.cachedIndices = null;
        this.cachedVertices = null;
    }

    private boolean equals(int[] a, int[] b) {
        if (a == null) {
            if (b != null) {
                return false;
            }
        } else {
            if (b == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(VertexInfo vertexInfo, int numberOfVertex) {
        if (!this.vertexCache.vertexAlreadyChecked(vertexInfo)) {
            vertexInfo.readForCache(numberOfVertex);
            if (!this.equals(this.cachedVertices, vertexInfo.cachedVertices)) {
                return false;
            }
            if (!this.equals(this.cachedIndices, vertexInfo.cachedIndices)) {
                return false;
            }
            this.vertexCache.setVertexAlreadyChecked(vertexInfo);
        } else {
            if (this.index != 0 && this.cachedIndices == null) {
                return false;
            }
            if (this.ptr_vertex != 0 && this.cachedVertices == null) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(VertexInfo vertexInfo, int numberOfVertex, float[][] boneMatrix, int numberOfWeightsForBuffer) {
        int i;
        if (this.vtype != vertexInfo.vtype || this.cachedNumberOfVertex != numberOfVertex || this.ptr_index != vertexInfo.ptr_index) {
            return false;
        }
        if (this.morphingVertexCount > 1) {
            for (i = 0; i < this.morphingVertexCount; ++i) {
                if (this.cachedMorphWeights[i] == vertexInfo.morph_weight[i]) continue;
                return false;
            }
        }
        if (this.weight != 0 && numberOfWeightsForBuffer == 0) {
            for (i = 0; i < this.skinningWeightCount; ++i) {
                for (int j = 0; j < 12; ++j) {
                    if (this.cachedBoneMatrix[i][j] == boneMatrix[i][j]) continue;
                    return false;
                }
            }
        }
        if (VideoEngine.getInstance().useOptimisticVertexCache) {
            if (this.index != 0 && this.cachedIndices == null) {
                return false;
            }
            return this.ptr_vertex == 0 || this.cachedVertices != null;
        }
        return this.equals(vertexInfo, numberOfVertex);
    }

    public boolean bindVertex(IRenderingEngine re) {
        return this.bindVertex(re, false);
    }

    private boolean bindVertex(IRenderingEngine re, boolean bindBuffer) {
        boolean needSetDataPointers;
        if (this.vertexArrayId >= 0) {
            re.bindVertexArray(this.vertexArrayId);
            needSetDataPointers = false;
            if (bindBuffer) {
                re.bindBuffer(0, this.bufferId);
            }
        } else {
            re.bindBuffer(0, this.bufferId);
            needSetDataPointers = true;
        }
        return needSetDataPointers;
    }

    public boolean loadVertex(IRenderingEngine re, FloatBuffer buffer, int size) {
        boolean needSetDataPointers = false;
        if (this.vertexArrayId == -1 && re.isVertexArrayAvailable()) {
            this.vertexArrayId = re.genVertexArray();
            needSetDataPointers = true;
        }
        if (this.bufferId == -1) {
            this.bufferId = re.genBuffer();
            needSetDataPointers = true;
        }
        if (this.bindVertex(re, true)) {
            needSetDataPointers = true;
        }
        int bufferSize = size * VideoEngine.SIZEOF_FLOAT;
        if (this.cachedBuffer == null || this.cachedBuffer.capacity() < bufferSize) {
            this.cachedBuffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.cachedBuffer.clear();
        }
        int oldLimit = buffer.limit();
        buffer.limit(size);
        this.cachedBuffer.asFloatBuffer().put(buffer);
        buffer.limit(oldLimit);
        buffer.rewind();
        this.cachedBuffer.rewind();
        re.setBufferData(0, size * VideoEngine.SIZEOF_FLOAT, this.cachedBuffer, 3);
        return needSetDataPointers;
    }

    public void deleteVertex(IRenderingEngine re) {
        if (this.bufferId != -1) {
            re.deleteBuffer(this.bufferId);
            this.bufferId = -1;
        }
        if (this.vertexArrayId != -1) {
            re.deleteVertexArray(this.vertexArrayId);
            this.vertexArrayId = -1;
        }
        this.cachedMorphWeights = null;
        this.cachedBoneMatrix = null;
        this.cachedBuffer = null;
        this.cachedIndices = null;
        this.cachedVertices = null;
    }

    private void readForCache(int numberOfVertex) {
        int vertexArraySize;
        if (this.cachedIndices != null || this.cachedVertices != null) {
            return;
        }
        if (this.ptr_index != 0 && this.index != 0) {
            IMemoryReader memoryReader = null;
            switch (this.index) {
                case 1: {
                    memoryReader = MemoryReader.getMemoryReader(this.ptr_index, 1 * numberOfVertex, 1);
                    break;
                }
                case 2: {
                    memoryReader = MemoryReader.getMemoryReader(this.ptr_index, 2 * numberOfVertex, 2);
                    break;
                }
                case 3: {
                    memoryReader = MemoryReader.getMemoryReader(this.ptr_index, 4 * numberOfVertex, 4);
                }
            }
            int maxIndex = -1;
            if (memoryReader != null) {
                this.cachedIndices = new int[numberOfVertex];
                for (int i = 0; i < numberOfVertex; ++i) {
                    int index;
                    this.cachedIndices[i] = index = memoryReader.readNext();
                    if (index <= maxIndex) continue;
                    maxIndex = index;
                }
            }
            vertexArraySize = this.vertexSize * (maxIndex + 1);
        } else {
            vertexArraySize = this.vertexSize * numberOfVertex;
        }
        if (this.ptr_vertex != 0) {
            vertexArraySize = vertexArraySize + 3 & 0xFFFFFFFC;
            this.cachedVertices = new int[vertexArraySize >> 2];
            IMemoryReader verticesReader = MemoryReader.getMemoryReader(this.ptr_vertex, vertexArraySize, 4);
            for (int i = 0; i < this.cachedVertices.length; ++i) {
                this.cachedVertices[i] = verticesReader.readNext();
            }
        }
    }

    public void prepareForCache(VertexCache vertexCache, int numberOfVertex, float[][] boneMatrix, int numberOfWeightsForBuffer) {
        this.vertexCache = vertexCache;
        this.cachedNumberOfVertex = numberOfVertex;
        this.cachedMorphWeights = new float[this.morphingVertexCount];
        System.arraycopy(this.morph_weight, 0, this.cachedMorphWeights, 0, this.morphingVertexCount);
        if (this.weight != 0 && numberOfWeightsForBuffer == 0 && boneMatrix != null) {
            this.cachedBoneMatrix = new float[this.skinningWeightCount][];
            for (int i = 0; i < this.skinningWeightCount; ++i) {
                this.cachedBoneMatrix[i] = new float[12];
                System.arraycopy(boneMatrix[i], 0, this.cachedBoneMatrix[i], 0, 12);
            }
        } else {
            this.cachedBoneMatrix = null;
        }
        this.readForCache(numberOfVertex);
    }

    public void reuseCachedBuffer(VertexInfo vertexInfo) {
        if (vertexInfo != null && vertexInfo.cachedBuffer != null && (this.cachedBuffer == null || this.cachedBuffer.capacity() < vertexInfo.cachedBuffer.capacity())) {
            this.cachedBuffer = vertexInfo.cachedBuffer;
            vertexInfo.cachedBuffer = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (texture_info[this.texture] != null) {
            sb.append(texture_info[this.texture] + "|");
        }
        if (color_info[this.color] != null) {
            sb.append(color_info[this.color] + "|");
        }
        if (normal_info[this.normal] != null) {
            sb.append(normal_info[this.normal] + "|");
        }
        if (vertex_info[this.position] != null) {
            sb.append(vertex_info[this.position] + "|");
        }
        if (weight_info[this.weight] != null) {
            sb.append(weight_info[this.weight] + "|");
            sb.append("GU_WEIGHTS(" + this.skinningWeightCount + ")|");
        }
        if (this.morphingVertexCount > 1) {
            sb.append("GU_VERTICES(" + this.morphingVertexCount + ")|");
        }
        if (index_info[this.index] != null) {
            sb.append(index_info[this.index] + "|");
        }
        if (transform_info[this.transform2D ? 1 : 0] != null) {
            sb.append(transform_info[this.transform2D ? 1 : 0]);
        }
        sb.append(" size=" + this.vertexSize);
        return sb.toString();
    }
}

