/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureRAM;

public class CaptureDisplayDetails {
    private static final boolean captureRenderTargets = false;
    private static final int packetSize = 36;
    private int fbp;
    private int fbw;
    private int zbp;
    private int zbw;
    private int psm;
    private int topaddrFb;
    private int bufferwidthFb;
    private int pixelformatFb;
    private int sync;
    private CaptureRAM drawBuffer;
    private CaptureRAM depthBuffer;
    private CaptureRAM displayBuffer;

    public CaptureDisplayDetails() throws IOException {
        VideoEngine ge = VideoEngine.getInstance();
        sceDisplay display = Modules.sceDisplayModule;
        this.fbp = ge.getFBP();
        this.fbw = ge.getFBW();
        this.zbp = ge.getZBP();
        this.zbw = ge.getZBW();
        this.psm = ge.getPSM();
        this.topaddrFb = display.getTopAddrFb();
        this.bufferwidthFb = display.getBufferWidthFb();
        this.pixelformatFb = display.getPixelFormatFb();
        this.sync = display.getSync();
        int pixelFormatBytes = this.psm == 3 ? 4 : 2;
        this.drawBuffer = new CaptureRAM(this.fbp + 0x4000000, this.fbw * 272 * pixelFormatBytes);
        this.depthBuffer = new CaptureRAM(this.zbp + 0x4000000, this.zbw * 272 * 2);
        pixelFormatBytes = this.pixelformatFb == 3 ? 4 : 2;
        this.displayBuffer = new CaptureRAM(this.topaddrFb, this.bufferwidthFb * 272 * pixelFormatBytes);
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(36);
        data.writeInt(this.fbp);
        data.writeInt(this.fbw);
        data.writeInt(this.zbp);
        data.writeInt(this.zbw);
        data.writeInt(this.psm);
        data.writeInt(this.topaddrFb);
        data.writeInt(this.bufferwidthFb);
        data.writeInt(this.pixelformatFb);
        data.writeInt(this.sync);
    }

    public static CaptureDisplayDetails read(InputStream in) throws IOException {
        CaptureDisplayDetails details = new CaptureDisplayDetails();
        DataInputStream data = new DataInputStream(in);
        int sizeRemaining = data.readInt();
        if (sizeRemaining >= 36) {
            details.fbp = data.readInt();
            sizeRemaining -= 4;
            details.fbw = data.readInt();
            sizeRemaining -= 4;
            details.zbp = data.readInt();
            sizeRemaining -= 4;
            details.zbw = data.readInt();
            sizeRemaining -= 4;
            details.psm = data.readInt();
            sizeRemaining -= 4;
            details.topaddrFb = data.readInt();
            sizeRemaining -= 4;
            details.bufferwidthFb = data.readInt();
            sizeRemaining -= 4;
            details.pixelformatFb = data.readInt();
            sizeRemaining -= 4;
        } else {
            throw new IOException("Not enough bytes remaining in stream");
        }
        details.sync = data.readInt();
        data.skipBytes(sizeRemaining -= 4);
        return details;
    }

    public void commit() {
        sceDisplay display = Modules.sceDisplayModule;
        display.hleDisplaySetFrameBuf(this.topaddrFb, this.bufferwidthFb, this.pixelformatFb, this.sync);
        display.hleDisplaySetGeBuf(this.fbp, this.fbw, this.psm, false, false);
    }
}

