/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class CaptureImage {
    private int imageaddr;
    private int level;
    private Buffer buffer;
    private int width;
    private int height;
    private int bufferWidth;
    private int bufferStorage;
    private boolean compressedImage;
    private int compressedImageSize;
    private boolean invert;
    private boolean overwriteFile;
    private String fileNamePrefix;
    private static HashMap<Integer, Integer> lastFileIndex = new HashMap();

    public CaptureImage(int imageaddr, int level, Buffer buffer, int width, int height, int bufferWidth, int bufferStorage, boolean compressedImage, int compressedImageSize, boolean invert, boolean overwriteFile, String fileNamePrefix) {
        this.imageaddr = imageaddr;
        this.level = level;
        this.buffer = buffer;
        this.width = width;
        this.height = height;
        this.bufferWidth = bufferWidth;
        this.bufferStorage = bufferStorage;
        this.compressedImage = compressedImage;
        this.compressedImageSize = compressedImageSize;
        this.invert = invert;
        this.overwriteFile = overwriteFile;
        this.fileNamePrefix = fileNamePrefix == null ? "Image" : fileNamePrefix;
    }

    public void write() throws IOException {
        boolean imageType32Bit;
        if (this.bufferStorage >= 4 && this.bufferStorage <= 7) {
            return;
        }
        String levelName = "";
        if (this.level > 0) {
            levelName = "_" + this.level;
        }
        String fileName = null;
        int scanIndex = 0;
        Integer lastIndex = lastFileIndex.get(this.imageaddr);
        if (lastIndex != null) {
            scanIndex = lastIndex + 1;
        }
        int i = scanIndex;
        while (true) {
            String id = i == 0 ? "" : "-" + i;
            fileName = String.format("tmp/%s%08X%s%s.bmp", this.fileNamePrefix, this.imageaddr, levelName, id);
            if (this.overwriteFile) break;
            File file = new File(fileName);
            if (!file.exists()) {
                lastFileIndex.put(this.imageaddr, i);
                break;
            }
            ++i;
        }
        if (this.compressedImage) {
            this.decompressImage();
        }
        if (this.width > this.bufferWidth) {
            this.width = this.bufferWidth;
        }
        byte[] fileHeader = new byte[14];
        byte[] dibHeader = new byte[56];
        int rowPad = 4 - (this.width * 4 & 3) & 3;
        int imageSize = this.height * (this.width * 4 + rowPad);
        int fileSize = fileHeader.length + dibHeader.length + imageSize;
        BufferedOutputStream outBmp = new BufferedOutputStream(new FileOutputStream(fileName), fileSize);
        fileHeader[0] = 66;
        fileHeader[1] = 77;
        this.storeLittleEndianInt(fileHeader, 2, fileSize);
        this.storeLittleEndianInt(fileHeader, 10, fileHeader.length + dibHeader.length);
        this.storeLittleEndianInt(dibHeader, 0, dibHeader.length);
        this.storeLittleEndianInt(dibHeader, 4, this.width);
        this.storeLittleEndianInt(dibHeader, 8, -this.height);
        this.storeLittleEndianShort(dibHeader, 12, 1);
        this.storeLittleEndianShort(dibHeader, 14, 32);
        this.storeLittleEndianInt(dibHeader, 16, 3);
        this.storeLittleEndianInt(dibHeader, 20, imageSize);
        this.storeLittleEndianInt(dibHeader, 24, 2835);
        this.storeLittleEndianInt(dibHeader, 28, 2835);
        this.storeLittleEndianInt(dibHeader, 32, 0);
        this.storeLittleEndianInt(dibHeader, 36, 0);
        this.storeLittleEndianInt(dibHeader, 40, 0xFF0000);
        this.storeLittleEndianInt(dibHeader, 44, 65280);
        this.storeLittleEndianInt(dibHeader, 48, 255);
        this.storeLittleEndianInt(dibHeader, 52, -16777216);
        ((OutputStream)outBmp).write(fileHeader);
        ((OutputStream)outBmp).write(dibHeader);
        byte[] rowPadBytes = new byte[rowPad];
        byte[] pixelBytes = new byte[4];
        byte[] blackPixelBytes = new byte[pixelBytes.length];
        boolean bl = imageType32Bit = this.bufferStorage == 3;
        if (this.buffer instanceof IntBuffer && imageType32Bit) {
            IntBuffer intBuffer = (IntBuffer)this.buffer;
            for (int y = 0; y < this.height; ++y) {
                intBuffer.position((this.invert ? this.height - y - 1 : y) * this.bufferWidth);
                for (int x = 0; x < this.width; ++x) {
                    try {
                        int pixel = intBuffer.get();
                        pixelBytes[0] = (byte)(pixel >> 16);
                        pixelBytes[1] = (byte)(pixel >> 8);
                        pixelBytes[2] = (byte)pixel;
                        pixelBytes[3] = (byte)(pixel >> 24);
                        ((OutputStream)outBmp).write(pixelBytes);
                        continue;
                    }
                    catch (BufferUnderflowException e) {
                        ((OutputStream)outBmp).write(blackPixelBytes);
                    }
                }
                ((OutputStream)outBmp).write(rowPadBytes);
            }
        } else if (this.buffer instanceof IntBuffer && !imageType32Bit) {
            IntBuffer intBuffer = (IntBuffer)this.buffer;
            for (int y = 0; y < this.height; ++y) {
                intBuffer.position((this.invert ? this.height - y - 1 : y) * this.bufferWidth / 2);
                for (int x = 0; x < this.width; x += 2) {
                    try {
                        int twoPixels = intBuffer.get();
                        this.getPixelBytes((short)twoPixels, this.bufferStorage, pixelBytes);
                        ((OutputStream)outBmp).write(pixelBytes);
                        this.getPixelBytes((short)(twoPixels >>> 16), this.bufferStorage, pixelBytes);
                        ((OutputStream)outBmp).write(pixelBytes);
                        continue;
                    }
                    catch (BufferUnderflowException e) {
                        ((OutputStream)outBmp).write(blackPixelBytes);
                        ((OutputStream)outBmp).write(blackPixelBytes);
                    }
                }
                ((OutputStream)outBmp).write(rowPadBytes);
            }
        } else if (this.buffer instanceof ShortBuffer && !imageType32Bit) {
            ShortBuffer shortBuffer = (ShortBuffer)this.buffer;
            for (int y = 0; y < this.height; ++y) {
                shortBuffer.position((this.invert ? this.height - y - 1 : y) * this.bufferWidth);
                for (int x = 0; x < this.width; ++x) {
                    short pixel = shortBuffer.get();
                    this.getPixelBytes(pixel, this.bufferStorage, pixelBytes);
                    ((OutputStream)outBmp).write(pixelBytes);
                }
                ((OutputStream)outBmp).write(rowPadBytes);
            }
        } else if (imageType32Bit) {
            for (int y = 0; y < this.height; ++y) {
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.imageaddr + (this.invert ? this.height - y - 1 : y) * this.bufferWidth * 4, this.bufferWidth * 4, 4);
                for (int x = 0; x < this.width; ++x) {
                    int pixel = memoryReader.readNext();
                    pixelBytes[0] = (byte)(pixel >> 16);
                    pixelBytes[1] = (byte)(pixel >> 8);
                    pixelBytes[2] = (byte)pixel;
                    pixelBytes[3] = (byte)(pixel >> 24);
                    ((OutputStream)outBmp).write(pixelBytes);
                }
                ((OutputStream)outBmp).write(rowPadBytes);
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.imageaddr + (this.invert ? this.height - y - 1 : y) * this.bufferWidth * 2, this.bufferWidth * 2, 2);
                for (int x = 0; x < this.width; ++x) {
                    short pixel = (short)memoryReader.readNext();
                    this.getPixelBytes(pixel, this.bufferStorage, pixelBytes);
                    ((OutputStream)outBmp).write(pixelBytes);
                }
                ((OutputStream)outBmp).write(rowPadBytes);
            }
        }
        this.buffer.rewind();
        ((OutputStream)outBmp).close();
        VideoEngine.log.debug(String.format("Saved image to %s", fileName));
    }

    private void storeLittleEndianInt(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)value;
        buffer[offset + 1] = (byte)(value >> 8);
        buffer[offset + 2] = (byte)(value >> 16);
        buffer[offset + 3] = (byte)(value >> 24);
    }

    private void storeLittleEndianShort(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)value;
        buffer[offset + 1] = (byte)(value >> 8);
    }

    private void getPixelBytes(short pixel, int imageType, byte[] pixelBytes) {
        switch (imageType) {
            case 0: {
                pixelBytes[0] = (byte)(pixel >> 8 & 0xF8);
                pixelBytes[1] = (byte)(pixel >> 3 & 0xFC);
                pixelBytes[2] = (byte)(pixel << 3 & 0xF8);
                pixelBytes[3] = 0;
                break;
            }
            case 1: {
                pixelBytes[0] = (byte)(pixel >> 7 & 0xF8);
                pixelBytes[1] = (byte)(pixel >> 2 & 0xF8);
                pixelBytes[2] = (byte)(pixel << 3 & 0xF8);
                pixelBytes[3] = (byte)(pixel >> 15 != 0 ? 255 : 0);
                break;
            }
            case 2: {
                pixelBytes[0] = (byte)(pixel >> 4 & 0xF0);
                pixelBytes[1] = (byte)(pixel & 0xF0);
                pixelBytes[2] = (byte)(pixel << 4 & 0xF0);
                pixelBytes[3] = (byte)(pixel >> 8 & 0xF0);
                break;
            }
            default: {
                pixelBytes[0] = 0;
                pixelBytes[1] = 0;
                pixelBytes[2] = 0;
                pixelBytes[3] = 0;
            }
        }
    }

    private void storePixel(IntBuffer buffer, int x, int y, int color) {
        buffer.put(y * this.width + x, color);
    }

    private int round4(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    private int getInt32(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).get();
        }
        if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            int n0 = shortBuffer.get() & 0xFFFF;
            int n1 = shortBuffer.get() & 0xFFFF;
            return n1 << 16 | n0;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).getInt();
        }
        return 0;
    }

    private void decompressImageDXT(int dxtLevel) {
        IntBuffer decompressedBuffer = IntBuffer.allocate(this.round4(this.width) * this.round4(this.height));
        int strideX = 0;
        int strideY = 0;
        int[] colors = new int[4];
        int strideSize = dxtLevel == 1 ? 8 : 16;
        int[] alphas = new int[16];
        int[] alphasLookup = new int[8];
        for (int i = 0; i < this.compressedImageSize; i += strideSize) {
            int b3;
            int g3;
            int r3;
            int b2;
            int g2;
            int r2;
            if (dxtLevel > 1) {
                if (dxtLevel <= 3) {
                    int alphaBits = 0;
                    int j = 0;
                    while (j < 16) {
                        if (j % 8 == 0) {
                            alphaBits = this.getInt32(this.buffer);
                        }
                        int alpha = alphaBits & 0xF;
                        alphas[j] = alpha << 4;
                        ++j;
                        alphaBits >>>= 4;
                    }
                } else {
                    int bits0 = this.getInt32(this.buffer);
                    int bits1 = this.getInt32(this.buffer);
                    int alpha0 = bits0 & 0xFF;
                    int alpha1 = bits0 >> 8 & 0xFF;
                    alphasLookup[0] = alpha0;
                    alphasLookup[1] = alpha1;
                    if (alpha0 > alpha1) {
                        alphasLookup[2] = (6 * alpha0 + 1 * alpha1) / 7;
                        alphasLookup[3] = (5 * alpha0 + 2 * alpha1) / 7;
                        alphasLookup[4] = (4 * alpha0 + 3 * alpha1) / 7;
                        alphasLookup[5] = (3 * alpha0 + 4 * alpha1) / 7;
                        alphasLookup[6] = (2 * alpha0 + 5 * alpha1) / 7;
                        alphasLookup[7] = (1 * alpha0 + 6 * alpha1) / 7;
                    } else {
                        alphasLookup[2] = (4 * alpha0 + 1 * alpha1) / 5;
                        alphasLookup[3] = (3 * alpha0 + 2 * alpha1) / 5;
                        alphasLookup[4] = (2 * alpha0 + 3 * alpha1) / 5;
                        alphasLookup[5] = (1 * alpha0 + 4 * alpha1) / 5;
                        alphasLookup[6] = 0;
                        alphasLookup[7] = 255;
                    }
                    int bits = bits0 >> 16;
                    for (int j = 0; j < 16; ++j) {
                        int lookup;
                        if (j == 5) {
                            lookup = (bits & 1) << 2 | bits1 & 3;
                            bits = bits1 >>> 2;
                        } else {
                            lookup = bits & 7;
                            bits >>>= 3;
                        }
                        alphas[j] = alphasLookup[lookup];
                    }
                }
            }
            int color = this.getInt32(this.buffer);
            int color0 = color >> 0 & 0xFFFF;
            int color1 = color >> 16 & 0xFFFF;
            int r0 = color0 >> 8 & 0xF8;
            int g0 = color0 >> 3 & 0xFC;
            int b0 = color0 << 3 & 0xF8;
            int r1 = color1 >> 8 & 0xF8;
            int g1 = color1 >> 3 & 0xFC;
            int b1 = color1 << 3 & 0xF8;
            if (color0 > color1) {
                r2 = (r0 * 2 + r1) / 3;
                g2 = (g0 * 2 + g1) / 3;
                b2 = (b0 * 2 + b1) / 3;
            } else {
                r2 = (r0 + r1) / 2;
                g2 = (g0 + g1) / 2;
                b2 = (b0 + b1) / 2;
            }
            if (color0 > color1 || dxtLevel > 1) {
                r3 = (r0 + r1 * 2) / 3;
                g3 = (g0 + g1 * 2) / 3;
                b3 = (b0 + b1 * 2) / 3;
            } else {
                r3 = 0;
                g3 = 0;
                b3 = 0;
            }
            colors[0] = (b0 & 0xFF) << 16 | (g0 & 0xFF) << 8 | r0 & 0xFF;
            colors[1] = (b1 & 0xFF) << 16 | (g1 & 0xFF) << 8 | r1 & 0xFF;
            colors[2] = (b2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | r2 & 0xFF;
            colors[3] = (b3 & 0xFF) << 16 | (g3 & 0xFF) << 8 | r3 & 0xFF;
            int bits = this.getInt32(this.buffer);
            int alphaIndex = 0;
            for (int y = 0; y < 4; ++y) {
                int x = 0;
                while (x < 4) {
                    int bgr = colors[bits & 3];
                    int alpha = alphas[alphaIndex] << 24;
                    this.storePixel(decompressedBuffer, strideX + x, strideY + y, bgr | alpha);
                    ++x;
                    bits >>>= 2;
                    ++alphaIndex;
                }
            }
            if ((strideX += 4) < this.width) continue;
            strideX = 0;
            strideY += 4;
        }
        this.buffer.rewind();
        this.compressedImage = false;
        this.buffer = decompressedBuffer;
        this.bufferWidth = this.width;
        this.bufferStorage = 3;
    }

    private void decompressImage() {
        switch (this.bufferStorage) {
            case 8: {
                this.decompressImageDXT(1);
                break;
            }
            case 9: {
                this.decompressImageDXT(3);
                break;
            }
            case 10: {
                this.decompressImageDXT(5);
                break;
            }
            default: {
                VideoEngine.log.warn("Unsupported compressed buffer storage " + this.bufferStorage);
            }
        }
    }
}

