/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class CaptureRAM {
    private int packetSize;
    private int address;
    private int length;
    private Buffer buffer;

    public CaptureRAM(int address, int length) throws IOException {
        this.packetSize = 8 + length;
        this.address = address;
        this.length = length;
        Memory mem = Memory.getInstance();
        if (Memory.isAddressGood(address)) {
            this.buffer = mem.getBuffer(address, length);
        }
        if (this.buffer == null) {
            throw new IOException(String.format("CaptureRAM: Unable to read buffer %08x - %08x", address, address + length));
        }
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(this.packetSize);
        data.writeInt(this.address);
        data.writeInt(this.length);
        if (this.buffer instanceof ByteBuffer) {
            WritableByteChannel channel = Channels.newChannel(out);
            channel.write((ByteBuffer)this.buffer);
        } else {
            IMemoryReader reader = MemoryReader.getMemoryReader(this.address, this.length, 1);
            for (int i = 0; i < this.length; ++i) {
                data.writeByte(reader.readNext());
            }
        }
        VideoEngine.log.info(String.format("Saved memory %08x - %08x (len %08x)", this.address, this.address + this.length, this.length));
    }

    private CaptureRAM() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaptureRAM read(InputStream in) throws IOException {
        CaptureRAM ramFragment = new CaptureRAM();
        DataInputStream data = new DataInputStream(in);
        int sizeRemaining = data.readInt();
        if (sizeRemaining < 8) throw new IOException("Not enough bytes remaining in stream");
        ramFragment.address = data.readInt();
        sizeRemaining -= 4;
        ramFragment.length = data.readInt();
        if ((sizeRemaining -= 4) > data.available()) {
            VideoEngine.log.warn("CaptureRAM read want=" + sizeRemaining + " available=" + data.available());
        }
        if (sizeRemaining < ramFragment.length) throw new IOException("Not enough bytes remaining in stream");
        ByteBuffer bb = ByteBuffer.allocate(ramFragment.length);
        byte[] b = bb.array();
        if (b == null) {
            throw new IOException("Buffer is not backed by an array");
        }
        data.readFully(b, 0, ramFragment.length);
        ramFragment.buffer = bb;
        data.skipBytes(sizeRemaining -= ramFragment.length);
        VideoEngine.log.info(String.format("Loaded memory %08x - %08x (len %08x)", ramFragment.address, ramFragment.address + ramFragment.length, ramFragment.length));
        return ramFragment;
    }

    public void commit() {
        Memory.getInstance().copyToMemory(this.address, (ByteBuffer)this.buffer, this.length);
    }

    public int getAddress() {
        return this.address;
    }

    public int getLength() {
        return this.length;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }
}

