/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.textures.Texture;
import jpcsp.util.CacheStatistics;

public class TextureCache {
    public static final int cacheMaxSize = 1000;
    public static final float cacheLoadFactor = 0.75f;
    private static TextureCache instance = null;
    private LinkedHashMap<Integer, Texture> cache;
    public CacheStatistics statistics = new CacheStatistics("Texture", 1000);
    private Set<Integer> textureAlreadyHashed;

    public static TextureCache getInstance() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    private TextureCache() {
        this.cache = new LinkedHashMap(1334, 0.75f, true);
        this.textureAlreadyHashed = new HashSet<Integer>();
    }

    private Integer getKey(int addr, int clutAddr) {
        return new Integer(addr + clutAddr);
    }

    public boolean hasTexture(int addr, int clutAddr) {
        return this.cache.containsKey(this.getKey(addr, clutAddr));
    }

    private Texture getTexture(int addr, int clutAddr) {
        return this.cache.get(this.getKey(addr, clutAddr));
    }

    public void addTexture(IRenderingEngine re, Texture texture) {
        Iterator<Map.Entry<Integer, Texture>> it;
        Integer key = this.getKey(texture.getAddr(), texture.getClutAddr());
        Texture previousTexture = this.cache.get(key);
        if (previousTexture != null) {
            previousTexture.deleteTexture(re);
        } else if (this.cache.size() >= 1000 && (it = this.cache.entrySet().iterator()).hasNext()) {
            Map.Entry<Integer, Texture> entry = it.next();
            entry.getValue().deleteTexture(re);
            it.remove();
            ++this.statistics.entriesRemoved;
        }
        this.cache.put(key, texture);
        if ((long)this.cache.size() > this.statistics.maxSizeUsed) {
            this.statistics.maxSizeUsed = this.cache.size();
        }
    }

    public Texture getTexture(int addr, int lineWidth, int width, int height, int pixelStorage, int clutAddr, int clutMode, int clutStart, int clutShift, int clutMask, int clutNumBlocks, int mipmapLevels, boolean mipmapShareClut, short[] values16, int[] values32) {
        ++this.statistics.totalHits;
        Texture texture = this.getTexture(addr, clutAddr);
        if (texture == null) {
            ++this.statistics.notPresentHits;
            return texture;
        }
        if (texture.equals(addr, lineWidth, width, height, pixelStorage, clutAddr, clutMode, clutStart, clutShift, clutMask, clutNumBlocks, mipmapLevels, mipmapShareClut, values16, values32)) {
            ++this.statistics.successfulHits;
            return texture;
        }
        ++this.statistics.changedHits;
        return null;
    }

    public void resetTextureAlreadyHashed() {
        this.textureAlreadyHashed.clear();
    }

    public boolean textureAlreadyHashed(int addr, int clutAddr) {
        return this.textureAlreadyHashed.contains(this.getKey(addr, clutAddr));
    }

    public void setTextureAlreadyHashed(int addr, int clutAddr) {
        this.textureAlreadyHashed.add(this.getKey(addr, clutAddr));
    }

    public void resetTextureAlreadyHashed(int addr, int clutAddr) {
        this.textureAlreadyHashed.remove(this.getKey(addr, clutAddr));
    }
}

