/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import jpcsp.media.MediaEngine;
import org.apache.log4j.Logger;

public class FileProtocolHandler
implements IURLProtocolHandler {
    private Logger log = MediaEngine.log;
    private File file;
    private RandomAccessFile stream;

    public FileProtocolHandler(String fileName) {
        this.file = new File(fileName);
    }

    @Override
    public boolean isStreamed(String url, int flags) {
        return false;
    }

    @Override
    public int close() {
        try {
            this.stream.close();
            this.stream = null;
        }
        catch (IOException e) {
            this.log.error(e);
        }
        return 0;
    }

    @Override
    public int open(String url, int flags) {
        String mode;
        if (this.stream != null) {
            this.close();
        }
        if (this.file == null) {
            this.file = new File(url);
        }
        switch (flags) {
            case 0: {
                mode = "r";
                break;
            }
            case 2: {
                mode = "rw";
                break;
            }
            case 1: {
                mode = "w";
                break;
            }
            default: {
                this.log.error(String.format("Unknown open flag %d", flags));
                return -1;
            }
        }
        try {
            this.stream = new RandomAccessFile(this.file, mode);
        }
        catch (FileNotFoundException e) {
            this.log.error(e);
            return -1;
        }
        return 0;
    }

    @Override
    public int read(byte[] buf, int size) {
        try {
            return this.stream.read(buf, 0, size);
        }
        catch (IOException e) {
            this.log.error(e);
            return -1;
        }
    }

    @Override
    public long seek(long offset, int whence) {
        try {
            long seek;
            switch (whence) {
                case 0: {
                    seek = offset;
                    break;
                }
                case 1: {
                    seek = this.stream.getFilePointer() + offset;
                    break;
                }
                case 2: {
                    seek = this.stream.length() + offset;
                    break;
                }
                case 65536: {
                    return this.stream.length();
                }
                default: {
                    this.log.error(String.format("Unknown seek whence %d", whence));
                    return -1L;
                }
            }
            this.stream.seek(seek);
            return seek;
        }
        catch (IOException e) {
            this.log.error(e);
            return -1L;
        }
    }

    @Override
    public int write(byte[] buf, int size) {
        try {
            this.stream.write(buf, 0, size);
            return size;
        }
        catch (IOException e) {
            this.log.error(e);
            return -1;
        }
    }
}

