/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import com.xuggle.ferry.Logger;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.State;
import jpcsp.connector.Connector;
import jpcsp.media.ExternalDecoder;
import jpcsp.media.FileProtocolHandler;
import jpcsp.media.StreamState;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Debug;
import jpcsp.util.FIFOByteBuffer;
import jpcsp.util.Utilities;

public class MediaEngine {
    public static org.apache.log4j.Logger log = Modules.log;
    protected static final int AVSEEK_FLAG_BACKWARD = 1;
    protected static final int AVSEEK_FLAG_BYTE = 2;
    protected static final int AVSEEK_FLAG_ANY = 4;
    protected static final int AVSEEK_FLAG_FRAME = 8;
    private static boolean initialized = false;
    private IContainer container;
    private int numStreams;
    private IStreamCoder videoCoder;
    private IStreamCoder audioCoder;
    private int videoStreamID;
    private int audioStreamID;
    private BufferedImage currentImg;
    private FIFOByteBuffer decodedAudioSamples;
    private int currentSamplesSize = 1024;
    private IVideoPicture videoPicture;
    private IAudioSamples audioSamples;
    private IConverter videoConverter;
    private IVideoResampler videoResampler;
    private int[] videoImagePixels;
    private int bufferAddress;
    private int bufferSize;
    private int bufferMpegOffset;
    private byte[] bufferData;
    private StreamState videoStreamState;
    private StreamState audioStreamState;
    private List<IPacket> freePackets = new LinkedList<IPacket>();
    private ExternalDecoder externalDecoder = new ExternalDecoder();
    private byte[] tempBuffer;
    private IContainer extContainer;

    public MediaEngine() {
        MediaEngine.initXuggler();
    }

    public static void initXuggler() {
        if (!initialized) {
            try {
                Logger.setGlobalIsLogging(Logger.Level.LEVEL_DEBUG, false);
                Logger.setGlobalIsLogging(Logger.Level.LEVEL_ERROR, false);
                Logger.setGlobalIsLogging(Logger.Level.LEVEL_INFO, false);
                Logger.setGlobalIsLogging(Logger.Level.LEVEL_TRACE, false);
                Logger.setGlobalIsLogging(Logger.Level.LEVEL_WARN, false);
            }
            catch (NoClassDefFoundError e) {
                log.warn("Xuggler is not available on your platform");
            }
            initialized = true;
        }
    }

    public IContainer getContainer() {
        return this.container;
    }

    public IContainer getAudioContainer() {
        if (this.audioStreamState == null) {
            return null;
        }
        return this.audioStreamState.getContainer();
    }

    public IContainer getExtContainer() {
        return this.extContainer;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public IStreamCoder getVideoCoder() {
        return this.videoCoder;
    }

    public IStreamCoder getAudioCoder() {
        return this.audioCoder;
    }

    public int getVideoStreamID() {
        return this.videoStreamID;
    }

    public int getAudioStreamID() {
        return this.audioStreamID;
    }

    public BufferedImage getCurrentImg() {
        return this.currentImg;
    }

    public int getCurrentAudioSamples(byte[] buffer) {
        if (this.decodedAudioSamples == null) {
            return 0;
        }
        int length = Math.min(buffer.length, this.decodedAudioSamples.length());
        if (length > 0) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, length);
            length = this.decodedAudioSamples.readByteBuffer(byteBuffer);
        }
        return length;
    }

    public int getAudioSamplesSize() {
        return this.currentSamplesSize;
    }

    public void setAudioSamplesSize(int newSize) {
        this.currentSamplesSize = newSize;
    }

    public void release(IPacket packet) {
        if (packet != null) {
            this.freePackets.add(packet);
        }
    }

    public IPacket getPacket() {
        if (!this.freePackets.isEmpty()) {
            return this.freePackets.remove(0);
        }
        return IPacket.make();
    }

    private boolean readAu(StreamState state, SceMpegAu au) {
        boolean successful = true;
        if (state == null) {
            au.dts = 0L;
            au.pts = 0L;
        } else {
            while (true) {
                if (!this.getNextPacket(state)) {
                    if (state == this.videoStreamState) {
                        state.incrementTimestamps(3003);
                    } else if (state == this.audioStreamState) {
                        state.incrementTimestamps(4180);
                    }
                    successful = false;
                    break;
                }
                state.updateTimestamps();
                if (state.getPts() >= 90000L) break;
                this.decodePacket(state, 0);
            }
            state.getTimestamps(au);
        }
        return successful;
    }

    public boolean readVideoAu(SceMpegAu au) {
        boolean successful = this.readAu(this.videoStreamState, au);
        if (au.pts >= 3003L) {
            au.dts = au.pts - 3003L;
        }
        return successful;
    }

    public boolean readAudioAu(SceMpegAu au) {
        boolean successful = this.readAu(this.audioStreamState, au);
        au.dts = -1L;
        return successful;
    }

    public void getCurrentAudioAu(SceMpegAu au) {
        if (this.audioStreamState != null) {
            this.audioStreamState.getTimestamps(au);
        } else {
            au.pts += 4180L;
        }
        au.dts = -1L;
    }

    public void getCurrentVideoAu(SceMpegAu au) {
        if (this.videoStreamState != null) {
            this.videoStreamState.getTimestamps(au);
        } else {
            au.pts += 3003L;
        }
        if (au.pts >= 3003L) {
            au.dts = au.pts - 3003L;
        }
    }

    private int read32(byte[] data, int offset) {
        int n1 = data[offset] & 0xFF;
        int n2 = data[offset + 1] & 0xFF;
        int n3 = data[offset + 2] & 0xFF;
        int n4 = data[offset + 3] & 0xFF;
        return n4 << 24 | n3 << 16 | n2 << 8 | n1;
    }

    public void init(byte[] bufferData) {
        this.bufferData = bufferData;
        this.bufferAddress = 0;
        this.bufferSize = Utilities.endianSwap32(this.read32(bufferData, 12));
        this.bufferMpegOffset = Utilities.endianSwap32(this.read32(bufferData, 8));
        this.init();
    }

    public void init(int bufferAddress, int bufferSize, int bufferMpegOffset) {
        this.bufferAddress = bufferAddress;
        this.bufferSize = bufferSize;
        this.bufferMpegOffset = bufferMpegOffset;
        this.bufferData = new byte[2048];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(bufferAddress, this.bufferData.length, 1);
        for (int i = 0; i < this.bufferData.length; ++i) {
            this.bufferData[i] = (byte)memoryReader.readNext();
        }
        this.init();
    }

    public void init() {
        this.finish();
        this.videoStreamID = -1;
        this.audioStreamID = -1;
    }

    public void init(IURLProtocolHandler channel, boolean decodeVideo, boolean decodeAudio) {
        this.init();
        this.container = IContainer.make();
        this.container.setReadRetryCount(-1);
        if (this.container.open(channel, IContainer.Type.READ, null) < 0) {
            log.error("MediaEngine: Invalid container format!");
        }
        this.numStreams = this.container.getNumStreams();
        for (int i = 0; i < this.numStreams; ++i) {
            IStream stream = this.container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (this.videoStreamID == -1 && coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.videoStreamID = i;
                this.videoCoder = coder;
                continue;
            }
            if (this.audioStreamID != -1 || coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            this.audioStreamID = i;
            this.audioCoder = coder;
        }
        if (decodeVideo) {
            if (this.videoStreamID == -1) {
                log.error("MediaEngine: No video streams found!");
            } else if (this.videoCoder.open() < 0) {
                this.videoCoder.delete();
                this.videoCoder = null;
                log.error("MediaEngine: Can't open video decoder!");
            } else {
                this.videoConverter = ConverterFactory.createConverter("XUGGLER-BGR-24", this.videoCoder.getPixelType(), this.videoCoder.getWidth(), this.videoCoder.getHeight());
                this.videoPicture = IVideoPicture.make(this.videoCoder.getPixelType(), this.videoCoder.getWidth(), this.videoCoder.getHeight());
                if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24) {
                    this.videoResampler = IVideoResampler.make(this.videoCoder.getWidth(), this.videoCoder.getHeight(), IPixelFormat.Type.BGR24, this.videoCoder.getWidth(), this.videoCoder.getHeight(), this.videoCoder.getPixelType());
                    this.videoPicture = IVideoPicture.make(this.videoResampler.getOutputPixelFormat(), this.videoPicture.getWidth(), this.videoPicture.getHeight());
                }
                this.videoStreamState = new StreamState(this, this.videoStreamID, this.container, 0);
            }
        }
        if (decodeAudio) {
            if (this.audioStreamID == -1) {
                if (!this.initExtAudio()) {
                    log.error("MediaEngine: No audio streams found!");
                    this.audioStreamState = new StreamState(this, -1, null, 90000);
                }
            } else if (this.audioCoder.open() < 0) {
                this.audioCoder.delete();
                this.audioCoder = null;
                log.error("MediaEngine: Can't open audio decoder!");
            } else {
                this.audioSamples = IAudioSamples.make(this.getAudioSamplesSize(), this.audioCoder.getChannels());
                this.decodedAudioSamples = new FIFOByteBuffer();
                this.audioStreamState = new StreamState(this, this.audioStreamID, this.container, 0);
            }
        }
    }

    private boolean getNextPacket(StreamState state) {
        if (state.isPacketEmpty()) {
            state.releasePacket();
            IPacket packet = state.getNextPacket();
            if (packet != null) {
                state.setPacket(packet);
            } else {
                IContainer container = state.getContainer();
                if (container == null) {
                    return false;
                }
                while (state.isPacketEmpty()) {
                    packet = this.getPacket();
                    if (container.readNextPacket(packet) < 0) {
                        this.release(packet);
                        return false;
                    }
                    int streamIndex = packet.getStreamIndex();
                    if (packet.getSize() <= 0) {
                        this.release(packet);
                        continue;
                    }
                    if (state.isStream(container, streamIndex)) {
                        state.setPacket(packet);
                        continue;
                    }
                    if (this.videoCoder != null && this.videoStreamState.isStream(container, streamIndex)) {
                        this.videoStreamState.addPacket(packet);
                        continue;
                    }
                    if (this.audioCoder != null && this.audioStreamState.isStream(container, streamIndex)) {
                        this.audioStreamState.addPacket(packet);
                        continue;
                    }
                    this.release(packet);
                }
            }
        }
        return true;
    }

    private boolean decodePacket(StreamState state, int requiredAudioBytes) {
        boolean complete = false;
        if (state == this.videoStreamState) {
            if (this.videoCoder == null) {
                state.releasePacket();
                complete = true;
            } else {
                complete = this.decodeVideoPacket(state);
            }
        } else if (state == this.audioStreamState) {
            if (this.audioCoder == null) {
                state.releasePacket();
                complete = true;
            } else if (this.decodeAudioPacket(state) && this.decodedAudioSamples.length() >= requiredAudioBytes) {
                complete = true;
            }
        }
        return complete;
    }

    private boolean decodeVideoPacket(StreamState state) {
        boolean complete = false;
        while (!state.isPacketEmpty()) {
            int decodedBytes = this.videoCoder.decodeVideo(this.videoPicture, state.getPacket(), state.getOffset());
            if (decodedBytes < 0) {
                state.releasePacket();
                break;
            }
            state.updateTimestamps();
            state.consume(decodedBytes);
            if (!this.videoPicture.isComplete()) continue;
            if (this.videoConverter != null) {
                this.currentImg = this.videoConverter.toImage(this.videoPicture);
            }
            complete = true;
            break;
        }
        return complete;
    }

    private boolean decodeAudioPacket(StreamState state) {
        boolean complete = false;
        while (!state.isPacketEmpty()) {
            int decodedBytes = this.audioCoder.decodeAudio(this.audioSamples, state.getPacket(), state.getOffset());
            if (decodedBytes < 0) {
                state.releasePacket();
                break;
            }
            state.updateTimestamps();
            state.consume(decodedBytes);
            if (!this.audioSamples.isComplete()) continue;
            this.updateSoundSamples(this.audioSamples);
            complete = true;
            break;
        }
        return complete;
    }

    public static String getExtAudioBasePath(int mpegStreamSize) {
        return String.format("%s%s\\Mpeg-%d\\", Connector.baseDirectory, State.discId, mpegStreamSize);
    }

    public static String getExtAudioPath(int mpegStreamSize, String suffix) {
        return String.format("%sExtAudio.%s", MediaEngine.getExtAudioBasePath(mpegStreamSize), suffix);
    }

    public boolean stepVideo() {
        return this.step(this.videoStreamState, 0);
    }

    public boolean stepAudio(int requiredAudioBytes) {
        boolean success = this.step(this.audioStreamState, requiredAudioBytes);
        if (this.decodedAudioSamples != null && this.decodedAudioSamples.length() > 0) {
            success = true;
        }
        return success;
    }

    private boolean step(StreamState state, int requiredAudioBytes) {
        boolean complete = false;
        if (state != null) {
            while (!complete && this.getNextPacket(state)) {
                complete = this.decodePacket(state, requiredAudioBytes);
            }
        }
        return complete;
    }

    private File getExtAudioFile() {
        String[] supportedFormats = new String[]{"wav", "mp3", "at3", "raw", "wma", "flac", "m4a"};
        for (int i = 0; i < supportedFormats.length; ++i) {
            File f = new File(MediaEngine.getExtAudioPath(this.bufferSize, supportedFormats[i]));
            if (!f.canRead() || f.length() <= 0L) continue;
            return f;
        }
        return null;
    }

    private boolean initExtAudio() {
        boolean useExtAudio = false;
        File extAudioFile = this.getExtAudioFile();
        if (extAudioFile == null && ExternalDecoder.isEnabled()) {
            if (this.bufferAddress == 0) {
                if (this.bufferData != null) {
                    this.externalDecoder.decodeExtAudio(this.bufferData, this.bufferSize, this.bufferMpegOffset);
                }
            } else {
                this.externalDecoder.decodeExtAudio(this.bufferAddress, this.bufferSize, this.bufferMpegOffset, this.bufferData);
            }
            extAudioFile = this.getExtAudioFile();
        }
        if (extAudioFile != null) {
            useExtAudio = this.initExtAudio(extAudioFile.toString());
        }
        return useExtAudio;
    }

    private boolean initExtAudio(String file) {
        FileProtocolHandler fileProtocolHandler;
        this.extContainer = IContainer.make();
        if (log.isDebugEnabled()) {
            log.debug(String.format("initExtAudio %s", file));
        }
        if (this.extContainer.open(fileProtocolHandler = new FileProtocolHandler(file), IContainer.Type.READ, null) < 0) {
            log.error("MediaEngine: Invalid file or container format: " + file);
            this.extContainer.close();
            this.extContainer = null;
            return false;
        }
        int extNumStreams = this.extContainer.getNumStreams();
        this.audioStreamID = -1;
        this.audioCoder = null;
        for (int i = 0; i < extNumStreams; ++i) {
            IStream stream = this.extContainer.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (this.audioStreamID != -1 || coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            this.audioStreamID = i;
            this.audioCoder = coder;
        }
        if (this.audioStreamID == -1) {
            log.error("MediaEngine: No audio streams found in external audio!");
            this.extContainer.close();
            this.extContainer = null;
            return false;
        }
        if (this.audioCoder.open() < 0) {
            log.error("MediaEngine: Can't open audio decoder!");
            this.extContainer.close();
            this.extContainer = null;
            return false;
        }
        this.audioSamples = IAudioSamples.make(this.getAudioSamplesSize(), this.audioCoder.getChannels());
        this.decodedAudioSamples = new FIFOByteBuffer();
        this.audioStreamState = new StreamState(this, this.audioStreamID, this.extContainer, 90000);
        this.audioStreamState.setTimestamps(90000L);
        log.info(String.format("Using external audio '%s'", file));
        return true;
    }

    public void finish() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        if (this.videoStreamState != null) {
            this.videoStreamState.finish();
            this.videoStreamState = null;
        }
        if (this.audioStreamState != null) {
            this.audioStreamState.finish();
            this.audioStreamState = null;
        }
        while (!this.freePackets.isEmpty()) {
            IPacket packet = this.getPacket();
            packet.delete();
        }
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder = null;
        }
        if (this.audioCoder != null) {
            this.audioCoder.close();
            this.audioCoder = null;
        }
        if (this.videoConverter != null) {
            this.videoConverter.delete();
            this.videoConverter = null;
        }
        if (this.videoPicture != null) {
            this.videoPicture.delete();
            this.videoPicture = null;
        }
        if (this.audioSamples != null) {
            this.audioSamples.delete();
            this.audioSamples = null;
        }
        if (this.videoResampler != null) {
            this.videoResampler.delete();
            this.videoResampler = null;
        }
        if (this.extContainer != null) {
            this.extContainer.close();
            this.extContainer = null;
        }
        if (this.decodedAudioSamples != null) {
            this.decodedAudioSamples.delete();
            this.decodedAudioSamples = null;
        }
        this.tempBuffer = null;
    }

    private int convertSamples(IAudioSamples samples, byte[] buffer, int length) {
        if (samples.getFormat() != IAudioSamples.Format.FMT_S16) {
            log.error("Unsupported audio samples format: " + (Object)((Object)samples.getFormat()));
            return length;
        }
        if (samples.getChannels() == 2) {
            return length;
        }
        if (samples.getChannels() != 1) {
            log.error("Unsupported number of audio channels: " + samples.getChannels());
            return length;
        }
        int samplesSize = length * 2;
        if (this.tempBuffer == null || samplesSize > this.tempBuffer.length) {
            this.tempBuffer = new byte[samplesSize];
        }
        int i = samplesSize - 4;
        int j = length - 2;
        while (i >= 0) {
            byte byte1 = buffer[j + 0];
            byte byte2 = buffer[j + 1];
            this.tempBuffer[i + 0] = byte1;
            this.tempBuffer[i + 1] = byte2;
            this.tempBuffer[i + 2] = byte1;
            this.tempBuffer[i + 3] = byte2;
            i -= 4;
            j -= 2;
        }
        return samplesSize;
    }

    private void updateSoundSamples(IAudioSamples samples) {
        int samplesSize = samples.getSize();
        if (this.tempBuffer == null || samplesSize > this.tempBuffer.length) {
            this.tempBuffer = new byte[samplesSize];
        }
        samples.get(0, this.tempBuffer, 0, samplesSize);
        samplesSize = this.convertSamples(samples, this.tempBuffer, samplesSize);
        this.decodedAudioSamples.write(this.tempBuffer, 0, samplesSize);
    }

    public void writeVideoImage(int dest_addr, int frameWidth, int videoPixelMode) {
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(videoPixelMode);
        if (this.getCurrentImg() != null) {
            int width = this.getCurrentImg().getWidth();
            int height = this.getCurrentImg().getHeight();
            int imageSize = height * width;
            BufferedImage image = this.getCurrentImg();
            if (image.getColorModel() instanceof ComponentColorModel && image.getRaster().getDataBuffer() instanceof DataBufferByte) {
                byte[] imageData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                if (videoPixelMode == 3) {
                    IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dest_addr, bytesPerPixel);
                    int i = 0;
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int b = imageData[i++] & 0xFF;
                            int g = imageData[i++] & 0xFF;
                            int r = imageData[i++] & 0xFF;
                            int colorABGR = 0xFF000000 | b << 16 | g << 8 | r;
                            memoryWriter.writeNext(colorABGR);
                        }
                        memoryWriter.skip(frameWidth - width);
                    }
                    memoryWriter.flush();
                } else {
                    IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dest_addr, bytesPerPixel);
                    int i = 0;
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int b = imageData[i++] & 0xFF;
                            int g = imageData[i++] & 0xFF;
                            int r = imageData[i++] & 0xFF;
                            int colorABGR = 0xFF000000 | b << 16 | g << 8 | r;
                            int pixelColor = Debug.getPixelColor(colorABGR, videoPixelMode);
                            memoryWriter.writeNext(pixelColor);
                        }
                        memoryWriter.skip(frameWidth - width);
                    }
                    memoryWriter.flush();
                }
            } else {
                if (this.videoImagePixels == null || this.videoImagePixels.length < imageSize) {
                    this.videoImagePixels = new int[imageSize];
                }
                this.videoImagePixels = image.getRGB(0, 0, width, height, this.videoImagePixels, 0, width);
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dest_addr, bytesPerPixel);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int colorARGB = this.videoImagePixels[y * width + x];
                        int a = colorARGB >>> 24 & 0xFF;
                        int r = colorARGB >>> 16 & 0xFF;
                        int g = colorARGB >>> 8 & 0xFF;
                        int b = colorARGB & 0xFF;
                        int colorABGR = a << 24 | b << 16 | g << 8 | r;
                        int pixelColor = Debug.getPixelColor(colorABGR, videoPixelMode);
                        memoryWriter.writeNext(pixelColor);
                    }
                    memoryWriter.skip(frameWidth - width);
                }
                memoryWriter.flush();
            }
        }
    }

    public void writeVideoImageWithRange(int dest_addr, int frameWidth, int videoPixelMode, int x, int y, int w, int h) {
        if (this.getCurrentImg() != null) {
            if (x == 0 && y == 0 && this.getCurrentImg().getWidth() == w && this.getCurrentImg().getHeight() == h) {
                this.writeVideoImage(dest_addr, frameWidth, videoPixelMode);
                return;
            }
            int imageSize = h * w;
            if (this.videoImagePixels == null || this.videoImagePixels.length < imageSize) {
                this.videoImagePixels = new int[imageSize];
            }
            this.videoImagePixels = this.getCurrentImg().getRGB(x, y, w, h, this.videoImagePixels, 0, w);
            int pixelIndex = 0;
            int bytesPerPixel = sceDisplay.getPixelFormatBytes(videoPixelMode);
            for (int i = 0; i < h; ++i) {
                int address = dest_addr + i * frameWidth * bytesPerPixel;
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, bytesPerPixel);
                int j = 0;
                while (j < w) {
                    int colorARGB = this.videoImagePixels[pixelIndex];
                    int a = colorARGB >>> 24 & 0xFF;
                    int r = colorARGB >>> 16 & 0xFF;
                    int g = colorARGB >>> 8 & 0xFF;
                    int b = colorARGB & 0xFF;
                    int colorABGR = a << 24 | b << 16 | g << 8 | r;
                    int pixelColor = Debug.getPixelColor(colorABGR, videoPixelMode);
                    memoryWriter.writeNext(pixelColor);
                    ++j;
                    ++pixelIndex;
                }
                memoryWriter.flush();
            }
        }
    }

    public void audioResetPlayPosition(int sample) {
        if (this.container != null && this.audioStreamID != -1 && this.container.seekKeyFrame(this.audioStreamID, sample, 12) < 0) {
            log.warn(String.format("Could not reset audio play position to %d", sample));
        }
    }
}

