/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import java.nio.ByteBuffer;
import jpcsp.HLE.Modules;
import jpcsp.media.MpegStream;
import org.apache.log4j.Logger;

public class MpegDemux {
    private static Logger log = Modules.log;
    public static final int PACKET_START_CODE_MASK = -256;
    public static final int PACKET_START_CODE_PREFIX = 256;
    public static final int SEQUENCE_START_CODE = 435;
    public static final int EXT_START_CODE = 437;
    public static final int SEQUENCE_END_CODE = 439;
    public static final int GOP_START_CODE = 440;
    public static final int ISO_11172_END_CODE = 441;
    public static final int PACK_START_CODE = 442;
    public static final int SYSTEM_HEADER_START_CODE = 443;
    public static final int PROGRAM_STREAM_MAP = 444;
    public static final int PRIVATE_STREAM_1 = 445;
    public static final int PADDING_STREAM = 446;
    public static final int PRIVATE_STREAM_2 = 447;
    private byte[] buffer;
    private int index;
    private int length;
    private ByteBuffer videoStream;
    private ByteBuffer audioStream;

    public MpegDemux(byte[] buffer, int offset) {
        this.buffer = buffer;
        this.index = offset;
        this.length = buffer.length;
    }

    private int read8() {
        return this.buffer[this.index++] & 0xFF;
    }

    private int read16() {
        return this.read8() << 8 | this.read8();
    }

    private long readPts() {
        return this.readPts(this.read8());
    }

    private long readPts(int c) {
        return (long)(c & 0xE) << 29 | (long)(this.read16() >> 1 << 15) | (long)(this.read16() >> 1);
    }

    private boolean isEOF() {
        return this.index >= this.length;
    }

    private void skip(int n) {
        if (n > 0) {
            this.index += n;
        }
    }

    private int readPesHeader(PesHeader pesHeader, int length, int startCode) {
        int c = 0;
        while (length > 0) {
            c = this.read8();
            --length;
            if (c == 255) continue;
        }
        if ((c & 0xC0) == 64) {
            this.read8();
            c = this.read8();
            length -= 2;
        }
        pesHeader.pts = 0L;
        pesHeader.dts = 0L;
        if ((c & 0xE0) == 32) {
            pesHeader.dts = pesHeader.pts = this.readPts(c);
            length -= 4;
            if ((c & 0x10) != 0) {
                pesHeader.dts = this.readPts();
                length -= 5;
            }
        } else if ((c & 0xC0) == 128) {
            int flags = this.read8();
            int headerLength = this.read8();
            length -= 2;
            length -= headerLength;
            if ((flags & 0x80) != 0) {
                pesHeader.dts = pesHeader.pts = this.readPts();
                headerLength -= 5;
                if ((flags & 0x40) != 0) {
                    pesHeader.dts = this.readPts();
                    headerLength -= 5;
                }
            }
            if ((flags & 0x3F) != 0 && headerLength == 0) {
                flags &= 0xC0;
            }
            if ((flags & 1) != 0) {
                int pesExt = this.read8();
                int skip = pesExt >> 4 & 0xB;
                skip += skip & 9;
                if ((pesExt & 0x40) != 0 || skip > --headerLength) {
                    skip = 0;
                    pesExt = 0;
                }
                this.skip(skip);
                headerLength -= skip;
                if ((pesExt & 1) != 0) {
                    int ext2Length = this.read8();
                    --headerLength;
                    if ((ext2Length & 0x7F) != 0) {
                        int idExt = this.read8();
                        --headerLength;
                        if ((idExt & 0x80) == 0) {
                            startCode = (startCode & 0xFF) << 8 | idExt;
                        }
                    }
                }
            }
            this.skip(headerLength);
        }
        if (startCode == 445) {
            int channel;
            pesHeader.channel = channel = this.read8();
            --length;
            if (channel >= 128 && channel <= 207) {
                this.skip(3);
                length -= 3;
                if (channel >= 176 && channel <= 191) {
                    this.skip(1);
                    --length;
                }
            } else {
                this.skip(3);
                length -= 3;
            }
        }
        return length;
    }

    private void demuxStream(boolean demuxStream, int startCode, int channel, ByteBuffer byteStream, boolean unescape) {
        int length = this.read16();
        if (demuxStream) {
            PesHeader pesHeader = new PesHeader(channel);
            length = this.readPesHeader(pesHeader, length, startCode);
            if (unescape) {
                MpegStream mpegStream = new MpegStream(this.buffer, this.index, length);
                while (!mpegStream.isEmpty()) {
                    int b = mpegStream.read8();
                    byteStream.put((byte)b);
                }
            } else {
                ByteBuffer mpegStream = ByteBuffer.wrap(this.buffer, this.index, length);
                byteStream.put(mpegStream);
            }
            this.skip(length);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Stream %X, channel %d, length %X", startCode, pesHeader.channel, length));
            }
        } else {
            this.skip(length);
        }
    }

    public void demux(boolean demuxVideo, boolean demuxAudio) {
        if (demuxVideo) {
            this.videoStream = ByteBuffer.allocate(this.length - this.index);
        }
        if (demuxAudio) {
            this.audioStream = ByteBuffer.allocate(this.length - this.index);
        }
        block7: while (this.index < this.length) {
            int startIndex = this.index;
            int startCode = 255;
            while ((startCode & 0xFFFFFF00) != 256 && !this.isEOF()) {
                startCode = startCode << 8 | this.read8();
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("StartCode 0x%08X, offset %08X, skipped %d", startCode, this.index, this.index - startIndex - 4));
            }
            switch (startCode) {
                case 442: {
                    this.skip(10);
                    continue block7;
                }
                case 443: {
                    this.skip(14);
                    continue block7;
                }
                case 446: 
                case 447: {
                    int length = this.read16();
                    this.skip(length);
                    continue block7;
                }
                case 445: {
                    this.demuxStream(demuxAudio, startCode, startCode, this.audioStream, false);
                    continue block7;
                }
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 484: 
                case 485: 
                case 486: 
                case 487: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: {
                    this.demuxStream(demuxVideo, startCode, startCode & 0xF, this.videoStream, true);
                    continue block7;
                }
            }
            log.warn(String.format("Unknown StartCode 0x%08X, offset %08X", startCode, this.index));
        }
        if (demuxAudio) {
            if (this.audioStream.position() > 0) {
                this.audioStream.limit(this.audioStream.position());
                this.audioStream.rewind();
            } else {
                this.audioStream = null;
            }
        }
        if (demuxVideo) {
            if (this.videoStream.position() > 0) {
                this.videoStream.limit(this.videoStream.position());
                this.videoStream.rewind();
            } else {
                this.videoStream = null;
            }
        }
    }

    public ByteBuffer getAudioStream() {
        return this.audioStream;
    }

    public ByteBuffer getVideoStream() {
        return this.videoStream;
    }

    private static class PesHeader {
        public long pts = 0L;
        public long dts = 0L;
        public int channel;

        public PesHeader(int channel) {
            this.channel = channel;
        }

        public String toString() {
            return String.format("PesHeader(channel=%d, pts=%d, dts=%d)", this.channel, this.pts, this.dts);
        }
    }
}

