/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IRational;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.media.MediaEngine;

public class StreamState {
    private static final long timestampMask = Long.MAX_VALUE;
    private MediaEngine me;
    private int streamID;
    private List<IPacket> pendingPackets;
    private IPacket packet;
    private int offset;
    private long dts;
    private long pts;
    private IContainer container;
    private int timestampOffset;

    public StreamState(MediaEngine me, int streamID, IContainer container, int timestampOffset) {
        this.me = me;
        this.streamID = streamID;
        this.container = container;
        this.timestampOffset = timestampOffset;
        this.pts = timestampOffset;
        this.dts = timestampOffset;
        this.pendingPackets = new LinkedList<IPacket>();
    }

    public IPacket getPacket() {
        return this.packet;
    }

    public void setPacket(IPacket packet) {
        this.packet = packet;
        this.offset = 0;
    }

    public void releasePacket() {
        if (this.packet != null) {
            this.me.release(this.packet);
            this.packet = null;
            this.offset = 0;
        }
    }

    public int getStreamID() {
        return this.streamID;
    }

    public int getOffset() {
        return this.offset;
    }

    public void consume(int bytes) {
        this.offset += bytes;
    }

    public IPacket getNextPacket() {
        if (this.pendingPackets.isEmpty()) {
            return null;
        }
        return this.pendingPackets.remove(0);
    }

    public void addPacket(IPacket packet) {
        this.pendingPackets.add(packet);
    }

    private long convertTimestamp(long ts, IRational timeBase, int timestampsPerSecond) {
        return Math.round((double)(ts & Long.MAX_VALUE) * timeBase.getDouble() * (double)timestampsPerSecond);
    }

    public void updateTimestamps() {
        if (this.getOffset() == 0) {
            this.dts = (long)this.timestampOffset + this.convertTimestamp(this.packet.getDts(), this.packet.getTimeBase(), 90000);
            this.pts = (long)this.timestampOffset + this.convertTimestamp(this.packet.getPts(), this.packet.getTimeBase(), 90000);
        } else {
            this.dts = -1L;
            this.pts = -1L;
        }
    }

    public void getTimestamps(SceMpegAu au) {
        au.pts = this.pts;
        au.dts = this.dts;
    }

    public void finish() {
        this.setTimestamps(0L);
        this.releasePacket();
        while (!this.pendingPackets.isEmpty()) {
            this.me.release(this.getNextPacket());
        }
    }

    public boolean isPacketEmpty() {
        return this.packet == null || this.offset >= this.packet.getSize();
    }

    public void incrementTimestamps(int step) {
        this.pts += (long)step;
        this.dts += (long)step;
    }

    public void setTimestamps(long ts) {
        this.pts = ts;
        this.dts = ts;
    }

    public boolean isStream(IContainer container, int streamID) {
        return this.getContainer() == container && this.getStreamID() == streamID;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public long getPts() {
        return this.pts;
    }

    public String toString() {
        return String.format("StreamID=%d, Pts=%d", this.getStreamID(), this.getPts());
    }
}

