/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class DebuggerMemory
extends Memory {
    public boolean traceMemoryRead = false;
    public boolean traceMemoryWrite = false;
    public boolean traceMemoryRead8 = false;
    public boolean traceMemoryWrite8 = false;
    public boolean traceMemoryRead16 = false;
    public boolean traceMemoryWrite16 = false;
    public boolean traceMemoryRead32 = false;
    public boolean traceMemoryWrite32 = false;
    public boolean pauseEmulatorOnMemoryBreakpoint = false;
    public static String mBrkFilePath = "Memory.mbrk";
    private HashSet<Integer> memoryReadBreakpoint;
    private HashSet<Integer> memoryWriteBreakpoint;
    private Memory mem;

    public DebuggerMemory(Memory mem) {
        this.mem = mem;
        this.initBreakpoints();
    }

    private void setBreakpointToken(String token) {
        if (token.equals("read")) {
            this.traceMemoryRead = true;
        } else if (token.equals("read8")) {
            this.traceMemoryRead8 = true;
        } else if (token.equals("read16")) {
            this.traceMemoryRead16 = true;
        } else if (token.equals("read32")) {
            this.traceMemoryRead32 = true;
        } else if (token.equals("write")) {
            this.traceMemoryWrite = true;
        } else if (token.equals("write8")) {
            this.traceMemoryWrite8 = true;
        } else if (token.equals("write16")) {
            this.traceMemoryWrite16 = true;
        } else if (token.equals("write32")) {
            this.traceMemoryWrite32 = true;
        } else if (token.equals("pause")) {
            this.pauseEmulatorOnMemoryBreakpoint = true;
        } else {
            log.error(String.format("Unknown token '%s'", token));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initBreakpoints() {
        this.memoryReadBreakpoint = new HashSet();
        this.memoryWriteBreakpoint = new HashSet();
        BufferedReader in = null;
        try {
            String line;
            File f = new File(mBrkFilePath);
            in = new BufferedReader(new FileReader(f));
            while (in != null && (line = in.readLine()) != null) {
                int rangeIndex = (line = line.trim()).indexOf("-");
                if (rangeIndex >= 0) {
                    int end;
                    if (line.startsWith("RW ")) {
                        int start = Utilities.parseAddress(line.substring(2, rangeIndex));
                        end = Utilities.parseAddress(line.substring(rangeIndex + 1));
                        this.addRangeReadWriteBreakpoint(start, end);
                        continue;
                    }
                    if (line.startsWith("R ")) {
                        int start = Utilities.parseAddress(line.substring(1, rangeIndex));
                        end = Utilities.parseAddress(line.substring(rangeIndex + 1));
                        this.addRangeReadBreakpoint(start, end);
                        continue;
                    }
                    if (!line.startsWith("W ")) continue;
                    int start = Utilities.parseAddress(line.substring(1, rangeIndex));
                    end = Utilities.parseAddress(line.substring(rangeIndex + 1));
                    this.addRangeWriteBreakpoint(start, end);
                    continue;
                }
                if (line.startsWith("RW ")) {
                    int address = Utilities.parseAddress(line.substring(2));
                    this.addReadWriteBreakpoint(address);
                    continue;
                }
                if (line.startsWith("R ")) {
                    int address = Utilities.parseAddress(line.substring(1));
                    this.addReadBreakpoint(address);
                    continue;
                }
                if (line.startsWith("W ")) {
                    int address = Utilities.parseAddress(line.substring(1));
                    this.addWriteBreakpoint(address);
                    continue;
                }
                if (line.startsWith("#")) continue;
                String[] tokens = line.split("\\|");
                for (int i = 0; tokens != null && i < tokens.length; ++i) {
                    String token = tokens[i].trim().toLowerCase();
                    this.setBreakpointToken(token);
                }
            }
        }
        catch (IOException iOException) {
            Utilities.close(in);
            catch (Throwable throwable) {
                Utilities.close(in);
                throw throwable;
            }
        }
        Utilities.close(in);
    }

    public static void install() {
        log.info("Using DebuggerMemory");
        Memory mem = Memory.getInstance();
        if (!(mem instanceof DebuggerMemory)) {
            DebuggerMemory debuggerMemory = new DebuggerMemory(mem);
            Memory.setInstance(debuggerMemory);
        }
    }

    public static void deinstall() {
        Memory mem = Memory.getInstance();
        if (mem instanceof DebuggerMemory) {
            DebuggerMemory debuggerMemory = (DebuggerMemory)mem;
            Memory.setInstance(debuggerMemory.mem);
        }
    }

    public void addReadBreakpoint(int address) {
        this.memoryReadBreakpoint.add(address &= 0x3FFFFFFF);
    }

    public void removeReadBreakpoint(int address) {
        this.memoryReadBreakpoint.remove(address &= 0x3FFFFFFF);
    }

    public void addRangeReadBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.addReadBreakpoint(address);
        }
    }

    public void removeRangeReadBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.removeReadBreakpoint(address);
        }
    }

    public void addWriteBreakpoint(int address) {
        this.memoryWriteBreakpoint.add(address &= 0x3FFFFFFF);
    }

    public void removeWriteBreakpoint(int address) {
        this.memoryWriteBreakpoint.remove(address &= 0x3FFFFFFF);
    }

    public void addRangeWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.addWriteBreakpoint(address);
        }
    }

    public void removeRangeWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.removeWriteBreakpoint(address);
        }
    }

    public void addReadWriteBreakpoint(int address) {
        this.memoryReadBreakpoint.add(address &= 0x3FFFFFFF);
        this.memoryWriteBreakpoint.add(address);
    }

    public void removeReadWriteBreakpoint(int address) {
        this.memoryReadBreakpoint.remove(address &= 0x3FFFFFFF);
        this.memoryWriteBreakpoint.remove(address);
    }

    public void addRangeReadWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.addReadWriteBreakpoint(address);
        }
    }

    public void removeRangeReadWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.removeReadWriteBreakpoint(address);
        }
    }

    protected String getMemoryReadMessage(int address, int width) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("0x%08X - ", Emulator.getProcessor().cpu.pc));
        if (width == 8 || width == 16 || width == 32) {
            message.append(String.format("read%d(0x%08X)=0x", width, address));
            if (width == 8) {
                message.append(String.format("%02X", this.mem.read8(address)));
            } else if (width == 16) {
                message.append(String.format("%04X", this.mem.read16(address)));
            } else if (width == 32) {
                int value = this.mem.read32(address);
                message.append(String.format("%08X (%f)", value, Float.valueOf(Float.intBitsToFloat(value))));
            }
        } else {
            int length = width / 8;
            message.append(String.format("read 0x%08X-0x%08X (length=%d)", address, address + length, length));
        }
        return message.toString();
    }

    protected void memoryRead(int address, int width, boolean trace) {
        address &= 0x3FFFFFFF;
        if ((this.traceMemoryRead || trace) && log.isTraceEnabled()) {
            log.trace(this.getMemoryReadMessage(address, width));
        }
        if (this.memoryReadBreakpoint.contains(address)) {
            log.info(this.getMemoryReadMessage(address, width));
            if (this.pauseEmulatorOnMemoryBreakpoint) {
                Emulator.PauseEmuWithStatus(16);
            }
        }
    }

    protected String getMemoryWriteMessage(int address, int value, int width) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("0x%08X - ", Emulator.getProcessor().cpu.pc));
        message.append(String.format("write%d(0x%08X, 0x", width, address));
        if (width == 8) {
            message.append(String.format("%02X", value & 0xFF));
        } else if (width == 16) {
            message.append(String.format("%04X", value & 0xFFFF));
        } else if (width == 32) {
            message.append(String.format("%08X (%f)", value, Float.valueOf(Float.intBitsToFloat(value))));
        }
        message.append(")");
        return message.toString();
    }

    protected void memoryWrite(int address, int value, int width, boolean trace) {
        address &= 0x3FFFFFFF;
        if ((this.traceMemoryWrite || trace) && log.isTraceEnabled()) {
            log.trace(this.getMemoryWriteMessage(address, value, width));
        }
        if (this.memoryWriteBreakpoint.contains(address)) {
            log.info(this.getMemoryWriteMessage(address, value, width));
            if (this.pauseEmulatorOnMemoryBreakpoint) {
                Emulator.PauseEmuWithStatus(16);
            }
        }
    }

    @Override
    public void Initialise() {
        this.mem.Initialise();
    }

    @Override
    public boolean allocate() {
        return this.mem.allocate();
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        for (int i = 0; i < length && source.hasRemaining(); ++i) {
            byte value = source.get();
            this.write8(address + i, value);
        }
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        this.memoryRead(address, length * 8, false);
        return this.mem.getBuffer(address, length);
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return this.mem.getMainMemoryByteBuffer();
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        for (int i = 0; i < length; ++i) {
            this.write8(destination + i, (byte)this.mem.read8(source + i));
        }
    }

    @Override
    public void memset(int address, byte data, int length) {
        for (int i = 0; i < length; ++i) {
            this.write8(address + i, data);
        }
    }

    @Override
    public int read8(int address) {
        this.memoryRead(address, 8, this.traceMemoryRead8);
        return this.mem.read8(address);
    }

    @Override
    public int read16(int address) {
        this.memoryRead(address, 16, this.traceMemoryRead16);
        return this.mem.read16(address);
    }

    @Override
    public int read32(int address) {
        this.memoryRead(address, 32, this.traceMemoryRead32);
        return this.mem.read32(address);
    }

    @Override
    public void write8(int address, byte data) {
        this.memoryWrite(address, data, 8, this.traceMemoryWrite8);
        this.mem.write8(address, data);
    }

    @Override
    public void write16(int address, short data) {
        this.memoryWrite(address, data, 16, this.traceMemoryWrite16);
        this.mem.write16(address, data);
    }

    @Override
    public void write32(int address, int data) {
        this.memoryWrite(address, data, 32, this.traceMemoryWrite32);
        this.mem.write32(address, data);
    }
}

