/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class ImageReader {
    public static IMemoryReader getImageReader(int address, int width, int height, int bufferWidth, int pixelFormat, boolean swizzle, int clutAddr, int clutMode, int clutNumBlocks, int clutStart, int clutShift, int clutMask) {
        int byteSize = ImageReader.getImageByteSize(width, height, bufferWidth, pixelFormat);
        IMemoryReader imageReader = MemoryReader.getMemoryReader(address, byteSize, 4);
        if (swizzle) {
            imageReader = new SwizzleDecoder(imageReader, bufferWidth, ImageReader.getBytesPerPixel(pixelFormat));
        }
        boolean hasClut = false;
        boolean isCompressed = false;
        switch (pixelFormat) {
            case 2: {
                imageReader = new Value32to16Decoder(imageReader);
                imageReader = new PixelFormat4444Decoder(imageReader);
                break;
            }
            case 1: {
                imageReader = new Value32to16Decoder(imageReader);
                imageReader = new PixelFormat5551Decoder(imageReader);
                break;
            }
            case 0: {
                imageReader = new Value32to16Decoder(imageReader);
                imageReader = new PixelFormat565Decoder(imageReader);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                imageReader = new Value32to4Decoder(imageReader);
                imageReader = clutStart == 0 && clutShift == 0 && clutMask == 255 ? new SimpleClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks) : new ClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks, clutStart, clutShift, clutMask);
                hasClut = true;
                break;
            }
            case 5: {
                imageReader = new Value32to8Decoder(imageReader);
                imageReader = clutStart == 0 && clutShift == 0 && clutMask == 255 ? new SimpleClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks) : new ClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks, clutStart, clutShift, clutMask);
                hasClut = true;
                break;
            }
            case 6: {
                imageReader = new Value32to16Decoder(imageReader);
                imageReader = clutStart == 0 && clutShift == 0 && clutMask == 255 ? new SimpleClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks) : new ClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks, clutStart, clutShift, clutMask);
                hasClut = true;
                break;
            }
            case 7: {
                imageReader = clutStart == 0 && clutShift == 0 && clutMask == 255 ? new SimpleClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks) : new ClutDecoder(imageReader, clutAddr, clutMode, clutNumBlocks, clutStart, clutShift, clutMask);
                hasClut = true;
                break;
            }
            case 8: {
                imageReader = new DXT1Decoder(imageReader, width, height);
                isCompressed = true;
                break;
            }
            case 9: {
                imageReader = new DXT3Decoder(imageReader, width, height);
                isCompressed = true;
                break;
            }
            case 10: {
                imageReader = new DXT5Decoder(imageReader, width, height);
                isCompressed = true;
            }
        }
        if (hasClut) {
            switch (clutMode) {
                case 0: {
                    imageReader = new PixelFormat565Decoder(imageReader);
                    break;
                }
                case 1: {
                    imageReader = new PixelFormat5551Decoder(imageReader);
                    break;
                }
                case 2: {
                    imageReader = new PixelFormat4444Decoder(imageReader);
                    break;
                }
            }
        }
        if (!isCompressed && bufferWidth > width) {
            imageReader = new MemoryImageDecoder(imageReader, width, bufferWidth);
        }
        return imageReader;
    }

    public static int color4444to8888(int color4444) {
        return color4444 & 0xF | color4444 << 4 & 0xFF0 | color4444 << 8 & 0xFF000 | color4444 << 12 & 0xFF00000 | color4444 << 16 & 0xF0000000;
    }

    public static int color5551to8888(int color5551) {
        return color5551 << 3 & 0xF8 | color5551 >> 2 & 7 | color5551 << 6 & 0xF800 | color5551 << 1 & 0x700 | color5551 << 9 & 0xF80000 | color5551 << 4 & 0x70000 | (color5551 >> 15) * -16777216;
    }

    public static int color565to8888(int color565) {
        return color565 << 3 & 0xF8 | color565 >> 2 & 7 | color565 << 5 & 0xFC00 | color565 >> 1 & 0x300 | color565 << 8 & 0xF80000 | color565 << 3 & 0x70000 | 0xFF000000;
    }

    public static int colorABGRtoARGB(int colorABGR) {
        return colorABGR & 0xFF00FF00 | (colorABGR & 0xFF) << 16 | (colorABGR & 0xFF0000) >> 16;
    }

    public static int getBytesPerPixel(int pixelFormat) {
        switch (pixelFormat) {
            case 0: 
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 0;
            }
            case 9: 
            case 10: {
                return 1;
            }
        }
        return -1;
    }

    public static int getImageByteSize(int width, int height, int bufferWidth, int pixelFormat) {
        switch (pixelFormat) {
            case 4: {
                return height * bufferWidth / 2;
            }
            case 8: {
                return ImageReader.round4(height) * ImageReader.round4(width) / 2;
            }
            case 9: 
            case 10: {
                return ImageReader.round4(height) * ImageReader.round4(width);
            }
        }
        return height * bufferWidth * ImageReader.getBytesPerPixel(pixelFormat);
    }

    public static int round4(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    private static final class DXT5Decoder
    extends DXTDecoder {
        private int[] alpha = new int[8];
        private long alphaLookup;

        public DXT5Decoder(IMemoryReader memoryReader, int width, int height) {
            super(memoryReader, width, height, 5, 4);
        }

        @Override
        protected void storePixels(int strideX, int bits) {
            for (int y = 0; y < 4; ++y) {
                int x = 0;
                while (x < 4) {
                    int alphaPixel = this.alpha[(int)this.alphaLookup & 3];
                    this.buffer[y * this.width + x + strideX] = this.colors[bits & 3] | alphaPixel << 24;
                    ++x;
                    bits >>>= 2;
                    this.alphaLookup >>>= 2;
                }
            }
        }

        @Override
        protected void readAlpha() {
            this.alphaLookup = this.memoryReader.readNext();
            int value = this.memoryReader.readNext();
            this.alphaLookup |= (long)(value & 0xFFFF) << 32;
            int alpha0 = (value >>>= 16) & 0xFF;
            int alpha1 = value >> 8;
            this.alpha[0] = alpha0;
            this.alpha[1] = alpha1;
            if (alpha0 > alpha1) {
                this.alpha[2] = (6 * alpha0 + alpha1) / 7;
                this.alpha[3] = (5 * alpha0 + 2 * alpha1) / 7;
                this.alpha[4] = (4 * alpha0 + 3 * alpha1) / 7;
                this.alpha[5] = (3 * alpha0 + 4 * alpha1) / 7;
                this.alpha[6] = (2 * alpha0 + 5 * alpha1) / 7;
                this.alpha[7] = (alpha0 + 6 * alpha1) / 7;
            } else {
                this.alpha[2] = (4 * alpha0 + alpha1) / 5;
                this.alpha[3] = (3 * alpha0 + 2 * alpha1) / 5;
                this.alpha[4] = (2 * alpha0 + 3 * alpha1) / 5;
                this.alpha[5] = (alpha0 + 4 * alpha1) / 5;
                this.alpha[6] = 0;
                this.alpha[7] = 255;
            }
        }
    }

    private static final class DXT3Decoder
    extends DXTDecoder {
        private long alpha;

        public DXT3Decoder(IMemoryReader memoryReader, int width, int height) {
            super(memoryReader, width, height, 3, 4);
        }

        @Override
        protected void storePixels(int strideX, int bits) {
            for (int y = 0; y < 4; ++y) {
                int x = 0;
                while (x < 4) {
                    int pixelAlpha = (int)this.alpha & 0xF;
                    pixelAlpha |= pixelAlpha << 4;
                    this.buffer[y * this.width + x + strideX] = this.colors[bits & 3] | pixelAlpha << 24;
                    ++x;
                    bits >>>= 2;
                    this.alpha >>>= 4;
                }
            }
        }

        @Override
        protected void readAlpha() {
            this.alpha = this.memoryReader.readNext();
            this.alpha |= (long)this.memoryReader.readNext() << 32;
        }
    }

    private static final class DXT1Decoder
    extends DXTDecoder {
        public DXT1Decoder(IMemoryReader memoryReader, int width, int height) {
            super(memoryReader, width, height, 1, 8);
        }

        @Override
        protected void storePixels(int strideX, int bits) {
            this.colors[0] = this.colors[0] | 0xFF000000;
            this.colors[1] = this.colors[1] | 0xFF000000;
            this.colors[2] = this.colors[2] | 0xFF000000;
            for (int y = 0; y < 4; ++y) {
                int x = 0;
                while (x < 4) {
                    this.buffer[y * this.width + x + strideX] = this.colors[bits & 3];
                    ++x;
                    bits >>>= 2;
                }
            }
        }

        @Override
        protected void readAlpha() {
        }
    }

    private static abstract class DXTDecoder
    extends ImageDecoder {
        protected int width;
        protected int dxtLevel;
        protected int[] buffer;
        protected int index;
        protected int maxIndex;
        protected int[] colors;

        public DXTDecoder(IMemoryReader memoryReader, int width, int height, int dxtLevel, int compressionRatio) {
            super(memoryReader);
            this.width = width;
            this.dxtLevel = dxtLevel;
            this.buffer = new int[width * 4];
            this.index = this.maxIndex = width * 4;
            this.colors = new int[4];
        }

        @Override
        public int readNext() {
            if (this.index >= this.maxIndex) {
                for (int strideX = 0; strideX < this.width; strideX += 4) {
                    int b3;
                    int g3;
                    int r3;
                    int b2;
                    int g2;
                    int r2;
                    int bits = this.memoryReader.readNext();
                    int color = this.memoryReader.readNext();
                    this.readAlpha();
                    int color0 = color >> 0 & 0xFFFF;
                    int color1 = color >> 16 & 0xFFFF;
                    int r0 = color0 >> 8 & 0xF8;
                    int g0 = color0 >> 3 & 0xFC;
                    int b0 = color0 << 3 & 0xF8;
                    int r1 = color1 >> 8 & 0xF8;
                    int g1 = color1 >> 3 & 0xFC;
                    int b1 = color1 << 3 & 0xF8;
                    if (color0 > color1) {
                        r2 = (r0 * 2 + r1) / 3;
                        g2 = (g0 * 2 + g1) / 3;
                        b2 = (b0 * 2 + b1) / 3;
                    } else {
                        r2 = (r0 + r1) / 2;
                        g2 = (g0 + g1) / 2;
                        b2 = (b0 + b1) / 2;
                    }
                    if (color0 > color1 || this.dxtLevel > 1) {
                        r3 = (r0 + r1 * 2) / 3;
                        g3 = (g0 + g1 * 2) / 3;
                        b3 = (b0 + b1 * 2) / 3;
                    } else {
                        r3 = 0;
                        g3 = 0;
                        b3 = 0;
                    }
                    this.colors[0] = b0 << 16 | g0 << 8 | r0;
                    this.colors[1] = b1 << 16 | g1 << 8 | r1;
                    this.colors[2] = b2 << 16 | g2 << 8 | r2;
                    this.colors[3] = b3 << 16 | g3 << 8 | r3;
                    this.storePixels(strideX, bits);
                }
                this.index = 0;
            }
            return this.buffer[this.index++];
        }

        protected abstract void storePixels(int var1, int var2);

        protected abstract void readAlpha();
    }

    private static final class SimpleClutDecoder
    extends ClutDecoder {
        public SimpleClutDecoder(IMemoryReader memoryReader, int clutMode, int clutAddr, int clutNumBlocks) {
            super(memoryReader, clutMode, clutAddr, clutNumBlocks, 0, 0, 255);
        }

        @Override
        protected int getClutIndex(int index) {
            return index;
        }

        @Override
        public int readNext() {
            int index = this.memoryReader.readNext();
            return this.clut[index];
        }
    }

    private static class ClutDecoder
    extends ImageDecoder {
        protected int[] clut;
        protected int clutAddr;
        protected int clutNumBlocks;
        protected int clutStart;
        protected int clutShift;
        protected int clutMask;
        protected int clutEntrySize;

        public ClutDecoder(IMemoryReader memoryReader, int clutAddr, int clutMode, int clutNumBlocks, int clutStart, int clutShift, int clutMask) {
            super(memoryReader);
            this.clutAddr = clutAddr;
            this.clutNumBlocks = clutNumBlocks;
            this.clutStart = clutStart;
            this.clutShift = clutShift;
            this.clutMask = clutMask;
            this.clutEntrySize = clutMode == 3 ? 4 : 2;
            this.readClut();
        }

        protected int getClutAddr() {
            return this.clutAddr + (this.clutStart << 4) * this.clutEntrySize;
        }

        protected void readClut() {
            int clutNumEntries = this.clutNumBlocks * 32 / this.clutEntrySize;
            this.clut = new int[clutNumEntries];
            int clutOffset = this.clutStart << 4;
            IMemoryReader clutReader = MemoryReader.getMemoryReader(this.getClutAddr(), (clutNumEntries - this.clutStart) * this.clutEntrySize, this.clutEntrySize);
            for (int i = clutOffset; i < clutNumEntries; ++i) {
                this.clut[i] = clutReader.readNext();
            }
        }

        protected int getClutIndex(int index) {
            return index >> this.clutShift & this.clutMask | this.clutStart << 4;
        }

        @Override
        public int readNext() {
            int index = this.memoryReader.readNext();
            return this.clut[this.getClutIndex(index)];
        }
    }

    private static final class MemoryImageDecoder
    extends ImageDecoder {
        private int minWidth;
        private int skipWidth;
        private int x;

        public MemoryImageDecoder(IMemoryReader memoryReader, int width, int bufferWidth) {
            super(memoryReader);
            this.minWidth = Math.min(width, bufferWidth);
            this.skipWidth = Math.max(0, bufferWidth - width);
            this.x = 0;
        }

        @Override
        public int readNext() {
            if (this.x >= this.minWidth) {
                this.memoryReader.skip(this.skipWidth);
                this.x = 0;
            }
            ++this.x;
            return this.memoryReader.readNext();
        }
    }

    private static final class SwizzleDecoder
    extends ImageDecoder {
        private int[] buffer;
        private int index;
        private int maxIndex;
        private int rowWidth;
        private int pitch;
        private int bxc;

        public SwizzleDecoder(IMemoryReader memoryReader, int bufferWidth, int bytesPerPixel) {
            super(memoryReader);
            this.rowWidth = bytesPerPixel > 0 ? bufferWidth * bytesPerPixel : bufferWidth / 2;
            this.pitch = this.rowWidth / 4;
            this.bxc = this.rowWidth / 16;
            this.buffer = new int[this.pitch * 8];
            this.index = this.maxIndex = this.buffer.length;
        }

        @Override
        public int readNext() {
            if (this.index >= this.maxIndex) {
                int xdest = 0;
                if (this.rowWidth >= 16) {
                    for (int bx = 0; bx < this.bxc; ++bx) {
                        int dest = xdest;
                        for (int n = 0; n < 8; ++n) {
                            this.buffer[dest] = this.memoryReader.readNext();
                            this.buffer[dest + 1] = this.memoryReader.readNext();
                            this.buffer[dest + 2] = this.memoryReader.readNext();
                            this.buffer[dest + 3] = this.memoryReader.readNext();
                            dest += this.pitch;
                        }
                        xdest += 4;
                    }
                } else if (this.rowWidth == 8) {
                    int n = 0;
                    while (n < 8) {
                        this.buffer[xdest] = this.memoryReader.readNext();
                        this.buffer[xdest + 1] = this.memoryReader.readNext();
                        this.memoryReader.skip(2);
                        ++n;
                        xdest += 2;
                    }
                } else if (this.rowWidth == 4) {
                    int n = 0;
                    while (n < 8) {
                        this.buffer[xdest] = this.memoryReader.readNext();
                        this.memoryReader.skip(3);
                        ++n;
                        ++xdest;
                    }
                } else if (this.rowWidth == 2) {
                    int n = 0;
                    while (n < 4) {
                        int n1 = this.memoryReader.readNext() & 0xFFFF;
                        this.memoryReader.skip(3);
                        int n2 = this.memoryReader.readNext() & 0xFFFF;
                        this.memoryReader.skip(3);
                        this.buffer[xdest] = n1 | n2 << 16;
                        ++n;
                        ++xdest;
                    }
                } else if (this.rowWidth == 1) {
                    int n = 0;
                    while (n < 2) {
                        int n1 = this.memoryReader.readNext() & 0xFF;
                        this.memoryReader.skip(3);
                        int n2 = this.memoryReader.readNext() & 0xFF;
                        this.memoryReader.skip(3);
                        int n3 = this.memoryReader.readNext() & 0xFF;
                        this.memoryReader.skip(3);
                        int n4 = this.memoryReader.readNext() & 0xFF;
                        this.memoryReader.skip(3);
                        this.buffer[xdest] = n1 | n2 << 8 | n3 << 16 | n4 << 24;
                        ++n;
                        ++xdest;
                    }
                }
                this.index = 0;
            }
            return this.buffer[this.index++];
        }
    }

    private static final class PixelFormat4444Decoder
    extends ImageDecoder {
        public PixelFormat4444Decoder(IMemoryReader memoryReader) {
            super(memoryReader);
        }

        @Override
        public int readNext() {
            return ImageReader.color4444to8888(this.memoryReader.readNext());
        }
    }

    private static final class PixelFormat565Decoder
    extends ImageDecoder {
        public PixelFormat565Decoder(IMemoryReader memoryReader) {
            super(memoryReader);
        }

        @Override
        public int readNext() {
            return ImageReader.color565to8888(this.memoryReader.readNext());
        }
    }

    private static final class PixelFormat5551Decoder
    extends ImageDecoder {
        public PixelFormat5551Decoder(IMemoryReader memoryReader) {
            super(memoryReader);
        }

        @Override
        public int readNext() {
            return ImageReader.color5551to8888(this.memoryReader.readNext());
        }
    }

    private static final class Value32to4Decoder
    extends ImageDecoder {
        private int index = 8;
        private int value;

        public Value32to4Decoder(IMemoryReader memoryReader) {
            super(memoryReader);
        }

        @Override
        public int readNext() {
            if (this.index == 8) {
                this.index = 0;
                this.value = this.memoryReader.readNext();
            }
            int n = this.value & 0xF;
            this.value >>= 4;
            ++this.index;
            return n;
        }
    }

    private static final class Value32to8Decoder
    extends ImageDecoder {
        private int index = 4;
        private int value;

        public Value32to8Decoder(IMemoryReader memoryReader) {
            super(memoryReader);
        }

        @Override
        public int readNext() {
            if (this.index == 4) {
                this.index = 0;
                this.value = this.memoryReader.readNext();
            }
            int n = this.value & 0xFF;
            this.value >>= 8;
            ++this.index;
            return n;
        }
    }

    private static final class Value32to16Decoder
    extends ImageDecoder {
        private int index = 0;
        private int value;

        public Value32to16Decoder(IMemoryReader memoryReader) {
            super(memoryReader);
        }

        @Override
        public int readNext() {
            if (this.index == 0) {
                this.value = this.memoryReader.readNext();
                this.index = 1;
                return this.value & 0xFFFF;
            }
            this.index = 0;
            return this.value >>> 16;
        }
    }

    private static abstract class ImageDecoder
    implements IMemoryReader {
        protected IMemoryReader memoryReader;

        public ImageDecoder(IMemoryReader memoryReader) {
            this.memoryReader = memoryReader;
        }

        @Override
        public void skip(int n) {
            for (int i = 0; i < n; ++i) {
                this.readNext();
            }
        }
    }
}

