/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.IMemoryReader;

public class MemoryReader {
    private static int getMaxLength(int address) {
        int length = address >= 0x8000000 && address <= MemoryMap.END_RAM ? MemoryMap.END_RAM - address + 1 : (address >= 0x4000000 && address <= 0x41FFFFF ? 0x41FFFFF - address + 1 : (address >= 65536 && address <= 81919 ? 81919 - address + 1 : 0));
        return length;
    }

    private static IMemoryReader getFastMemoryReader(FastMemory mem, int address, int step) {
        int[] memoryInt = mem.getAll();
        switch (step) {
            case 1: {
                return new MemoryReaderIntArray8(memoryInt, address);
            }
            case 2: {
                return new MemoryReaderIntArray16(memoryInt, address);
            }
            case 4: {
                return new MemoryReaderIntArray32(memoryInt, address);
            }
        }
        return new MemoryReaderGeneric(address, MemoryReader.getMaxLength(address), step);
    }

    public static IMemoryReader getMemoryReader(int address, int length, int step) {
        Memory mem = Memory.getInstance();
        address &= 0x3FFFFFFF;
        if (mem instanceof FastMemory) {
            return MemoryReader.getFastMemoryReader((FastMemory)mem, address, step);
        }
        if (!(mem instanceof DebuggerMemory)) {
            Buffer buffer = Memory.getInstance().getBuffer(address, length);
            if (buffer instanceof IntBuffer) {
                IntBuffer intBuffer = (IntBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryReaderInt8(intBuffer, address & 3);
                    }
                    case 2: {
                        return new MemoryReaderInt16(intBuffer, (address & 2) >> 1);
                    }
                    case 4: {
                        return new MemoryReaderInt32(intBuffer);
                    }
                }
            } else if (buffer instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryReaderByte8(byteBuffer);
                    }
                    case 2: {
                        return new MemoryReaderByte16(byteBuffer);
                    }
                    case 4: {
                        return new MemoryReaderByte32(byteBuffer);
                    }
                }
            }
        }
        return new MemoryReaderGeneric(address, length, step);
    }

    public static IMemoryReader getMemoryReader(int address, int step) {
        Memory mem = Memory.getInstance();
        address &= 0x3FFFFFFF;
        if (mem instanceof FastMemory) {
            return MemoryReader.getFastMemoryReader((FastMemory)mem, address, step);
        }
        return MemoryReader.getMemoryReader(address, MemoryReader.getMaxLength(address), step);
    }

    private static final class MemoryReaderByte32
    implements IMemoryReader {
        private ByteBuffer buffer;

        public MemoryReaderByte32(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public final int readNext() {
            return this.buffer.getInt();
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + (n << 2));
        }
    }

    private static final class MemoryReaderByte16
    implements IMemoryReader {
        private ByteBuffer buffer;

        public MemoryReaderByte16(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public final int readNext() {
            return this.buffer.getShort() & 0xFFFF;
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + (n << 1));
        }
    }

    private static final class MemoryReaderByte8
    implements IMemoryReader {
        private ByteBuffer buffer;

        public MemoryReaderByte8(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public final int readNext() {
            return this.buffer.get() & 0xFF;
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + n);
        }
    }

    private static final class MemoryReaderInt32
    implements IMemoryReader {
        private IntBuffer buffer;

        public MemoryReaderInt32(IntBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public final int readNext() {
            return this.buffer.get();
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + n);
        }
    }

    private static final class MemoryReaderInt16
    implements IMemoryReader {
        private int index;
        private int value;
        private IntBuffer buffer;

        public MemoryReaderInt16(IntBuffer buffer, int index) {
            this.buffer = buffer;
            this.index = index;
            if (index != 0 && buffer.capacity() > 0) {
                this.value = buffer.get();
            }
        }

        @Override
        public final int readNext() {
            int n;
            if (this.index == 0) {
                this.value = this.buffer.get();
                n = this.value & 0xFFFF;
                this.index = 1;
            } else {
                this.index = 0;
                n = this.value >>> 16;
            }
            return n;
        }

        @Override
        public final void skip(int n) {
            this.index += n;
            this.buffer.position(this.buffer.position() + (this.index >> 1));
            this.index &= 1;
            if (this.index != 0) {
                this.value = this.buffer.get();
            }
        }
    }

    private static final class MemoryReaderInt8
    implements IMemoryReader {
        private int index;
        private int value;
        private IntBuffer buffer;

        public MemoryReaderInt8(IntBuffer buffer, int index) {
            this.buffer = buffer;
            this.index = index;
            if (buffer.capacity() > 0) {
                this.value = buffer.get() >> (index << 3);
            }
        }

        @Override
        public final int readNext() {
            if (this.index == 4) {
                this.index = 0;
                this.value = this.buffer.get();
            }
            int n = this.value & 0xFF;
            this.value >>= 8;
            ++this.index;
            return n;
        }

        @Override
        public final void skip(int n) {
            this.index += n;
            this.buffer.position(this.buffer.position() + (this.index >> 2));
            this.index &= 3;
            this.value = this.buffer.get() >> 8 * this.index;
        }
    }

    private static final class MemoryReaderIntArray32
    implements IMemoryReader {
        private int offset;
        private int[] buffer;

        public MemoryReaderIntArray32(int[] buffer, int addr) {
            this.offset = addr / 4;
            this.buffer = buffer;
        }

        @Override
        public final int readNext() {
            return this.buffer[this.offset++];
        }

        @Override
        public final void skip(int n) {
            this.offset += n;
        }
    }

    private static final class MemoryReaderIntArray16
    implements IMemoryReader {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;

        public MemoryReaderIntArray16(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = addr >> 2;
            this.index = addr >> 1 & 1;
            if (this.index != 0) {
                this.value = buffer[this.offset++];
            }
        }

        @Override
        public final int readNext() {
            int n;
            if (this.index == 0) {
                this.value = this.buffer[this.offset++];
                n = this.value & 0xFFFF;
                this.index = 1;
            } else {
                this.index = 0;
                n = this.value >>> 16;
            }
            return n;
        }

        @Override
        public final void skip(int n) {
            this.index += n;
            this.offset += this.index >> 1;
            this.index &= 1;
            if (this.index != 0) {
                this.value = this.buffer[this.offset++];
            }
        }
    }

    private static final class MemoryReaderIntArray8
    implements IMemoryReader {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;

        public MemoryReaderIntArray8(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = addr / 4;
            this.index = addr & 3;
            this.value = buffer[this.offset] >> (this.index << 3);
        }

        @Override
        public final int readNext() {
            if (this.index == 4) {
                this.index = 0;
                ++this.offset;
                this.value = this.buffer[this.offset];
            }
            int n = this.value & 0xFF;
            this.value >>= 8;
            ++this.index;
            return n;
        }

        @Override
        public final void skip(int n) {
            this.index += n;
            this.offset += this.index >> 2;
            this.index &= 3;
            this.value = this.buffer[this.offset] >> (this.index << 3);
        }
    }

    private static final class MemoryReaderGeneric
    implements IMemoryReader {
        private Memory mem;
        private int address;
        private int length;
        private int step;

        public MemoryReaderGeneric(int address, int length, int step) {
            this.address = address;
            this.length = length;
            this.step = step;
            this.mem = Memory.getInstance();
        }

        @Override
        public final int readNext() {
            int n;
            if (this.length <= 0) {
                return 0;
            }
            switch (this.step) {
                case 1: {
                    n = this.mem.read8(this.address);
                    break;
                }
                case 2: {
                    n = this.mem.read16(this.address);
                    break;
                }
                case 4: {
                    n = this.mem.read32(this.address);
                    break;
                }
                default: {
                    n = 0;
                }
            }
            this.address += this.step;
            this.length -= this.step;
            return n;
        }

        @Override
        public final void skip(int n) {
            this.address += n * this.step;
            this.length -= n * this.step;
        }
    }
}

