/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.IMemoryWriter;

public class MemoryWriter {
    private static int getMaxLength(int address) {
        int length = address >= 0x8000000 && address <= MemoryMap.END_RAM ? MemoryMap.END_RAM - address + 1 : (address >= 0x4000000 && address <= 0x41FFFFF ? 0x41FFFFF - address + 1 : (address >= 65536 && address <= 81919 ? 81919 - address + 1 : 0));
        return length;
    }

    private static IMemoryWriter getFastMemoryWriter(FastMemory mem, int address, int step) {
        int[] memoryInt = mem.getAll();
        switch (step) {
            case 1: {
                return new MemoryWriterIntArray8(memoryInt, address);
            }
            case 2: {
                return new MemoryWriterIntArray16(memoryInt, address);
            }
            case 4: {
                return new MemoryWriterIntArray32(memoryInt, address);
            }
        }
        return new MemoryWriterGeneric(address, MemoryWriter.getMaxLength(address), step);
    }

    public static IMemoryWriter getMemoryWriter(int address, int length, int step) {
        Memory mem = Memory.getInstance();
        address &= 0x3FFFFFFF;
        if (mem instanceof FastMemory) {
            return MemoryWriter.getFastMemoryWriter((FastMemory)mem, address, step);
        }
        if (!(mem instanceof DebuggerMemory)) {
            Buffer buffer = Memory.getInstance().getBuffer(address, length);
            if (buffer instanceof IntBuffer) {
                IntBuffer intBuffer = (IntBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryWriterInt8(intBuffer, address & 3);
                    }
                    case 2: {
                        return new MemoryWriterInt16(intBuffer, (address & 2) >> 1);
                    }
                    case 4: {
                        return new MemoryWriterInt32(intBuffer);
                    }
                }
            } else if (buffer instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryWriterByte8(byteBuffer);
                    }
                    case 2: {
                        return new MemoryWriterByte16(byteBuffer);
                    }
                    case 4: {
                        return new MemoryWriterByte32(byteBuffer);
                    }
                }
            }
        }
        return new MemoryWriterGeneric(address, length, step);
    }

    public static IMemoryWriter getMemoryWriter(int address, int step) {
        Memory mem = Memory.getInstance();
        address &= 0x3FFFFFFF;
        if (mem instanceof FastMemory) {
            return MemoryWriter.getFastMemoryWriter((FastMemory)mem, address, step);
        }
        return MemoryWriter.getMemoryWriter(address, MemoryWriter.getMaxLength(address), step);
    }

    private static class MemoryWriterByte32
    implements IMemoryWriter {
        private ByteBuffer buffer;

        public MemoryWriterByte32(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.putInt(value);
        }

        @Override
        public void flush() {
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + (n << 2));
        }
    }

    private static class MemoryWriterByte16
    implements IMemoryWriter {
        private ByteBuffer buffer;

        public MemoryWriterByte16(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.putShort((short)value);
        }

        @Override
        public void flush() {
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + (n << 1));
        }
    }

    private static class MemoryWriterByte8
    implements IMemoryWriter {
        private ByteBuffer buffer;

        public MemoryWriterByte8(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.put((byte)value);
        }

        @Override
        public void flush() {
        }

        @Override
        public final void skip(int n) {
            this.buffer.position(this.buffer.position() + n);
        }
    }

    private static class MemoryWriterInt32
    implements IMemoryWriter {
        private IntBuffer buffer;

        public MemoryWriterInt32(IntBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer.put(value);
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int n) {
            this.buffer.position(this.buffer.position() + n);
        }
    }

    private static class MemoryWriterInt16
    implements IMemoryWriter {
        private int index;
        private int value;
        private IntBuffer buffer;

        public MemoryWriterInt16(IntBuffer buffer, int index) {
            this.buffer = buffer;
            this.index = index;
            if (index != 0 && buffer.capacity() > 0) {
                this.value = buffer.get(buffer.position()) & 0xFFFF;
            }
        }

        @Override
        public void writeNext(int n) {
            if (this.index == 0) {
                this.value = n & 0xFFFF;
                this.index = 1;
            } else {
                this.buffer.put(n << 16 | this.value);
                this.index = 0;
            }
        }

        @Override
        public void flush() {
            if (this.index != 0) {
                this.buffer.put(this.buffer.get(this.buffer.position()) & 0xFFFF0000 | this.value);
            }
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                int bufferSkip = 0;
                if (this.index != 0) {
                    this.flush();
                    ++bufferSkip;
                    --n;
                }
                this.buffer.position(this.buffer.position() + (bufferSkip += n / 2));
                this.index = n & 1;
                if (this.index != 0) {
                    this.value = this.buffer.get(this.buffer.position()) & 0xFFFF;
                }
            }
        }
    }

    private static class MemoryWriterInt8
    implements IMemoryWriter {
        private int index;
        private int value;
        private IntBuffer buffer;
        private static final int[] mask = new int[]{0, 255, 65535, 0xFFFFFF, -1};

        public MemoryWriterInt8(IntBuffer buffer, int index) {
            this.buffer = buffer;
            this.index = index;
            if (index > 0 && buffer.capacity() > 0) {
                this.value = buffer.get(buffer.position()) & mask[index];
            }
        }

        @Override
        public void writeNext(int n) {
            n &= 0xFF;
            if (this.index == 4) {
                this.buffer.put(this.value);
                this.value = n;
                this.index = 1;
            } else {
                this.value |= n << (this.index << 3);
                ++this.index;
            }
        }

        @Override
        public void flush() {
            if (this.index > 0) {
                this.buffer.put(this.buffer.get(this.buffer.position()) & ~mask[this.index] | this.value);
            }
        }

        @Override
        public void skip(int n) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemoryWriterIntArray32
    implements IMemoryWriter {
        private int offset;
        private int[] buffer;

        public MemoryWriterIntArray32(int[] buffer, int addr) {
            this.offset = addr / 4;
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer[this.offset++] = value;
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int n) {
            this.offset += n;
        }
    }

    private static class MemoryWriterIntArray16
    implements IMemoryWriter {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;

        public MemoryWriterIntArray16(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = addr >> 2;
            this.index = addr >> 1 & 1;
            if (this.index != 0) {
                this.value = buffer[this.offset] & 0xFFFF;
            }
        }

        @Override
        public void writeNext(int n) {
            if (this.index == 0) {
                this.value = n & 0xFFFF;
                this.index = 1;
            } else {
                this.buffer[this.offset++] = n << 16 | this.value;
                this.index = 0;
            }
        }

        @Override
        public void flush() {
            if (this.index != 0) {
                this.buffer[this.offset] = this.buffer[this.offset] & 0xFFFF0000 | this.value;
            }
        }

        @Override
        public void skip(int n) {
            this.flush();
            this.index += n;
            this.offset += this.index >> 1;
            this.index &= 1;
            if (this.index != 0) {
                this.value = this.buffer[this.offset] & 0xFFFF;
            }
        }
    }

    private static class MemoryWriterIntArray8
    implements IMemoryWriter {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;
        private static final int[] mask = new int[]{0, 255, 65535, 0xFFFFFF, -1};

        public MemoryWriterIntArray8(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = addr >> 2;
            this.index = addr & 3;
            this.value = buffer[this.offset] & mask[this.index];
        }

        @Override
        public void writeNext(int n) {
            n &= 0xFF;
            if (this.index == 4) {
                this.buffer[this.offset++] = this.value;
                this.value = n;
                this.index = 1;
            } else {
                this.value |= n << (this.index << 3);
                ++this.index;
            }
        }

        @Override
        public void flush() {
            if (this.index > 0) {
                this.buffer[this.offset] = this.buffer[this.offset] & ~mask[this.index] | this.value;
            }
        }

        @Override
        public final void skip(int n) {
            this.flush();
            this.index += n;
            this.offset += this.index >> 2;
            this.index &= 3;
            this.value = this.buffer[this.offset] & mask[this.index];
        }
    }

    private static class MemoryWriterGeneric
    implements IMemoryWriter {
        private Memory mem;
        private int address;
        private int length;
        private int step;

        public MemoryWriterGeneric(int address, int length, int step) {
            this.address = address;
            this.length = length;
            this.step = step;
            this.mem = Memory.getInstance();
        }

        @Override
        public void writeNext(int value) {
            if (this.length <= 0) {
                return;
            }
            switch (this.step) {
                case 1: {
                    this.mem.write8(this.address, (byte)value);
                    break;
                }
                case 2: {
                    this.mem.write16(this.address, (short)value);
                    break;
                }
                case 4: {
                    this.mem.write32(this.address, value);
                }
            }
            this.address += this.step;
            this.length -= this.step;
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int n) {
            this.address += n * this.step;
            this.length -= n * this.step;
        }
    }
}

