/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import jpcsp.network.RawSelectionKey;
import jpcsp.network.SelectableRawSocket;

public class RawSelector
extends Selector {
    Set<RawSelectionKey> rawSelectionKeys = new HashSet<RawSelectionKey>();
    Set<SelectionKey> rawSelectedKeys = new HashSet<SelectionKey>();

    public static RawSelector open() throws IOException {
        return new RawSelector();
    }

    protected RawSelector() throws IOException {
    }

    @Override
    public void close() throws IOException {
        for (RawSelectionKey rawSelectionKey : this.rawSelectionKeys) {
            rawSelectionKey.getRawChannel().onSelectorClosed();
        }
        this.rawSelectionKeys.clear();
        this.rawSelectedKeys.clear();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public Set<SelectionKey> keys() {
        HashSet<SelectionKey> setKeys = new HashSet<SelectionKey>();
        setKeys.addAll(this.rawSelectionKeys);
        return setKeys;
    }

    @Override
    public SelectorProvider provider() {
        return null;
    }

    @Override
    public int select() throws IOException {
        return this.selectNow();
    }

    @Override
    public int select(long timeout) throws IOException {
        return this.selectNow();
    }

    protected void selectNow(RawSelectionKey rawSelectionKey) {
        SelectableRawSocket rawSocket = rawSelectionKey.getRawChannel().socket();
        rawSelectionKey.clearReadyOps();
        if ((rawSelectionKey.interestOps() & 1) != 0 && rawSocket.isSelectedForRead()) {
            rawSelectionKey.addReadyOp(1);
        }
        if ((rawSelectionKey.interestOps() & 4) != 0 && rawSocket.isSelectedForWrite()) {
            rawSelectionKey.addReadyOp(4);
        }
        if (rawSelectionKey.readyOps() != 0) {
            this.rawSelectedKeys.add(rawSelectionKey);
        }
    }

    @Override
    public int selectNow() throws IOException {
        this.rawSelectedKeys.clear();
        for (RawSelectionKey rawSelectionKey : this.rawSelectionKeys) {
            this.selectNow(rawSelectionKey);
        }
        return this.rawSelectedKeys.size();
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.rawSelectedKeys;
    }

    @Override
    public Selector wakeup() {
        return this;
    }

    public void register(RawSelectionKey rawSelectionKey) {
        this.rawSelectionKeys.add(rawSelectionKey);
    }
}

