/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.sound.ISampleSource;

public class SampleSourceWithPitch
implements ISampleSource {
    private ISampleSource sampleSource;
    private int pitch;
    private int sampleSourceIndex = -1;
    private int sampleIndex;
    private short currentSample;

    public SampleSourceWithPitch(ISampleSource sampleSource, int pitch) {
        this.sampleSource = sampleSource;
        this.pitch = pitch;
    }

    private int getSampleSourceIndexFromSampleIndex(int index) {
        return (int)((long)index * (long)this.pitch / 4096L);
    }

    @Override
    public short getNextSample() {
        int nextSampleSourceIndex = this.getSampleSourceIndexFromSampleIndex(this.sampleIndex);
        while (nextSampleSourceIndex > this.sampleSourceIndex) {
            this.currentSample = this.sampleSource.getNextSample();
            ++this.sampleSourceIndex;
        }
        ++this.sampleIndex;
        return this.currentSample;
    }

    private int getSampleIndexFromSampleSourceIndex(int index) {
        return (int)((long)index * 4096L / (long)this.pitch);
    }

    @Override
    public int getNumberSamples() {
        if (this.pitch <= 0) {
            return 0;
        }
        return this.getSampleIndexFromSampleSourceIndex(this.sampleSource.getNumberSamples());
    }

    @Override
    public void setSampleIndex(int index) {
        if (index != this.sampleIndex) {
            this.sampleIndex = index;
            this.sampleSourceIndex = this.getSampleSourceIndexFromSampleIndex(this.sampleIndex);
            this.sampleSource.setSampleIndex(this.sampleSourceIndex);
            this.currentSample = this.sampleSource.getNextSample();
        }
    }

    @Override
    public int getSampleIndex() {
        int realSampleSourceIndex = this.sampleSource.getSampleIndex();
        if (realSampleSourceIndex == this.sampleSourceIndex + 1) {
            return this.sampleIndex;
        }
        return this.getSampleIndexFromSampleSourceIndex(realSampleSourceIndex);
    }

    public String toString() {
        return String.format("SampleSourceWithPitch[index=%d, pitch=%d, %s]", this.sampleIndex, this.pitch, this.sampleSource.toString());
    }
}

