/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import jpcsp.HLE.modules.sceAudio;
import org.apache.log4j.Logger;
import org.lwjgl.openal.AL10;

public class SoundBufferManager {
    private static Logger log = sceAudio.log;
    private static SoundBufferManager instance;
    private Stack<Integer> freeBuffers = new Stack();
    private List<ByteBuffer> freeDirectBuffers = new LinkedList<ByteBuffer>();

    public static SoundBufferManager getInstance() {
        if (instance == null) {
            instance = new SoundBufferManager();
        }
        return instance;
    }

    private SoundBufferManager() {
    }

    public int getBuffer() {
        if (this.freeBuffers.isEmpty()) {
            int alBuffer = AL10.alGenBuffers();
            this.freeBuffers.push(alBuffer);
        }
        return this.freeBuffers.pop();
    }

    public void checkFreeBuffers(int alSource) {
        int processedBuffers;
        while ((processedBuffers = AL10.alGetSourcei(alSource, 4118)) > 0) {
            int alBuffer = AL10.alSourceUnqueueBuffers(alSource);
            if (log.isDebugEnabled()) {
                log.debug(String.format("free buffer %d", alBuffer));
            }
            this.freeBuffers.push(alBuffer);
        }
    }

    public ByteBuffer getDirectBuffer(int size) {
        for (int i = 0; i < this.freeDirectBuffers.size(); ++i) {
            ByteBuffer directBuffer = this.freeDirectBuffers.get(i);
            if (directBuffer.capacity() < size) continue;
            this.freeDirectBuffers.remove(i);
            return directBuffer;
        }
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(size);
        return directBuffer;
    }

    public void releaseDirectBuffer(ByteBuffer directBuffer) {
        this.freeDirectBuffers.add(0, directBuffer);
    }
}

