/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.modules.sceSasCore;

public class SoundVoice {
    private boolean changed;
    private int leftVolume;
    private int rightVolume;
    private int sampleRate;
    private int vagAddress;
    private int vagSize;
    private int loopMode;
    private int pitch;
    private int noise;
    private boolean playing;
    private boolean paused;
    private boolean on;
    private VoiceADSREnvelope envelope;
    private int playSample;
    private int index;

    public SoundVoice(int index) {
        this.index = index;
        this.changed = true;
        this.vagAddress = 0;
        this.vagSize = 0;
        this.loopMode = 0;
        this.pitch = 4096;
        this.noise = 0;
        this.playing = false;
        this.paused = false;
        this.on = false;
        this.envelope = new VoiceADSREnvelope();
        this.playSample = 0;
    }

    private void onVoiceChanged() {
        this.changed = true;
        if (this.isOn() && !this.isPlaying()) {
            this.setPlaying(true);
        }
    }

    public int getLeftVolume() {
        return this.leftVolume;
    }

    public void setLeftVolume(int leftVolume) {
        this.leftVolume = leftVolume;
    }

    public int getRightVolume() {
        return this.rightVolume;
    }

    public void setRightVolume(int rightVolume) {
        this.rightVolume = rightVolume;
    }

    public void on() {
        this.on = true;
        this.setPlaying(true);
    }

    public void off() {
        this.on = false;
    }

    public VoiceADSREnvelope getEnvelope() {
        return this.envelope;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playSample = 0;
        if (!playing) {
            this.envelope.height = 0;
        }
        this.playing = playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setVAG(int address, int size) {
        this.vagAddress = address;
        this.vagSize = size;
        this.onVoiceChanged();
    }

    public int getVAGAddress() {
        return this.vagAddress;
    }

    public int getVAGSize() {
        return this.vagSize;
    }

    public int getLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(int loopMode) {
        if (this.loopMode != loopMode) {
            this.loopMode = loopMode;
            this.onVoiceChanged();
        }
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        if (this.pitch != pitch) {
            this.pitch = pitch;
            this.onVoiceChanged();
        }
    }

    public int getNoise() {
        return this.noise;
    }

    public void setNoise(int noise) {
        if (this.noise != noise) {
            this.noise = noise;
            this.onVoiceChanged();
        }
    }

    public int getPlaySample() {
        return this.playSample;
    }

    public void setPlaySample(int playSample) {
        this.playSample = playSample;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public boolean isEnded() {
        return !this.isPlaying();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.format("SoundVoice #%d", this.index);
    }

    public class VoiceADSREnvelope {
        public int AttackRate = 0;
        public int DecayRate = 0;
        public int SustainRate = 0;
        public int ReleaseRate = 0;
        public int AttackCurveType;
        public int DecayCurveType;
        public int SustainCurveType;
        public int ReleaseCurveType;
        public int SustainLevel = 0;
        public int height = 0;

        public String toString() {
            return String.format("VoiceADSREnvelope[AR 0x%08X(%s), DR 0x%08X(%s), SR 0x%08X(%s, SL 0x%08X), RR 0x%08X(%s)]", this.AttackRate, sceSasCore.getSasADSRCurveTypeName(this.AttackCurveType), this.DecayRate, sceSasCore.getSasADSRCurveTypeName(this.DecayCurveType), this.SustainRate, sceSasCore.getSasADSRCurveTypeName(this.SustainCurveType), this.SustainLevel, this.ReleaseRate, sceSasCore.getSasADSRCurveTypeName(this.ReleaseCurveType));
        }
    }
}

