/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;

public class Utils {
    public static int clampMono(int value) {
        return Math.max(Math.min(value, Short.MAX_VALUE), Short.MIN_VALUE);
    }

    public static int mixMono(int value1, int value2) {
        return Utils.clampMono(value1 + value2);
    }

    public static int getRightStereo(int value) {
        return value >> 16;
    }

    public static int getLeftStereo(int value) {
        return (short)value;
    }

    public static int getStereoWithoutClamp(int leftValue, int rightValue) {
        return rightValue << 16 | leftValue & 0xFFFF;
    }

    public static int getStereo(int leftValue, int rightValue) {
        return Utils.getStereoWithoutClamp(Utils.clampMono(leftValue), Utils.clampMono(rightValue));
    }

    public static int getStereo(int stereoValue, float leftVolume, float rightVolume) {
        return Utils.getStereoWithoutClamp((int)((float)Utils.getLeftStereo(stereoValue) * leftVolume), (int)((float)Utils.getRightStereo(stereoValue) * rightVolume));
    }

    public static int mixStereo(int value1, int value2) {
        return Utils.getStereoWithoutClamp(Utils.mixMono(Utils.getLeftStereo(value1), Utils.getLeftStereo(value2)), Utils.mixMono(Utils.getRightStereo(value1), Utils.getRightStereo(value2)));
    }

    public static void mixStereoInMemory(int inAddr, int inOutAddr, int samples) {
        int length = samples << 2;
        IMemoryReader inReader = MemoryReader.getMemoryReader(inAddr, length, 4);
        IMemoryReader inOutReader = MemoryReader.getMemoryReader(inOutAddr, length, 4);
        IMemoryWriter inOutWriter = MemoryWriter.getMemoryWriter(inOutAddr, length, 4);
        for (int i = 0; i < samples; ++i) {
            int inStereoValue = inReader.readNext();
            if (inStereoValue == 0) {
                inOutReader.skip(1);
                inOutWriter.skip(1);
                continue;
            }
            int inOutStereoValue = inOutReader.readNext();
            inOutStereoValue = Utils.mixStereo(inStereoValue, inOutStereoValue);
            inOutWriter.writeNext(inOutStereoValue);
        }
        inOutWriter.flush();
    }

    public static void mixStereoInMemory(int inAddr, int inOutAddr, int samples, float inLeftVolume, float inRightVolume) {
        if (Math.abs(inLeftVolume) < 1.0E-4f) {
            inLeftVolume = 0.0f;
        }
        if (Math.abs(inRightVolume) < 1.0E-4f) {
            inRightVolume = 0.0f;
        }
        if (inLeftVolume == 0.0f && inRightVolume == 0.0f) {
            return;
        }
        if (inLeftVolume == 1.0f && inRightVolume == 1.0f) {
            Utils.mixStereoInMemory(inAddr, inOutAddr, samples);
            return;
        }
        if (inLeftVolume < 0.0f || inLeftVolume > 1.0f) {
            throw new UnsupportedOperationException("Incorrect volume " + inLeftVolume);
        }
        if (inRightVolume < 0.0f || inRightVolume > 1.0f) {
            throw new UnsupportedOperationException("Incorrect volume " + inRightVolume);
        }
        int length = samples << 2;
        IMemoryReader inReader = MemoryReader.getMemoryReader(inAddr, length, 4);
        IMemoryReader inOutReader = MemoryReader.getMemoryReader(inOutAddr, length, 4);
        IMemoryWriter inOutWriter = MemoryWriter.getMemoryWriter(inOutAddr, length, 4);
        for (int i = 0; i < samples; ++i) {
            int inStereoValue = inReader.readNext();
            if (inStereoValue == 0) {
                inOutReader.skip(1);
                inOutWriter.skip(1);
                continue;
            }
            inStereoValue = Utils.getStereo(inStereoValue, inLeftVolume, inRightVolume);
            int inOutStereoValue = inOutReader.readNext();
            inOutStereoValue = Utils.mixStereo(inStereoValue, inOutStereoValue);
            inOutWriter.writeNext(inOutStereoValue);
        }
        inOutWriter.flush();
    }
}

