/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import jpcsp.test.Module;
import jpcsp.test.NIDInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

class Firmware {
    private String m_version;
    private int m_moduleCount;
    private int m_functionCount;
    private Hashtable<String, Module> m_moduleTable;

    public Firmware(String version, String psplibdoc_filename) throws Exception {
        this.m_version = version;
        this.m_moduleCount = 0;
        this.m_functionCount = 0;
        this.m_moduleTable = new Hashtable();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new File(psplibdoc_filename));
        XPath modules = XPath.newInstance("/PSPLIBDOC/PRXFILES/PRXFILE/LIBRARIES/LIBRARY");
        List LibList = modules.selectNodes(doc);
        for (Element curEl : LibList) {
            String modName = curEl.getChild("NAME").getText();
            Module newMod = new Module(modName);
            List FunctionList = curEl.getChild("FUNCTIONS").getChildren("FUNCTION");
            for (Element funcEl : FunctionList) {
                newMod.addFunction(funcEl.getChild("NID").getText(), funcEl.getChild("NAME").getText());
                ++this.m_functionCount;
            }
            ++this.m_moduleCount;
            this.m_moduleTable.put(modName, newMod);
        }
        System.out.println("filename: " + psplibdoc_filename + " modules: " + this.m_moduleCount + " functions: " + this.m_functionCount);
    }

    public String getVersion() {
        return this.m_version;
    }

    public int getModuleCount() {
        return this.m_moduleCount;
    }

    public int getFunctionCount() {
        return this.m_functionCount;
    }

    public boolean resolveNID(NIDInfo info) {
        for (Module module : this.m_moduleTable.values()) {
            String functionName = module.getFunctionFromModule(String.format("0x%08X", info.functionNID));
            if (functionName == null) continue;
            info.functionName = functionName;
            info.libraryName = module.getName();
            if (!info.resolved) {
                info.firmwareVersion = this.m_version;
            }
            info.resolved = true;
            return true;
        }
        return false;
    }
}

