/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import jpcsp.HLE.Modules;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;

public class Debug {
    public static final int fontPixelSize = 2;
    private static final int[] fontPixelSizeInBytes = new int[]{0, 0, 1, 3, 4};

    public static void printFontbuffer(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int pixelformat, int charCode, int altCharCode) {
        if (Modules.log.isInfoEnabled()) {
            Modules.log.info(String.format("printFontbuffer 0x%04X '%c' (%d, %d)", charCode, Character.valueOf((char)charCode), x, y));
        }
        if (Font.font == null) {
            return;
        }
        int fontBaseIndex = charCode * Font.charSize;
        if ((fontBaseIndex >= Font.font.length || Debug.isFontCharNull(fontBaseIndex)) && ((fontBaseIndex = altCharCode * Font.charSize) >= Font.font.length || Debug.isFontCharNull(fontBaseIndex))) {
            return;
        }
        int pixelColor0 = Debug.getFontPixelColor(0, pixelformat);
        int pixelColor1 = Debug.getFontPixelColor(-1, pixelformat);
        for (int i = 0; i < Font.charHeight; ++i) {
            for (int j = 0; j < Font.charWidth; ++j) {
                int pixel = Font.font[fontBaseIndex + i] & 128 >> j;
                int pixelColor = pixel != 0 ? pixelColor1 : pixelColor0;
                for (int pixelY = 0; pixelY < 2; ++pixelY) {
                    for (int pixelX = 0; pixelX < 2; ++pixelX) {
                        Debug.setFontPixel(base, bpl, bufWidth, bufHeight, x + j * 2 + pixelX, y + i * 2 + pixelY, pixelColor, pixelformat);
                    }
                }
            }
        }
    }

    private static boolean isFontCharNull(int index) {
        for (int i = 0; i < Font.charHeight; ++i) {
            if (Font.font[index + i] == '\u0000') continue;
            return false;
        }
        return true;
    }

    public static void setFontPixel(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int pixelColor, int pixelformat) {
        int bufMaxWidth;
        if (x < 0 || x >= bufWidth || y < 0 || y >= bufHeight) {
            return;
        }
        int pixelBytes = Debug.getFontPixelBytes(pixelformat);
        int n = bufMaxWidth = pixelBytes == 0 ? bpl * 2 : bpl / pixelBytes;
        if (x >= bufMaxWidth) {
            return;
        }
        int framebufferAddr = base + y * bpl + (pixelBytes == 0 ? x / 2 : x * pixelBytes);
        Memory mem = Memory.getInstance();
        switch (pixelformat) {
            case 0: 
            case 1: {
                int oldColor = mem.read8(framebufferAddr);
                int newColor = (x & 1) != pixelformat ? pixelColor << 4 | oldColor & 0xF : oldColor & 0xF0 | pixelColor;
                mem.write8(framebufferAddr, (byte)newColor);
                break;
            }
            case 2: {
                mem.write8(framebufferAddr, (byte)pixelColor);
                break;
            }
            case 3: {
                mem.write8(framebufferAddr + 0, (byte)(pixelColor >> 0));
                mem.write8(framebufferAddr + 1, (byte)(pixelColor >> 8));
                mem.write8(framebufferAddr + 2, (byte)(pixelColor >> 16));
                break;
            }
            case 4: {
                mem.write32(framebufferAddr, pixelColor);
            }
        }
    }

    private static int getFontPixelBytes(int pixelformat) {
        if (pixelformat >= 0 && pixelformat < fontPixelSizeInBytes.length) {
            return fontPixelSizeInBytes[pixelformat];
        }
        Modules.log.warn("Unknown pixel format for sceFont: " + pixelformat);
        return 1;
    }

    public static int getFontPixelColor(int color, int pixelformat) {
        switch (pixelformat) {
            case 0: 
            case 1: {
                color = color >> 28 & 0xF;
                break;
            }
            case 2: {
                color = color >> 24 & 0xFF;
                break;
            }
            case 3: {
                color &= 0xFFFFFF;
                break;
            }
        }
        return color;
    }

    public static void printFramebuffer(int base, int bufferwidth, int x, int y, int colorFg, int colorBg, int pixelformat, String s) {
        Debug.printFramebuffer(base, bufferwidth, x, y, colorFg, colorBg, pixelformat, 1, s);
    }

    public static void printFramebuffer(int base, int bufferwidth, int x, int y, int colorFg, int colorBg, int pixelformat, int size, String s) {
        if (Font.font == null) {
            return;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                x = 0;
                y += Font.charHeight * size;
                continue;
            }
            Debug.printFramebuffer(base, bufferwidth, x, y, colorFg, colorBg, pixelformat, size, c);
            x += Font.charWidth * size;
        }
    }

    private static void printFramebuffer(int base, int bufferwidth, int x, int y, int colorFg, int colorBg, int pixelformat, int size, char c) {
        int fontBaseIndex = c * 8;
        for (int i = 0; i < Font.charHeight; ++i) {
            for (int j = 0; j < Font.charWidth; ++j) {
                int pixel = Font.font[fontBaseIndex + i] & 128 >> j;
                if (pixel != 0) {
                    Debug.setPixel(base, bufferwidth, x + j * size, y + i * size, colorFg, pixelformat, size);
                    continue;
                }
                if (colorBg == 0) continue;
                Debug.setPixel(base, bufferwidth, x + j * size, y + i * size, colorBg, pixelformat, size);
            }
        }
    }

    private static void setPixel(int base, int bufferwidth, int x, int y, int color, int pixelformat, int size) {
        Memory mem = Memory.getInstance();
        int pixelBytes = sceDisplay.getPixelFormatBytes(pixelformat);
        int framebufferAddr = base + (y * bufferwidth + x) * pixelBytes;
        int pixelColor = Debug.getPixelColor(color, pixelformat);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (pixelBytes == 4) {
                    mem.write32(framebufferAddr + j * pixelBytes, pixelColor);
                    continue;
                }
                if (pixelBytes != 2) continue;
                mem.write16(framebufferAddr + j * pixelBytes, (short)pixelColor);
            }
            framebufferAddr += bufferwidth * pixelBytes;
        }
    }

    public static int getPixelColor(int color, int pixelformat) {
        switch (pixelformat) {
            case 0: {
                color = (color & 0xF80000) >> 8 | (color & 0xFC00) >> 5 | (color & 0xF8) >> 3;
                break;
            }
            case 1: {
                color = (color & Integer.MIN_VALUE) >> 16 | (color & 0xF80000) >> 9 | (color & 0xF800) >> 6 | (color & 0xF8) >> 3;
                break;
            }
            case 2: {
                color = (color & 0xF0000000) >> 16 | (color & 0xF00000) >> 12 | (color & 0xF000) >> 8 | (color & 0xF0) >> 4;
                break;
            }
        }
        return color;
    }

    public static class Font {
        public static int charSize = 8;
        public static int charWidth = 8;
        public static int charHeight = 8;
        public static char[] font = null;

        public static void setDebugFont(char[] newFont) {
            font = newFont;
        }

        public static void setDebugCharWidth(int width) {
            charWidth = width;
        }

        public static void setDebugCharHeight(int height) {
            charHeight = height;
        }

        public static void setDebugCharSize(int size) {
            charSize = size;
        }
    }
}

