/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;

public class Utilities {
    public static final Charset charset = Charset.forName("UTF-8");

    public static String formatString(String type, String oldstring) {
        int counter = 0;
        if (type.equals("byte")) {
            counter = 2;
        }
        if (type.equals("short")) {
            counter = 4;
        }
        if (type.equals("long")) {
            counter = 8;
        }
        int len = oldstring.length();
        StringBuilder sb = new StringBuilder();
        while (len++ < counter) {
            sb.append('0');
        }
        oldstring = sb.append(oldstring).toString();
        return oldstring;
    }

    public static String integerToBin(int value) {
        return Long.toBinaryString(0x100000000L | (long)value & 0xFFFFFFFFL).substring(1);
    }

    public static String integerToHex(int value) {
        return Integer.toHexString(0x100 | value).substring(1).toUpperCase();
    }

    public static String integerToHexShort(int value) {
        return Integer.toHexString(0x10000 | value).substring(1).toUpperCase();
    }

    public static long readUWord(SeekableDataInput f) throws IOException {
        long l = f.readUnsignedByte() | f.readUnsignedByte() << 8 | f.readUnsignedByte() << 16 | f.readUnsignedByte() << 24;
        return l & 0xFFFFFFFFL;
    }

    public static int readUByte(SeekableDataInput f) throws IOException {
        return f.readUnsignedByte();
    }

    public static int readUHalf(SeekableDataInput f) throws IOException {
        return f.readUnsignedByte() | f.readUnsignedByte() << 8;
    }

    public static int readWord(SeekableDataInput f) throws IOException {
        return f.readUnsignedByte() | f.readUnsignedByte() << 8 | f.readUnsignedByte() << 16 | f.readUnsignedByte() << 24;
    }

    public static void skipUnknown(ByteBuffer buf, int length) throws IOException {
        buf.position(buf.position() + length);
    }

    public static String readStringZ(ByteBuffer buf) throws IOException {
        byte b;
        StringBuilder sb = new StringBuilder();
        while (buf.position() < buf.limit() && (b = (byte)Utilities.readUByte(buf)) != 0) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static String readStringNZ(ByteBuffer buf, int n) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (n > 0) {
            byte b = (byte)Utilities.readUByte(buf);
            if (b != 0) {
                sb.append((char)b);
            }
            --n;
        }
        return sb.toString();
    }

    public static String readStringNZ(Memory mem, int address, int n) {
        int b;
        if ((address &= 0x3FFFFFFF) + n > MemoryMap.END_RAM) {
            n = MemoryMap.END_RAM - address + 1;
        }
        byte[] bytes = new byte[Math.min(n, 10000)];
        int length = 0;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, n, 1);
        while (n > 0 && (b = memoryReader.readNext()) != 0) {
            if (length >= bytes.length) {
                byte[] newBytes = new byte[bytes.length + 10000];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                bytes = newBytes;
            }
            bytes[length] = (byte)b;
            ++length;
            --n;
        }
        return new String(bytes, 0, length, charset);
    }

    public static String readStringZ(Memory mem, int address) {
        return Utilities.readStringNZ(mem, address &= 0x3FFFFFFF, MemoryMap.END_RAM - address + 1);
    }

    public static String readStringZ(int address) {
        return Utilities.readStringZ(Memory.getInstance(), address);
    }

    public static String readStringNZ(int address, int n) {
        return Utilities.readStringNZ(Memory.getInstance(), address, n);
    }

    public static void writeStringNZ(Memory mem, int address, int n, String s) {
        int offset;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, n, 1);
        byte[] bytes = s.getBytes(charset);
        for (offset = 0; offset < bytes.length && offset < n; ++offset) {
            memoryWriter.writeNext(bytes[offset]);
        }
        while (offset < n) {
            memoryWriter.writeNext(0);
            ++offset;
        }
        memoryWriter.flush();
    }

    public static void writeStringZ(Memory mem, int address, String s) {
        Utilities.writeStringNZ(mem, address, s.length() + 1, s);
    }

    public static void writeStringZ(ByteBuffer buf, String s) {
        buf.put(s.getBytes());
        buf.put((byte)0);
    }

    public static short getUnsignedByte(ByteBuffer bb) throws IOException {
        return (short)(bb.get() & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer bb, int value) {
        bb.put((byte)(value & 0xFF));
    }

    public static short readUByte(ByteBuffer buf) throws IOException {
        return Utilities.getUnsignedByte(buf);
    }

    public static int readUHalf(ByteBuffer buf) throws IOException {
        return Utilities.getUnsignedByte(buf) | Utilities.getUnsignedByte(buf) << 8;
    }

    public static long readUWord(ByteBuffer buf) throws IOException {
        long l = Utilities.getUnsignedByte(buf) | Utilities.getUnsignedByte(buf) << 8 | Utilities.getUnsignedByte(buf) << 16 | Utilities.getUnsignedByte(buf) << 24;
        return l & 0xFFFFFFFFL;
    }

    public static int readWord(ByteBuffer buf) throws IOException {
        return Utilities.getUnsignedByte(buf) | Utilities.getUnsignedByte(buf) << 8 | Utilities.getUnsignedByte(buf) << 16 | Utilities.getUnsignedByte(buf) << 24;
    }

    public static void writeWord(ByteBuffer buf, long value) {
        Utilities.putUnsignedByte(buf, (int)(value >> 0));
        Utilities.putUnsignedByte(buf, (int)(value >> 8));
        Utilities.putUnsignedByte(buf, (int)(value >> 16));
        Utilities.putUnsignedByte(buf, (int)(value >> 24));
    }

    public static void writeHalf(ByteBuffer buf, int value) {
        Utilities.putUnsignedByte(buf, value >> 0);
        Utilities.putUnsignedByte(buf, value >> 8);
    }

    public static void writeByte(ByteBuffer buf, int value) {
        Utilities.putUnsignedByte(buf, value);
    }

    public static int parseAddress(String value) throws NumberFormatException {
        int address = 0;
        if (value == null) {
            return address;
        }
        if ((value = value.trim()).startsWith("0x")) {
            value = value.substring(2);
        }
        address = value.length() == 8 && value.charAt(0) >= '8' ? (int)Long.parseLong(value, 16) : Integer.parseInt(value, 16);
        return address;
    }

    public static long parseLong(String s) {
        long value = 0L;
        if (s == null) {
            return value;
        }
        value = s.startsWith("0x") ? Long.parseLong(s.substring(2), 16) : Long.parseLong(s);
        return value;
    }

    public static long parseHexLong(String s) {
        long value = 0L;
        if (s == null) {
            return value;
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
        }
        value = Long.parseLong(s, 16);
        return value;
    }

    public static int makePow2(int n) {
        --n;
        n = n >> 1 | n;
        n = n >> 2 | n;
        n = n >> 4 | n;
        n = n >> 8 | n;
        n = n >> 16 | n;
        return ++n;
    }

    public static void readFully(SeekableDataInput input, int address, int length) throws IOException {
        int blockSize = 0x100000;
        while (length > 0) {
            int size = Math.min(length, 0x100000);
            byte[] buffer = new byte[size];
            input.readFully(buffer);
            Memory.getInstance().copyToMemory(address, ByteBuffer.wrap(buffer), size);
            address += size;
            length -= size;
        }
    }

    public static void write(SeekableRandomFile output, int address, int length) throws IOException {
        Buffer buffer = Memory.getInstance().getBuffer(address, length);
        if (buffer instanceof ByteBuffer) {
            output.getChannel().write((ByteBuffer)buffer);
        } else if (length > 0) {
            byte[] bytes = new byte[length];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)memoryReader.readNext();
            }
            output.write(bytes);
        }
    }

    public static void bytePositionBuffer(Buffer buffer, int bytePosition) {
        buffer.position(bytePosition / Utilities.bufferElementSize(buffer));
    }

    public static int bufferElementSize(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            return 4;
        }
        return 1;
    }

    public static String stripNL(String s) {
        if (s != null && s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void putBuffer(ByteBuffer destination, Buffer source, ByteOrder sourceByteOrder) {
        ByteOrder order = destination.order();
        destination.order(sourceByteOrder);
        if (source instanceof IntBuffer) {
            destination.asIntBuffer().put((IntBuffer)source);
        } else if (source instanceof ShortBuffer) {
            destination.asShortBuffer().put((ShortBuffer)source);
        } else if (source instanceof ByteBuffer) {
            destination.put((ByteBuffer)source);
        } else if (source instanceof FloatBuffer) {
            destination.asFloatBuffer().put((FloatBuffer)source);
        } else {
            Modules.log.error("Utilities.putBuffer: Unsupported Buffer type " + source.getClass().getName());
            Emulator.PauseEmuWithStatus(32);
        }
        destination.order(order);
    }

    public static void putBuffer(ByteBuffer destination, Buffer source, ByteOrder sourceByteOrder, int lengthInBytes) {
        ByteOrder order = destination.order();
        destination.order(sourceByteOrder);
        int srcLimit = source.limit();
        if (source instanceof IntBuffer) {
            destination.asIntBuffer().put((IntBuffer)source.limit(source.position() + (lengthInBytes >> 2)));
        } else if (source instanceof ShortBuffer) {
            destination.asShortBuffer().put((ShortBuffer)source.limit(source.position() + (lengthInBytes >> 1)));
        } else if (source instanceof ByteBuffer) {
            destination.put((ByteBuffer)source.limit(source.position() + lengthInBytes));
        } else if (source instanceof FloatBuffer) {
            destination.asFloatBuffer().put((FloatBuffer)source.limit(source.position() + (lengthInBytes >> 2)));
        } else {
            Modules.log.error("Utilities.putBuffer: Unsupported Buffer type " + source.getClass().getName());
            Emulator.PauseEmuWithStatus(32);
        }
        destination.order(order);
        source.limit(srcLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(InputStream inputStream, boolean close) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("null inputstream");
        }
        StringBuilder outputBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while (null != (string = reader.readLine())) {
                outputBuilder.append(string).append('\n');
            }
            if (!close) return outputBuilder.toString();
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            Utilities.close(inputStream);
            throw throwable;
        }
        Utilities.close(inputStream);
        return outputBuilder.toString();
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception ex) {
                Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Couldn't close Closeable", ex);
            }
        }
    }

    public static long makeValue64(int low32, int high32) {
        return (long)high32 << 32 | (long)low32 & 0xFFFFFFFFL;
    }

    public static void storeRegister64(CpuState cpu, int register, long value) {
        cpu.gpr[register] = (int)value;
        cpu.gpr[register + 1] = (int)(value >> 32);
    }

    public static void returnRegister64(CpuState cpu, long value) {
        Utilities.storeRegister64(cpu, 2, value);
    }

    public static long getRegister64(CpuState cpu, int register) {
        return Utilities.makeValue64(cpu.gpr[register], cpu.gpr[register + 1]);
    }

    public static int getSizeKb(long sizeByte) {
        return (int)((sizeByte + 1023L) / 1024L);
    }

    private static void addAsciiDump(StringBuilder dump, IMemoryReader charReader, int bytesPerLine) {
        dump.append("  >");
        for (int i = 0; i < bytesPerLine; ++i) {
            char c = (char)charReader.readNext();
            if (c < ' ' || c > '~') {
                c = '.';
            }
            dump.append(c);
        }
        dump.append("<");
    }

    public static String getMemoryDump(int address, int length, int step, int bytesPerLine) {
        if (!Memory.isAddressGood(address) || length <= 0 || bytesPerLine <= 0 || step <= 0) {
            return "";
        }
        StringBuilder dump = new StringBuilder();
        if (length < bytesPerLine) {
            bytesPerLine = length;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, step);
        IMemoryReader charReader = MemoryReader.getMemoryReader(address, length, 1);
        String format = String.format(" %%0%dX", step * 2);
        boolean startOfLine = true;
        block5: for (int i = 0; i < length; i += step) {
            if (i % bytesPerLine < step) {
                if (i > 0) {
                    Utilities.addAsciiDump(dump, charReader, bytesPerLine);
                }
                dump.append("\n");
                startOfLine = true;
            }
            if (startOfLine) {
                dump.append(String.format("0x%08X", address + i));
                startOfLine = false;
            }
            int value = memoryReader.readNext();
            if (length - i >= step) {
                dump.append(String.format(format, value));
                continue;
            }
            switch (length - i) {
                case 3: {
                    dump.append(String.format(" %06X", value & 0xFFFFFF));
                    continue block5;
                }
                case 2: {
                    dump.append(String.format(" %04X", value & 0xFFFF));
                    continue block5;
                }
                case 1: {
                    dump.append(String.format(" %02X", value & 0xFF));
                }
            }
        }
        int lengthLastLine = length % bytesPerLine;
        if (lengthLastLine > 0) {
            for (int i = lengthLastLine; i < bytesPerLine; ++i) {
                dump.append("  ");
                if (i % step != 0) continue;
                dump.append(" ");
            }
            Utilities.addAsciiDump(dump, charReader, bytesPerLine - lengthLastLine);
        } else {
            Utilities.addAsciiDump(dump, charReader, bytesPerLine);
        }
        return dump.toString();
    }

    public static String getMemoryDump(int[] values, int offset, int length, int entriesPerLine) {
        StringBuilder dump = new StringBuilder();
        boolean startOfLine = true;
        for (int i = 0; i < length; ++i) {
            if (i % entriesPerLine == 0) {
                dump.append("\n");
                startOfLine = true;
            }
            if (startOfLine) {
                dump.append(String.format("0x%08X", offset + i << 2));
                startOfLine = false;
            }
            int value = values[offset + i];
            dump.append(String.format(" %08X", value));
        }
        return dump.toString();
    }

    public static int alignUp(int value, int alignment) {
        return Utilities.alignDown(value + alignment, alignment);
    }

    public static int alignDown(int value, int alignment) {
        return value & ~alignment;
    }

    public static int endianSwap32(int x) {
        return Integer.reverseBytes(x);
    }

    public static int readUnaligned32(Memory mem, int address) {
        switch (address & 3) {
            case 0: {
                return mem.read32(address);
            }
            case 2: {
                return mem.read16(address) | mem.read16(address + 2) << 16;
            }
        }
        return mem.read8(address + 3) << 24 | mem.read8(address + 2) << 16 | mem.read8(address + 1) << 8 | mem.read8(address);
    }

    public static void writeUnaligned32(Memory mem, int address, int data) {
        switch (address & 3) {
            case 0: {
                mem.write32(address, data);
                break;
            }
            case 2: {
                mem.write16(address, (short)data);
                mem.write16(address + 2, (short)(data >> 16));
                break;
            }
            default: {
                mem.write8(address, (byte)data);
                mem.write8(address + 1, (byte)(data >> 8));
                mem.write8(address + 2, (byte)(data >> 16));
                mem.write8(address + 3, (byte)(data >> 24));
            }
        }
    }

    public static void sleep(int micros) {
        Utilities.sleep(micros / 1000, micros % 1000);
    }

    public static void sleep(int millis, int micros) {
        try {
            if (micros <= 0) {
                Thread.sleep(millis);
            } else {
                Thread.sleep(millis, micros * 1000);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

